/*
 * Decompiled with CFR 0.152.
 */
package juzu.io;

import java.io.IOException;
import java.util.LinkedList;
import juzu.io.Chunk;
import juzu.io.Stream;
import juzu.io.Streamable;

public class ChunkBuffer
implements Streamable,
Appendable {
    private static final int STATUS_BUFFERING = 0;
    private static final int STATUS_PROVIDING = 1;
    private static final int STATUS_CLOSED = 2;
    private final LinkedList<Chunk> queue = new LinkedList();
    private Stream consumer = null;
    private int status = 0;
    private final Object lock = new Object();
    private Thread.UncaughtExceptionHandler errorHandler;

    public ChunkBuffer() {
    }

    public ChunkBuffer(Thread.UncaughtExceptionHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    @Override
    public Appendable append(CharSequence csq) throws IOException {
        return this.append(Chunk.create(csq));
    }

    @Override
    public Appendable append(CharSequence csq, int start, int end) throws IOException {
        return this.append(Chunk.create(csq));
    }

    @Override
    public Appendable append(char c) throws IOException {
        return this.append(Chunk.create(c));
    }

    public ChunkBuffer append(Iterable<Chunk> chunks) {
        for (Chunk chunk : chunks) {
            this.append(chunk);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ChunkBuffer append(Chunk chunk) {
        Object object = this.lock;
        synchronized (object) {
            switch (this.status) {
                case 2: {
                    throw new IllegalArgumentException("Already closed");
                }
                case 0: {
                    this.queue.add(chunk);
                    break;
                }
                case 1: {
                    this.consumer.provide(chunk);
                }
            }
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void send(Stream stream) {
        boolean close;
        Object object = this.lock;
        synchronized (object) {
            if (this.consumer != null) {
                throw new IllegalStateException("Already consumed");
            }
            this.consumer = stream;
        }
        while (true) {
            Chunk chunk;
            Object object2 = this.lock;
            synchronized (object2) {
                if (this.queue.isEmpty()) {
                    if (this.status == 2) {
                        close = true;
                    } else {
                        this.status = 1;
                        close = false;
                    }
                    break;
                }
                chunk = this.queue.removeFirst();
            }
            stream.provide(chunk);
        }
        if (close) {
            stream.close(this.errorHandler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ChunkBuffer close() {
        Stream stream;
        Object object = this.lock;
        synchronized (object) {
            switch (this.status) {
                case 2: {
                    stream = null;
                    break;
                }
                case 1: {
                    stream = this.consumer;
                    this.status = 2;
                    break;
                }
                case 0: {
                    stream = null;
                    this.status = 2;
                    break;
                }
                default: {
                    throw new UnsupportedOperationException();
                }
            }
        }
        if (stream != null) {
            stream.close(this.errorHandler);
        }
        return this;
    }
}

