/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.commons.juzu;

import javax.inject.Provider;
import juzu.inject.ProviderFactory;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.spi.ComponentAdapter;

public class KernelProviderFactory
implements ProviderFactory {
    public <T> Provider<? extends T> getProvider(final Class<T> implementationType) throws Exception {
        final PortalContainer container = PortalContainer.getInstance();
        if (container == null) {
            throw new IllegalStateException("Not running in the context of a portal container");
        }
        final ComponentAdapter adapter = container.getComponentAdapterOfType(implementationType);
        if (adapter != null) {
            return new Provider<T>(){

                public T get() {
                    Object service = adapter.getComponentInstance();
                    if (service == null) {
                        throw new RuntimeException("Could not obtain service " + String.valueOf(implementationType) + " from container " + String.valueOf(container));
                    }
                    return implementationType.cast(service);
                }
            };
        }
        return null;
    }
}

