/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.chat.services.mongodb;

import com.mongodb.BasicDBObject;
import com.mongodb.DB;
import com.mongodb.DBCollection;
import com.mongodb.DBObject;
import com.mongodb.MongoClient;
import com.mongodb.MongoClientOptions;
import com.mongodb.MongoCredential;
import com.mongodb.WriteConcern;
import de.flapdoodle.embed.mongo.MongodExecutable;
import de.flapdoodle.embed.mongo.MongodProcess;
import de.flapdoodle.embed.mongo.MongodStarter;
import de.flapdoodle.embed.mongo.config.IMongodConfig;
import de.flapdoodle.embed.mongo.config.MongodConfigBuilder;
import de.flapdoodle.embed.mongo.config.Net;
import de.flapdoodle.embed.mongo.distribution.IFeatureAwareVersion;
import de.flapdoodle.embed.mongo.distribution.Version;
import de.flapdoodle.embed.process.config.IExecutableProcessConfig;
import de.flapdoodle.embed.process.runtime.Network;
import java.io.IOException;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.exoplatform.chat.services.mongodb.utils.ConnectionHelper;
import org.exoplatform.chat.utils.PropertyManager;

public class MongoBootstrap {
    private static MongodExecutable mongodExe;
    private static MongodProcess mongod;
    private MongoClient m;
    private DB db;
    private static final Logger LOG;

    private MongoClient mongo() {
        if (this.m == null) {
            try {
                if ("embed".equals(PropertyManager.getProperty((String)"dbServerType"))) {
                    LOG.warning("WE WILL NOW USE MONGODB IN EMBED MODE...");
                    LOG.warning("BE AWARE...");
                    LOG.warning("EMBED MODE SHOULD NEVER BE USED IN PRODUCTION!");
                    MongoBootstrap.setupEmbedMongo();
                }
                MongoClientOptions options = MongoClientOptions.builder().connectionsPerHost(200).connectTimeout(60000).threadsAllowedToBlockForConnectionMultiplier(10).build();
                boolean authenticate = "true".equals(PropertyManager.getProperty((String)"dbAuthentication"));
                if (authenticate) {
                    MongoCredential credential = MongoCredential.createCredential((String)PropertyManager.getProperty((String)"dbUser"), (String)PropertyManager.getProperty((String)"dbName"), (char[])PropertyManager.getProperty((String)"dbPassword").toCharArray());
                    this.m = new MongoClient(ConnectionHelper.getMongoServerAdresses(), Arrays.asList(credential), options);
                } else {
                    this.m = new MongoClient(ConnectionHelper.getMongoServerAdresses(), options);
                }
                this.m.setWriteConcern(WriteConcern.SAFE);
            }
            catch (Exception e) {
                LOG.log(Level.SEVERE, "Error occur when get Mongo server adresses .", e);
            }
        }
        return this.m;
    }

    public void close() {
        try {
            if (mongod != null) {
                mongod.stop();
                mongodExe.stop();
            }
            if (this.m != null) {
                this.m.close();
            }
        }
        catch (NullPointerException e) {
            return;
        }
    }

    public void initialize() {
        this.close();
        this.m = null;
        this.mongo();
    }

    public void dropDB(String dbName) {
        LOG.info("---- Dropping DB " + dbName);
        this.mongo().dropDatabase(dbName);
        LOG.info("-------- DB " + dbName + " dropped!");
    }

    public DB getDB() {
        return this.getDB(null);
    }

    public DB getDB(String dbName) {
        if (this.db == null || dbName != null) {
            this.db = dbName != null ? this.mongo().getDB(dbName) : this.mongo().getDB(PropertyManager.getProperty((String)"dbName"));
            this.initCollection("notifications");
            this.initCollection("rooms");
            this.initCollection("users");
            this.dropTokenCollectionIfExists();
        }
        return this.db;
    }

    private static void setupEmbedMongo() throws IOException {
        MongodStarter runtime = MongodStarter.getDefaultInstance();
        int port = Integer.parseInt(PropertyManager.getProperty((String)"dbServerPort"));
        IMongodConfig mongodConfig = new MongodConfigBuilder().version((IFeatureAwareVersion)Version.Main.V2_6).net(new Net(port, Network.localhostIsIPv6())).build();
        mongodExe = (MongodExecutable)runtime.prepare((IExecutableProcessConfig)mongodConfig);
        mongod = (MongodProcess)mongodExe.start();
    }

    public void initCappedCollection(String name, int size) {
        this.initCollection(name, true, size);
    }

    private void initCollection(String name) {
        this.initCollection(name, false, 0);
    }

    private void initCollection(String name, boolean isCapped, int size) {
        if (this.getDB().collectionExists(name)) {
            return;
        }
        BasicDBObject doc = new BasicDBObject();
        doc.put((Object)"capped", (Object)isCapped);
        if (isCapped) {
            doc.put((Object)"size", (Object)size);
        }
        this.getDB().createCollection(name, (DBObject)doc);
    }

    private void dropTokenCollectionIfExists() {
        if (this.getDB().collectionExists("tokens")) {
            DBCollection tokens = this.getDB().getCollection("tokens");
            tokens.drop();
        }
    }

    public void ensureIndexesInRoom(String type) {
        String dbName = this.getDB().getName();
        BasicDBObject unique = new BasicDBObject();
        unique.put((Object)"unique", (Object)true);
        unique.put((Object)"background", (Object)true);
        BasicDBObject notUnique = new BasicDBObject();
        notUnique.put((Object)"unique", (Object)false);
        notUnique.put((Object)"background", (Object)true);
        DBCollection collr = this.getDB().getCollection("messages_room_" + type);
        collr.createIndex((DBObject)new BasicDBObject("roomId", (Object)1).append("timestamp", (Object)-1), (DBObject)notUnique.append("name", (Object)"roomId_1_timestamp_-1").append("ns", (Object)(dbName + "." + "messages_room_" + type)));
        LOG.info("##### room index in messages_room_" + type);
    }

    public void ensureIndexes() {
        String[] roomTypes;
        String dbName = this.getDB().getName();
        LOG.info("### ensureIndexes in " + dbName);
        BasicDBObject unique = new BasicDBObject();
        unique.put((Object)"unique", (Object)true);
        unique.put((Object)"background", (Object)true);
        BasicDBObject notUnique = new BasicDBObject();
        notUnique.put((Object)"unique", (Object)false);
        notUnique.put((Object)"background", (Object)true);
        DBCollection notifications = this.getDB().getCollection("notifications");
        notifications.dropIndexes();
        notifications.createIndex((DBObject)new BasicDBObject("user", (Object)1), (DBObject)notUnique.append("name", (Object)"user_1").append("ns", (Object)(dbName + ".notifications")));
        notifications.createIndex((DBObject)new BasicDBObject("isRead", (Object)1), (DBObject)notUnique.append("name", (Object)"isRead_1").append("ns", (Object)(dbName + ".notifications")));
        BasicDBObject index2 = new BasicDBObject();
        index2.put((Object)"user", (Object)1);
        index2.put((Object)"categoryId", (Object)1);
        index2.put((Object)"category", (Object)1);
        index2.put((Object)"type", (Object)1);
        notifications.createIndex((DBObject)index2, (DBObject)notUnique.append("name", (Object)"user_1_type_1_category_1_categoryId_1").append("ns", (Object)(dbName + ".notifications")));
        LOG.info("### notifications indexes in " + this.getDB().getName());
        DBCollection rooms = this.getDB().getCollection("rooms");
        rooms.dropIndexes();
        rooms.createIndex((DBObject)new BasicDBObject("space", (Object)1), (DBObject)notUnique.append("name", (Object)"space_1").append("ns", (Object)(dbName + "." + "rooms")));
        rooms.createIndex((DBObject)new BasicDBObject("users", (Object)1), (DBObject)notUnique.append("name", (Object)"users_1").append("ns", (Object)(dbName + "." + "rooms")));
        rooms.createIndex((DBObject)new BasicDBObject("shortName", (Object)1), (DBObject)notUnique.append("name", (Object)"shortName_1").append("ns", (Object)(dbName + "." + "rooms")));
        LOG.info("### rooms indexes in " + this.getDB().getName());
        for (String type : roomTypes = new String[]{"u", "s", "t", "e"}) {
            DBCollection collr = this.getDB().getCollection("messages_room_" + type);
            collr.createIndex((DBObject)new BasicDBObject("roomId", (Object)1).append("timestamp", (Object)-1), (DBObject)notUnique.append("name", (Object)"roomId_1_timestamp_-1").append("ns", (Object)(dbName + "." + "messages_room_" + type)));
            LOG.info("##### room index in " + type);
        }
        DBCollection users = this.getDB().getCollection("users");
        users.dropIndexes();
        users.createIndex((DBObject)new BasicDBObject("token", (Object)1), (DBObject)notUnique.append("name", (Object)"token_1").append("ns", (Object)(dbName + ".users")));
        index2 = new BasicDBObject();
        index2.put((Object)"user", (Object)1);
        index2.put((Object)"token", (Object)1);
        users.createIndex((DBObject)index2, (DBObject)unique.append("name", (Object)"user_1_token_1").append("ns", (Object)(dbName + ".users")));
        index2 = new BasicDBObject();
        index2.put((Object)"user", (Object)1);
        index2.put((Object)"validity", (Object)-1);
        users.createIndex((DBObject)index2, (DBObject)unique.append("name", (Object)"user_1_validity_m1").append("ns", (Object)(dbName + ".users")));
        users.createIndex((DBObject)new BasicDBObject("user", (Object)1), (DBObject)unique.append("name", (Object)"user_1").append("ns", (Object)(dbName + ".users")));
        users.createIndex((DBObject)new BasicDBObject("spaces", (Object)1), (DBObject)notUnique.append("name", (Object)"spaces_1").append("ns", (Object)(dbName + ".users")));
        LOG.info("### users indexes in " + this.getDB().getName());
        LOG.info("### Indexes creation completed in " + this.getDB().getName());
    }

    static {
        LOG = Logger.getLogger("MongoBootstrap");
    }
}

