/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.chat.server;

import com.mongodb.BasicDBList;
import com.mongodb.BasicDBObject;
import com.mongodb.util.JSON;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLDecoder;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.mail.Address;
import javax.mail.Authenticator;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.Multipart;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.mail.util.ByteArrayDataSource;
import juzu.MimeType;
import juzu.Path;
import juzu.Resource;
import juzu.Response;
import juzu.Route;
import juzu.View;
import juzu.impl.common.Tools;
import juzu.request.ApplicationContext;
import juzu.request.UserContext;
import juzu.template.Template;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.chat.listener.GuiceManager;
import org.exoplatform.chat.model.MessageBean;
import org.exoplatform.chat.model.NotificationBean;
import org.exoplatform.chat.model.RealTimeMessageBean;
import org.exoplatform.chat.model.ReportBean;
import org.exoplatform.chat.model.RoomBean;
import org.exoplatform.chat.model.RoomsBean;
import org.exoplatform.chat.model.UserBean;
import org.exoplatform.chat.model.UsersBean;
import org.exoplatform.chat.server.ChatTools;
import org.exoplatform.chat.services.ChatException;
import org.exoplatform.chat.services.ChatService;
import org.exoplatform.chat.services.NotificationService;
import org.exoplatform.chat.services.RealTimeMessageService;
import org.exoplatform.chat.services.TokenService;
import org.exoplatform.chat.services.UserService;
import org.exoplatform.chat.utils.ChatUtils;
import org.exoplatform.chat.utils.PropertyManager;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.simple.JSONObject;

@ApplicationScoped
public class ChatServer {
    private static final Logger LOG = Logger.getLogger("ChatServer");
    @Inject
    @Path(value="index.gtmpl")
    Template index;
    ChatService chatService = (ChatService)GuiceManager.getInstance().getInstance(ChatService.class);
    UserService userService = (UserService)GuiceManager.getInstance().getInstance(UserService.class);
    TokenService tokenService = (TokenService)GuiceManager.getInstance().getInstance(TokenService.class);
    NotificationService notificationService = (NotificationService)GuiceManager.getInstance().getInstance(NotificationService.class);
    RealTimeMessageService realTimeMessageService = (RealTimeMessageService)GuiceManager.getInstance().getInstance(RealTimeMessageService.class);
    @Inject
    ChatTools chatTools;

    @View
    @Route(value="/")
    public Response.Content index() throws IOException {
        return this.index.ok();
    }

    @Resource
    @Route(value="/whoIsOnline")
    public Response.Content whoIsOnline(String user, String onlineUsers, String token, String filter, String limit, String dbName) {
        if (!this.tokenService.hasUserWithToken(user, token, dbName)) {
            return Response.notFound((CharSequence)"Petit malin !");
        }
        Integer ilimit = 0;
        try {
            if (limit != null && !"".equals(limit)) {
                ilimit = Integer.parseInt(limit);
            }
        }
        catch (NumberFormatException nfe) {
            LOG.info("limit is not a valid Integer number");
        }
        List<String> limitUsers = Arrays.asList(onlineUsers.split(","));
        RoomsBean roomsBean = this.chatService.getRooms(user, limitUsers, filter, true, true, true, true, false, ilimit.intValue(), this.notificationService, this.tokenService, dbName);
        roomsBean.getRooms().forEach(roomBean -> {
            if (StringUtils.isNotBlank((String)roomBean.getRoom())) {
                try {
                    roomBean.setFavorite(this.userService.isFavorite(user, roomBean.getRoom(), dbName));
                    String lastMesageString = this.chatService.read(user, roomBean.getRoom(), false, null, null, 1, dbName);
                    if (StringUtils.isNotBlank((String)lastMesageString)) {
                        org.json.JSONObject lastMessage = new org.json.JSONObject(lastMesageString);
                        lastMessage = lastMessage == null || lastMessage.get("messages") == null || ((JSONArray)lastMessage.get("messages")).length() == 0 ? null : (org.json.JSONObject)((JSONArray)lastMessage.get("messages")).get(0);
                        roomBean.setLastMessage(lastMessage);
                    }
                }
                catch (Exception e) {
                    LOG.log(Level.WARNING, "Error while building room bean " + roomBean.getRoom() + " for user " + user, e);
                }
            }
        });
        return Response.ok((CharSequence)roomsBean.roomsToJSON()).withMimeType("application/json").withHeader("Cache-Control", new String[]{"no-cache"}).withCharset(Tools.UTF_8);
    }

    @Resource
    @Route(value="/send")
    public Response.Content send(String sender, String token, String message, String room, String isSystem, String options, String dbName) throws IOException {
        if (!this.tokenService.hasUserWithToken(sender, token, dbName)) {
            return Response.notFound((CharSequence)"Petit malin !");
        }
        if (message != null) {
            try {
                message = URLDecoder.decode(message, "UTF-8");
                options = URLDecoder.decode(options, "UTF-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
            try {
                this.chatService.write(null, message, sender, room, isSystem, options, dbName);
            }
            catch (ChatException e) {
                return Response.content((int)e.getStatus(), (CharSequence)e.getMessage());
            }
        }
        return Response.ok((CharSequence)"ok").withMimeType("application/json; charset=UTF-8").withHeader("Cache-Control", new String[]{"no-cache"});
    }

    @Resource
    @Route(value="/read")
    public Response.Content read(String user, String token, String room, String fromTimestamp, String toTimestamp, String isTextOnly, String limit, String dbName) throws IOException {
        if (!this.tokenService.hasUserWithToken(user, token, dbName)) {
            return Response.notFound((CharSequence)"Petit malin !");
        }
        Long from = null;
        Long to = null;
        try {
            if (fromTimestamp != null && !fromTimestamp.isEmpty()) {
                from = Long.parseLong(fromTimestamp);
            }
            if (toTimestamp != null && !toTimestamp.isEmpty()) {
                to = Long.parseLong(toTimestamp);
            }
        }
        catch (NumberFormatException nfe) {
            LOG.info("fromTimestamp is not a valid Long number");
        }
        Integer ilimit = 0;
        try {
            if (limit != null && !"".equals(limit)) {
                ilimit = Integer.parseInt(limit);
            }
        }
        catch (NumberFormatException nfe) {
            LOG.info("limit is not a valid Integer number");
        }
        String data = null;
        try {
            data = this.chatService.read(user, room, "true".equals(isTextOnly), from, to, ilimit.intValue(), dbName);
            this.notificationService.setNotificationsAsRead(user, "chat", "room", room, dbName);
        }
        catch (Exception e) {
            if (e instanceof ChatException) {
                return Response.content((int)((ChatException)((Object)e)).getStatus(), (CharSequence)e.getMessage());
            }
            return Response.content((int)500, (CharSequence)e.getMessage());
        }
        return Response.ok((CharSequence)data).withMimeType("application/json").withHeader("Cache-Control", new String[]{"no-cache"}).withCharset(Tools.UTF_8);
    }

    @Resource
    @Route(value="/sendMeetingNotes")
    public Response.Content sendMeetingNotes(String user, String token, String room, String fromTimestamp, String toTimestamp, String serverBase, String dbName, ApplicationContext applicationContext, UserContext userContext) throws IOException {
        if (!this.tokenService.hasUserWithToken(user, token, dbName)) {
            return Response.notFound((CharSequence)"Petit malin !");
        }
        Long from = null;
        Long to = null;
        try {
            if (fromTimestamp != null && !"".equals(fromTimestamp)) {
                from = Long.parseLong(fromTimestamp);
            }
        }
        catch (NumberFormatException nfe) {
            LOG.info("fromTimestamp is not a valid Long number");
        }
        try {
            if (toTimestamp != null && !"".equals(toTimestamp)) {
                to = Long.parseLong(toTimestamp);
            }
        }
        catch (NumberFormatException nfe) {
            LOG.info("fromTimestamp is not a valid Long number");
        }
        String data = this.chatService.read(user, room, false, from, to, 0, dbName);
        BasicDBObject datao = (BasicDBObject)JSON.parse((String)data);
        String roomType = this.chatService.getTypeRoomChat(room, dbName);
        SimpleDateFormat formatter = new SimpleDateFormat("dd/MM/yyyy");
        String date = formatter.format(new GregorianCalendar().getTime());
        String title = "";
        String roomName = "";
        ArrayList<UserBean> users = new ArrayList();
        Locale locale = userContext.getLocale();
        ResourceBundle res = applicationContext.resolveBundle(locale);
        if (datao.containsField("messages")) {
            if ("u".equalsIgnoreCase(roomType)) {
                users = this.userService.getUsersInRoomChatOneToOne(room, dbName);
                title = res.getString("exoplatform.chat.meetingnotes") + " [" + date + "]";
            } else {
                users = this.userService.getUsers(room, dbName);
                List spaces = this.userService.getSpaces(user, dbName);
                for (Object spaceBean : spaces) {
                    if (!room.equals(spaceBean.getRoom())) continue;
                    roomName = spaceBean.getDisplayName();
                }
                List roomBeans = this.userService.getTeams(user, dbName);
                for (RoomBean roomBean : roomBeans) {
                    if (!room.equals(roomBean.getRoom())) continue;
                    roomName = roomBean.getFullName();
                }
                title = roomName + " : " + res.getString("exoplatform.chat.meetingnotes") + " [" + date + "]";
            }
            ReportBean reportBean = new ReportBean(res);
            reportBean.fill((BasicDBList)datao.get("messages"), users);
            ArrayList<String> tos = new ArrayList<String>();
            String senderName = user;
            String senderMail = "";
            for (UserBean userBean : users) {
                if (!"".equals(userBean.getEmail())) {
                    tos.add(userBean.getEmail());
                }
                if (!user.equals(userBean.getName())) continue;
                senderName = userBean.getFullname();
                senderMail = userBean.getEmail();
            }
            String html = reportBean.getAsHtml(title, serverBase, locale);
            String prevUser = "";
            int index2 = 0;
            HashMap<String, String> inlineImages = new HashMap<String, String>();
            for (MessageBean messageBean : reportBean.getMessages()) {
                if (!messageBean.getUser().equals(prevUser)) {
                    String keyAvatar = messageBean.getUser() + index2;
                    String valueAvatar = serverBase + "/rest/v1/social/users/{}/avatar".replace("{}", messageBean.getUser());
                    inlineImages.put(keyAvatar, valueAvatar);
                    ++index2;
                }
                prevUser = messageBean.getUser();
            }
            try {
                this.sendMailWithAuth(senderName, senderMail, tos, html, title, inlineImages);
            }
            catch (Exception e) {
                LOG.info(e.getMessage());
            }
        }
        return Response.ok((CharSequence)"sent").withMimeType("text/event-stream; charset=UTF-8").withHeader("Cache-Control", new String[]{"no-cache"});
    }

    @Resource
    @Route(value="/getMeetingNotes")
    public Response.Content getMeetingNotes(String user, String token, String room, String fromTimestamp, String toTimestamp, String serverBase, String dbName, String portalURI, ApplicationContext applicationContext, UserContext userContext) throws IOException {
        if (!this.tokenService.hasUserWithToken(user, token, dbName)) {
            return Response.notFound((CharSequence)"Petit malin !");
        }
        Long from = null;
        Long to = null;
        String xwiki = "";
        String roomName = "";
        ArrayList<UserBean> users = new ArrayList();
        JSONObject jsonObject = new JSONObject();
        try {
            if (fromTimestamp != null && !"".equals(fromTimestamp)) {
                from = Long.parseLong(fromTimestamp);
            }
        }
        catch (NumberFormatException nfe) {
            LOG.info("fromTimestamp is not a valid Long number");
        }
        try {
            if (toTimestamp != null && !"".equals(toTimestamp)) {
                to = Long.parseLong(toTimestamp);
            }
        }
        catch (NumberFormatException nfe) {
            LOG.info("fromTimestamp is not a valid Long number");
        }
        String data = this.chatService.read(user, room, false, from, to, 0, dbName);
        String typeRoom = this.chatService.getTypeRoomChat(room, dbName);
        BasicDBObject datao = (BasicDBObject)JSON.parse((String)data);
        if (datao.containsField("messages")) {
            if ("u".equalsIgnoreCase(typeRoom)) {
                users = this.userService.getUsersInRoomChatOneToOne(room, dbName);
            } else {
                users = this.userService.getUsers(room, dbName);
                List spaces = this.userService.getSpaces(user, dbName);
                for (Object spaceBean : spaces) {
                    if (!room.equals(spaceBean.getRoom())) continue;
                    roomName = spaceBean.getDisplayName();
                }
                List roomBeans = this.userService.getTeams(user, dbName);
                for (RoomBean roomBean : roomBeans) {
                    if (!room.equals(roomBean.getRoom())) continue;
                    roomName = roomBean.getFullName();
                }
            }
            Locale locale = userContext.getLocale();
            ResourceBundle res = applicationContext.resolveBundle(locale);
            ReportBean reportBean = new ReportBean(res);
            reportBean.fill((BasicDBList)datao.get("messages"), users);
            ArrayList<String> usersInGroup = new ArrayList<String>();
            xwiki = reportBean.getAsXWiki(serverBase, portalURI);
            try {
                for (UserBean userBean : users) {
                    if ("".equals(userBean.getName())) continue;
                    usersInGroup.add(userBean.getName());
                }
                jsonObject.put((Object)"users", usersInGroup);
                jsonObject.put((Object)"xwiki", (Object)xwiki);
                jsonObject.put((Object)"typeRoom", (Object)typeRoom);
            }
            catch (Exception e) {
                LOG.warning(e.getMessage());
                return Response.notFound((CharSequence)"No Room yet");
            }
        }
        return Response.ok((CharSequence)jsonObject.toString()).withMimeType("application/json").withHeader("Cache-Control", new String[]{"no-cache"}).withCharset(Tools.UTF_8);
    }

    @Resource
    @MimeType(value={"text/plain"})
    @Route(value="/delete")
    public Response.Content delete(String user, String token, String room, String messageId, String dbName) throws IOException {
        if (!this.tokenService.hasUserWithToken(user, token, dbName)) {
            return Response.notFound((CharSequence)"Petit malin !");
        }
        MessageBean message = this.chatService.getMessage(room, messageId, dbName);
        if (message == null || !message.getUser().equals(user)) {
            return Response.notFound((CharSequence)"");
        }
        try {
            this.chatService.delete(room, user, messageId, dbName);
        }
        catch (Exception e) {
            return Response.notFound((CharSequence)"Oups");
        }
        return Response.ok((CharSequence)"Updated!");
    }

    @Resource
    @MimeType(value={"text/plain"})
    @Route(value="/deleteTeamRoom")
    public Response.Content deleteTeamRoom(String user, String token, String room, String dbName) throws IOException {
        if (!this.tokenService.hasUserWithToken(user, token, dbName)) {
            return Response.notFound((CharSequence)"Petit malin !");
        }
        try {
            this.chatService.deleteTeamRoom(room, user, dbName);
        }
        catch (Exception e) {
            LOG.log(Level.SEVERE, "Impossible to delete Team Room [" + room + "] : " + e.getMessage(), e);
            return Response.content((int)500, (CharSequence)"Oups!");
        }
        return Response.ok((CharSequence)"Updated!");
    }

    @Resource
    @MimeType(value={"text/plain"})
    @Route(value="/edit")
    public Response.Content edit(String user, String token, String room, String messageId, String message, String dbName) throws IOException {
        if (!this.tokenService.hasUserWithToken(user, token, dbName)) {
            return Response.notFound((CharSequence)"Petit malin !");
        }
        MessageBean currentMessage = this.chatService.getMessage(room, messageId, dbName);
        if (currentMessage == null || !currentMessage.getUser().equals(user)) {
            return Response.notFound((CharSequence)"");
        }
        try {
            try {
                message = URLDecoder.decode(message, "UTF-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
            this.chatService.edit(room, user, messageId, message, dbName);
        }
        catch (Exception e) {
            return Response.notFound((CharSequence)"Oups");
        }
        return Response.ok((CharSequence)"Updated!");
    }

    @Resource
    @MimeType(value={"text/plain"})
    @Route(value="/toggleFavorite")
    public Response.Content toggleFavorite(String user, String token, String targetUser, String favorite, String dbName) {
        if (!this.tokenService.hasUserWithToken(user, token, dbName)) {
            return Response.notFound((CharSequence)"Petit malin !");
        }
        if (Boolean.valueOf(favorite).booleanValue()) {
            this.userService.addFavorite(user, targetUser, dbName);
        } else {
            this.userService.removeFavorite(user, targetUser, dbName);
        }
        return Response.ok((CharSequence)"Updated!");
    }

    @Resource
    @MimeType(value={"text/plain"})
    @Route(value="/isFavorite")
    public Response.Content isFavorite(String user, String token, String targetUser, String dbName) {
        if (!this.tokenService.hasUserWithToken(user, token, dbName)) {
            return Response.notFound((CharSequence)"Petit malin !");
        }
        boolean isFavorite = false;
        try {
            isFavorite = this.userService.isFavorite(user, targetUser, dbName);
        }
        catch (Exception e) {
            LOG.log(Level.WARNING, e.getMessage());
            return Response.notFound((CharSequence)"Oups");
        }
        return Response.ok((CharSequence)String.valueOf(isFavorite));
    }

    @Resource
    @MimeType(value={"application/json"})
    @Route(value="/getUserDesktopNotificationSettings")
    public Response.Content getUserDesktopNotificationSettings(String user, String token, String dbName) throws JSONException {
        if (!this.tokenService.hasUserWithToken(user, token, dbName)) {
            return Response.notFound((CharSequence)"Something is wrong.");
        }
        JSONObject response = new JSONObject();
        JSONObject res = this.userService.getUserDesktopNotificationSettings(user, dbName).toJSON();
        if (res == null || res.isEmpty()) {
            response.put((Object)"done", (Object)false);
        } else {
            response.put((Object)"done", (Object)true);
        }
        response.put((Object)"userDesktopNotificationSettings", (Object)res);
        return Response.ok((CharSequence)response.toString()).withHeader("Cache-Control", new String[]{"no-cache"}).withCharset(Tools.UTF_8);
    }

    @Resource
    @MimeType(value={"text/plain"})
    @Route(value="/setPreferredNotification")
    public Response.Content setPreferredNotification(String user, String token, String notifManner, String dbName) throws JSONException {
        if (!this.tokenService.hasUserWithToken(user, token, dbName)) {
            return Response.notFound((CharSequence)"Something is wrong.");
        }
        JSONObject response = new JSONObject();
        try {
            this.userService.setPreferredNotification(user, notifManner, dbName);
            response.put((Object)"done", (Object)true);
        }
        catch (Exception e) {
            response.put((Object)"done", (Object)false);
        }
        return Response.ok((CharSequence)response.toString()).withMimeType("application/json").withHeader("Cache-Control", new String[]{"no-cache"}).withCharset(Tools.UTF_8);
    }

    @Resource
    @MimeType(value={"text/plain"})
    @Route(value="/setRoomNotificationTrigger")
    public Response.Content setRoomNotificationTrigger(String user, String token, String room, String notifCondition, String notifConditionType, String dbName, Long time) throws JSONException {
        if (!this.tokenService.hasUserWithToken(user, token, dbName)) {
            return Response.notFound((CharSequence)"Something is wrong.");
        }
        try {
            this.userService.setRoomNotificationTrigger(user, room, notifCondition, notifConditionType, dbName, time.longValue());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.getUserDesktopNotificationSettings(user, token, dbName);
    }

    @Resource
    @MimeType(value={"text/plain"})
    @Route(value="/setNotificationSettings")
    public Response.Content setNotificationSettings(String user, String token, String room, String[] notifConditions, String[] notifManners, String dbName, Long time) throws JSONException {
        if (!this.tokenService.hasUserWithToken(user, token, dbName)) {
            return Response.notFound((CharSequence)"Something is wrong.");
        }
        if (notifConditions != null) {
            for (String notifCondition : notifConditions) {
                try {
                    this.userService.setPreferredNotification(user, notifCondition, dbName);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        if (notifManners != null) {
            for (String notifManner : notifManners) {
                try {
                    this.userService.setNotificationTrigger(user, notifManner, dbName);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return this.getUserDesktopNotificationSettings(user, token, dbName);
    }

    @Resource
    @MimeType(value={"text/plain"})
    @Route(value="/setNotificationTrigger")
    public Response.Content setNotificationTrigger(String user, String token, String notifCondition, String dbName) throws JSONException {
        if (!this.tokenService.hasUserWithToken(user, token, dbName)) {
            return Response.notFound((CharSequence)"Something is wrong.");
        }
        try {
            this.userService.setNotificationTrigger(user, notifCondition, dbName);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.getUserDesktopNotificationSettings(user, token, dbName);
    }

    @Resource
    @Route(value="/getRoom")
    public Response.Content getRoom(String user, String token, String targetUser, String isAdmin, String withDetail, String type, String dbName) {
        if (!this.tokenService.hasUserWithToken(user, token, dbName)) {
            return Response.notFound((CharSequence)"Petit malin !");
        }
        String room = targetUser;
        RoomBean roomBean = null;
        try {
            ArrayList<String> users;
            if (type != null) {
                if ("room-id".equals(type)) {
                    room = targetUser;
                } else if ("space-name".equals(type)) {
                    room = this.chatService.getSpaceRoomByName(targetUser, dbName);
                } else if ("space-id".equals(type)) {
                    room = ChatUtils.getRoomId((String)targetUser);
                } else if ("username".equals(type)) {
                    users = new ArrayList();
                    users.add(user);
                    users.add(targetUser);
                    room = this.chatService.getRoom(users, dbName);
                } else if ("external".equals(type)) {
                    room = this.chatService.getExternalRoom(targetUser, dbName);
                }
            } else if (targetUser.startsWith("space-")) {
                room = this.chatService.getSpaceRoom(targetUser, dbName);
            } else if (targetUser.startsWith("team-")) {
                room = this.chatService.getTeamRoom(targetUser, user, dbName);
            } else if (targetUser.startsWith("external-")) {
                room = this.chatService.getExternalRoom(targetUser, dbName);
            } else {
                users = new ArrayList<String>(2);
                users.add(user);
                users.add(targetUser);
                room = this.chatService.getRoom(users, dbName);
            }
            if ("true".equals(withDetail)) {
                roomBean = this.userService.getRoom(user, room, dbName);
            }
            this.notificationService.setNotificationsAsRead(user, "chat", "room", room, dbName);
        }
        catch (Exception e) {
            LOG.log(Level.WARNING, e.getMessage());
            return Response.notFound((CharSequence)"No Room yet");
        }
        String out = room;
        if (roomBean != null) {
            out = roomBean.toJSON();
        }
        return Response.ok((CharSequence)out).withMimeType("application/json").withCharset(Tools.UTF_8).withHeader("Cache-Control", new String[]{"no-cache"});
    }

    @Resource
    @Route(value="/saveTeamRoom")
    public Response.Content saveTeamRoom(String user, String token, String teamName, String room, String users, String dbName) {
        if (!this.tokenService.hasUserWithToken(user, token, dbName)) {
            return Response.notFound((CharSequence)"Petit malin !");
        }
        try {
            teamName = URLDecoder.decode(teamName, "UTF-8");
            teamName = teamName.trim();
        }
        catch (UnsupportedEncodingException e) {
            LOG.info("Cannot decode message: " + teamName);
        }
        JSONObject jsonObject = new JSONObject();
        try {
            String creator;
            List existingUsers;
            if ("".equals(teamName)) {
                return Response.content((int)400, (CharSequence)"Data is invalid!");
            }
            if (room == null || "".equals(room) || "---".equals(room)) {
                List roomBeans = this.chatService.getTeamRoomsByName(teamName, dbName);
                if (roomBeans != null && !roomBeans.isEmpty()) {
                    for (RoomBean roomBean : roomBeans) {
                        if (user.equals(roomBean.getUser())) {
                            return Response.content((int)400, (CharSequence)"roomAlreadyExists.creator");
                        }
                        existingUsers = this.userService.getUsersFilterBy(null, roomBean.getRoom(), "t", dbName);
                        if (existingUsers == null || !existingUsers.contains(user)) continue;
                        return Response.content((int)400, (CharSequence)"roomAlreadyExists.notCreator");
                    }
                }
                room = this.chatService.getTeamRoom(teamName, user, dbName);
            }
            if (!user.equals(creator = this.chatService.getTeamCreator(room, dbName))) {
                return Response.notFound((CharSequence)"Petit malin !");
            }
            org.json.simple.JSONArray usersToNotifyForAdd = new org.json.simple.JSONArray();
            org.json.simple.JSONArray usersToAdd = new org.json.simple.JSONArray();
            if (users != null && !users.isEmpty()) {
                StringBuilder sbUsers;
                existingUsers = this.userService.getUsersFilterBy(null, room, "t", dbName);
                List<String> usersNew = Arrays.asList(users.split(","));
                usersToAdd.addAll(usersNew);
                org.json.simple.JSONArray usersToRemove = new org.json.simple.JSONArray();
                for (String u : existingUsers) {
                    if (usersNew.contains(u)) {
                        usersToNotifyForAdd.add(u);
                        usersToAdd.remove(u);
                        continue;
                    }
                    usersToRemove.add(u);
                }
                if (usersToRemove.size() > 0) {
                    this.userService.removeTeamUsers(room, (List)usersToRemove, dbName);
                    sbUsers = new StringBuilder();
                    boolean first = true;
                    for (String u : usersToRemove) {
                        if (!first) {
                            sbUsers.append("; ");
                        }
                        sbUsers.append(this.userService.getUserFullName(u, dbName));
                        first = false;
                        this.notificationService.setNotificationsAsRead(u, "chat", "room", room, dbName);
                    }
                    String removeTeamUserOptions = "{\"type\":\"type-remove-team-user\",\"users\":\"" + sbUsers + "\", \"fullname\":\"" + this.userService.getUserFullName(user, dbName) + "\"}";
                    this.send(user, token, "", room, "true", removeTeamUserOptions, dbName);
                }
                this.chatService.setRoomName(room, teamName, dbName);
                if (usersToAdd.size() > 0) {
                    this.userService.addTeamUsers(room, (List)usersToAdd, dbName);
                    sbUsers = new StringBuilder();
                    boolean first = true;
                    for (String usert : usersToAdd) {
                        if (usert.equals(creator)) continue;
                        if (!first) {
                            sbUsers.append("; ");
                        }
                        sbUsers.append(this.userService.getUserFullName(usert, dbName));
                        first = false;
                    }
                    String addTeamUserOptions = "{\"type\":\"type-add-team-user\",\"users\":\"" + sbUsers + "\", \"fullname\":\"" + this.userService.getUserFullName(user, dbName) + "\"}";
                    this.send(user, token, "", room, "true", addTeamUserOptions, dbName);
                }
            }
            RoomBean roomBean = this.userService.getRoom(user, room, dbName);
            JSONObject data = roomBean.toJSONObject();
            data.put((Object)"title", (Object)teamName);
            data.put((Object)"participants", (Object)usersToAdd);
            RealTimeMessageBean updatedRoomMessage = new RealTimeMessageBean(RealTimeMessageBean.EventType.ROOM_UPDATED, room, user, null, (Map)data);
            if (!usersToNotifyForAdd.contains(creator)) {
                usersToNotifyForAdd.add(creator);
            }
            this.realTimeMessageService.sendMessage(updatedRoomMessage, (List<String>)usersToNotifyForAdd);
            jsonObject.putAll((Map)data);
            jsonObject.put((Object)"name", (Object)teamName);
            jsonObject.put((Object)"room", (Object)room);
        }
        catch (Exception e) {
            LOG.log(Level.WARNING, "Error while saving room " + teamName, e);
            return Response.notFound((CharSequence)"No Room yet");
        }
        return Response.ok((CharSequence)jsonObject.toString()).withMimeType("application/json").withHeader("Cache-Control", new String[]{"no-cache"}).withCharset(Tools.UTF_8);
    }

    @Resource
    @MimeType(value={"text/plain"})
    @Route(value="/updateUnreadMessages")
    public Response.Content updateUnreadMessages(String room, String user, String token, String dbName) {
        if (!this.tokenService.hasUserWithToken(user, token, dbName)) {
            return Response.notFound((CharSequence)"Petit malin !");
        }
        try {
            this.notificationService.setNotificationsAsRead(user, "chat", "room", room, dbName);
            if (this.userService.isAdmin(user, dbName)) {
                this.notificationService.setNotificationsAsRead("__support_", "chat", "room", room, dbName);
            }
        }
        catch (Exception e) {
            LOG.warning(e.getMessage());
            return Response.notFound((CharSequence)"Server Not Available yet");
        }
        return Response.ok((CharSequence)"Updated.");
    }

    @Resource
    @Route(value="/notification")
    public Response.Content notification(String user, String token, String event, String withDetails, String dbName) throws IOException {
        String data;
        if (!this.tokenService.hasUserWithToken(user, token, dbName)) {
            return Response.notFound((CharSequence)"Petit malin !");
        }
        boolean detailed = Boolean.valueOf(withDetails);
        int totalUnread = 0;
        List notifications = null;
        if (!detailed) {
            totalUnread = this.notificationService.getUnreadNotificationsTotal(user, dbName);
            if (this.userService.isAdmin(user, dbName)) {
                totalUnread += this.notificationService.getUnreadNotificationsTotal("__support_", dbName);
            }
        } else {
            notifications = this.notificationService.getUnreadNotifications(user, this.userService, dbName);
            totalUnread = notifications.size();
        }
        if (event != null && event.equals("1")) {
            data = "id: " + totalUnread + "\n";
            data = data + "data: {\"total\": " + totalUnread + "}\n\n";
        } else {
            JSONObject json = new JSONObject();
            json.put((Object)"total", (Object)totalUnread);
            if (detailed && notifications != null) {
                org.json.simple.JSONArray notifies = new org.json.simple.JSONArray();
                for (NotificationBean o : notifications) {
                    notifies.add((Object)o.toJSONObject());
                }
                json.put((Object)"notifications", (Object)notifies);
            }
            data = json.toJSONString();
        }
        return Response.ok((CharSequence)data).withMimeType("application/json").withCharset(Tools.UTF_8).withHeader("Cache-Control", new String[]{"no-cache"});
    }

    @Resource
    @MimeType(value={"text/plain"})
    @Route(value="/getStatus")
    public Response.Content getStatus(String user, String token, String targetUser, String dbName) {
        if (!this.tokenService.hasUserWithToken(user, token, dbName)) {
            return Response.notFound((CharSequence)"Petit malin !");
        }
        String status = "invisible";
        try {
            if (targetUser != null) {
                status = this.userService.getStatus(targetUser, dbName);
            }
        }
        catch (Exception e) {
            LOG.warning(e.getMessage());
            return Response.notFound((CharSequence)status);
        }
        return Response.ok((CharSequence)status).withHeader("Cache-Control", new String[]{"no-cache"});
    }

    @Resource
    @MimeType(value={"text/plain"})
    @Route(value="/setStatus")
    public Response.Content setStatus(String user, String token, String status, String dbName) {
        if (!this.tokenService.hasUserWithToken(user, token, dbName)) {
            return Response.notFound((CharSequence)"Petit malin !");
        }
        try {
            this.userService.setStatus(user, status, dbName);
        }
        catch (Exception e) {
            LOG.warning(e.getMessage());
            return Response.notFound((CharSequence)"No Status for this User");
        }
        return Response.ok((CharSequence)status);
    }

    @Resource
    @MimeType(value={"text/plain"})
    @Route(value="/getCreator")
    public Response.Content getCreator(String user, String token, String room, String dbName) {
        String creator = "";
        if (!this.tokenService.hasUserWithToken(user, token, dbName)) {
            return Response.notFound((CharSequence)"Petit malin !");
        }
        try {
            creator = this.chatService.getTeamCreator(room, dbName);
        }
        catch (Exception e) {
            LOG.warning(e.getMessage());
            return Response.notFound((CharSequence)"No Status for this User");
        }
        return Response.ok((CharSequence)creator);
    }

    @Resource
    @Route(value="/users")
    public Response.Content getUsers(String user, String token, String room, String filter, String limit, String dbName) {
        if (!this.tokenService.hasUserWithToken(user, token, dbName)) {
            return Response.notFound((CharSequence)"Petit malin !");
        }
        int limit_ = 0;
        try {
            if (limit != null) {
                limit_ = Integer.valueOf(limit);
            }
        }
        catch (NumberFormatException e) {
            return Response.status((int)400).content((CharSequence)"The 'limit' parameter value is invalid");
        }
        List users = this.userService.getUsers(room, filter, limit_, dbName);
        UsersBean usersBean = new UsersBean();
        usersBean.setUsers(users);
        return Response.ok((CharSequence)usersBean.usersToJSON()).withMimeType("application/json").withHeader("Cache-Control", new String[]{"no-cache"}).withCharset(Tools.UTF_8);
    }

    @Resource
    @Route(value="/statistics")
    public Response.Content getStatistics(String dbName) {
        StringBuffer data = new StringBuffer();
        data.append("{");
        data.append(" \"users\": " + this.userService.getNumberOfUsers(dbName) + ", ");
        data.append(" \"rooms\": " + this.chatService.getNumberOfRooms(dbName) + ", ");
        data.append(" \"messages\": " + this.chatService.getNumberOfMessages(dbName) + ", ");
        data.append(" \"notifications\": " + this.notificationService.getNumberOfNotifications(dbName) + ", ");
        data.append(" \"notificationsUnread\": " + this.notificationService.getNumberOfUnreadNotifications(dbName));
        data.append("}");
        return Response.ok((CharSequence)data.toString()).withMimeType("application/json").withCharset(Tools.UTF_8).withHeader("Cache-Control", new String[]{"no-cache"});
    }

    private Session getMailSession() {
        String protocal = PropertyManager.getProperty((String)"email.smtp.protocal");
        String host = PropertyManager.getProperty((String)"email.smtp.host");
        final String user = PropertyManager.getProperty((String)"email.smtp.username");
        final String password = PropertyManager.getProperty((String)"email.smtp.password");
        String port = PropertyManager.getProperty((String)"email.smtp.port");
        String auth = PropertyManager.getProperty((String)"email.smtp.auth");
        String starttlsEnable = PropertyManager.getProperty((String)"email.smtp.starttls.enable");
        String enableSSL = PropertyManager.getProperty((String)"email.smtp.EnableSSL.enable");
        String smtpAuth = PropertyManager.getProperty((String)"email.smtp.auth");
        String socketFactoryPort = PropertyManager.getProperty((String)"email.smtp.socketFactory.port");
        String socketFactoryClass = PropertyManager.getProperty((String)"email.smtp.socketFactory.class");
        String socketFactoryFallback = PropertyManager.getProperty((String)"email.smtp.socketFactory.fallback");
        Properties props = new Properties();
        props.put("mail.transport.protocol", protocal);
        props.put("mail.smtp.host", host);
        props.put("mail.smtp.port", port);
        props.put("mail.smtp.auth", auth);
        if (Boolean.parseBoolean(smtpAuth)) {
            props.put("mail.smtp.socketFactory.port", socketFactoryPort);
            props.put("mail.smtp.socketFactory.class", socketFactoryClass);
            props.put("mail.smtp.socketFactory.fallback", socketFactoryFallback);
            props.put("mail.smtp.starttls.enable", starttlsEnable);
            props.put("mail.smtp.ssl.enable", enableSSL);
            return Session.getInstance((Properties)props, (Authenticator)new Authenticator(){

                protected PasswordAuthentication getPasswordAuthentication() {
                    return new PasswordAuthentication(user, password);
                }
            });
        }
        return Session.getInstance((Properties)props);
    }

    public void sendMailWithAuth(String senderFullname, String senderMail, List<String> toList, String htmlBody, String subject, Map<String, String> inlineImages) throws Exception {
        Session session = this.getMailSession();
        MimeMessage message = new MimeMessage(session);
        message.setFrom((Address)new InternetAddress(senderMail, senderFullname, "UTF-8"));
        for (String to : toList) {
            message.addRecipients(Message.RecipientType.BCC, (Address[])InternetAddress.parse((String)to));
        }
        message.setSubject(subject, "UTF-8");
        MimeMultipart multipart = new MimeMultipart();
        MimeBodyPart messageBodyPart = new MimeBodyPart();
        messageBodyPart.setContent((Object)htmlBody, "text/html; charset=UTF-8");
        multipart.addBodyPart((BodyPart)messageBodyPart);
        if (inlineImages != null && inlineImages.size() > 0) {
            Set<String> setImageID = inlineImages.keySet();
            for (String contentId : setImageID) {
                messageBodyPart = new MimeBodyPart();
                String imageFilePath = inlineImages.get(contentId);
                URL url = new URL(imageFilePath);
                URLConnection con = url.openConnection();
                con.setDoOutput(true);
                InputStream is = con.getInputStream();
                ByteArrayDataSource byteArrayDataSource = new ByteArrayDataSource(is, con.getContentType());
                messageBodyPart.setDataHandler(new DataHandler((DataSource)byteArrayDataSource));
                messageBodyPart.setContentID("<" + contentId + ">");
                messageBodyPart.setDisposition("inline");
                multipart.addBodyPart((BodyPart)messageBodyPart);
            }
        }
        message.setContent((Multipart)multipart);
        try {
            Transport.send((Message)message);
        }
        catch (Exception e) {
            LOG.info(e.getMessage());
        }
    }
}

