/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.chat.services;

import java.util.HashMap;
import java.util.List;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.exoplatform.chat.model.NotificationBean;
import org.exoplatform.chat.model.RealTimeMessageBean;
import org.exoplatform.chat.services.NotificationDataStorage;
import org.exoplatform.chat.services.NotificationService;
import org.exoplatform.chat.services.RealTimeMessageService;
import org.exoplatform.chat.services.UserService;

@Named(value="notificationService")
@ApplicationScoped
@Singleton
public class NotificationServiceImpl
implements NotificationService {
    @Inject
    private RealTimeMessageService realTimeMessageService;
    @Inject
    private NotificationDataStorage storage;

    public void addNotification(String receiver, String sender, String type, String category, String categoryId, String content, String link, String dbName) {
        this.storage.addNotification(receiver, sender, type, category, categoryId, content, link, null, dbName);
    }

    public void addNotification(String receiver, String sender, String type, String category, String categoryId, String content, String link, String options, String dbName) {
        this.storage.addNotification(receiver, sender, type, category, categoryId, content, link, options, dbName);
        this.sendNotification(receiver, dbName);
    }

    public void setNotificationsAsRead(String user, String type, String category, String categoryId, String dbName) {
        this.storage.setNotificationsAsRead(user, type, category, categoryId, dbName);
        this.sendNotification(user, dbName);
    }

    public List<NotificationBean> getUnreadNotifications(String user, UserService userService, String dbName) {
        return this.getUnreadNotifications(user, userService, null, null, null, dbName);
    }

    public List<NotificationBean> getUnreadNotifications(String user, UserService userService, String type, String category, String categoryId, String dbName) {
        return this.storage.getUnreadNotifications(user, userService, type, category, categoryId, dbName);
    }

    public int getUnreadNotificationsTotal(String user, String dbName) {
        return this.getUnreadNotificationsTotal(user, null, null, null, dbName);
    }

    public int getUnreadNotificationsTotal(String user, String type, String category, String categoryId, String dbName) {
        return this.storage.getUnreadNotificationsTotal(user, type, category, categoryId, dbName);
    }

    public int getNumberOfNotifications(String dbName) {
        return this.storage.getNumberOfNotifications(dbName);
    }

    public int getNumberOfUnreadNotifications(String dbName) {
        return this.storage.getNumberOfUnreadNotifications(dbName);
    }

    private void sendNotification(String receiver, String dbName) {
        HashMap<String, Integer> data = new HashMap<String, Integer>();
        data.put("totalUnreadMsg", this.getUnreadNotificationsTotal(receiver, dbName));
        RealTimeMessageBean messageBean = new RealTimeMessageBean(RealTimeMessageBean.EventType.NOTIFICATION_COUNT_UPDATED, null, receiver, null, data);
        this.realTimeMessageService.sendMessage(messageBean, receiver);
    }
}

