/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.chat.services.mongodb;

import com.mongodb.BasicDBObject;
import com.mongodb.DB;
import com.mongodb.DBCollection;
import com.mongodb.DBCursor;
import com.mongodb.DBObject;
import com.mongodb.WriteConcern;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.chat.listener.ConnectionManager;
import org.exoplatform.chat.model.NotificationSettingsBean;
import org.exoplatform.chat.model.RoomBean;
import org.exoplatform.chat.model.SpaceBean;
import org.exoplatform.chat.model.UserBean;
import org.exoplatform.chat.services.UserDataStorage;
import org.exoplatform.chat.utils.ChatUtils;
import org.json.JSONException;

@Named(value="userStorage")
@ApplicationScoped
@Singleton
public class UserMongoDataStorage
implements UserDataStorage {
    private static final Logger LOG = Logger.getLogger(UserMongoDataStorage.class.getName());
    public static final String M_USERS_COLLECTION = "users";
    public static final String M_ROOMS_COLLECTION = "rooms";
    public static final String DEFAULT_ENABLED_CHANNELS = "[ \"desktop\" , \"on-site\" , \"bip\"]";

    private DB db() {
        return ConnectionManager.getInstance().getDB();
    }

    @Override
    public void addFavorite(String user, String targetUser) {
        DBCollection coll = this.db().getCollection(M_USERS_COLLECTION);
        BasicDBObject query = new BasicDBObject();
        query.put((Object)"user", (Object)user);
        DBCursor cursor = coll.find((DBObject)query);
        if (cursor.hasNext()) {
            DBObject doc = cursor.next();
            List<String> favorites = new ArrayList();
            if (doc.containsField("favorites")) {
                favorites = (List)doc.get("favorites");
            }
            if (!favorites.contains(targetUser)) {
                favorites.add(targetUser);
                doc.put("favorites", favorites);
                coll.save(doc, WriteConcern.SAFE);
            }
        }
    }

    @Override
    public void removeFavorite(String user, String targetUser) {
        DBCollection coll = this.db().getCollection(M_USERS_COLLECTION);
        BasicDBObject query = new BasicDBObject();
        query.put((Object)"user", (Object)user);
        DBCursor cursor = coll.find((DBObject)query);
        if (cursor.hasNext()) {
            DBObject doc = cursor.next();
            List favorites = new ArrayList();
            if (doc.containsField("favorites") && (favorites = (List)doc.get("favorites")).contains(targetUser)) {
                favorites.remove(targetUser);
                doc.put("favorites", favorites);
                coll.save(doc, WriteConcern.SAFE);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void setPreferredNotification(String user, String notifManner) throws Exception {
        DBCollection coll = this.db().getCollection(M_USERS_COLLECTION);
        BasicDBObject query = new BasicDBObject();
        query.put((Object)"user", (Object)user);
        DBCursor cursor = coll.find((DBObject)query);
        if (!cursor.hasNext()) throw new Exception("Doc not found, operation not done");
        DBObject doc = cursor.next();
        if (!"bip".equals(notifManner) && !"desktop".equals(notifManner) && !"on-site".equals(notifManner)) throw new Exception("Wrong Params, operation not done");
        BasicDBObject settings = (BasicDBObject)doc.get("notificationsSettings");
        Object prefNotif = null;
        Object prefTriger = null;
        Object existingRoomNotif = null;
        if (settings != null) {
            prefNotif = settings.get("preferredNotification");
            prefTriger = settings.get("preferredNotificationTrigger");
            existingRoomNotif = settings.get("preferredRoomNotificationTrigger");
        } else {
            settings = new BasicDBObject();
        }
        ArrayList<String> existingPrefNotif = null;
        if (prefNotif == null) {
            existingPrefNotif = new ArrayList<String>();
            existingPrefNotif.add("on-site");
            existingPrefNotif.add("desktop");
            existingPrefNotif.add("bip");
        } else {
            existingPrefNotif = (ArrayList<String>)prefNotif;
        }
        if (existingPrefNotif.contains(notifManner)) {
            existingPrefNotif.remove(notifManner);
        } else {
            existingPrefNotif.add(notifManner);
        }
        if (existingPrefNotif != null) {
            settings.put((Object)"preferredNotification", existingPrefNotif);
        }
        if (prefTriger != null) {
            settings.put((Object)"preferredNotificationTrigger", prefTriger);
        }
        if (existingRoomNotif != null) {
            settings.put((Object)"preferredRoomNotificationTrigger", existingRoomNotif);
        }
        doc.put("notificationsSettings", (Object)settings);
        coll.save(doc, WriteConcern.ACKNOWLEDGED);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void setNotificationTrigger(String user, String notifCond) throws Exception {
        DBCollection coll = this.db().getCollection(M_USERS_COLLECTION);
        BasicDBObject query = new BasicDBObject();
        query.put((Object)"user", (Object)user);
        DBCursor cursor = coll.find((DBObject)query);
        if (!cursor.hasNext()) throw new Exception("Doc not found, operation not done");
        DBObject doc = cursor.next();
        if (!"notify-even-not-disturb".equals(notifCond) && !"notify-when-mention".equals(notifCond)) throw new Exception("Wrong Params, operation not done");
        BasicDBObject settings = (BasicDBObject)doc.get("notificationsSettings");
        Object prefNotif = null;
        Object prefTriger = null;
        Object existingRoomNotif = null;
        if (settings != null) {
            prefNotif = settings.get("preferredNotificationTrigger");
            prefTriger = settings.get("preferredNotification");
            existingRoomNotif = settings.get("preferredRoomNotificationTrigger");
        } else {
            settings = new BasicDBObject();
        }
        ArrayList<String> existingPrefNotif = null;
        existingPrefNotif = prefNotif == null ? new ArrayList<String>() : (ArrayList<String>)prefNotif;
        if (existingPrefNotif.contains(notifCond)) {
            existingPrefNotif.remove(notifCond);
        } else {
            existingPrefNotif.add(notifCond);
        }
        if (existingPrefNotif != null) {
            settings.put((Object)"preferredNotificationTrigger", existingPrefNotif);
        }
        if (prefTriger != null) {
            settings.put((Object)"preferredNotification", prefTriger);
        }
        if (existingRoomNotif != null) {
            settings.put((Object)"preferredRoomNotificationTrigger", existingRoomNotif);
        }
        doc.put("notificationsSettings", (Object)settings);
        coll.save(doc, WriteConcern.ACKNOWLEDGED);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void setRoomNotificationTrigger(String user, String room, String notifCond, String notifConditionType, long time) throws Exception {
        DBObject notifData;
        DBCollection coll = this.db().getCollection(M_USERS_COLLECTION);
        BasicDBObject query = new BasicDBObject();
        query.put((Object)"user", (Object)user);
        DBCursor cursor = coll.find((DBObject)query);
        if (!cursor.hasNext()) throw new Exception("Doc not found, operation not done");
        DBObject doc = cursor.next();
        if (!"normal".equals(notifConditionType) && !"silence".equals(notifConditionType) && !notifConditionType.startsWith("keywords")) throw new Exception("Wrong Params, operation not done");
        BasicDBObject settings = (BasicDBObject)doc.get("notificationsSettings");
        Object prefNotif = null;
        Object prefTriger = null;
        BasicDBObject existingRoomNotif = null;
        if (settings != null) {
            prefTriger = settings.get("preferredNotificationTrigger");
            prefNotif = settings.get("preferredNotification");
            existingRoomNotif = (DBObject)settings.get("preferredRoomNotificationTrigger");
        } else {
            settings = new BasicDBObject();
        }
        if (existingRoomNotif == null) {
            existingRoomNotif = new BasicDBObject();
        }
        if ((notifData = (DBObject)existingRoomNotif.get(room)) == null) {
            notifData = new BasicDBObject();
        }
        if (notifData.get("time") == null || (Long)notifData.get("time") < time) {
            notifData.put("notifCond", (Object)notifConditionType);
            notifData.put("time", (Object)time);
            if ("keywords".equals(notifConditionType)) {
                notifData.put("keywords", (Object)notifCond);
            }
        }
        if (prefTriger != null) {
            settings.put((Object)"preferredNotificationTrigger", prefTriger);
        }
        if (prefNotif != null) {
            settings.put((Object)"preferredNotification", prefNotif);
        }
        if (existingRoomNotif != null) {
            existingRoomNotif.put(room, (Object)notifData);
            settings.put((Object)"preferredRoomNotificationTrigger", (Object)existingRoomNotif);
        }
        doc.put("notificationsSettings", (Object)settings);
        coll.save(doc, WriteConcern.ACKNOWLEDGED);
    }

    @Override
    public NotificationSettingsBean getUserDesktopNotificationSettings(String user) throws JSONException {
        NotificationSettingsBean settings = new NotificationSettingsBean();
        DBCollection coll = this.db().getCollection(M_USERS_COLLECTION);
        BasicDBObject query = new BasicDBObject();
        query.put((Object)"user", (Object)user);
        DBCursor cursor = coll.find((DBObject)query);
        if (cursor.hasNext()) {
            DBObject doc = cursor.next();
            BasicDBObject wrapperDoc = (BasicDBObject)doc.get("notificationsSettings");
            if (wrapperDoc == null) {
                wrapperDoc = new BasicDBObject();
            }
            if (wrapperDoc.get("preferredNotification") != null) {
                settings.setEnabledChannels(wrapperDoc.get("preferredNotification").toString());
            } else {
                settings.setEnabledChannels(DEFAULT_ENABLED_CHANNELS);
            }
            if (wrapperDoc.get("preferredNotificationTrigger") != null) {
                settings.setEnabledTriggers(wrapperDoc.get("preferredNotificationTrigger").toString());
            }
            if (wrapperDoc.get("preferredRoomNotificationTrigger") != null) {
                settings.setEnabledRoomTriggers(wrapperDoc.get("preferredRoomNotificationTrigger").toString());
            }
        }
        return settings;
    }

    @Override
    public boolean isFavorite(String user, String targetUser) {
        List favorites;
        DBObject doc;
        DBCollection coll = this.db().getCollection(M_USERS_COLLECTION);
        BasicDBObject query = new BasicDBObject();
        query.put((Object)"user", (Object)user);
        DBCursor cursor = coll.find((DBObject)query);
        return cursor.hasNext() && (doc = cursor.next()).containsField("favorites") && (favorites = (List)doc.get("favorites")).contains(targetUser);
    }

    @Override
    public void addUserFullName(String user, String fullname) {
        DBCollection coll = this.db().getCollection(M_USERS_COLLECTION);
        BasicDBObject query = new BasicDBObject();
        query.put((Object)"user", (Object)user);
        DBCursor cursor = coll.find((DBObject)query);
        if (!cursor.hasNext()) {
            BasicDBObject doc = new BasicDBObject();
            doc.put((Object)"_id", (Object)user);
            doc.put((Object)"user", (Object)user);
            doc.put((Object)"fullname", (Object)fullname);
            coll.insert(new DBObject[]{doc});
        } else {
            DBObject doc = cursor.next();
            doc.put("fullname", (Object)fullname);
            coll.save(doc, WriteConcern.ACKNOWLEDGED);
        }
    }

    @Override
    public void addUserEmail(String user, String email) {
        DBCollection coll = this.db().getCollection(M_USERS_COLLECTION);
        BasicDBObject query = new BasicDBObject();
        query.put((Object)"user", (Object)user);
        DBCursor cursor = coll.find((DBObject)query);
        if (!cursor.hasNext()) {
            BasicDBObject doc = new BasicDBObject();
            doc.put((Object)"_id", (Object)user);
            doc.put((Object)"user", (Object)user);
            doc.put((Object)"email", (Object)email);
            coll.insert(new DBObject[]{doc});
        } else {
            DBObject doc = cursor.next();
            doc.put("email", (Object)email);
            coll.save(doc);
        }
    }

    @Override
    public void setSpaces(String user, List<SpaceBean> spaces) {
        DBObject doc;
        ArrayList<String> spaceIds = new ArrayList<String>();
        DBCollection coll = this.db().getCollection(M_ROOMS_COLLECTION);
        for (SpaceBean bean : spaces) {
            DBObject doc2;
            String room = ChatUtils.getRoomId((String)bean.getId());
            spaceIds.add(room);
            BasicDBObject query = new BasicDBObject();
            query.put((Object)"_id", (Object)room);
            DBCursor cursor = coll.find((DBObject)query);
            if (!cursor.hasNext()) {
                doc2 = new BasicDBObject();
                doc2.put((Object)"_id", (Object)room);
                doc2.put((Object)"space_id", (Object)bean.getId());
                doc2.put((Object)"displayName", (Object)bean.getDisplayName());
                doc2.put((Object)"groupId", (Object)bean.getGroupId());
                doc2.put((Object)"shortName", (Object)bean.getShortName());
                doc2.put((Object)"prettyName", (Object)bean.getPrettyName());
                doc2.put((Object)"type", (Object)"s");
                coll.insert(new DBObject[]{doc2});
                continue;
            }
            doc2 = cursor.next();
            String displayName = doc2.get("displayName").toString();
            Object prettyName = doc2.get("prettyName");
            if (bean.getDisplayName().equals(displayName) && prettyName != null && bean.getPrettyName().equals(prettyName.toString())) continue;
            doc2.put("_id", (Object)room);
            doc2.put("displayName", (Object)bean.getDisplayName());
            doc2.put("groupId", (Object)bean.getGroupId());
            doc2.put("shortName", (Object)bean.getShortName());
            doc2.put("prettyName", (Object)bean.getPrettyName());
            coll.save(doc2);
        }
        coll = this.db().getCollection(M_USERS_COLLECTION);
        BasicDBObject query = new BasicDBObject();
        query.put((Object)"user", (Object)user);
        DBCursor cursor = coll.find((DBObject)query);
        if (cursor.hasNext()) {
            doc = cursor.next();
            doc.put("spaces", spaceIds);
            coll.save(doc, WriteConcern.SAFE);
        } else {
            doc = new BasicDBObject();
            doc.put((Object)"_id", (Object)user);
            doc.put((Object)"user", (Object)user);
            doc.put((Object)"spaces", spaceIds);
            coll.insert(new DBObject[]{doc});
        }
    }

    @Override
    public void addTeamRoom(String user, String teamRoomId) {
        ArrayList<String> teamIds = new ArrayList<String>();
        teamIds.add(teamRoomId);
        DBCollection coll = this.db().getCollection(M_USERS_COLLECTION);
        BasicDBObject query = new BasicDBObject();
        query.put((Object)"user", (Object)user);
        DBCursor cursor = coll.find((DBObject)query);
        if (cursor.hasNext()) {
            DBObject doc = cursor.next();
            if (doc.containsField("teams")) {
                List existingTeams = (List)doc.get("teams");
                if (!existingTeams.contains(teamRoomId)) {
                    existingTeams.add(teamRoomId);
                }
                doc.put("teams", (Object)existingTeams);
            } else {
                doc.put("teams", teamIds);
            }
            coll.save(doc, WriteConcern.SAFE);
        } else {
            BasicDBObject doc = new BasicDBObject();
            doc.put((Object)"_id", (Object)user);
            doc.put((Object)"user", (Object)user);
            doc.put((Object)"teams", teamIds);
            coll.insert(new DBObject[]{doc});
        }
    }

    @Override
    public void removeTeamUsers(String teamRoomId, List<String> users) {
        DBCollection coll = this.db().getCollection(M_USERS_COLLECTION);
        for (String user : users) {
            List teams;
            DBObject doc;
            BasicDBObject query = new BasicDBObject();
            query.put((Object)"user", (Object)user);
            DBCursor cursor = coll.find((DBObject)query);
            if (!cursor.hasNext() || !(doc = cursor.next()).containsField("teams") || !(teams = (List)doc.get("teams")).contains(teamRoomId)) continue;
            teams.remove(teamRoomId);
            doc.put("teams", (Object)teams);
            coll.save(doc, WriteConcern.SAFE);
        }
    }

    private RoomBean getTeam(String teamId) {
        RoomBean roomBean = null;
        DBCollection coll = this.db().getCollection(M_ROOMS_COLLECTION);
        BasicDBObject query = new BasicDBObject();
        query.put((Object)"_id", (Object)teamId);
        DBCursor cursor = coll.find((DBObject)query);
        if (cursor.hasNext()) {
            DBObject doc = cursor.next();
            roomBean = new RoomBean();
            roomBean.setRoom(teamId);
            roomBean.setUser(doc.get("user").toString());
            roomBean.setFullName(doc.get("team").toString());
            roomBean.setType(doc.get("type").toString());
            if (doc.containsField("timestamp")) {
                roomBean.setTimestamp(((Long)doc.get("timestamp")).longValue());
            }
            if (StringUtils.isNotBlank((CharSequence)roomBean.getUser())) {
                roomBean.setAdmins(new String[]{roomBean.getUser()});
            }
        }
        return roomBean;
    }

    @Override
    public List<RoomBean> getTeams(String user) {
        DBObject doc;
        List listrooms;
        ArrayList<RoomBean> rooms = new ArrayList<RoomBean>();
        DBCollection coll = this.db().getCollection(M_USERS_COLLECTION);
        BasicDBObject query = new BasicDBObject();
        query.put((Object)"user", (Object)user);
        DBCursor cursor = coll.find((DBObject)query);
        if (cursor.hasNext() && (listrooms = (List)(doc = cursor.next()).get("teams")) != null) {
            for (String room : listrooms) {
                rooms.add(this.getTeam(room));
            }
        }
        return rooms;
    }

    @Override
    public RoomBean getRoom(String user, String roomId) {
        RoomBean roomBean = null;
        DBCollection coll = this.db().getCollection(M_ROOMS_COLLECTION);
        BasicDBObject query = new BasicDBObject();
        query.put((Object)"_id", (Object)roomId);
        DBCursor cursor = coll.find((DBObject)query);
        if (cursor.hasNext()) {
            roomBean = new RoomBean();
            roomBean.setRoom(roomId);
            DBObject doc = cursor.next();
            if (doc.containsField("timestamp")) {
                roomBean.setTimestamp(((Long)doc.get("timestamp")).longValue());
            }
            String type = doc.get("type").toString();
            roomBean.setType(type);
            if ("s".equals(type)) {
                roomBean.setUser("space-" + roomId);
                roomBean.setFullName(doc.get("displayName").toString());
            } else if ("t".equals(type)) {
                roomBean.setUser("team-" + roomId);
                roomBean.setFullName(doc.get("team").toString());
                String creator = (String)doc.get("user");
                roomBean.setAdmins(new String[]{creator});
            } else if ("u".equals(type)) {
                List users = (List)doc.get(M_USERS_COLLECTION);
                users.remove(user);
                String targetUser = (String)users.get(0);
                roomBean.setUser(targetUser);
                roomBean.setFullName(this.getUserFullName(targetUser));
            } else if ("e".equals(type)) {
                roomBean.setUser("external-" + roomId);
                roomBean.setFullName(doc.get("identifier").toString());
            }
        }
        return roomBean;
    }

    private SpaceBean getSpace(String roomId) {
        SpaceBean spaceBean = null;
        DBCollection coll = this.db().getCollection(M_ROOMS_COLLECTION);
        BasicDBObject query = new BasicDBObject();
        query.put((Object)"_id", (Object)roomId);
        DBCursor cursor = coll.find((DBObject)query);
        if (cursor.hasNext()) {
            DBObject doc = cursor.next();
            spaceBean = new SpaceBean();
            spaceBean.setRoom(roomId);
            spaceBean.setId(doc.get("space_id").toString());
            spaceBean.setDisplayName(doc.get("displayName").toString());
            spaceBean.setGroupId(doc.get("groupId").toString());
            spaceBean.setShortName(doc.get("shortName").toString());
            spaceBean.setPrettyName(doc.get("prettyName").toString());
            if (doc.containsField("timestamp")) {
                spaceBean.setTimestamp(((Long)doc.get("timestamp")).longValue());
            }
        }
        return spaceBean;
    }

    @Override
    public List<SpaceBean> getSpaces(String user) {
        DBObject doc;
        List listspaces;
        ArrayList<SpaceBean> spaces = new ArrayList<SpaceBean>();
        DBCollection coll = this.db().getCollection(M_USERS_COLLECTION);
        BasicDBObject query = new BasicDBObject();
        query.put((Object)"user", (Object)user);
        DBCursor cursor = coll.find((DBObject)query);
        if (cursor.hasNext() && (listspaces = (List)(doc = cursor.next()).get("spaces")) != null) {
            for (String space : listspaces) {
                spaces.add(this.getSpace(space));
            }
        }
        return spaces;
    }

    @Override
    public List<UserBean> getUsersInRoomChatOneToOne(String roomId) {
        ArrayList<UserBean> users = new ArrayList<UserBean>();
        DBCollection coll = this.db().getCollection(M_ROOMS_COLLECTION);
        BasicDBObject query = new BasicDBObject();
        query.put((Object)"_id", (Object)roomId);
        DBCursor cursor = coll.find((DBObject)query);
        while (cursor.hasNext()) {
            DBObject doc = cursor.next();
            Object objectUsers = doc.get(M_USERS_COLLECTION);
            ArrayList myArrayList = (ArrayList)objectUsers;
            for (int i = 0; i < myArrayList.size(); ++i) {
                users.add(this.getUser(myArrayList.get(i).toString()));
            }
        }
        return users;
    }

    @Override
    public List<UserBean> getUsers(String roomId, String filter, int limit) {
        if (roomId == null && filter == null) {
            throw new IllegalArgumentException();
        }
        ArrayList<BasicDBObject> andList = new ArrayList<BasicDBObject>();
        if (roomId != null && !"".equals(roomId)) {
            if (roomId.indexOf("space-") == 0) {
                roomId = roomId.substring("space-".length());
            } else if (roomId.indexOf("team-") == 0) {
                roomId = roomId.substring("team-".length());
            }
            ArrayList<BasicDBObject> orList = new ArrayList<BasicDBObject>();
            orList.add(new BasicDBObject("spaces", (Object)roomId));
            orList.add(new BasicDBObject("teams", (Object)roomId));
            andList.add(new BasicDBObject("$or", orList));
        }
        if (filter != null) {
            filter = filter.replaceAll(" ", ".*");
            Pattern regex = Pattern.compile(filter, 2);
            ArrayList<BasicDBObject> orList = new ArrayList<BasicDBObject>();
            orList.add(new BasicDBObject("user", (Object)regex));
            orList.add(new BasicDBObject("fullname", (Object)regex));
            andList.add(new BasicDBObject("$or", orList));
        }
        BasicDBObject query = new BasicDBObject("$and", andList);
        DBCollection coll = this.db().getCollection(M_USERS_COLLECTION);
        DBCursor cursor = coll.find((DBObject)query).limit(limit);
        ArrayList<UserBean> users = new ArrayList<UserBean>();
        while (cursor.hasNext()) {
            DBObject doc = cursor.next();
            UserBean userBean = new UserBean();
            userBean.setName(doc.get("user").toString());
            Object prop = doc.get("fullname");
            userBean.setFullname(prop != null ? prop.toString() : "");
            prop = doc.get("email");
            userBean.setEmail(prop != null ? prop.toString() : "");
            prop = doc.get("status");
            userBean.setStatus(prop != null ? prop.toString() : "");
            users.add(userBean);
        }
        return users;
    }

    @Override
    public String setStatus(String user, String status) {
        DBCollection coll = this.db().getCollection(M_USERS_COLLECTION);
        BasicDBObject query = new BasicDBObject();
        query.put((Object)"user", (Object)user);
        DBCursor cursor = coll.find((DBObject)query);
        if (cursor.hasNext()) {
            DBObject doc = cursor.next();
            doc.put("status", (Object)status);
            coll.save(doc, WriteConcern.SAFE);
        } else {
            BasicDBObject doc = new BasicDBObject();
            doc.put((Object)"_id", (Object)user);
            doc.put((Object)"user", (Object)user);
            doc.put((Object)"status", (Object)status);
            coll.insert(new DBObject[]{doc});
        }
        return status;
    }

    @Override
    public void setAsAdmin(String user, boolean isAdmin) {
        DBCollection coll = this.db().getCollection(M_USERS_COLLECTION);
        BasicDBObject query = new BasicDBObject();
        query.put((Object)"user", (Object)user);
        DBCursor cursor = coll.find((DBObject)query);
        if (cursor.hasNext()) {
            DBObject doc = cursor.next();
            doc.put("isSupportAdmin", (Object)isAdmin);
            coll.save(doc, WriteConcern.SAFE);
        } else {
            BasicDBObject doc = new BasicDBObject();
            doc.put((Object)"_id", (Object)user);
            doc.put((Object)"user", (Object)user);
            doc.put((Object)"isSupportAdmin", (Object)isAdmin);
            coll.insert(new DBObject[]{doc});
        }
    }

    @Override
    public boolean isAdmin(String user) {
        DBCollection coll = this.db().getCollection(M_USERS_COLLECTION);
        BasicDBObject query = new BasicDBObject();
        query.put((Object)"user", (Object)user);
        DBCursor cursor = coll.find((DBObject)query);
        if (cursor.hasNext()) {
            DBObject doc = cursor.next();
            Object isAdmin = doc.get("isSupportAdmin");
            return isAdmin != null && "true".equals(isAdmin.toString());
        }
        return false;
    }

    @Override
    public String getStatus(String user) {
        DBObject doc;
        String status = "none";
        DBCollection coll = this.db().getCollection(M_USERS_COLLECTION);
        BasicDBObject query = new BasicDBObject();
        query.put((Object)"user", (Object)user);
        DBCursor cursor = coll.find((DBObject)query);
        status = cursor.hasNext() ? ((doc = cursor.next()).containsField("status") ? doc.get("status").toString() : this.setStatus(user, "available")) : this.setStatus(user, "available");
        return status;
    }

    @Override
    public String getUserFullName(String user) {
        DBObject doc;
        String fullname = null;
        DBCollection coll = this.db().getCollection(M_USERS_COLLECTION);
        BasicDBObject query = new BasicDBObject();
        query.put((Object)"user", (Object)user);
        DBCursor cursor = coll.find((DBObject)query);
        if (cursor.hasNext() && (doc = cursor.next()).get("fullname") != null) {
            fullname = doc.get("fullname").toString();
        }
        return fullname;
    }

    @Override
    public UserBean getUser(String user) {
        return this.getUser(user, false);
    }

    @Override
    public UserBean getUser(String user, boolean withFavorites) {
        UserBean userBean = new UserBean();
        DBCollection coll = this.db().getCollection(M_USERS_COLLECTION);
        BasicDBObject query = new BasicDBObject();
        query.put((Object)"user", (Object)user);
        DBCursor cursor = coll.find((DBObject)query);
        if (cursor.hasNext()) {
            DBObject doc = cursor.next();
            userBean.setName(user);
            if (doc.get("fullname") != null) {
                userBean.setFullname(doc.get("fullname").toString());
            }
            if (doc.get("email") != null) {
                userBean.setEmail(doc.get("email").toString());
            }
            if (doc.get("status") != null) {
                userBean.setStatus(doc.get("status").toString());
            }
            if (withFavorites && doc.containsField("favorites")) {
                userBean.setFavorites((List)doc.get("favorites"));
            }
        }
        return userBean;
    }

    @Override
    public List<String> getUsersFilterBy(String user, String room, String type) {
        ArrayList<String> users = new ArrayList<String>();
        DBCollection coll = this.db().getCollection(M_USERS_COLLECTION);
        BasicDBObject query = new BasicDBObject();
        if ("s".equals(type)) {
            query.put((Object)"spaces", (Object)room);
        } else {
            query.put((Object)"teams", (Object)room);
        }
        DBCursor cursor = coll.find((DBObject)query);
        while (cursor.hasNext()) {
            DBObject doc = cursor.next();
            String target = doc.get("user").toString();
            if (user != null && user.equals(target)) continue;
            users.add(target);
        }
        return users;
    }

    @Override
    public int getNumberOfUsers() {
        DBCollection coll = this.db().getCollection(M_USERS_COLLECTION);
        BasicDBObject query = new BasicDBObject();
        DBCursor cursor = coll.find((DBObject)query);
        return cursor.count();
    }
}

