/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.chat.services.mongodb;

import com.mongodb.BasicDBObject;
import com.mongodb.DB;
import com.mongodb.DBCollection;
import com.mongodb.DBCursor;
import com.mongodb.DBObject;
import com.mongodb.WriteConcern;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Named;
import javax.inject.Singleton;
import org.exoplatform.chat.listener.ConnectionManager;
import org.exoplatform.chat.model.UserBean;
import org.exoplatform.chat.services.TokenStorage;
import org.exoplatform.chat.utils.MessageDigester;
import org.exoplatform.chat.utils.PropertyManager;

@Named(value="tokenStorage")
@ApplicationScoped
@Singleton
public class TokenMongoService
implements TokenStorage {
    public static final String M_USERS_COLLECTION = "users";

    private DB db() {
        return ConnectionManager.getInstance().getDB();
    }

    public String getToken(String user) {
        String passphrase = PropertyManager.getProperty((String)"chatPassPhrase");
        String in = user + passphrase;
        String token = MessageDigester.getHash((String)in);
        return token;
    }

    @Override
    public boolean hasUserWithToken(String user, String token) {
        DBCollection coll = this.db().getCollection(M_USERS_COLLECTION);
        BasicDBObject query = new BasicDBObject();
        query.put((Object)"user", (Object)user);
        query.put((Object)"token", (Object)token);
        DBCursor cursor = coll.find((DBObject)query);
        return cursor.hasNext();
    }

    @Override
    public void addUser(String user, String token) {
        if (!this.hasUserWithToken(user, token)) {
            DBCollection coll = this.db().getCollection(M_USERS_COLLECTION);
            BasicDBObject query = new BasicDBObject();
            query.put((Object)"user", (Object)user);
            DBCursor cursor = coll.find((DBObject)query);
            if (cursor.hasNext()) {
                DBObject doc = cursor.next();
                doc.put("token", (Object)token);
                doc.put("isDemoUser", (Object)user.startsWith("__anonim_"));
                coll.save(doc, WriteConcern.SAFE);
            } else {
                BasicDBObject doc = new BasicDBObject();
                doc.put((Object)"_id", (Object)user);
                doc.put((Object)"user", (Object)user);
                doc.put((Object)"token", (Object)token);
                doc.put((Object)"isDemoUser", (Object)user.startsWith("__anonim_"));
                coll.insert(new DBObject[]{doc});
            }
        }
    }

    @Override
    public void removeUserToken(String user, String token) {
        DBCollection coll = this.db().getCollection(M_USERS_COLLECTION);
        BasicDBObject query = new BasicDBObject();
        query.put((Object)"user", (Object)user);
        query.put((Object)"token", (Object)token);
        BasicDBObject tokenUpdate = new BasicDBObject();
        tokenUpdate.put((Object)"token", (Object)"");
        BasicDBObject set = new BasicDBObject("$set", (Object)tokenUpdate);
        coll.update((DBObject)query, (DBObject)set);
    }

    @Override
    public Map<String, UserBean> getActiveUsersFilterBy(String user, List<String> limitedFilter, boolean withUsers, boolean withPublic, boolean isAdmin, int limit) {
        BasicDBObject query = new BasicDBObject();
        if (isAdmin) {
            if (withPublic && !withUsers) {
                query.put((Object)"isDemoUser", (Object)true);
            } else if (!withPublic && withUsers) {
                query.put((Object)"isDemoUser", (Object)false);
            }
        } else {
            query.put((Object)"isDemoUser", (Object)user.startsWith("__anonim_"));
        }
        query.put((Object)"user", (Object)new BasicDBObject("$in", limitedFilter));
        if (limit < 0) {
            limit = 0;
        }
        DBCollection coll = this.db().getCollection(M_USERS_COLLECTION);
        DBCursor cursor = coll.find((DBObject)query).limit(limit);
        HashMap<String, UserBean> users = new HashMap<String, UserBean>();
        while (cursor.hasNext()) {
            DBObject doc = cursor.next();
            String target = doc.get("user").toString();
            if (user.equals(target)) continue;
            UserBean userBean = new UserBean();
            userBean.setName(target);
            if (doc.get("fullname") != null) {
                userBean.setFullname(doc.get("fullname").toString());
            }
            if (doc.get("status") != null) {
                userBean.setStatus(doc.get("status").toString());
            }
            users.put(target, userBean);
        }
        return users;
    }
}

