/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.chat.services;

import java.util.HashMap;
import java.util.List;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.exoplatform.chat.model.NotificationBean;
import org.exoplatform.chat.model.RealTimeMessageBean;
import org.exoplatform.chat.services.NotificationDataStorage;
import org.exoplatform.chat.services.NotificationService;
import org.exoplatform.chat.services.RealTimeMessageService;
import org.exoplatform.chat.services.UserService;

@Named(value="notificationService")
@ApplicationScoped
@Singleton
public class NotificationServiceImpl
implements NotificationService {
    @Inject
    private RealTimeMessageService realTimeMessageService;
    @Inject
    private NotificationDataStorage storage;

    public void addNotification(String receiver, String sender, String type, String category, String categoryId, String content, String link) {
        this.storage.addNotification(receiver, sender, type, category, categoryId, content, link, null);
    }

    public void addNotification(String receiver, String sender, String type, String category, String categoryId, String content, String link, String options) {
        this.storage.addNotification(receiver, sender, type, category, categoryId, content, link, options);
        this.sendNotification(receiver);
    }

    public void setNotificationsAsRead(String user, String type, String category, String categoryId) {
        this.storage.setNotificationsAsRead(user, type, category, categoryId);
        this.sendNotification(user);
    }

    public List<NotificationBean> getUnreadNotifications(String user, UserService userService) {
        return this.getUnreadNotifications(user, userService, null, null, null);
    }

    public List<NotificationBean> getUnreadNotifications(String user, UserService userService, String type, String category, String categoryId) {
        return this.storage.getUnreadNotifications(user, userService, type, category, categoryId);
    }

    public int getUnreadNotificationsTotal(String user) {
        return this.getUnreadNotificationsTotal(user, null, null, null);
    }

    public int getUnreadNotificationsTotal(String user, String type, String category, String categoryId) {
        return this.storage.getUnreadNotificationsTotal(user, type, category, categoryId);
    }

    public int getNumberOfNotifications() {
        return this.storage.getNumberOfNotifications();
    }

    public int getNumberOfUnreadNotifications() {
        return this.storage.getNumberOfUnreadNotifications();
    }

    private void sendNotification(String receiver) {
        HashMap<String, Integer> data = new HashMap<String, Integer>();
        data.put("totalUnreadMsg", this.getUnreadNotificationsTotal(receiver));
        RealTimeMessageBean messageBean = new RealTimeMessageBean(RealTimeMessageBean.EventType.NOTIFICATION_COUNT_UPDATED, null, receiver, null, data);
        this.realTimeMessageService.sendMessage(messageBean, receiver);
    }
}

