/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.chat.server;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.cometd.bayeux.ChannelId;
import org.cometd.bayeux.Message;
import org.cometd.bayeux.Session;
import org.cometd.bayeux.server.BayeuxServer;
import org.cometd.bayeux.server.SecurityPolicy;
import org.cometd.bayeux.server.ServerChannel;
import org.cometd.bayeux.server.ServerMessage;
import org.cometd.bayeux.server.ServerSession;
import org.cometd.oort.Oort;
import org.cometd.oort.Seti;
import org.cometd.server.ServerSessionImpl;
import org.eclipse.jetty.util.ConcurrentHashSet;
import org.exoplatform.chat.services.TokenService;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.mortbay.cometd.continuation.EXoContinuationCometdServlet;

public class EXoContinuationBayeux
extends org.mortbay.cometd.continuation.EXoContinuationBayeux {
    private static Map<String, String> userToken = new HashMap<String, String>();
    private static Map<String, Set<String>> clientIDs = new ConcurrentHashMap<String, Set<String>>();
    private String cometdContextName = "cometd";
    private String cloudIDSeparator = "/";
    private ServerSessionImpl systemClient;
    private Seti seti;
    private Oort oort;
    private TokenService tokenService;
    private static final Log LOG = ExoLogger.getLogger(org.mortbay.cometd.continuation.EXoContinuationBayeux.class);

    public EXoContinuationBayeux(TokenService tokenService) {
        this.setSecurityPolicy(new EXoSecurityPolicy(this));
        this.tokenService = tokenService;
        EXoContinuationCometdServlet servlet = EXoContinuationCometdServlet.getInstance();
        if (servlet != null) {
            servlet.setContainer(ExoContainerContext.getCurrentContainer());
            servlet.reInit();
        }
    }

    long getRandom(long variation) {
        long l = this.randomLong() ^ variation;
        return l < 0L ? -l : l;
    }

    public String getUserToken(String eXoId) {
        if (userToken.containsKey(eXoId)) {
            return userToken.get(eXoId);
        }
        String token = Long.toString(this.getRandom((long)System.identityHashCode((Object)this) ^ System.currentTimeMillis()), 36);
        userToken.put(eXoId, token);
        return token;
    }

    public boolean isSubscribed(String eXoID, String clientID) {
        return clientIDs.get(eXoID = this.toCloudId(eXoID)) != null && clientIDs.get(eXoID).contains(clientID);
    }

    public boolean isPresent(String eXoID) {
        eXoID = this.toCloudId(eXoID);
        return this.seti.isPresent(eXoID);
    }

    public void sendBroadcastMessage(String channel, Object data, String msgId) {
        ServerSessionImpl fromClient = this.getSystemClient();
        ServerChannel ch = this.getChannel(channel);
        if (ch != null) {
            ch.publish((Session)fromClient, data);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Send broadcast message " + data.toString() + " on channel " + channel));
            }
        } else if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Message " + data.toString() + " not send. Channel " + channel + " not exist!"));
        }
    }

    public void sendMessage(String eXoID, String channel, Object data, String id) {
        eXoID = this.toCloudId(eXoID);
        this.seti.sendMessage(eXoID, channel, data);
    }

    public void setSeti(Seti seti) {
        this.seti = seti;
    }

    public void setOort(Oort oort) {
        this.oort = oort;
    }

    public void setCloudIDSeparator(String cloudIDSeparator) {
        if (cloudIDSeparator != null) {
            this.cloudIDSeparator = cloudIDSeparator;
        } else {
            LOG.warn((Object)"Can't set null for cloudIDSeparator");
        }
    }

    private ServerSessionImpl getSystemClient() {
        if (this.systemClient == null) {
            this.systemClient = this.newServerSession();
        }
        return this.systemClient;
    }

    private String toCloudId(String eXoID) {
        return eXoID;
    }

    public void dispose() {
        for (ServerSession session : this.getSessions()) {
            ((ServerSessionImpl)session).cancelSchedule();
        }
        try {
            this.seti.stop();
            this.oort.stop();
            super.stop();
        }
        catch (Exception e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    public static class EXoSecurityPolicy
    implements SecurityPolicy,
    ServerSession.RemoveListener {
        private EXoContinuationBayeux bayeux;

        public EXoSecurityPolicy(EXoContinuationBayeux bayeux) {
            this.bayeux = bayeux;
        }

        private boolean checkUser(ServerMessage message) {
            String userId = (String)message.get((Object)"exoId");
            String eXoToken = (String)message.get((Object)"exoToken");
            return this.bayeux.tokenService.hasUserWithToken(userId, eXoToken);
        }

        public boolean canCreate(BayeuxServer server, ServerSession client, String channelId, ServerMessage message) {
            Boolean b = client != null && !ChannelId.isMeta((String)channelId);
            return b;
        }

        public boolean canHandshake(BayeuxServer server, ServerSession client, ServerMessage message) {
            if (client.isLocalSession() || this.bayeux.oort.isOortHandshake((Message)message)) {
                return true;
            }
            if (this.checkUser(message)) {
                client.addListener((ServerSession.ServerSessionListener)this);
                String eXoID = (String)message.get((Object)"exoId");
                eXoID = this.bayeux.toCloudId(eXoID);
                Set cIds = (Set)clientIDs.get(eXoID);
                if (cIds == null) {
                    cIds = new ConcurrentHashSet();
                    clientIDs.put(eXoID, cIds);
                }
                this.bayeux.seti.associate(eXoID, client);
                cIds.add(client.getId());
                return true;
            }
            return false;
        }

        public boolean canPublish(BayeuxServer server, ServerSession client, ServerChannel channel, ServerMessage message) {
            return client != null;
        }

        public boolean canSubscribe(BayeuxServer server, ServerSession client, ServerChannel channel, ServerMessage message) {
            return client != null && (this.checkUser(message) || client.isLocalSession() || this.bayeux.oort.isOort(client));
        }

        public void removed(ServerSession session, boolean timeout) {
            Iterator iter = clientIDs.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry client = iter.next();
                Set ids = (Set)client.getValue();
                ids.remove(session.getId());
                if (!ids.isEmpty()) continue;
                iter.remove();
            }
        }
    }
}

