/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.chat.services;

import java.util.List;
import java.util.Map;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.exoplatform.chat.model.UserBean;
import org.exoplatform.chat.services.TokenService;
import org.exoplatform.chat.services.TokenStorage;
import org.exoplatform.chat.utils.MessageDigester;
import org.exoplatform.chat.utils.PropertyManager;

@Named(value="tokenService")
@ApplicationScoped
@Singleton
public class TokenServiceImpl
implements TokenService {
    @Inject
    private TokenStorage storage;

    public String getToken(String user) {
        String passphrase = PropertyManager.getProperty((String)"chatPassPhrase");
        String in = user + passphrase;
        String token = MessageDigester.getHash((String)in);
        return token;
    }

    public boolean hasUserWithToken(String user, String token) {
        return this.storage.hasUserWithToken(user, token);
    }

    public void addUser(String user, String token) {
        this.storage.addUser(user, token);
    }

    public void removeUserToken(String user, String token) {
        this.storage.removeUserToken(user, token);
    }

    public Map<String, UserBean> getActiveUsersFilterBy(String user, List<String> limitUsers, boolean withUsers, boolean withPublic, boolean isAdmin, int limit) {
        return this.storage.getActiveUsersFilterBy(user, limitUsers, withUsers, withPublic, isAdmin, limit);
    }

    public boolean isDemoUser(String user) {
        return user.startsWith("__anonim_");
    }
}

