/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.chat.services.mongodb;

import com.mongodb.BasicDBObject;
import com.mongodb.DB;
import com.mongodb.DBCollection;
import com.mongodb.DBCursor;
import com.mongodb.DBObject;
import java.util.logging.Logger;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Named;
import javax.inject.Singleton;
import org.exoplatform.chat.listener.ConnectionManager;
import org.exoplatform.chat.services.SettingDataStorage;

@Named(value="settingStorage")
@ApplicationScoped
@Singleton
public class SettingMongoDataStorage
implements SettingDataStorage {
    private static final Logger LOG = Logger.getLogger(SettingMongoDataStorage.class.getName());
    public static final String M_SETTINGS_COLLECTION = "settings";

    private DB db() {
        return ConnectionManager.getInstance().getDB();
    }

    @Override
    public String getSetting(String name) {
        DBCollection coll = this.db().getCollection(M_SETTINGS_COLLECTION);
        BasicDBObject query = new BasicDBObject();
        query.put((Object)"name", (Object)name);
        DBCursor dbCursor = coll.find((DBObject)query);
        if (dbCursor.hasNext()) {
            return (String)dbCursor.next().get("value");
        }
        return null;
    }

    @Override
    public void setSetting(String name, String value) {
        DBCollection settingsCol = this.db().getCollection(M_SETTINGS_COLLECTION);
        BasicDBObject query = new BasicDBObject();
        query.put((Object)"name", (Object)name);
        BasicDBObject newStatusDBObject = new BasicDBObject();
        newStatusDBObject.put((Object)"name", (Object)name);
        newStatusDBObject.put((Object)"value", (Object)value);
        settingsCol.update((DBObject)query, (DBObject)newStatusDBObject, true, false);
    }
}

