/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.chat.server;

import java.io.IOException;
import java.util.Date;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.context.ApplicationScoped;
import juzu.Resource;
import juzu.Response;
import juzu.Route;
import juzu.impl.common.Tools;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.chat.listener.ConnectionManager;
import org.exoplatform.chat.listener.GuiceManager;
import org.exoplatform.chat.model.RealTimeMessageBean;
import org.exoplatform.chat.model.SpaceBeans;
import org.exoplatform.chat.model.UserBean;
import org.exoplatform.chat.services.NotificationService;
import org.exoplatform.chat.services.RealTimeMessageService;
import org.exoplatform.chat.services.TokenService;
import org.exoplatform.chat.services.UserService;
import org.exoplatform.chat.utils.ChatUtils;
import org.exoplatform.chat.utils.PropertyManager;

@ApplicationScoped
public class ChatTools {
    private static final Logger LOG = Logger.getLogger("ChatTools");
    UserService userService = (UserService)GuiceManager.getInstance().getInstance(UserService.class);
    TokenService tokenService = (TokenService)GuiceManager.getInstance().getInstance(TokenService.class);
    NotificationService notificationService = (NotificationService)GuiceManager.getInstance().getInstance(NotificationService.class);
    RealTimeMessageService realTimeMessageService = (RealTimeMessageService)GuiceManager.getInstance().getInstance(RealTimeMessageService.class);

    @Resource
    @Route(value="/addUser")
    public Response.Content addUser(String username, String token, String passphrase) {
        if (!this.checkPassphrase(passphrase)) {
            return Response.notFound((CharSequence)"{ \"message\": \"passphrase doesn't match\"}");
        }
        this.tokenService.addUser(username, token);
        return Response.ok((CharSequence)"OK").withMimeType("text/event-stream").withCharset(Tools.UTF_8).withHeader("Cache-Control", new String[]{"no-cache"});
    }

    @Resource
    @Route(value="/logout")
    public Response.Content logout(String username, String token, String sessionId, String passphrase, String uniqueSession) {
        if (!this.checkPassphrase(passphrase)) {
            return Response.notFound((CharSequence)"{ \"message\": \"passphrase doesn't match\"}");
        }
        HashMap<String, String> options = new HashMap<String, String>();
        options.put("sessionId", sessionId);
        RealTimeMessageBean realTimeMessageBean = new RealTimeMessageBean(RealTimeMessageBean.EventType.LOGOUT_SENT, null, username, new Date(), options);
        this.realTimeMessageService.sendMessage(realTimeMessageBean, username);
        if (StringUtils.equals((CharSequence)uniqueSession, (CharSequence)"true")) {
            HashMap<String, String> data = new HashMap<String, String>();
            data.put("status", "offline");
            realTimeMessageBean = new RealTimeMessageBean(RealTimeMessageBean.EventType.USER_STATUS_CHANGED, username, username, new Date(), data);
            this.realTimeMessageService.sendMessageToAll(realTimeMessageBean);
        }
        return Response.ok((CharSequence)"OK").withMimeType("text/event-stream").withCharset(Tools.UTF_8).withHeader("Cache-Control", new String[]{"no-cache"});
    }

    @Resource
    @Route(value="/setAsAdmin")
    public Response.Content setAsAdmin(String username, String isAdmin, String passphrase) {
        if (!this.checkPassphrase(passphrase)) {
            return Response.notFound((CharSequence)"{ \"message\": \"passphrase doesn't match\"}");
        }
        this.userService.setAsAdmin(username, "true".equals(isAdmin));
        return Response.ok((CharSequence)"OK").withMimeType("text/event-stream; charset=UTF-8").withHeader("Cache-Control", new String[]{"no-cache"});
    }

    @Resource
    @Route(value="/addUserFullNameAndEmail")
    public Response.Content addUserFullNameAndEmail(String username, String fullname, String email, String passphrase) {
        if (!this.checkPassphrase(passphrase)) {
            return Response.notFound((CharSequence)"{ \"message\": \"passphrase doesn't match\"}");
        }
        try {
            this.userService.addUserEmail(username, email);
            fullname = (String)ChatUtils.fromString((String)fullname);
            this.userService.addUserFullName(username, fullname);
        }
        catch (Exception e) {
            LOG.log(Level.SEVERE, "The fullName with value " + fullname + " of the user " + username + " couldn't be serialized : " + e.getMessage(), e);
        }
        return Response.ok((CharSequence)"OK").withMimeType("text/event-stream; charset=UTF-8").withHeader("Cache-Control", new String[]{"no-cache"});
    }

    @Resource
    @Route(value="/deleteUser")
    public Response.Content deleteUser(String username, String passphrase, String dbName) {
        if (!this.checkPassphrase(passphrase)) {
            return Response.notFound((CharSequence)"{ \"message\": \"passphrase doesn't match\"}");
        }
        this.userService.deleteUser(username);
        return Response.ok((CharSequence)"OK").withMimeType("text/event-stream; charset=UTF-8").withHeader("Cache-Control", new String[]{"no-cache"});
    }

    @Resource
    @Route(value="/setEnabledUser")
    public Response.Content setEnabledUser(String username, String enabled, String passphrase, String dbName) {
        if (!this.checkPassphrase(passphrase)) {
            return Response.notFound((CharSequence)"{ \"message\": \"passphrase doesn't match\"}");
        }
        Boolean isEnabled = StringUtils.equals((CharSequence)enabled, (CharSequence)"true");
        this.userService.setEnabledUser(username, isEnabled);
        return Response.ok((CharSequence)"OK").withMimeType("text/event-stream; charset=UTF-8").withHeader("Cache-Control", new String[]{"no-cache"});
    }

    @Resource
    @Route(value="/setSpaces")
    public Response.Content setSpaces(String username, String spaces, String passphrase) {
        if (!this.checkPassphrase(passphrase)) {
            return Response.notFound((CharSequence)"{ \"message\": \"passphrase doesn't match\"}");
        }
        try {
            SpaceBeans spaceBeans = (SpaceBeans)ChatUtils.fromString((String)spaces);
            this.userService.setSpaces(username, spaceBeans.getSpaces());
        }
        catch (IOException e) {
            LOG.warning(e.getMessage());
        }
        catch (ClassNotFoundException e) {
            LOG.warning(e.getMessage());
        }
        return Response.ok((CharSequence)"OK").withMimeType("text/event-stream; charset=UTF-8").withHeader("Cache-Control", new String[]{"no-cache"});
    }

    @Resource
    @Route(value="/getUserFullName")
    public Response.Content getUserFullName(String username, String passphrase) {
        if (!this.checkPassphrase(passphrase)) {
            return Response.notFound((CharSequence)"{ \"message\": \"passphrase doesn't match\"}");
        }
        String fullname = this.userService.getUserFullName(username);
        return Response.ok((CharSequence)String.valueOf(fullname)).withMimeType("text/event-stream").withCharset(Tools.UTF_8).withHeader("Cache-Control", new String[]{"no-cache"});
    }

    @Resource
    @Route(value="/shouldUpdate")
    public Response.Content shouldUpdate(String user, String passphrase) {
        if (!this.checkPassphrase(passphrase)) {
            return Response.notFound((CharSequence)"{ \"message\": \"passphrase doesn't match\"}");
        }
        UserBean userBean = this.userService.getUser(user);
        Boolean shouldUpdate = userBean.isEnabled() == null || userBean.isDeleted() == null;
        return Response.ok((CharSequence)shouldUpdate.toString()).withMimeType("text/event-stream").withCharset(Tools.UTF_8).withHeader("Cache-Control", new String[]{"no-cache"});
    }

    @Resource
    @Route(value="/updateUnreadTestMessages")
    public Response.Content updateUnreadTestMessages(String username, String room, String passphrase) {
        if (!this.checkPassphrase(passphrase)) {
            return Response.notFound((CharSequence)"{ \"message\": \"passphrase doesn't match\"}");
        }
        if (username == null) {
            return Response.notFound((CharSequence)"{ \"message\": \"username is null\"}");
        }
        if (room == null) {
            return Response.notFound((CharSequence)"{ \"message\": \"room is null\"}");
        }
        if (username.startsWith("space-")) {
            return Response.ok((CharSequence)"OK").withMimeType("text/event-stream; charset=UTF-8").withHeader("Cache-Control", new String[]{"no-cache"});
        }
        if (!room.equals("ALL")) {
            this.notificationService.setNotificationsAsRead(username, "chat", "room", room);
        } else {
            this.notificationService.setNotificationsAsRead(username, null, null, null);
        }
        return Response.ok((CharSequence)"OK").withMimeType("text/event-stream; charset=UTF-8").withHeader("Cache-Control", new String[]{"no-cache"});
    }

    @Resource
    @Route(value="/initDB")
    public Response.Content initDB(String db, String passphrase) {
        if (!this.checkPassphrase(passphrase)) {
            return Response.notFound((CharSequence)"{ \"message\": \"passphrase doesn't match\"}");
        }
        if (db == null) {
            return Response.notFound((CharSequence)"{ \"message\": \"db is null\"}");
        }
        ConnectionManager.getInstance().getDB(db);
        StringBuffer data = new StringBuffer();
        data.append("{");
        data.append(" \"message\": \"using db=" + db + "\"");
        data.append("}");
        return Response.ok((CharSequence)data.toString()).withMimeType("text/event-stream").withCharset(Tools.UTF_8).withHeader("Cache-Control", new String[]{"no-cache"});
    }

    @Resource
    @Route(value="/dropDB")
    public Response.Content dropDB(String db, String passphrase) {
        if (!this.checkPassphrase(passphrase)) {
            return Response.notFound((CharSequence)"{ \"message\": \"passphrase doesn't match\"}");
        }
        if (db == null) {
            return Response.notFound((CharSequence)"{ \"message\": \"db is null\"}");
        }
        ConnectionManager.getInstance().dropDB(db);
        StringBuffer data = new StringBuffer();
        data.append("{");
        data.append(" \"message\": \"deleting db=" + db + "\"");
        data.append("}");
        return Response.ok((CharSequence)data.toString()).withMimeType("text/event-stream").withCharset(Tools.UTF_8).withHeader("Cache-Control", new String[]{"no-cache"});
    }

    @Resource
    @Route(value="/ensureIndexes")
    public Response.Content ensureIndexes(String db, String passphrase) {
        if (!this.checkPassphrase(passphrase)) {
            return Response.notFound((CharSequence)"{ \"message\": \"passphrase doesn't match\"}");
        }
        if (db == null) {
            return Response.notFound((CharSequence)"{ \"message\": \"db is null\"}");
        }
        if (!db.equals(ConnectionManager.getInstance().getDB().getName())) {
            return Response.notFound((CharSequence)"{ \"message\": \"db name doesn't match\"}");
        }
        ConnectionManager.getInstance().ensureIndexes();
        StringBuffer data = new StringBuffer();
        data.append("{");
        data.append(" \"message\": \"indexes created or updated on db=" + db + "\"");
        data.append("}");
        return Response.ok((CharSequence)data.toString()).withMimeType("text/event-stream").withCharset(Tools.UTF_8).withHeader("Cache-Control", new String[]{"no-cache"});
    }

    private boolean checkPassphrase(String passphrase) {
        boolean checkPP = false;
        if (PropertyManager.getProperty((String)"chatPassPhrase").equals(passphrase)) {
            checkPP = true;
        }
        if ("".equals(passphrase) || "chat".equals(passphrase)) {
            LOG.warning("ChatServer is not secured! Please change 'chatPassPhrase' property in " + PropertyManager.PROPERTIES_PATH);
        }
        return checkPP;
    }
}

