/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.chat.services.mongodb;

import com.mongodb.BasicDBObject;
import com.mongodb.DB;
import com.mongodb.DBCollection;
import com.mongodb.DBCursor;
import com.mongodb.DBObject;
import java.util.ArrayList;
import java.util.List;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.chat.listener.ConnectionManager;
import org.exoplatform.chat.model.NotificationBean;
import org.exoplatform.chat.model.NotificationSettingsBean;
import org.exoplatform.chat.model.RoomBean;
import org.exoplatform.chat.services.NotificationDataStorage;
import org.exoplatform.chat.services.UserService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.json.JSONException;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

@Named(value="notificationStorage")
@ApplicationScoped
@Singleton
public class NotificationMongoDataStorage
implements NotificationDataStorage {
    private static final Log LOG = ExoLogger.getLogger(NotificationMongoDataStorage.class);

    private DB db() {
        return ConnectionManager.getInstance().getDB();
    }

    public static void cleanupNotifications() {
        DBCollection coll = ConnectionManager.getInstance().getDB().getCollection("notifications");
        BasicDBObject query = new BasicDBObject();
        query.put((Object)"timestamp", (Object)new BasicDBObject("$lt", (Object)(System.currentTimeMillis() - 86400000L)));
        DBCursor cursor = coll.find((DBObject)query);
        while (cursor.hasNext()) {
            DBObject doc = cursor.next();
            coll.remove(doc);
        }
    }

    @Override
    public void addNotification(String receiver, String sender, String type, String category, String categoryId, String content, String link) {
        this.addNotification(receiver, sender, type, category, categoryId, content, link, null);
    }

    @Override
    public void addNotification(String receiver, String sender, String type, String category, String categoryId, String content, String link, String options) {
        if (options != null && (options.contains("call-on") || options.contains("call-off") || options.contains("call-proceed"))) {
            return;
        }
        DBCollection coll = this.db().getCollection("notifications");
        BasicDBObject doc = new BasicDBObject();
        content = StringUtils.chomp((String)content);
        content = content.replaceAll("&", "&#38");
        content = content.replaceAll("<", "&lt;");
        content = content.replaceAll(">", "&gt;");
        content = content.replaceAll("\"", "&quot;");
        content = content.replaceAll("\n", "<br/>");
        content = content.replaceAll("\\\\", "&#92");
        content = content.replaceAll("\t", "  ");
        doc.put((Object)"timestamp", (Object)System.currentTimeMillis());
        doc.put((Object)"user", (Object)receiver);
        doc.put((Object)"from", (Object)sender);
        doc.put((Object)"type", (Object)type);
        doc.put((Object)"category", (Object)category);
        doc.put((Object)"categoryId", (Object)categoryId);
        doc.put((Object)"content", (Object)content);
        if (options != null) {
            options = options.replaceAll("<", "&lt;");
            options = options.replaceAll(">", "&gt;");
            options = options.replaceAll("'", "\\\\\"");
            doc.put((Object)"options", (Object)options);
        }
        doc.put((Object)"link", (Object)link);
        doc.put((Object)"isRead", (Object)false);
        coll.insert(new DBObject[]{doc});
    }

    @Override
    public void setNotificationsAsRead(String user, String type, String category, String categoryId) {
        DBCollection coll = this.db().getCollection("notifications");
        BasicDBObject query = this.buildQuery(user, type, category, categoryId);
        coll.remove((DBObject)query);
    }

    @Override
    public List<NotificationBean> getUnreadNotifications(String user, UserService userService) {
        return this.getUnreadNotifications(user, userService, null, null, null);
    }

    @Override
    public List<NotificationBean> getUnreadNotifications(String user, UserService userService, String type, String category, String categoryId) {
        List<NotificationBean> notifications = new ArrayList<NotificationBean>();
        DBCursor cursor = this.find(user, type, category, categoryId);
        while (cursor.hasNext()) {
            RoomBean roomBean;
            DBObject doc = cursor.next();
            NotificationBean notificationBean = new NotificationBean();
            notificationBean.setTimestamp((Long)doc.get("timestamp"));
            notificationBean.setUser(user);
            if (doc.containsField("from")) {
                notificationBean.setFrom(doc.get("from").toString());
                notificationBean.setFromFullName(userService.getUser(notificationBean.getFrom()).getFullname());
            }
            notificationBean.setCategory(doc.get("category").toString());
            notificationBean.setCategoryId(doc.get("categoryId").toString());
            notificationBean.setType(doc.get("type").toString());
            notificationBean.setContent(doc.get("content").toString());
            if (doc.containsField("options")) {
                notificationBean.setOptions(doc.get("options").toString());
            }
            if ((roomBean = userService.getRoom(user, notificationBean.getCategoryId())) != null) {
                notificationBean.setRoomType(roomBean.getType());
                if (roomBean.getType().equals("s") || roomBean.getType().equals("t")) {
                    notificationBean.setRoomDisplayName(roomBean.getFullName());
                }
            }
            notificationBean.setLink(doc.get("link").toString());
            notifications.add(notificationBean);
        }
        notifications = this.filterNotifications(notifications, userService, user);
        return notifications;
    }

    private List<NotificationBean> filterNotifications(List<NotificationBean> notifications, UserService userService, String receiver) {
        ArrayList<NotificationBean> notificationBeans;
        block4: {
            notificationBeans = new ArrayList<NotificationBean>();
            try {
                if (notifications == null || notifications.isEmpty()) break block4;
                NotificationSettingsBean settings = userService.getUserDesktopNotificationSettings(receiver);
                if (settings != null && settings.getEnabledRoomTriggers() != null) {
                    String bean = settings.getEnabledRoomTriggers();
                    JSONParser parser = new JSONParser();
                    JSONObject json = (JSONObject)parser.parse(bean);
                    for (NotificationBean notification : notifications) {
                        JSONObject roomSettings = (JSONObject)json.get((Object)notification.getCategoryId());
                        if (roomSettings != null && roomSettings.get((Object)"notifCond") != null && roomSettings.get((Object)"notifCond").equals("silence") && notification.getCategory().equals("room")) continue;
                        notificationBeans.add(notification);
                    }
                    break block4;
                }
                return notifications;
            }
            catch (JSONException | ParseException e) {
                LOG.error((Object)"error parsing chat notifications data", e);
            }
        }
        return notificationBeans;
    }

    @Override
    public int getUnreadNotificationsTotal(String user) {
        return this.getUnreadNotificationsTotal(user, null, null, null);
    }

    @Override
    public int getUnreadNotificationsTotal(String user, String type, String category, String categoryId) {
        DBCursor cursor = this.find(user, type, category, categoryId);
        int total = cursor.size();
        return total;
    }

    @Override
    public int getNumberOfNotifications() {
        DBCollection coll = this.db().getCollection("notifications");
        BasicDBObject query = new BasicDBObject();
        DBCursor cursor = coll.find((DBObject)query);
        return cursor.count();
    }

    @Override
    public int getNumberOfUnreadNotifications() {
        DBCollection coll = this.db().getCollection("notifications");
        BasicDBObject query = new BasicDBObject();
        DBCursor cursor = coll.find((DBObject)query);
        return cursor.count();
    }

    private DBCursor find(String user, String type, String category, String categoryId) {
        DBCollection coll = this.db().getCollection("notifications");
        BasicDBObject query = this.buildQuery(user, type, category, categoryId);
        return coll.find((DBObject)query);
    }

    private BasicDBObject buildQuery(String user, String type, String category, String categoryId) {
        BasicDBObject query = new BasicDBObject();
        query.put((Object)"user", (Object)user);
        if (type != null) {
            query.put((Object)"type", (Object)type);
        }
        if (category != null) {
            query.put((Object)"category", (Object)category);
        }
        if (categoryId != null) {
            query.put((Object)"categoryId", (Object)categoryId);
        }
        return query;
    }
}

