/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.chat.server;

import com.mongodb.BasicDBList;
import com.mongodb.BasicDBObject;
import com.mongodb.util.JSON;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLDecoder;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.mail.Address;
import javax.mail.Authenticator;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.Multipart;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.mail.util.ByteArrayDataSource;
import juzu.MimeType;
import juzu.Path;
import juzu.Resource;
import juzu.Response;
import juzu.Route;
import juzu.View;
import juzu.impl.common.Tools;
import juzu.request.ApplicationContext;
import juzu.request.UserContext;
import juzu.template.Template;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.chat.listener.GuiceManager;
import org.exoplatform.chat.model.MessageBean;
import org.exoplatform.chat.model.NotificationBean;
import org.exoplatform.chat.model.RealTimeMessageBean;
import org.exoplatform.chat.model.ReportBean;
import org.exoplatform.chat.model.RoomBean;
import org.exoplatform.chat.model.RoomsBean;
import org.exoplatform.chat.model.UserBean;
import org.exoplatform.chat.model.UsersBean;
import org.exoplatform.chat.server.ChatTools;
import org.exoplatform.chat.services.ChatException;
import org.exoplatform.chat.services.ChatService;
import org.exoplatform.chat.services.NotificationService;
import org.exoplatform.chat.services.RealTimeMessageService;
import org.exoplatform.chat.services.TokenService;
import org.exoplatform.chat.services.UserService;
import org.exoplatform.chat.utils.ChatUtils;
import org.exoplatform.chat.utils.PropertyManager;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.portal.localization.LocaleContextInfoUtils;
import org.exoplatform.services.resources.LocaleContextInfo;
import org.exoplatform.services.resources.LocalePolicy;
import org.exoplatform.services.resources.ResourceBundleService;
import org.json.JSONException;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

@ApplicationScoped
public class ChatServer {
    private static final String MIME_TYPE_JSON = "application/json";
    private static final Logger LOG = Logger.getLogger("ChatServer");
    @Inject
    @Path(value="index.gtmpl")
    Template index;
    ChatService chatService = (ChatService)GuiceManager.getInstance().getInstance(ChatService.class);
    UserService userService = (UserService)GuiceManager.getInstance().getInstance(UserService.class);
    TokenService tokenService = (TokenService)GuiceManager.getInstance().getInstance(TokenService.class);
    NotificationService notificationService = (NotificationService)GuiceManager.getInstance().getInstance(NotificationService.class);
    RealTimeMessageService realTimeMessageService = (RealTimeMessageService)GuiceManager.getInstance().getInstance(RealTimeMessageService.class);
    @Inject
    ChatTools chatTools;

    @View
    @Route(value="/")
    public Response.Content index() throws IOException {
        return this.index.ok();
    }

    @Resource
    @Route(value="/filterOutSilentUsers")
    public Response.Content getFilteredList(String user, String roomId, String token) {
        if (!this.tokenService.hasUserWithToken(user, token)) {
            return Response.notFound((CharSequence)"Petit malin !");
        }
        ArrayList<String> receivers = new ArrayList<String>();
        List roomParticipants = this.userService.getUsers(roomId);
        if (roomParticipants.isEmpty()) {
            roomParticipants = this.userService.getUsersInRoomChatOneToOne(roomId);
        }
        for (UserBean roomUser : roomParticipants) {
            if (roomUser.getName().equals(user) || this.notificationService.isRoomSilentForUser(roomUser.getName(), roomId)) continue;
            receivers.add(roomUser.getName());
        }
        return Response.ok((CharSequence)JSONArray.toJSONString(receivers)).withMimeType(MIME_TYPE_JSON).withHeader("Cache-Control", new String[]{"no-cache"}).withCharset(Tools.UTF_8);
    }

    @Resource
    @Route(value="/userRooms")
    public Response.Content getUserRooms(String user, String onlineUsers, String token, String filter, String offset, String limit, String roomType) {
        if (!this.tokenService.hasUserWithToken(user, token)) {
            return Response.notFound((CharSequence)"Petit malin !");
        }
        int limitValue = 20;
        try {
            if (limit != null && !"".equals(limit)) {
                limitValue = Integer.parseInt(limit);
            }
        }
        catch (NumberFormatException nfe) {
            LOG.info("limit is not a valid Integer number");
        }
        int offsetValue = 0;
        try {
            if (StringUtils.isNotBlank((String)offset)) {
                offsetValue = Integer.parseInt(offset);
            }
        }
        catch (NumberFormatException nfe) {
            LOG.info("offset is not a valid Integer number");
        }
        List<String> limitUsers = Arrays.asList(onlineUsers.split(","));
        RoomsBean roomsBean = this.chatService.getUserRooms(user, limitUsers, filter, offsetValue, limitValue, this.notificationService, this.tokenService, roomType);
        return Response.ok((CharSequence)roomsBean.roomsToJSON()).withMimeType(MIME_TYPE_JSON).withHeader("Cache-Control", new String[]{"no-cache"}).withCharset(Tools.UTF_8);
    }

    @Resource
    @Route(value="/whoIsOnline")
    public Response.Content whoIsOnline(String user, String onlineUsers, String token, String filter, String limit) {
        if (!this.tokenService.hasUserWithToken(user, token)) {
            return Response.notFound((CharSequence)"Petit malin !");
        }
        int ilimit = 20;
        try {
            if (limit != null && !"".equals(limit)) {
                ilimit = Integer.parseInt(limit);
            }
        }
        catch (NumberFormatException nfe) {
            LOG.info("limit is not a valid Integer number");
        }
        List<String> limitUsers = Arrays.asList(onlineUsers.split(","));
        RoomsBean roomsBean = this.chatService.getRooms(user, limitUsers, filter, true, true, true, true, false, ilimit, this.notificationService, this.tokenService);
        return Response.ok((CharSequence)roomsBean.roomsToJSON()).withMimeType(MIME_TYPE_JSON).withHeader("Cache-Control", new String[]{"no-cache"}).withCharset(Tools.UTF_8);
    }

    @Resource
    @Route(value="/updateUser")
    public Response.Content updateUser(String user, String token, String targetUser, String isDeleted, String isEnabled, String isExternal) {
        if (!this.tokenService.hasUserWithToken(user, token)) {
            return Response.notFound((CharSequence)"Petit malin !");
        }
        this.userService.setExternalUser(targetUser, isExternal);
        if (Boolean.valueOf(isDeleted).booleanValue()) {
            this.userService.deleteUser(targetUser);
        } else {
            this.userService.setEnabledUser(targetUser, Boolean.valueOf(isEnabled));
        }
        return Response.ok((CharSequence)"Updated!");
    }

    @Resource
    @Route(value="/setExternal")
    public Response.Content setExternal(String user, String targetUser, String token, String isExternal) {
        if (!this.tokenService.hasUserWithToken(user, token)) {
            return Response.notFound((CharSequence)"Petit malin !");
        }
        this.userService.setExternalUser(targetUser, isExternal);
        return Response.ok((CharSequence)"Updated!");
    }

    @Resource
    @Route(value="/send")
    public Response.Content send(String sender, String token, String message, String room, String isSystem, String options) throws IOException {
        if (!this.tokenService.hasUserWithToken(sender, token)) {
            return Response.notFound((CharSequence)"Petit malin !");
        }
        if (message != null) {
            try {
                message = URLDecoder.decode(message, "UTF-8");
                options = URLDecoder.decode(options, "UTF-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
            try {
                this.chatService.write(null, message, sender, room, isSystem, options);
            }
            catch (ChatException e) {
                return Response.content((int)e.getStatus(), (CharSequence)e.getMessage());
            }
        }
        return Response.ok((CharSequence)"ok").withMimeType("application/json; charset=UTF-8").withHeader("Cache-Control", new String[]{"no-cache"});
    }

    @Resource
    @Route(value="/read")
    public Response.Content read(String user, String token, String room, String fromTimestamp, String toTimestamp, String isTextOnly, String limit) throws IOException {
        if (!this.tokenService.hasUserWithToken(user, token)) {
            return Response.notFound((CharSequence)"Petit malin !");
        }
        Long from = null;
        Long to = null;
        try {
            if (fromTimestamp != null && !fromTimestamp.isEmpty()) {
                from = Long.parseLong(fromTimestamp);
            }
            if (toTimestamp != null && !toTimestamp.isEmpty()) {
                to = Long.parseLong(toTimestamp);
            }
        }
        catch (NumberFormatException nfe) {
            LOG.info("fromTimestamp is not a valid Long number");
        }
        Integer ilimit = 0;
        try {
            if (limit != null && !"".equals(limit)) {
                ilimit = Integer.parseInt(limit);
            }
        }
        catch (NumberFormatException nfe) {
            LOG.info("limit is not a valid Integer number");
        }
        String data = null;
        try {
            data = this.chatService.read(user, room, "true".equals(isTextOnly), from, to, ilimit.intValue());
            this.notificationService.setNotificationsAsRead(user, "chat", "room", room);
        }
        catch (Exception e) {
            if (e instanceof ChatException) {
                return Response.content((int)((ChatException)((Object)e)).getStatus(), (CharSequence)e.getMessage());
            }
            return Response.content((int)500, (CharSequence)e.getMessage());
        }
        return Response.ok((CharSequence)data).withMimeType(MIME_TYPE_JSON).withHeader("Cache-Control", new String[]{"no-cache"}).withCharset(Tools.UTF_8);
    }

    @Resource
    @Route(value="/sendMeetingNotes")
    public Response.Content sendMeetingNotes(String user, String token, String room, String fromTimestamp, String toTimestamp, ApplicationContext applicationContext, UserContext userContext) throws IOException {
        if (!this.tokenService.hasUserWithToken(user, token)) {
            return Response.notFound((CharSequence)"Petit malin !");
        }
        Long from = null;
        Long to = null;
        try {
            if (fromTimestamp != null && !"".equals(fromTimestamp)) {
                from = Long.parseLong(fromTimestamp);
            }
        }
        catch (NumberFormatException nfe) {
            LOG.info("fromTimestamp is not a valid Long number");
        }
        try {
            if (toTimestamp != null && !"".equals(toTimestamp)) {
                to = Long.parseLong(toTimestamp);
            }
        }
        catch (NumberFormatException nfe) {
            LOG.info("fromTimestamp is not a valid Long number");
        }
        String data = this.chatService.read(user, room, false, from, to, 0);
        BasicDBObject datao = (BasicDBObject)JSON.parse((String)data);
        String roomType = this.chatService.getTypeRoomChat(room);
        SimpleDateFormat formatter = new SimpleDateFormat("dd/MM/yyyy");
        String date = formatter.format(new GregorianCalendar().getTime());
        Object title = "";
        String roomName = "";
        Locale locale = userContext.getLocale();
        ResourceBundle res = applicationContext.resolveBundle(locale);
        if (datao.containsField("messages")) {
            List<UserBean> users;
            if ("u".equalsIgnoreCase(roomType)) {
                users = this.userService.getUsersInRoomChatOneToOne(room).stream().filter(UserBean::isEnabledUser).collect(Collectors.toList());
                title = res.getString("exoplatform.chat.meetingnotes") + " [" + date + "]";
            } else {
                users = this.userService.getUsers(room).stream().filter(UserBean::isEnabledUser).collect(Collectors.toList());
                List spaces = this.userService.getSpaces(user);
                for (Object spaceBean : spaces) {
                    if (!room.equals(spaceBean.getRoom())) continue;
                    roomName = spaceBean.getDisplayName();
                }
                List roomBeans = this.userService.getTeams(user);
                for (RoomBean roomBean : roomBeans) {
                    if (!room.equals(roomBean.getRoom())) continue;
                    roomName = roomBean.getFullName();
                }
                title = roomName + " : " + res.getString("exoplatform.chat.meetingnotes") + " [" + date + "]";
            }
            ReportBean reportBean = new ReportBean(res);
            reportBean.fill((BasicDBList)datao.get("messages"), users);
            ArrayList<String> tos = new ArrayList<String>();
            String senderName = user;
            String senderMail = "";
            for (UserBean userBean : users) {
                if (!"".equals(userBean.getEmail())) {
                    tos.add(userBean.getEmail());
                }
                if (!user.equals(userBean.getName())) continue;
                senderName = userBean.getFullname();
                senderMail = userBean.getEmail();
            }
            String serverBase = ChatUtils.getServerBase();
            String html = reportBean.getAsHtml((String)title, serverBase, locale);
            String prevUser = "";
            int index2 = 0;
            HashMap<String, String> inlineImages = new HashMap<String, String>();
            for (MessageBean messageBean : reportBean.getMessages()) {
                if (!messageBean.getUser().equals(prevUser)) {
                    String keyAvatar = messageBean.getUser() + index2;
                    String valueAvatar = serverBase + "/portal/rest/v1/social/users/{}/avatar".replace("{}", messageBean.getUser());
                    inlineImages.put(keyAvatar, valueAvatar);
                    ++index2;
                }
                prevUser = messageBean.getUser();
            }
            try {
                this.sendMailWithAuth(senderName, senderMail, tos, html, (String)title, inlineImages);
            }
            catch (Exception e) {
                LOG.info(e.getMessage());
            }
        }
        return Response.ok((CharSequence)"sent").withMimeType("text/event-stream; charset=UTF-8").withHeader("Cache-Control", new String[]{"no-cache"});
    }

    @Resource
    @Route(value="/getMeetingNotes")
    public Response.Content getMeetingNotes(String user, String token, String room, String fromTimestamp, String toTimestamp, String portalURI, ApplicationContext applicationContext, UserContext userContext) throws IOException {
        if (!this.tokenService.hasUserWithToken(user, token)) {
            return Response.notFound((CharSequence)"Petit malin !");
        }
        Long from = null;
        Long to = null;
        String wikiPageContent = "";
        String roomName = "";
        ArrayList<UserBean> users = new ArrayList();
        JSONObject jsonObject = new JSONObject();
        try {
            if (fromTimestamp != null && !"".equals(fromTimestamp)) {
                from = Long.parseLong(fromTimestamp);
            }
        }
        catch (NumberFormatException nfe) {
            LOG.info("fromTimestamp is not a valid Long number");
        }
        try {
            if (toTimestamp != null && !"".equals(toTimestamp)) {
                to = Long.parseLong(toTimestamp);
            }
        }
        catch (NumberFormatException nfe) {
            LOG.info("fromTimestamp is not a valid Long number");
        }
        String data = this.chatService.read(user, room, false, from, to, 0);
        String typeRoom = this.chatService.getTypeRoomChat(room);
        BasicDBObject datao = (BasicDBObject)JSON.parse((String)data);
        if (datao.containsField("messages")) {
            if ("u".equalsIgnoreCase(typeRoom)) {
                users = this.userService.getUsersInRoomChatOneToOne(room).stream().filter(UserBean::isEnabledUser).collect(Collectors.toList());
            } else {
                users = this.userService.getUsers(room).stream().filter(UserBean::isEnabledUser).collect(Collectors.toList());
                List spaces = this.userService.getSpaces(user);
                for (Object spaceBean : spaces) {
                    if (!room.equals(spaceBean.getRoom())) continue;
                    roomName = spaceBean.getDisplayName();
                }
                List roomBeans = this.userService.getTeams(user);
                for (RoomBean roomBean : roomBeans) {
                    if (!room.equals(roomBean.getRoom())) continue;
                    roomName = roomBean.getFullName();
                }
            }
            Locale locale = userContext.getLocale();
            ResourceBundle res = applicationContext.resolveBundle(locale);
            ReportBean reportBean = new ReportBean(res);
            reportBean.fill((BasicDBList)datao.get("messages"), users);
            ArrayList<String> usersInGroup = new ArrayList<String>();
            String serverBase = ChatUtils.getServerBase();
            wikiPageContent = reportBean.getWikiPageContent(serverBase, portalURI);
            try {
                for (UserBean userBean : users) {
                    if ("".equals(userBean.getName())) continue;
                    usersInGroup.add(userBean.getName());
                }
                jsonObject.put((Object)"users", usersInGroup);
                jsonObject.put((Object)"wikiPageContent", (Object)wikiPageContent);
                jsonObject.put((Object)"typeRoom", (Object)typeRoom);
            }
            catch (Exception e) {
                LOG.warning(e.getMessage());
                return Response.notFound((CharSequence)"No Room yet");
            }
        }
        return Response.ok((CharSequence)jsonObject.toString()).withMimeType(MIME_TYPE_JSON).withHeader("Cache-Control", new String[]{"no-cache"}).withCharset(Tools.UTF_8);
    }

    @Resource
    @MimeType(value={"text/plain"})
    @Route(value="/delete")
    public Response.Content delete(String user, String token, String room, String messageId) throws IOException {
        if (!this.tokenService.hasUserWithToken(user, token)) {
            return Response.notFound((CharSequence)"Petit malin !");
        }
        MessageBean message = this.chatService.getMessage(room, messageId);
        if (message == null || !message.getUser().equals(user)) {
            return Response.notFound((CharSequence)"");
        }
        try {
            this.chatService.delete(room, user, messageId);
        }
        catch (Exception e) {
            return Response.notFound((CharSequence)"Oups");
        }
        return Response.ok((CharSequence)"Updated!");
    }

    @Resource
    @MimeType(value={"text/plain"})
    @Route(value="/deleteTeamRoom")
    public Response.Content deleteTeamRoom(String user, String token, String room) throws IOException {
        if (!this.tokenService.hasUserWithToken(user, token)) {
            return Response.notFound((CharSequence)"Petit malin !");
        }
        try {
            String creator = this.chatService.getTeamCreator(room);
            if (!creator.equals(user)) {
                return Response.notFound((CharSequence)"");
            }
            this.chatService.deleteTeamRoom(room, user);
        }
        catch (Exception e) {
            LOG.log(Level.SEVERE, "Impossible to delete Team Room [" + room + "] : " + e.getMessage(), e);
            return Response.content((int)500, (CharSequence)"Oups!");
        }
        return Response.ok((CharSequence)"Updated!");
    }

    @Resource
    @MimeType(value={"text/plain"})
    @Route(value="/edit")
    public Response.Content edit(String user, String token, String room, String messageId, String message) throws IOException {
        if (!this.tokenService.hasUserWithToken(user, token)) {
            return Response.notFound((CharSequence)"Petit malin !");
        }
        MessageBean currentMessage = this.chatService.getMessage(room, messageId);
        if (currentMessage == null || !currentMessage.getUser().equals(user)) {
            return Response.notFound((CharSequence)"");
        }
        try {
            try {
                message = URLDecoder.decode(message, "UTF-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
            this.chatService.edit(room, user, messageId, message);
        }
        catch (Exception e) {
            return Response.notFound((CharSequence)"Oups");
        }
        return Response.ok((CharSequence)"Updated!");
    }

    @Resource
    @MimeType(value={"text/plain"})
    @Route(value="/toggleFavorite")
    public Response.Content toggleFavorite(String user, String token, String targetUser, String favorite) {
        if (!this.tokenService.hasUserWithToken(user, token)) {
            return Response.notFound((CharSequence)"Petit malin !");
        }
        if (Boolean.valueOf(favorite).booleanValue()) {
            this.userService.addFavorite(user, targetUser);
        } else {
            this.userService.removeFavorite(user, targetUser);
        }
        return Response.ok((CharSequence)"Updated!");
    }

    @Resource
    @MimeType(value={"text/plain"})
    @Route(value="/isFavorite")
    public Response.Content isFavorite(String user, String token, String targetUser) {
        if (!this.tokenService.hasUserWithToken(user, token)) {
            return Response.notFound((CharSequence)"Petit malin !");
        }
        boolean isFavorite = false;
        try {
            isFavorite = this.userService.isFavorite(user, targetUser);
        }
        catch (Exception e) {
            LOG.log(Level.WARNING, e.getMessage());
            return Response.notFound((CharSequence)"Oups");
        }
        return Response.ok((CharSequence)String.valueOf(isFavorite));
    }

    @Resource
    @MimeType(value={"application/json"})
    @Route(value="/getUserDesktopNotificationSettings")
    public Response.Content getUserDesktopNotificationSettings(String user, String token) throws JSONException {
        if (!this.tokenService.hasUserWithToken(user, token)) {
            return Response.notFound((CharSequence)"Something is wrong.");
        }
        JSONObject response = new JSONObject();
        JSONObject res = this.userService.getUserDesktopNotificationSettings(user).toJSON();
        if (res == null || res.isEmpty()) {
            response.put((Object)"done", (Object)false);
        } else {
            response.put((Object)"done", (Object)true);
        }
        response.put((Object)"userDesktopNotificationSettings", (Object)res);
        return Response.ok((CharSequence)response.toString()).withHeader("Cache-Control", new String[]{"no-cache"}).withCharset(Tools.UTF_8);
    }

    @Resource
    @MimeType(value={"text/plain"})
    @Route(value="/setPreferredNotification")
    public Response.Content setPreferredNotification(String user, String token, String notifManner) throws JSONException {
        if (!this.tokenService.hasUserWithToken(user, token)) {
            return Response.notFound((CharSequence)"Something is wrong.");
        }
        JSONObject response = new JSONObject();
        try {
            this.userService.setPreferredNotification(user, notifManner);
            response.put((Object)"done", (Object)true);
        }
        catch (Exception e) {
            response.put((Object)"done", (Object)false);
        }
        return Response.ok((CharSequence)response.toString()).withMimeType(MIME_TYPE_JSON).withHeader("Cache-Control", new String[]{"no-cache"}).withCharset(Tools.UTF_8);
    }

    @Resource
    @MimeType(value={"text/plain"})
    @Route(value="/setRoomNotificationTrigger")
    public Response.Content setRoomNotificationTrigger(String user, String token, String room, String notifCondition, String notifConditionType, Long time) throws JSONException {
        if (!this.tokenService.hasUserWithToken(user, token)) {
            return Response.notFound((CharSequence)"Something is wrong.");
        }
        try {
            this.userService.setRoomNotificationTrigger(user, room, notifCondition, notifConditionType, time.longValue());
            HashMap<String, String> data = new HashMap<String, String>();
            data.put("notificationTrigger", notifConditionType);
            data.put("targetRoom", room);
            RealTimeMessageBean messageBean = new RealTimeMessageBean(RealTimeMessageBean.EventType.ROOM_NOTIFICATION_SETTINGS_UPDATED, null, user, null, data);
            this.realTimeMessageService.sendMessage(messageBean, user);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.getUserDesktopNotificationSettings(user, token);
    }

    @Resource
    @MimeType(value={"text/plain"})
    @Route(value="/setNotificationSettings")
    public Response.Content setNotificationSettings(String user, String token, String room, String[] notifConditions, String[] notifManners, Long time) throws JSONException {
        if (!this.tokenService.hasUserWithToken(user, token)) {
            return Response.notFound((CharSequence)"Something is wrong.");
        }
        if (notifConditions != null) {
            for (String notifCondition : notifConditions) {
                try {
                    this.userService.setPreferredNotification(user, notifCondition);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        if (notifManners != null) {
            for (String notifManner : notifManners) {
                try {
                    this.userService.setNotificationTrigger(user, notifManner);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return this.getUserDesktopNotificationSettings(user, token);
    }

    @Resource
    @MimeType(value={"text/plain"})
    @Route(value="/setNotificationTrigger")
    public Response.Content setNotificationTrigger(String user, String token, String notifCondition) throws JSONException {
        if (!this.tokenService.hasUserWithToken(user, token)) {
            return Response.notFound((CharSequence)"Something is wrong.");
        }
        try {
            this.userService.setNotificationTrigger(user, notifCondition);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.getUserDesktopNotificationSettings(user, token);
    }

    @Resource
    @Route(value="/getRoom")
    public Response.Content getRoom(String user, String token, String targetUser, String isAdmin, String withDetail, String type) {
        if (!this.tokenService.hasUserWithToken(user, token)) {
            return Response.notFound((CharSequence)"Petit malin !");
        }
        String room = targetUser;
        RoomBean roomBean = null;
        try {
            if (type != null) {
                if ("room-id".equals(type)) {
                    room = targetUser;
                } else if ("space-name".equals(type)) {
                    room = this.chatService.getSpaceRoomByName(targetUser);
                } else if ("space-id".equals(type)) {
                    room = ChatUtils.getRoomId((String)targetUser);
                } else if ("username".equals(type)) {
                    users = new ArrayList();
                    users.add(user);
                    users.add(targetUser);
                    room = this.chatService.getRoom(users);
                } else if ("external".equals(type)) {
                    room = this.chatService.getExternalRoom(targetUser);
                }
            } else if (targetUser.startsWith("space-")) {
                room = this.chatService.getSpaceRoom(targetUser);
            } else if (targetUser.startsWith("team-")) {
                room = this.chatService.getTeamRoom(targetUser, user);
            } else if (targetUser.startsWith("external-")) {
                room = this.chatService.getExternalRoom(targetUser);
            } else {
                users = new ArrayList<String>(2);
                users.add(user);
                users.add(targetUser);
                room = this.chatService.getRoom(users);
            }
            if ("true".equals(withDetail)) {
                roomBean = this.userService.getRoom(user, room);
            }
        }
        catch (Exception e) {
            LOG.log(Level.WARNING, e.getMessage());
            return Response.notFound((CharSequence)"No Room yet");
        }
        String out = room;
        if (roomBean != null) {
            out = roomBean.toJSON();
        }
        return Response.ok((CharSequence)out).withMimeType(MIME_TYPE_JSON).withCharset(Tools.UTF_8).withHeader("Cache-Control", new String[]{"no-cache"});
    }

    @Resource
    @Route(value="/saveTeamRoom")
    public Response.Content saveTeamRoom(String user, String token, String teamName, String room, String users) {
        if (!this.tokenService.hasUserWithToken(user, token)) {
            return Response.notFound((CharSequence)"Petit malin !");
        }
        try {
            teamName = URLDecoder.decode(teamName, "UTF-8");
            teamName = teamName.trim();
        }
        catch (UnsupportedEncodingException e) {
            LOG.info("Cannot decode message: " + teamName);
        }
        JSONObject jsonObject = new JSONObject();
        try {
            String creator;
            List existingUsers;
            if ("".equals(teamName)) {
                return Response.content((int)400, (CharSequence)"Data is invalid!");
            }
            if (room == null || "".equals(room) || "---".equals(room)) {
                List roomBeans = this.chatService.getTeamRoomsByName(teamName);
                if (roomBeans != null && !roomBeans.isEmpty()) {
                    for (RoomBean roomBean : roomBeans) {
                        if (user.equals(roomBean.getUser())) {
                            return Response.content((int)400, (CharSequence)"roomAlreadyExists.creator");
                        }
                        existingUsers = this.userService.getUsersFilterBy(null, roomBean.getRoom(), "t");
                        if (existingUsers == null || !existingUsers.contains(user)) continue;
                        return Response.content((int)400, (CharSequence)"roomAlreadyExists.notCreator");
                    }
                }
                room = this.chatService.getTeamRoom(teamName, user);
            }
            if (!user.equals(creator = this.chatService.getTeamCreator(room))) {
                return Response.notFound((CharSequence)"Petit malin !");
            }
            JSONArray usersToNotifyForAdd = new JSONArray();
            JSONArray usersToAdd = new JSONArray();
            if (users != null && !users.isEmpty()) {
                String fullName;
                UserBean userBean;
                StringBuilder sbUsers;
                existingUsers = this.userService.getUsersFilterBy(null, room, "t");
                List<String> usersNew = Arrays.asList(users.split(","));
                usersToAdd.addAll(usersNew);
                JSONArray usersToRemove = new JSONArray();
                for (String u : existingUsers) {
                    if (usersNew.contains(u)) {
                        usersToNotifyForAdd.add(u);
                        usersToAdd.remove(u);
                        continue;
                    }
                    usersToRemove.add(u);
                }
                if (usersToRemove.size() > 0) {
                    this.userService.removeTeamUsers(room, (List)usersToRemove);
                    sbUsers = new StringBuilder();
                    boolean first = true;
                    for (String u : usersToRemove) {
                        if (!first) {
                            sbUsers.append("; ");
                        }
                        fullName = (userBean = this.userService.getUser(u)).isExternal() != null && userBean.isExternal().equals("true") ? this.userService.getUserFullName(u) + " (" + ChatServer.getResourceBundleLabel(new Locale(ChatServer.getCurrentUserLanguage(user)), "external.label.tag") + ")" : this.userService.getUserFullName(u);
                        sbUsers.append(fullName);
                        first = false;
                        this.notificationService.setNotificationsAsRead(u, "chat", "room", room);
                    }
                    String removeTeamUserOptions = "{\"type\":\"type-remove-team-user\",\"users\":\"" + sbUsers + "\", \"fullname\":\"" + this.userService.getUserFullName(user) + "\"}";
                    this.send(user, token, "", room, "true", removeTeamUserOptions);
                }
                this.chatService.setRoomName(room, teamName);
                if (usersToAdd.size() > 0) {
                    this.userService.addTeamUsers(room, (List)usersToAdd);
                    sbUsers = new StringBuilder();
                    boolean first = true;
                    for (String usert : usersToAdd) {
                        if (usert.equals(creator)) continue;
                        if (!first) {
                            sbUsers.append("; ");
                        }
                        fullName = (userBean = this.userService.getUser(usert)).isExternal() != null && userBean.isExternal().equals("true") ? this.userService.getUserFullName(usert) + " (" + ChatServer.getResourceBundleLabel(new Locale(ChatServer.getCurrentUserLanguage(user)), "external.label.tag") + ")" : this.userService.getUserFullName(usert);
                        sbUsers.append(fullName);
                        first = false;
                    }
                    String addTeamUserOptions = "{\"type\":\"type-add-team-user\",\"users\":\"" + sbUsers + "\", \"fullname\":\"" + this.userService.getUserFullName(user) + "\"}";
                    this.send(user, token, "", room, "true", addTeamUserOptions);
                }
            }
            RoomBean roomBean = this.userService.getRoom(user, room);
            JSONObject data = roomBean.toJSONObject();
            data.put((Object)"title", (Object)teamName);
            data.put((Object)"participants", (Object)usersToAdd);
            RealTimeMessageBean updatedRoomMessage = new RealTimeMessageBean(RealTimeMessageBean.EventType.ROOM_UPDATED, room, user, null, (Map)data);
            if (!usersToNotifyForAdd.contains(creator)) {
                usersToNotifyForAdd.add(creator);
            }
            this.realTimeMessageService.sendMessage(updatedRoomMessage, (List<String>)usersToNotifyForAdd);
            jsonObject.putAll((Map)data);
            jsonObject.put((Object)"name", (Object)teamName);
            jsonObject.put((Object)"room", (Object)room);
        }
        catch (Exception e) {
            LOG.log(Level.WARNING, "Error while saving room " + teamName, e);
            return Response.notFound((CharSequence)"No Room yet");
        }
        return Response.ok((CharSequence)jsonObject.toString()).withMimeType(MIME_TYPE_JSON).withHeader("Cache-Control", new String[]{"no-cache"}).withCharset(Tools.UTF_8);
    }

    @Resource
    @Route(value="/updateRoomMeetingStatus")
    public Response.Content updateRoomMeetingStatus(String user, String token, String start, String room, String startTime) {
        if (!this.tokenService.hasUserWithToken(user, token)) {
            return Response.notFound((CharSequence)"Petit malin !");
        }
        if (this.chatService.isMemberOfRoom(user, room)) {
            this.chatService.setRoomMeetingStatus(room, Boolean.parseBoolean(start), startTime);
            return Response.ok((CharSequence)"Updated.");
        }
        return Response.notFound((CharSequence)"");
    }

    @Resource
    @Route(value="/isRoomEnabled")
    public Response.Content isRoomEnabled(String user, String token, String spaceId) {
        if (!this.tokenService.hasUserWithToken(user, token)) {
            return Response.notFound((CharSequence)"Petit malin !");
        }
        String room = ChatUtils.getRoomId((String)spaceId);
        Boolean isEnabled = this.chatService.isRoomEnabled(room);
        return Response.ok((CharSequence)isEnabled.toString());
    }

    @Resource
    @Route(value="/updateRoomEnabled")
    public Response.Content setRoomEnabled(String user, String token, String spaceId, Boolean enabled) {
        if (!this.tokenService.hasUserWithToken(user, token)) {
            return Response.notFound((CharSequence)"Petit malin !");
        }
        String room = ChatUtils.getRoomId((String)spaceId);
        this.chatService.setRoomEnabled(room, enabled.booleanValue());
        return Response.ok((CharSequence)"Updated.");
    }

    @Resource
    @MimeType(value={"text/plain"})
    @Route(value="/updateUnreadMessages")
    public Response.Content updateUnreadMessages(String room, String user, String token) {
        if (!this.tokenService.hasUserWithToken(user, token)) {
            return Response.notFound((CharSequence)"Petit malin !");
        }
        try {
            this.notificationService.setNotificationsAsRead(user, "chat", "room", room);
            if (this.userService.isAdmin(user)) {
                this.notificationService.setNotificationsAsRead("__support_", "chat", "room", room);
            }
        }
        catch (Exception e) {
            LOG.warning(e.getMessage());
            return Response.notFound((CharSequence)"Server Not Available yet");
        }
        return Response.ok((CharSequence)"Updated.");
    }

    @Resource
    @Route(value="/notification")
    public Response.Content notification(String user, String token, String event, String withDetails) throws IOException {
        Object data;
        if (!this.tokenService.hasUserWithToken(user, token)) {
            return Response.notFound((CharSequence)"Petit malin !");
        }
        boolean detailed = Boolean.valueOf(withDetails);
        int totalUnread = 0;
        List notifications = null;
        if (!detailed) {
            List notificationBeans = this.notificationService.getUnreadNotifications(user, this.userService);
            totalUnread = notificationBeans.size();
            if (this.userService.isAdmin(user)) {
                totalUnread += this.notificationService.getUnreadNotificationsTotal("__support_");
            }
        } else {
            notifications = this.notificationService.getUnreadNotifications(user, this.userService);
            totalUnread = notifications.size();
        }
        if (event != null && event.equals("1")) {
            data = "id: " + totalUnread + "\n";
            data = (String)data + "data: {\"total\": " + totalUnread + "}\n\n";
        } else {
            JSONObject json = new JSONObject();
            json.put((Object)"total", (Object)totalUnread);
            if (detailed && notifications != null) {
                JSONArray notifies = new JSONArray();
                for (NotificationBean o : notifications) {
                    notifies.add((Object)o.toJSONObject());
                }
                json.put((Object)"notifications", (Object)notifies);
            }
            data = json.toJSONString();
        }
        return Response.ok((CharSequence)data).withMimeType(MIME_TYPE_JSON).withCharset(Tools.UTF_8).withHeader("Cache-Control", new String[]{"no-cache"});
    }

    @Resource
    @MimeType(value={"text/plain"})
    @Route(value="/getStatus")
    public Response.Content getStatus(String user, String token, String targetUser) {
        if (!this.tokenService.hasUserWithToken(user, token)) {
            return Response.notFound((CharSequence)"Petit malin !");
        }
        String status = "invisible";
        try {
            if (targetUser != null) {
                status = this.userService.getStatus(targetUser);
            }
        }
        catch (Exception e) {
            LOG.warning(e.getMessage());
            return Response.notFound((CharSequence)status);
        }
        return Response.ok((CharSequence)status).withHeader("Cache-Control", new String[]{"no-cache"});
    }

    @Resource
    @MimeType(value={"text/plain"})
    @Route(value="/setStatus")
    public Response.Content setStatus(String user, String token, String status) {
        if (!this.tokenService.hasUserWithToken(user, token)) {
            return Response.notFound((CharSequence)"Petit malin !");
        }
        try {
            this.userService.setStatus(user, status);
        }
        catch (Exception e) {
            LOG.warning(e.getMessage());
            return Response.notFound((CharSequence)"No Status for this User");
        }
        return Response.ok((CharSequence)status);
    }

    @Resource
    @MimeType(value={"text/plain"})
    @Route(value="/getCreator")
    public Response.Content getCreator(String user, String token, String room) {
        String creator = "";
        if (!this.tokenService.hasUserWithToken(user, token)) {
            return Response.notFound((CharSequence)"Petit malin !");
        }
        try {
            creator = this.chatService.getTeamCreator(room);
        }
        catch (Exception e) {
            LOG.warning(e.getMessage());
            return Response.notFound((CharSequence)"No Status for this User");
        }
        return Response.ok((CharSequence)creator);
    }

    @Resource
    @Route(value="/users")
    public Response.Content getUsers(String user, String token, String onlineUsers, String room, String filter, String limit, String onlineOnly) {
        if (!this.tokenService.hasUserWithToken(user, token)) {
            return Response.notFound((CharSequence)"Petit malin !");
        }
        boolean showOnlyOnlineUsers = StringUtils.isNotBlank((String)onlineOnly) && "true".equals(onlineOnly);
        int limit_ = 0;
        try {
            if (limit != null) {
                limit_ = Integer.parseInt(limit);
            }
        }
        catch (NumberFormatException e) {
            return Response.status((int)400).content((CharSequence)"The 'limit' parameter value is invalid");
        }
        List<String> onlineUserList = StringUtils.isNotBlank((String)onlineUsers) ? Arrays.asList(onlineUsers.split(",")) : null;
        List users = this.userService.getUsers(room, onlineUserList, filter, limit_, showOnlyOnlineUsers);
        if (StringUtils.isNotBlank((String)user)) {
            UserBean currentUser = this.userService.getUser(user);
            users.remove(currentUser);
        }
        UsersBean usersBean = new UsersBean();
        usersBean.setUsers(users);
        return Response.ok((CharSequence)usersBean.usersToJSON()).withMimeType(MIME_TYPE_JSON).withHeader("Cache-Control", new String[]{"no-cache"}).withCharset(Tools.UTF_8);
    }

    @Resource
    @Route(value="/usersCount")
    public Response.Content getUsersCount(String user, String token, String room, String filter) {
        if (!this.tokenService.hasUserWithToken(user, token)) {
            return Response.notFound((CharSequence)"Petit malin !");
        }
        StringBuffer data = new StringBuffer();
        data.append("{");
        data.append(" \"usersCount\": ").append(this.userService.getUsersCount(room, filter)).append(",");
        data.append(" \"activeUsersCount\": ").append(this.userService.getActiveUsersCount(room, filter));
        data.append("}");
        return Response.ok((CharSequence)data).withMimeType(MIME_TYPE_JSON).withHeader("Cache-Control", new String[]{"no-cache"}).withCharset(Tools.UTF_8);
    }

    @Resource
    @Route(value="/statistics")
    public Response.Content getStatistics() {
        StringBuffer data = new StringBuffer();
        data.append("{");
        data.append(" \"users\": " + this.userService.getNumberOfUsers() + ", ");
        data.append(" \"rooms\": " + this.chatService.getNumberOfRooms() + ", ");
        data.append(" \"messages\": " + this.chatService.getNumberOfMessages() + ", ");
        data.append(" \"notifications\": " + this.notificationService.getNumberOfNotifications() + ", ");
        data.append(" \"notificationsUnread\": " + this.notificationService.getNumberOfUnreadNotifications());
        data.append("}");
        return Response.ok((CharSequence)data.toString()).withMimeType(MIME_TYPE_JSON).withCharset(Tools.UTF_8).withHeader("Cache-Control", new String[]{"no-cache"});
    }

    private Session getMailSession() {
        String protocal = PropertyManager.getProperty((String)"email.smtp.protocal");
        String host = PropertyManager.getProperty((String)"email.smtp.host");
        final String user = PropertyManager.getProperty((String)"email.smtp.username");
        final String password = PropertyManager.getProperty((String)"email.smtp.password");
        String port = PropertyManager.getProperty((String)"email.smtp.port");
        String auth = PropertyManager.getProperty((String)"email.smtp.auth");
        String starttlsEnable = PropertyManager.getProperty((String)"email.smtp.starttls.enable");
        String enableSSL = PropertyManager.getProperty((String)"email.smtp.EnableSSL.enable");
        String smtpAuth = PropertyManager.getProperty((String)"email.smtp.auth");
        String socketFactoryPort = PropertyManager.getProperty((String)"email.smtp.socketFactory.port");
        String socketFactoryClass = PropertyManager.getProperty((String)"email.smtp.socketFactory.class");
        String socketFactoryFallback = PropertyManager.getProperty((String)"email.smtp.socketFactory.fallback");
        Properties props = new Properties();
        props.put("mail.transport.protocol", protocal);
        props.put("mail.smtp.host", host);
        props.put("mail.smtp.port", port);
        props.put("mail.smtp.auth", auth);
        if (Boolean.parseBoolean(smtpAuth)) {
            props.put("mail.smtp.socketFactory.port", socketFactoryPort);
            props.put("mail.smtp.socketFactory.class", socketFactoryClass);
            props.put("mail.smtp.socketFactory.fallback", socketFactoryFallback);
            props.put("mail.smtp.starttls.enable", starttlsEnable);
            props.put("mail.smtp.ssl.enable", enableSSL);
            return Session.getInstance((Properties)props, (Authenticator)new Authenticator(){

                protected PasswordAuthentication getPasswordAuthentication() {
                    return new PasswordAuthentication(user, password);
                }
            });
        }
        return Session.getInstance((Properties)props);
    }

    public void sendMailWithAuth(String senderFullname, String senderMail, List<String> toList, String htmlBody, String subject, Map<String, String> inlineImages) throws Exception {
        Session session = this.getMailSession();
        MimeMessage message = new MimeMessage(session);
        message.setFrom((Address)new InternetAddress(senderMail, senderFullname, "UTF-8"));
        for (String to : toList) {
            message.addRecipients(Message.RecipientType.BCC, (Address[])InternetAddress.parse((String)to));
        }
        message.setSubject(subject, "UTF-8");
        MimeMultipart multipart = new MimeMultipart();
        MimeBodyPart messageBodyPart = new MimeBodyPart();
        messageBodyPart.setContent((Object)htmlBody, "text/html; charset=UTF-8");
        multipart.addBodyPart((BodyPart)messageBodyPart);
        if (inlineImages != null && inlineImages.size() > 0) {
            Set<String> setImageID = inlineImages.keySet();
            for (String contentId : setImageID) {
                messageBodyPart = new MimeBodyPart();
                String imageFilePath = inlineImages.get(contentId);
                URL url = new URL(imageFilePath);
                URLConnection con = url.openConnection();
                con.setDoOutput(true);
                InputStream is = con.getInputStream();
                ByteArrayDataSource byteArrayDataSource = new ByteArrayDataSource(is, con.getContentType());
                messageBodyPart.setDataHandler(new DataHandler((DataSource)byteArrayDataSource));
                messageBodyPart.setContentID("<" + contentId + ">");
                messageBodyPart.setDisposition("inline");
                multipart.addBodyPart((BodyPart)messageBodyPart);
            }
        }
        message.setContent((Multipart)multipart);
        try {
            Transport.send((Message)message);
        }
        catch (Exception e) {
            LOG.info(e.getMessage());
        }
    }

    public static String getResourceBundleLabel(Locale locale, String label) {
        ResourceBundleService resourceBundleService = (ResourceBundleService)ExoContainerContext.getService(ResourceBundleService.class);
        return resourceBundleService.getResourceBundle(resourceBundleService.getSharedResourceBundleNames(), locale).getString(label);
    }

    public static String getCurrentUserLanguage(String userId) {
        LocaleContextInfo localeCtx = LocaleContextInfoUtils.buildLocaleContextInfo((String)userId);
        LocalePolicy localePolicy = (LocalePolicy)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(LocalePolicy.class);
        String lang = Locale.getDefault().getLanguage();
        if (localePolicy != null) {
            Locale locale = localePolicy.determineLocale(localeCtx);
            lang = locale.toString();
        }
        return lang;
    }
}

