/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.chat;

import com.google.inject.AbstractModule;
import com.google.inject.Module;
import de.flapdoodle.embed.mongo.config.Net;
import de.flapdoodle.embed.mongo.distribution.Version;
import de.flapdoodle.embed.mongo.transitions.ImmutableMongod;
import de.flapdoodle.embed.mongo.transitions.Mongod;
import de.flapdoodle.embed.mongo.transitions.RunningMongodProcess;
import de.flapdoodle.embed.process.distribution.Version;
import de.flapdoodle.reverse.Listener;
import de.flapdoodle.reverse.Transition;
import de.flapdoodle.reverse.transitions.Start;
import java.util.List;
import java.util.logging.Logger;
import org.cometd.bayeux.server.BayeuxServer;
import org.exoplatform.chat.bootstrap.ServiceBootstrap;
import org.exoplatform.chat.listener.ConnectionManager;
import org.exoplatform.chat.listener.GuiceManager;
import org.exoplatform.chat.model.RealTimeMessageBean;
import org.exoplatform.chat.services.ChatDataStorage;
import org.exoplatform.chat.services.ChatService;
import org.exoplatform.chat.services.ChatServiceImpl;
import org.exoplatform.chat.services.NotificationDataStorage;
import org.exoplatform.chat.services.NotificationService;
import org.exoplatform.chat.services.NotificationServiceImpl;
import org.exoplatform.chat.services.RealTimeMessageService;
import org.exoplatform.chat.services.SettingDataStorage;
import org.exoplatform.chat.services.TokenService;
import org.exoplatform.chat.services.TokenServiceImpl;
import org.exoplatform.chat.services.TokenStorage;
import org.exoplatform.chat.services.UserDataStorage;
import org.exoplatform.chat.services.UserService;
import org.exoplatform.chat.services.UserServiceImpl;
import org.exoplatform.chat.services.mongodb.ChatMongoDataStorage;
import org.exoplatform.chat.services.mongodb.NotificationMongoDataStorage;
import org.exoplatform.chat.services.mongodb.SettingMongoDataStorage;
import org.exoplatform.chat.services.mongodb.TokenMongoService;
import org.exoplatform.chat.services.mongodb.UserMongoDataStorage;
import org.exoplatform.chat.utils.PropertyManager;
import org.junit.AfterClass;
import org.junit.BeforeClass;

public class AbstractChatTestCase {
    static Logger log = Logger.getLogger("ChatTestCase");
    private static RunningMongodProcess runningProcess;

    @BeforeClass
    public static void before() {
        PropertyManager.overrideProperty((String)"dbServerType", (String)"embed");
        PropertyManager.overrideProperty((String)"dbServerHosts", (String)"localhost:27777");
        PropertyManager.overrideProperty((String)"chatTokenValidity", (String)"100");
        ConnectionManager.forceNew();
        GuiceManager.forceNew((Module)new TestModule());
        ServiceBootstrap.forceNew();
        ImmutableMongod mongod = Mongod.builder().net((Transition)Start.to(Net.class).initializedWith((Object)Net.defaults().withPort(27777))).build();
        String mongoDBVersion = PropertyManager.getProperty((String)"embeddedMongoDBVersion");
        Version.Main mongoVersion = Version.Main.V6_0;
        switch (mongoDBVersion) {
            case "4.0": {
                mongoVersion = Version.Main.V4_0;
                break;
            }
            case "4.2": {
                mongoVersion = Version.Main.V4_2;
                break;
            }
            case "4.4": {
                mongoVersion = Version.Main.V4_4;
                break;
            }
            case "5.0": 
            case "5": {
                mongoVersion = Version.Main.V5_0;
            }
        }
        runningProcess = (RunningMongodProcess)mongod.start((Version)mongoVersion, new Listener[0]).current();
    }

    @AfterClass
    public static void after() throws Exception {
        runningProcess.stop();
    }

    private static class TestModule
    extends AbstractModule {
        private TestModule() {
        }

        protected void configure() {
            this.bind(ChatDataStorage.class).to(ChatMongoDataStorage.class);
            this.bind(ChatService.class).to(ChatServiceImpl.class);
            this.bind(NotificationDataStorage.class).to(NotificationMongoDataStorage.class);
            this.bind(NotificationService.class).to(NotificationServiceImpl.class);
            this.bind(TokenService.class).to(TokenServiceImpl.class);
            this.bind(TokenStorage.class).to(TokenMongoService.class);
            this.bind(UserDataStorage.class).to(UserMongoDataStorage.class);
            this.bind(UserService.class).to(UserServiceImpl.class);
            this.bind(SettingDataStorage.class).to(SettingMongoDataStorage.class);
            this.bind(RealTimeMessageService.class).toInstance((Object)new RealTimeMessageService(){

                public void setBayeux(BayeuxServer bayeux) {
                }

                public void sendMessage(RealTimeMessageBean realTimeMessageBean, String receiver) {
                }

                public void sendMessage(RealTimeMessageBean realTimeMessageBean, List<String> receivers) {
                }

                public void sendMessageToAll(RealTimeMessageBean realTimeMessageBean) {
                }
            });
        }
    }
}

