/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.chat;

import org.exoplatform.chat.AbstractChatTestCase;
import org.exoplatform.chat.bootstrap.ServiceBootstrap;
import org.exoplatform.chat.listener.ConnectionManager;
import org.exoplatform.chat.services.NotificationService;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class NotificationTestCase
extends AbstractChatTestCase {
    String user1 = "benjamin";
    String user2 = "john";
    NotificationService notificationService_;

    @Before
    public void setUp() {
        ConnectionManager.getInstance().getDB().getCollection("notifications").drop();
        this.notificationService_ = ServiceBootstrap.getNotificationService();
    }

    @Test
    public void testAddNotif() throws Exception {
        int tot1 = this.notificationService_.getUnreadNotificationsTotal(this.user1);
        int tot2 = this.notificationService_.getUnreadNotificationsTotal(this.user2);
        Assert.assertEquals((long)0L, (long)tot1);
        Assert.assertEquals((long)0L, (long)tot2);
        this.notificationService_.addNotification(this.user1, this.user2, "type", "cat", "catid", "content", "link", null);
        this.notificationService_.addNotification(this.user1, this.user2, "type", "cat", "catid", "content2", "link", null);
        tot1 = this.notificationService_.getUnreadNotificationsTotal(this.user1);
        tot2 = this.notificationService_.getUnreadNotificationsTotal(this.user2);
        Assert.assertEquals((long)2L, (long)tot1);
        Assert.assertEquals((long)0L, (long)tot2);
    }

    @Test
    public void testSetAsRead() throws Exception {
        this.notificationService_.addNotification(this.user1, this.user2, "type", "cat", "catid", "content", "link");
        this.notificationService_.addNotification(this.user1, this.user2, "type", "cat", "catid", "content2", "link");
        this.notificationService_.addNotification(this.user2, this.user1, "type", "cat", "catid", "content", "link");
        this.notificationService_.addNotification(this.user2, this.user1, "type", "cat", "catid", "content2", "link");
        int tot1 = this.notificationService_.getUnreadNotificationsTotal(this.user1);
        int tot2 = this.notificationService_.getUnreadNotificationsTotal(this.user2);
        Assert.assertEquals((long)2L, (long)tot1);
        Assert.assertEquals((long)2L, (long)tot2);
        this.notificationService_.setNotificationsAsRead(this.user1, null, null, null);
        tot1 = this.notificationService_.getUnreadNotificationsTotal(this.user1);
        tot2 = this.notificationService_.getUnreadNotificationsTotal(this.user2);
        Assert.assertEquals((long)0L, (long)tot1);
        Assert.assertEquals((long)2L, (long)tot2);
    }

    @Test
    public void testSetAsReadByCategory() throws Exception {
        this.notificationService_.addNotification(this.user1, this.user2, "type", "cat", "catid", "content", "link", null);
        this.notificationService_.addNotification(this.user1, this.user2, "type", "cat", "catid", "content2", "link", null);
        this.notificationService_.addNotification(this.user1, this.user2, "type", "othercat", "catid", "content", "link", null);
        this.notificationService_.addNotification(this.user1, this.user2, "type", "othercat", "catid", "content2", "link", null);
        this.notificationService_.addNotification(this.user1, this.user2, "type", "othercat", "catid", "content2", "link", null);
        int tot1 = this.notificationService_.getUnreadNotificationsTotal(this.user1);
        Assert.assertEquals((long)5L, (long)tot1);
        this.notificationService_.setNotificationsAsRead(this.user1, "type", "cat", "catid");
        tot1 = this.notificationService_.getUnreadNotificationsTotal(this.user1);
        Assert.assertEquals((long)3L, (long)tot1);
        this.notificationService_.setNotificationsAsRead(this.user1, "type", "othercat", "othercatid");
        tot1 = this.notificationService_.getUnreadNotificationsTotal(this.user1);
        Assert.assertEquals((long)3L, (long)tot1);
        this.notificationService_.setNotificationsAsRead(this.user1, "type", "othercat", "catid");
        tot1 = this.notificationService_.getUnreadNotificationsTotal(this.user1);
        Assert.assertEquals((long)0L, (long)tot1);
    }

    @Test
    public void testTotalByCategory() throws Exception {
        this.notificationService_.addNotification(this.user1, this.user2, "type", "cat", "catid", "content", "link", null);
        this.notificationService_.addNotification(this.user1, this.user2, "type", "cat", "catid", "content2", "link", null);
        this.notificationService_.addNotification(this.user1, this.user2, "type", "othercat", "catid", "content", "link", null);
        this.notificationService_.addNotification(this.user1, this.user2, "type", "othercat", "catid", "content2", "link", null);
        this.notificationService_.addNotification(this.user1, this.user2, "type", "othercat", "catid", "content2", "link", null);
        int total = this.notificationService_.getUnreadNotificationsTotal(this.user1);
        int totcat = this.notificationService_.getUnreadNotificationsTotal(this.user1, "type", "cat", "catid");
        int totothercat = this.notificationService_.getUnreadNotificationsTotal(this.user1, "type", "othercat", "catid");
        int totnone = this.notificationService_.getUnreadNotificationsTotal(this.user1, "type", "othercat", "othercatid");
        Assert.assertEquals((long)5L, (long)total);
        Assert.assertEquals((long)2L, (long)totcat);
        Assert.assertEquals((long)3L, (long)totothercat);
        Assert.assertEquals((long)0L, (long)totnone);
    }
}

