/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.chat.filter;

import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import org.exoplatform.chat.filter.ChatAuthenticationFilter;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentCaptor;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.Silent.class)
public class ChatAuthenticationFilterTest {
    @Mock
    private HttpServletRequest request;
    @Mock
    private HttpServletResponse response;
    @Mock
    private FilterChain filterChain;
    @InjectMocks
    private ChatAuthenticationFilter chatAuthenticationFilter;

    @Test
    public void doFilterWithoutAuthenticationHeader() throws Exception {
        this.chatAuthenticationFilter.doFilter((ServletRequest)this.request, (ServletResponse)this.response, this.filterChain);
        ArgumentCaptor argumentRequest = ArgumentCaptor.forClass(ServletRequest.class);
        ((FilterChain)Mockito.verify((Object)this.filterChain)).doFilter((ServletRequest)argumentRequest.capture(), (ServletResponse)Mockito.any(HttpServletResponse.class));
        Assert.assertTrue((boolean)(argumentRequest.getValue() instanceof HttpServletRequest));
    }

    @Test
    public void doFilterWithAuthenticationHeader() throws Exception {
        Mockito.when((Object)this.request.getHeader("Authorization")).thenReturn((Object)"Bearer t0k3n");
        this.chatAuthenticationFilter.doFilter((ServletRequest)this.request, (ServletResponse)this.response, this.filterChain);
        ArgumentCaptor argumentRequest = ArgumentCaptor.forClass(ServletRequest.class);
        ((FilterChain)Mockito.verify((Object)this.filterChain)).doFilter((ServletRequest)argumentRequest.capture(), (ServletResponse)Mockito.any(HttpServletResponse.class));
        Assert.assertTrue((boolean)(argumentRequest.getValue() instanceof ChatAuthenticationFilter.ChatHttpServletRequestWrapper));
        ChatAuthenticationFilter.ChatHttpServletRequestWrapper chatHttpServletRequestWrapper = (ChatAuthenticationFilter.ChatHttpServletRequestWrapper)argumentRequest.getValue();
        Assert.assertEquals((Object)"t0k3n", (Object)chatHttpServletRequestWrapper.getParameter("token"));
        Assert.assertNotNull((Object)chatHttpServletRequestWrapper.getParameterMap());
        Assert.assertEquals((long)1L, (long)chatHttpServletRequestWrapper.getParameterMap().size());
        Assert.assertTrue((boolean)chatHttpServletRequestWrapper.getParameterMap().containsKey("token"));
        Assert.assertEquals((Object)"t0k3n", (Object)((String[])chatHttpServletRequestWrapper.getParameterMap().get("token"))[0]);
        Assert.assertNotNull((Object)chatHttpServletRequestWrapper.getParameterNames());
        Assert.assertEquals((Object)"token", chatHttpServletRequestWrapper.getParameterNames().nextElement());
        Assert.assertNotNull((Object)chatHttpServletRequestWrapper.getQueryString());
        Assert.assertEquals((Object)"token=t0k3n", (Object)chatHttpServletRequestWrapper.getQueryString());
    }

    @Test
    public void doFilter() throws Exception {
        Mockito.when((Object)this.request.getRequestURI()).thenReturn((Object)"/");
        Mockito.when((Object)this.request.getContextPath()).thenReturn((Object)"/");
        Mockito.when((Object)this.request.getHeader("Authorization")).thenReturn((Object)"Bearer t0k3n");
        this.chatAuthenticationFilter.doFilter((ServletRequest)this.request, (ServletResponse)this.response, this.filterChain);
        ArgumentCaptor argumentRequest = ArgumentCaptor.forClass(ServletRequest.class);
        ((FilterChain)Mockito.verify((Object)this.filterChain)).doFilter((ServletRequest)argumentRequest.capture(), (ServletResponse)Mockito.any(HttpServletResponse.class));
        Assert.assertTrue((boolean)(argumentRequest.getValue() instanceof ChatAuthenticationFilter.ChatHttpServletRequestWrapper));
    }
}

