/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.chat;

import java.util.ArrayList;
import java.util.List;
import org.exoplatform.chat.AbstractChatTestCase;
import org.exoplatform.chat.bootstrap.ServiceBootstrap;
import org.exoplatform.chat.listener.ConnectionManager;
import org.exoplatform.chat.model.SpaceBean;
import org.exoplatform.chat.utils.ChatUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class SpaceTestCase
extends AbstractChatTestCase {
    @Before
    public void setUp() {
        ConnectionManager.getInstance().getDB().getCollection("users").drop();
        ServiceBootstrap.getUserService().addUserFullName("benjamin", "Benjamin Paillereau");
        ServiceBootstrap.getUserService().addUserEmail("benjamin", "bpaillereau@exoplatform.com");
        ServiceBootstrap.getUserService().addUserFullName("john", "John Smith");
        ServiceBootstrap.getUserService().addUserEmail("john", "john@exoplatform.com");
        ServiceBootstrap.getUserService().addUserFullName("mary", "Mary Williams");
        ServiceBootstrap.getUserService().addUserEmail("mary", "mary@exoplatform.com");
    }

    @Test
    public void testSpaces() throws Exception {
        log.info("SpaceTestCase.testSpaces");
        String user = "benjamin";
        List spaces = ServiceBootstrap.getUserService().getSpaces(user);
        Assert.assertEquals((long)0L, (long)spaces.size());
        SpaceBean space = new SpaceBean();
        space.setDisplayName("Test Space");
        space.setGroupId("test_space");
        space.setId("test_space");
        space.setShortName("Test Space");
        space.setPrettyName("Test space");
        space.setTimestamp(System.currentTimeMillis());
        spaces.add(space);
        ServiceBootstrap.getUserService().setSpaces(user, spaces);
        spaces = ServiceBootstrap.getUserService().getSpaces(user);
        Assert.assertEquals((long)1L, (long)spaces.size());
        SpaceBean space2 = new SpaceBean();
        space2.setDisplayName("Test Space 2");
        space2.setGroupId("test_space_2");
        space2.setId("test_space_2");
        space2.setShortName("Test Space 2");
        space2.setPrettyName("Test space2");
        space2.setTimestamp(System.currentTimeMillis());
        spaces.add(space2);
        ServiceBootstrap.getUserService().setSpaces(user, spaces);
        spaces = ServiceBootstrap.getUserService().getSpaces(user);
        Assert.assertEquals((long)2L, (long)spaces.size());
        spaces = new ArrayList<SpaceBean>();
        spaces.add(space);
        ServiceBootstrap.getUserService().setSpaces(user, spaces);
        spaces = ServiceBootstrap.getUserService().getSpaces(user);
        Assert.assertEquals((long)1L, (long)spaces.size());
        spaces = ServiceBootstrap.getUserService().getSpaces("john");
        Assert.assertEquals((long)0L, (long)spaces.size());
    }

    @Test
    public void testSpace() throws Exception {
        String user = "benjamin";
        List spaces = ServiceBootstrap.getUserService().getSpaces(user);
        SpaceBean space = new SpaceBean();
        String displayName = "Test Space";
        String spaceId = "123456789";
        String room = ChatUtils.getRoomId((String)spaceId);
        space.setDisplayName(displayName);
        space.setGroupId("test_space");
        space.setId(spaceId);
        space.setRoom(room);
        space.setShortName("Test Space");
        space.setPrettyName("Test space");
        space.setTimestamp(System.currentTimeMillis());
        spaces.add(space);
        ServiceBootstrap.getUserService().setSpaces(user, spaces);
        SpaceBean target = (SpaceBean)ServiceBootstrap.getUserService().getSpaces(user).get(0);
        Assert.assertEquals((Object)space, (Object)target);
    }

    @Test
    public void testSpaceUsers() throws Exception {
        String user = "benjamin";
        List spaces = ServiceBootstrap.getUserService().getSpaces(user);
        SpaceBean space = new SpaceBean();
        String displayName = "Test Space";
        String spaceId = "123456789";
        String room = ChatUtils.getRoomId((String)spaceId);
        space.setDisplayName(displayName);
        space.setGroupId("test_space");
        space.setId(spaceId);
        space.setRoom(room);
        space.setShortName("Test Space");
        space.setPrettyName("Test space");
        space.setTimestamp(System.currentTimeMillis());
        spaces.add(space);
        ServiceBootstrap.getUserService().setSpaces(user, spaces);
        ServiceBootstrap.getUserService().setSpaces("john", spaces);
        Assert.assertEquals((long)2L, (long)ServiceBootstrap.getUserService().getUsers(space.getRoom()).size());
        ServiceBootstrap.getUserService().setSpaces("mary", spaces);
        Assert.assertEquals((long)3L, (long)ServiceBootstrap.getUserService().getUsers(space.getRoom()).size());
        SpaceBean space2 = new SpaceBean();
        String displayName2 = "Test Space 2";
        String spaceId2 = "129623459876";
        String room2 = ChatUtils.getRoomId((String)spaceId2);
        space2.setDisplayName(displayName2);
        space2.setGroupId("test_space_2");
        space2.setId(spaceId2);
        space2.setRoom(room2);
        space2.setShortName("Test Space 2");
        space2.setPrettyName("Test space 2");
        space2.setTimestamp(System.currentTimeMillis());
        spaces.add(space2);
        ServiceBootstrap.getUserService().setSpaces("mary", spaces);
        Assert.assertEquals((long)1L, (long)ServiceBootstrap.getUserService().getUsers(space2.getRoom()).size());
        Assert.assertEquals((long)3L, (long)ServiceBootstrap.getUserService().getUsers(space.getRoom()).size());
    }
}

