/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.chat.model;

import com.mongodb.BasicDBList;
import com.mongodb.BasicDBObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import org.exoplatform.chat.model.EventBean;
import org.exoplatform.chat.model.FileBean;
import org.exoplatform.chat.model.MessageBean;
import org.exoplatform.chat.model.TaskBean;
import org.exoplatform.chat.model.UserBean;

public class ReportBean {
    HashMap<String, UserBean> attendees = new HashMap();
    List<String> questions = new ArrayList<String>();
    List<String> links = new ArrayList<String>();
    List<MessageBean> messages = new ArrayList<MessageBean>();
    List<FileBean> files = new ArrayList<FileBean>();
    List<TaskBean> tasks = new ArrayList<TaskBean>();
    List<EventBean> events = new ArrayList<EventBean>();
    ResourceBundle res;

    public ReportBean(ResourceBundle res) {
        this.res = res;
    }

    public Collection<UserBean> getAttendees() {
        return this.attendees.values();
    }

    public void addUser(UserBean attendee) {
        if (!this.attendees.containsKey(attendee.getName())) {
            attendee.setStatus("offline");
            this.attendees.put(attendee.getName(), attendee);
        }
    }

    public void addAttendee(String user) {
        if (this.attendees.containsKey(user)) {
            this.attendees.get(user).setStatus("available");
        }
    }

    public List<String> getQuestions() {
        return this.questions;
    }

    public void addQuestion(String question) {
        this.questions.add(question);
    }

    public List<String> getLinks() {
        return this.links;
    }

    public void addLink(String link) {
        this.links.add(link);
    }

    public List<MessageBean> getMessages() {
        return this.messages;
    }

    public void addMessage(MessageBean message) {
        this.messages.add(0, message);
    }

    public List<FileBean> getFiles() {
        return this.files;
    }

    public void addFile(FileBean file) {
        this.files.add(file);
    }

    public List<TaskBean> getTasks() {
        return this.tasks;
    }

    public void addTask(TaskBean task) {
        this.tasks.add(task);
    }

    public List<EventBean> getEvents() {
        return this.events;
    }

    public void addEvent(EventBean event) {
        this.events.add(event);
    }

    public void fill(BasicDBList messages, List<UserBean> users) {
        for (UserBean user : users) {
            this.addUser(user);
        }
        for (BasicDBObject message : messages) {
            Object msg = message.get("msg").toString();
            Long timestamp = (Long)message.get("timestamp");
            String user = message.get("user").toString();
            String fullname = message.get("fullname").toString();
            boolean isSystem = false;
            if (message.containsField("isSystem")) {
                isSystem = "true".equals(message.get("isSystem").toString());
            }
            BasicDBObject options = null;
            if (isSystem && message.containsField("options") && (options = (BasicDBObject)message.get("options")).containsField("type")) {
                String type = options.get("type").toString();
                if ("type-link".equals(type)) {
                    this.addLink(options.get("link").toString());
                    msg = "[ " + this.res.getString("exoplatform.chat.meetingnotes.link") + ": <a href=\"" + options.get("link").toString() + "\">" + options.get("link").toString() + "</a> ]";
                } else if ("type-question".equals(type)) {
                    this.addQuestion((String)msg);
                    msg = "[ " + this.res.getString("exoplatform.chat.meetingnotes.question") + ": " + (String)msg + " ]";
                } else if ("type-file".equals(type)) {
                    FileBean file = new FileBean();
                    file.setName(options.get("name").toString());
                    file.setUrl(options.get("restPath").toString());
                    file.setSize(options.get("sizeLabel").toString());
                    this.addFile(file);
                    msg = "[ " + this.res.getString("exoplatform.chat.meetingnotes.file") + ": " + options.get("name").toString() + " ]";
                } else if ("type-hand".equals(type)) {
                    msg = "[ " + this.res.getString("exoplatform.chat.meetingnotes.raiseHand") + ": " + (String)msg + "]";
                } else if ("type-task".equals(type)) {
                    TaskBean task = new TaskBean();
                    Object taskTitle = options.get("task");
                    Object username = options.get("username");
                    Object dueDate = options.get("dueDate");
                    task.setTask(taskTitle.toString());
                    if (username != null) {
                        task.setUsername(username.toString());
                        task.setAssignee(username.toString());
                    }
                    if (dueDate != null) {
                        task.setDueDate(dueDate.toString());
                    }
                    this.addTask(task);
                    msg = "[ " + this.res.getString("exoplatform.chat.meetingnotes.task").replace("{0}", taskTitle.toString()).replace("{1}", username != null ? username.toString() : "").replace("{2}", dueDate != null ? dueDate.toString() : "") + " ]";
                } else if ("type-event".equals(type)) {
                    EventBean event = new EventBean();
                    event.setSummary(options.get("summary").toString());
                    event.setStartDate(options.get("startDate").toString());
                    event.setStartTime(options.get("startTime").toString());
                    event.setEndDate(options.get("endDate").toString());
                    event.setEndTime(options.get("endTime").toString());
                    this.addEvent(event);
                    msg = "[ " + this.res.getString("exoplatform.chat.meetingnotes.event").replace("{0}", options.get("summary").toString()).replace("{1}", options.get("startDate").toString()).replace("{2}", options.get("startTime").toString()).replace("{3}", options.get("endDate").toString()).replace("{4}", options.get("endTime").toString()) + " ]";
                } else if ("call-join".equals(type)) {
                    msg = "[ " + this.res.getString("exoplatform.chat.meetingnotes.joined") + " ]";
                } else if ("type-meeting-start".equals(type)) {
                    msg = "[ " + this.res.getString("exoplatform.chat.meetingnotes.started") + " ]";
                } else if ("type-meeting-stop".equals(type)) {
                    msg = "[ " + this.res.getString("exoplatform.chat.meetingnotes.finished") + " ]";
                }
            }
            this.addAttendee(user);
            MessageBean messageBean = new MessageBean();
            messageBean.setTimestamp(timestamp.longValue());
            messageBean.setFullName(fullname);
            messageBean.setUser(user);
            messageBean.setMessage((String)msg);
            this.addMessage(messageBean);
        }
    }

    public String getWikiPageContent(String serverBase, String portalURI) {
        serverBase = serverBase == null ? "" : serverBase;
        StringBuilder wikiPageContent = new StringBuilder();
        if (this.questions.size() > 0) {
            wikiPageContent.append("\n<h2>" + this.res.getString("exoplatform.chat.meetingnotes.questions") + "</h2>\n");
            for (String question : this.getQuestions()) {
                wikiPageContent.append(question).append("<br>");
            }
        }
        if (this.links.size() > 0) {
            wikiPageContent.append("\n<h2>" + this.res.getString("exoplatform.chat.meetingnotes.links") + "</h2>\n");
            for (String link : this.getLinks()) {
                wikiPageContent.append("<a href=\"").append(link).append("\">").append(link).append("</a><br>");
            }
        }
        if (this.files.size() > 0) {
            wikiPageContent.append("\n<h2>" + this.res.getString("exoplatform.chat.meetingnotes.files") + "</h2>\n");
            for (FileBean file : this.getFiles()) {
                wikiPageContent.append("<a href=\"").append(file.getUrl().replaceFirst("/rest", serverBase + "/portal/rest/")).append("\">").append(file.getName()).append("</a> ").append(" (").append(file.getSize()).append(")<br>");
            }
        }
        if (this.tasks.size() > 0) {
            wikiPageContent.append("\n<h2>" + this.res.getString("exoplatform.chat.meetingnotes.tasks") + "</h2>\n");
            wikiPageContent.append("<figure class=\"table\"><table><thead><tr>").append("<th>").append(this.res.getString("exoplatform.chat.meetingnotes.tasks.task")).append("<th>").append(this.res.getString("exoplatform.chat.meetingnotes.tasks.assignee")).append("<th>").append(this.res.getString("exoplatform.chat.meetingnotes.tasks.due")).append("</tr></thead><tbody>");
            for (TaskBean task : this.getTasks()) {
                wikiPageContent.append("<tr><td>").append(task.getTask()).append("</td>").append("<td>").append(task.getAssignee()).append("</td>").append("<td>").append(task.getDueDate()).append("</td></tr>\n");
            }
            wikiPageContent.append("</tbody></table>");
        }
        if (this.events.size() > 0) {
            wikiPageContent.append("\n<h2>" + this.res.getString("exoplatform.chat.meetingnotes.events") + "</h2>\n");
            wikiPageContent.append("<figure class=\"table\"><table><thead><tr>").append("<th>").append(this.res.getString("exoplatform.chat.meetingnotes.events.event")).append("<th>").append(this.res.getString("exoplatform.chat.meetingnotes.events.start")).append("<th>").append(this.res.getString("exoplatform.chat.meetingnotes.events.end")).append("</tr></thead><tbody>");
            for (EventBean event : this.getEvents()) {
                wikiPageContent.append("<tr><td>").append(event.getSummary()).append("</td>").append("<td>").append(event.getStartDate()).append(" ").append(event.getStartTime()).append("</td>").append("<td>").append(event.getEndDate()).append(" ").append(event.getEndTime()).append("</td></tr>\n");
            }
            wikiPageContent.append("</tbody></table>");
        }
        wikiPageContent.append("\n<h2>" + this.res.getString("exoplatform.chat.meetingnotes.attendees") + "</h2>\n");
        for (UserBean userBean : this.getAttendees()) {
            if ("available".equals(userBean.getStatus())) {
                wikiPageContent.append("<img src=\"/rest/wiki/emoticons/accept.gif\"/> ");
            } else {
                wikiPageContent.append("<img src=\"/rest/wiki/emoticons/cancel.gif\"/> ");
            }
            wikiPageContent.append(" <a href=\"").append(serverBase + portalURI + "/profile/").append(userBean.getName()).append("\">").append(userBean.getFullname()).append("</a><br>");
        }
        wikiPageContent.append("\n<h1>" + this.res.getString("exoplatform.chat.meetingnotes.discussions") + "</h1>\n\n");
        String prevUser = "";
        for (MessageBean messageBean : this.getMessages()) {
            wikiPageContent.append("<span style='padding: 4px; border-bottom: 1px dotted #DDD; width: 500px;display: block;'>");
            if (!messageBean.getUser().equals(prevUser)) {
                wikiPageContent.append("<div style='padding: 4px;color: #CCC;margin:0;'>");
                wikiPageContent.append("<span style='float: left; display: inline-block;padding-right: 10px;'> <img src=\"" + serverBase + "/portal/rest/v1/social/users/" + messageBean.getUser() + "/avatar\" style=\"width:30px;height:30px;\"/></span>");
                wikiPageContent.append("<span style='width: 400px;display: inline-block;vertical-align: top;'>").append(messageBean.getFullName()).append("</span>");
                wikiPageContent.append("<span style='font-size: smaller;vertical-align: top;'>").append(messageBean.getTimestamp()).append("</span>");
                wikiPageContent.append("</div>");
            }
            prevUser = messageBean.getUser();
            String message = messageBean.getMessage();
            message = message.replaceAll("&#38", "&");
            message = message.replaceAll("&lt;", "<");
            message = message.replaceAll("&gt;", ">");
            message = message.replaceAll("&quot;", "\"");
            message = message.replaceAll("<br/>", "\n");
            message = message.replaceAll("&#92", "\\\\");
            message = message.replaceAll("=", "=");
            message = message.replaceAll("\\}", "}");
            message = message.replaceAll("\\{", "{");
            message = message.replaceAll("  ", "\t");
            wikiPageContent.append("<div style='padding: 0 4px; margin:0 0 0 40px;vertical-align: top;'>").append(message).append("</div>");
            wikiPageContent.append("</span>");
        }
        return wikiPageContent.toString();
    }

    public String getAsHtml(String title, String serverBase, Locale locale) {
        StringBuilder html = new StringBuilder();
        html.append("<div style='font-family: Lucida,arial,tahoma;'>");
        html.append("<style>.type-file {width: 16px;height: 16px;}.type-link {width: 16px;height: 16px;}.type-question {width: 16px;height: 16px;}</style>");
        html.append("<span style='float:right; border: 1px solid #CCC;'>");
        html.append("  <div style='font-weight: bold;border-bottom: 1px solid #CCC;padding: 4px;font-size: larger'>Attendees</div>");
        html.append("  <div style='font-weight: bold;border-bottom: 1px solid #CCC;padding: 4px;font-size: larger'>" + this.res.getString("exoplatform.chat.meetingnotes.attendees") + "</div>");
        for (UserBean userBean : this.getAttendees()) {
            html.append("<div style='padding: 4px;'>");
            if ("available".equals(userBean.getStatus())) {
                html.append("<span style='background-color: #3C3;color: white;padding: 1px 5px;'>o</span>");
            } else {
                html.append("<span style='background-color: #CCC;color: white;padding: 1px 5px;'>x</span>");
            }
            html.append("  <span style='font-weight:bold;padding: 5px;'>").append(userBean.getFullname()).append("</span>");
            html.append("</div>");
        }
        html.append("</span>");
        html.append("<h2>").append(title).append("</h2>");
        if (this.questions.size() > 0) {
            html.append("<span style='border: 1px solid #CCC;width: 300px; display: inline-block;'>");
            html.append("  <div style='font-weight: bold;border-bottom: 1px solid #CCC;padding: 4px;font-size: larger'>");
            html.append("    <span style='vertical-align: top;line-height: 18px;'>" + this.res.getString("exoplatform.chat.meetingnotes.questions") + "</span>");
            html.append("  </div>");
            for (String question : this.getQuestions()) {
                html.append("<div style='padding: 4px'>").append(question).append("</div>");
            }
            html.append("</span><br><br>");
        }
        if (this.links.size() > 0) {
            html.append("<span style='border: 1px solid #CCC;width: 300px; display: inline-block;'>");
            html.append("  <div style='font-weight: bold;border-bottom: 1px solid #CCC;padding: 4px;font-size: larger'>");
            html.append("    <span style='vertical-align: top;line-height: 18px;'>" + this.res.getString("exoplatform.chat.meetingnotes.links") + "</span>");
            html.append("  </div>");
            for (String link : this.getLinks()) {
                html.append("<div style='padding: 4px'>");
                html.append("<span><a href='" + link + "'>").append(link).append("</a></span>");
                html.append("</div>");
            }
            html.append("</span><br><br>");
        }
        if (this.files.size() > 0) {
            html.append("<span style='border: 1px solid #CCC;width: 300px; display: inline-block;'>");
            html.append("  <div style='font-weight: bold;border-bottom: 1px solid #CCC;padding: 4px;font-size: larger'>");
            html.append("    <span style='vertical-align: top;line-height: 18px;'>" + this.res.getString("exoplatform.chat.meetingnotes.files") + "</span>");
            html.append("  </div>");
            for (FileBean file : this.getFiles()) {
                html.append("<div style='padding: 4px'>");
                html.append("  <div><a href='" + serverBase + file.getUrl().replaceFirst("/rest", "/portal/rest") + "'>").append(file.getName()).append("</a></div>");
                html.append("  <div style='color: #ccc;'>").append(file.getSize()).append("</div>");
                html.append("</div>");
            }
            html.append("</span><br><br>");
        }
        html.append("<h3>" + this.res.getString("exoplatform.chat.meetingnotes.discussions") + "</h3>");
        html.append("<span>");
        String prevUser = "";
        Object keyAvatar = "";
        int index = 0;
        for (MessageBean messageBean : this.getMessages()) {
            html.append("<span style='padding: 4px; border-bottom: 1px dotted #DDD; width: 500px;display: block;'>");
            if (!messageBean.getUser().equals(prevUser)) {
                keyAvatar = messageBean.getUser() + index;
                html.append("  <div style='padding: 4px;color: #CCC;'>");
                html.append("    <span style='float: left; display: inline-block;padding-right: 10px;'><img src=\"cid:" + (String)keyAvatar + "\" width='30px' style='width:30px;'></span>");
                html.append("    <span style='width: 300px;display: inline-block;vertical-align: top;'>").append(messageBean.getFullName()).append("</span>");
                html.append("    <span style='font-size: smaller;vertical-align: top;'>").append(messageBean.getTimestamp()).append("</span>");
                html.append("  </div>");
                ++index;
            }
            prevUser = messageBean.getUser();
            html.append("  <div style='padding: 0 4px; margin-left: 40px;vertical-align: top;'>").append(messageBean.getMessage()).append("</div>");
            html.append("</span>");
        }
        html.append("</span>");
        html.append("</div>");
        return html.toString();
    }
}

