/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.chat;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.exoplatform.chat.AbstractChatTestCase;
import org.exoplatform.chat.bootstrap.ServiceBootstrap;
import org.exoplatform.chat.listener.ConnectionManager;
import org.exoplatform.chat.model.RoomBean;
import org.exoplatform.chat.model.RoomsBean;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TeamTestCase
extends AbstractChatTestCase {
    @Before
    public void setUp() {
        ConnectionManager.getInstance().getDB().getCollection("users").drop();
        ConnectionManager.getInstance().getDB().getCollection("rooms").drop();
        ServiceBootstrap.getUserService().addUserFullName("benjamin", "Benjamin Paillereau");
        ServiceBootstrap.getUserService().addUserEmail("benjamin", "bpaillereau@exoplatform.com");
        ServiceBootstrap.getUserService().addUserFullName("john", "John Smith");
        ServiceBootstrap.getUserService().addUserEmail("john", "john@exoplatform.com");
        ServiceBootstrap.getUserService().addUserFullName("mary", "Mary Williams");
        ServiceBootstrap.getUserService().addUserEmail("mary", "mary@exoplatform.com");
    }

    @Test
    public void testTeamCreation() throws Exception {
        log.info("TeamTestCase.testTeamCreation");
        String user = "benjamin";
        String user2 = "john";
        String room1 = ServiceBootstrap.getChatService().getTeamRoom("My VIP Team", user);
        String room2 = ServiceBootstrap.getChatService().getTeamRoom("My VIP Team 2", user);
        String room3 = ServiceBootstrap.getChatService().getTeamRoom("My VIP Team", user2);
        Assert.assertNotEquals((Object)room1, (Object)room2);
        Assert.assertNotEquals((Object)room1, (Object)room3);
        Assert.assertEquals((Object)user, (Object)ServiceBootstrap.getChatService().getTeamCreator(room1));
        Assert.assertEquals((Object)user, (Object)ServiceBootstrap.getChatService().getTeamCreator(room2));
        Assert.assertEquals((Object)user2, (Object)ServiceBootstrap.getChatService().getTeamCreator(room3));
    }

    @Test
    public void testTeamMeetingStatus() throws Exception {
        log.info("TeamTestCase.testTeamMeetingStatus");
        String user1 = "mary";
        String user2 = "john";
        String room1 = ServiceBootstrap.getChatService().getTeamRoom("My VIP Team1", user1);
        String room2 = ServiceBootstrap.getChatService().getTeamRoom("My VIP Team", user2);
        RoomBean roomBean1 = ServiceBootstrap.getChatService().getTeamRoomById(room1);
        RoomBean roomBean2 = ServiceBootstrap.getChatService().getTeamRoomById(room2);
        Assert.assertFalse((boolean)roomBean1.isMeetingStarted());
        Assert.assertFalse((boolean)roomBean2.isMeetingStarted());
        Assert.assertTrue((boolean)roomBean1.getStartTime().isEmpty());
        Assert.assertTrue((boolean)roomBean2.getStartTime().isEmpty());
        Date date = new Date();
        String now = date.toString();
        date.setHours(0);
        String now1 = date.toString();
        ServiceBootstrap.getChatService().setRoomMeetingStatus(room1, true, now);
        ServiceBootstrap.getChatService().setRoomMeetingStatus(room2, true, now1);
        roomBean1 = ServiceBootstrap.getChatService().getTeamRoomById(room1);
        roomBean2 = ServiceBootstrap.getChatService().getTeamRoomById(room2);
        Assert.assertTrue((boolean)roomBean1.isMeetingStarted());
        Assert.assertTrue((boolean)roomBean2.isMeetingStarted());
        Assert.assertEquals((Object)now, (Object)roomBean1.getStartTime());
        Assert.assertEquals((Object)now1, (Object)roomBean2.getStartTime());
    }

    @Test
    public void testTeamRoomsByName() throws Exception {
        log.info("TeamTestCase.testTeamCreation");
        String user = "benjamin";
        String user2 = "john";
        String room1 = ServiceBootstrap.getChatService().getTeamRoom("My VIP Team", user);
        String room2 = ServiceBootstrap.getChatService().getTeamRoom("My VIP Team 2", user);
        String room3 = ServiceBootstrap.getChatService().getTeamRoom("My VIP Team", user2);
        Assert.assertNotEquals((Object)room1, (Object)room2);
        Assert.assertNotEquals((Object)room1, (Object)room3);
        Assert.assertEquals((long)2L, (long)ServiceBootstrap.getChatService().getTeamRoomsByName("My VIP Team").size());
        Assert.assertEquals((long)1L, (long)ServiceBootstrap.getChatService().getTeamRoomsByName("My VIP Team 2").size());
        Assert.assertEquals((long)0L, (long)ServiceBootstrap.getChatService().getTeamRoomsByName("Not existing room").size());
    }

    @Test
    public void testTeamRoomDeletion() throws Exception {
        log.info("TeamTestCase.testTeamDeletion");
        String user = "benjamin";
        String teamName = "My Team to Delete";
        String roomId = ServiceBootstrap.getChatService().getTeamRoom(teamName, user);
        RoomBean room = ServiceBootstrap.getChatService().getTeamRoomById(roomId);
        Assert.assertNotNull((String)"The room should exist", (Object)room);
        ServiceBootstrap.getChatService().deleteTeamRoom(roomId, user);
        List members = ServiceBootstrap.getUserService().getUsersFilterBy(null, roomId, "t");
        Assert.assertTrue((String)"No user should be member of the deleted Team Room", (boolean)members.isEmpty());
        RoomBean roomDelete = ServiceBootstrap.getChatService().getTeamRoomById(roomId);
        Assert.assertNull((String)"The room should have been deleted", (Object)roomDelete);
    }

    @Test
    public void testTeamRoomLoadById() throws Exception {
        log.info("TeamTestCase.testTeamRoomLoadById");
        String user = "benjamin";
        String roomSpaceName = "RoomSpace";
        String roomTeamName = "RoomTeam";
        String roomTeamId = ServiceBootstrap.getChatService().getTeamRoom(roomTeamName, user);
        RoomBean roomTeam = ServiceBootstrap.getChatService().getTeamRoomById(roomTeamId);
        Assert.assertNotNull((String)"The room should exists", (Object)roomTeam);
        Assert.assertEquals((String)"The room name is not good", (Object)roomTeamName, (Object)roomTeam.getFullName());
        Assert.assertEquals((String)"The room owner is not good", (Object)user, (Object)roomTeam.getUser());
        String roomId = ServiceBootstrap.getChatService().getSpaceRoom(roomSpaceName);
        RoomBean room = ServiceBootstrap.getChatService().getTeamRoomById(roomId);
        Assert.assertNull((String)"The team room should not exist", (Object)room);
    }

    @Test
    public void testTeamRoomLoadByIdNonExisting() throws Exception {
        log.info("TeamTestCase.testTeamRoomLoadByIdNonExisting");
        String roomId = "non-existing-id";
        RoomBean nullTeamRoom = ServiceBootstrap.getChatService().getTeamRoomById(roomId);
        Assert.assertNull((String)"The returned room should be null", (Object)nullTeamRoom);
    }

    @Test
    public void testTeamUserAdd() throws Exception {
        log.info("TeamTestCase.testTeamUserAdd");
        String user = "benjamin";
        String user2 = "john";
        String room1 = ServiceBootstrap.getChatService().getTeamRoom("My VIP Team", user);
        String room2 = ServiceBootstrap.getChatService().getTeamRoom("My Other Team", user);
        String room3 = ServiceBootstrap.getChatService().getTeamRoom("My Last Team", user);
        Assert.assertEquals((Object)user, (Object)ServiceBootstrap.getChatService().getTeamCreator(room1));
        ServiceBootstrap.getUserService().addTeamRoom(user, room1);
        ServiceBootstrap.getUserService().addTeamRoom(user, room2);
        ServiceBootstrap.getUserService().addTeamRoom(user, room3);
        List teams = ServiceBootstrap.getUserService().getTeams(user);
        Assert.assertEquals((long)3L, (long)teams.size());
        ArrayList<String> users = new ArrayList<String>();
        users.add("john");
        users.add("mary");
        ArrayList<String> usersRemove = new ArrayList<String>();
        usersRemove.add("john");
        List teamsJohn = ServiceBootstrap.getUserService().getTeams("john");
        Assert.assertEquals((long)0L, (long)teamsJohn.size());
        ServiceBootstrap.getUserService().addTeamUsers(room1, users);
        ServiceBootstrap.getUserService().addTeamUsers(room2, users);
        teamsJohn = ServiceBootstrap.getUserService().getTeams("john");
        Assert.assertEquals((long)2L, (long)teamsJohn.size());
        ServiceBootstrap.getUserService().removeTeamUsers(room1, usersRemove);
        teamsJohn = ServiceBootstrap.getUserService().getTeams("john");
        Assert.assertEquals((long)1L, (long)teamsJohn.size());
        List teamsMary = ServiceBootstrap.getUserService().getTeams("mary");
        Assert.assertEquals((long)2L, (long)teamsMary.size());
    }

    @Test
    public void testTeamUserFilter() throws Exception {
        log.info("TeamTestCase.testTeamUserFilter");
        String user = "benjamin";
        String room1 = ServiceBootstrap.getChatService().getTeamRoom("My VIP Team", user);
        String room2 = ServiceBootstrap.getChatService().getTeamRoom("My Other Team", user);
        String room3 = ServiceBootstrap.getChatService().getTeamRoom("My Last Team", user);
        Assert.assertEquals((Object)user, (Object)ServiceBootstrap.getChatService().getTeamCreator(room1));
        ServiceBootstrap.getUserService().addTeamRoom(user, room1);
        ServiceBootstrap.getUserService().addTeamRoom(user, room2);
        ArrayList<String> users = new ArrayList<String>();
        users.add("john");
        ServiceBootstrap.getUserService().addTeamUsers(room1, users);
        List users1 = ServiceBootstrap.getUserService().getUsersFilterBy(user, room1, "t");
        Assert.assertEquals((long)1L, (long)users1.size());
        List users2 = ServiceBootstrap.getUserService().getUsersFilterBy(user, room2, "t");
        Assert.assertEquals((long)0L, (long)users2.size());
    }

    @Test
    public void testTeamRoomName() throws Exception {
        log.info("TeamTestCase.testTeamRoomName");
        String user = "benjamin";
        String room1 = ServiceBootstrap.getChatService().getTeamRoom("My VIP Team", user);
        ServiceBootstrap.getUserService().addTeamRoom(user, room1);
        RoomsBean rooms = ServiceBootstrap.getChatService().getRooms(user, "", true, true, true, true, true, ServiceBootstrap.getNotificationService(), ServiceBootstrap.getTokenService());
        Assert.assertEquals((long)1L, (long)rooms.getRooms().size());
        RoomBean room = (RoomBean)rooms.getRooms().get(0);
        Assert.assertEquals((Object)"My VIP Team", (Object)room.getFullName());
        ServiceBootstrap.getChatService().setRoomName(room1, "VIP Team");
        rooms = ServiceBootstrap.getChatService().getRooms(user, "", true, true, true, true, true, ServiceBootstrap.getNotificationService(), ServiceBootstrap.getTokenService());
        Assert.assertEquals((long)1L, (long)rooms.getRooms().size());
        room = (RoomBean)rooms.getRooms().get(0);
        Assert.assertEquals((Object)"VIP Team", (Object)room.getFullName());
    }
}

