/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.chat.server;

import jakarta.servlet.ServletConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Date;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.chat.listener.ConnectionManager;
import org.exoplatform.chat.listener.GuiceManager;
import org.exoplatform.chat.model.RealTimeMessageBean;
import org.exoplatform.chat.model.SpaceBean;
import org.exoplatform.chat.model.SpaceBeans;
import org.exoplatform.chat.model.UserBean;
import org.exoplatform.chat.services.ChatException;
import org.exoplatform.chat.services.ChatService;
import org.exoplatform.chat.services.NotificationService;
import org.exoplatform.chat.services.RealTimeMessageService;
import org.exoplatform.chat.services.TokenService;
import org.exoplatform.chat.services.UserService;
import org.exoplatform.chat.utils.ChatUtils;
import org.exoplatform.chat.utils.PropertyManager;

abstract class ChatTools
extends HttpServlet {
    protected static final String UNIQUE_SESSION_PARAM = "uniqueSession";
    protected static final String SESSION_ID_PARAM = "sessionId";
    protected static final String PASSPHRASE_DOESN_T_MATCH_MESSAGE = "{ \"message\": \"passphrase doesn't match\"}";
    protected static final String PASSPHRASE_PARAM = "passphrase";
    protected static final String USERNAME_PARAM = "username";
    protected static final String MIME_TYPE_JSON = "application/json";
    protected static final String MIME_TYPE_TEXT = "text/plain";
    protected static final String MESSAGES_PARAM = "messages";
    protected static final String UPDATED_MESSAGE = "Updated!";
    protected static final String ONLINE_ONLY_PARAM = "onlineOnly";
    protected static final String STATUS_PARAM = "status";
    protected static final String DATA_PARAM = "data";
    protected static final String WITH_DETAILS_PARAM = "withDetails";
    protected static final String EVENT_PARAM = "event";
    protected static final String ENABLED_PARAM = "enabled";
    protected static final String SPACE_ID_PARAM = "spaceId";
    protected static final String START_TIME_PARAM = "startTime";
    protected static final String START_PARAM = "start";
    protected static final String USERS_PARAM = "users";
    protected static final String TEAM_NAME_PARAM = "teamName";
    protected static final String TYPE_PARAM = "type";
    protected static final String WITH_DETAIL_PARAM = "withDetail";
    protected static final String TIME_PARAM = "time";
    protected static final String NOTIF_CONDITION_TYPE_PARAM = "notifConditionType";
    protected static final String NOTIF_CONDITION_PARAM = "notifCondition";
    protected static final String NOTIF_MANNER_PARAM = "notifManner";
    protected static final String FAVORITE_PARAM = "favorite";
    protected static final String MESSAGE_ID_PARAM = "messageId";
    protected static final String PORTAL_URI_PARAM = "portalURI";
    protected static final String IS_TEXT_ONLY_PARAM = "isTextOnly";
    protected static final String TO_TIMESTAMP_PARAM = "toTimestamp";
    protected static final String FROM_TIMESTAMP_PARAM = "fromTimestamp";
    protected static final String OPTIONS_PARAM = "options";
    protected static final String IS_SYSTEM_PARAM = "isSystem";
    protected static final String ROOM_PARAM = "room";
    protected static final String MESSAGE_PARAM = "message";
    protected static final String SENDER_PARAM = "sender";
    protected static final String IS_EXTERNAL_PARAM = "isExternal";
    protected static final String IS_ENABLED_PARAM = "isEnabled";
    protected static final String IS_DELETED_PARAM = "isDeleted";
    protected static final String TARGET_USER_PARAM = "targetUser";
    protected static final String ROOM_TYPE_PARAM = "roomType";
    protected static final String LIMIT_PARAM = "limit";
    protected static final String OFFSET_PARAM = "offset";
    protected static final String FILTER_PARAM = "filter";
    protected static final String ONLINE_USERS_PARAM = "onlineUsers";
    protected static final String USER_PARAM = "user";
    protected static final String ROOM_ID = "roomId";
    protected static final String TOKEN_PARAM = "token";
    private static final long serialVersionUID = 3942640732294577324L;
    private static final Logger LOG = Logger.getLogger("ChatTools");
    ChatService chatService;
    UserService userService;
    TokenService tokenService;
    NotificationService notificationService;
    RealTimeMessageService realTimeMessageService;

    ChatTools() {
    }

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        this.chatService = (ChatService)GuiceManager.getInstance().getInstance(ChatService.class);
        this.userService = (UserService)GuiceManager.getInstance().getInstance(UserService.class);
        this.tokenService = (TokenService)GuiceManager.getInstance().getInstance(TokenService.class);
        this.notificationService = (NotificationService)GuiceManager.getInstance().getInstance(NotificationService.class);
        this.realTimeMessageService = (RealTimeMessageService)GuiceManager.getInstance().getInstance(RealTimeMessageService.class);
    }

    protected void addUser(HttpServletRequest request, HttpServletResponse response) {
        String username = request.getParameter(USERNAME_PARAM);
        String token = request.getParameter(TOKEN_PARAM);
        String passphrase = request.getParameter(PASSPHRASE_PARAM);
        if (!this.checkPassphrase(passphrase)) {
            this.writeJsonResponse(response, PASSPHRASE_DOESN_T_MATCH_MESSAGE, 404);
            return;
        }
        this.tokenService.addUser(username, token);
        this.writeTextResponse(response, "OK");
    }

    protected void logout(HttpServletRequest request, HttpServletResponse response) {
        String username = request.getParameter(USERNAME_PARAM);
        String sessionId = request.getParameter(SESSION_ID_PARAM);
        String passphrase = request.getParameter(PASSPHRASE_PARAM);
        String uniqueSession = request.getParameter(UNIQUE_SESSION_PARAM);
        if (!this.checkPassphrase(passphrase)) {
            this.writeJsonResponse(response, PASSPHRASE_DOESN_T_MATCH_MESSAGE, 404);
            return;
        }
        HashMap<String, String> options = new HashMap<String, String>();
        options.put(SESSION_ID_PARAM, sessionId);
        RealTimeMessageBean realTimeMessageBean = new RealTimeMessageBean(RealTimeMessageBean.EventType.LOGOUT_SENT, null, username, new Date(), options);
        this.realTimeMessageService.sendMessage(realTimeMessageBean, username);
        if (StringUtils.equals((CharSequence)uniqueSession, (CharSequence)"true")) {
            HashMap<String, String> data = new HashMap<String, String>();
            data.put(STATUS_PARAM, "offline");
            realTimeMessageBean = new RealTimeMessageBean(RealTimeMessageBean.EventType.USER_STATUS_CHANGED, username, username, new Date(), data);
            this.realTimeMessageService.sendMessageToAll(realTimeMessageBean);
        }
        this.writeTextResponse(response, "OK");
    }

    protected void setAsAdmin(HttpServletRequest request, HttpServletResponse response) {
        String username = request.getParameter(USERNAME_PARAM);
        String isAdmin = request.getParameter("isAdmin");
        String passphrase = request.getParameter(PASSPHRASE_PARAM);
        if (!this.checkPassphrase(passphrase)) {
            this.writeJsonResponse(response, PASSPHRASE_DOESN_T_MATCH_MESSAGE, 404);
            return;
        }
        this.userService.setAsAdmin(username, "true".equals(isAdmin));
        this.writeTextResponse(response, "OK");
    }

    protected void addUserFullNameAndEmail(HttpServletRequest request, HttpServletResponse response) {
        String username = request.getParameter(USERNAME_PARAM);
        String fullname = request.getParameter("fullname");
        String email = request.getParameter("email");
        String passphrase = request.getParameter(PASSPHRASE_PARAM);
        if (!this.checkPassphrase(passphrase)) {
            this.writeJsonResponse(response, PASSPHRASE_DOESN_T_MATCH_MESSAGE, 404);
            return;
        }
        try {
            this.userService.addUserEmail(username, email);
            fullname = (String)ChatUtils.fromString((String)fullname);
            this.userService.addUserFullName(username, fullname);
            this.writeTextResponse(response, "OK");
        }
        catch (Exception e) {
            LOG.log(Level.SEVERE, String.format("The fullName with value %s of the user %s couldn't be serialized : ", fullname, username), e);
            this.writeTextResponse(response, e.getMessage(), 500);
        }
    }

    protected void deleteUser(HttpServletRequest request, HttpServletResponse response) {
        String username = request.getParameter(USERNAME_PARAM);
        String passphrase = request.getParameter(PASSPHRASE_PARAM);
        if (!this.checkPassphrase(passphrase)) {
            this.writeJsonResponse(response, PASSPHRASE_DOESN_T_MATCH_MESSAGE, 404);
            return;
        }
        this.userService.deleteUser(username);
        this.writeTextResponse(response, "OK");
    }

    protected void setEnabledUser(HttpServletRequest request, HttpServletResponse response) {
        String username = request.getParameter(USERNAME_PARAM);
        String enabled = request.getParameter(ENABLED_PARAM);
        String passphrase = request.getParameter(PASSPHRASE_PARAM);
        if (!this.checkPassphrase(passphrase)) {
            this.writeJsonResponse(response, PASSPHRASE_DOESN_T_MATCH_MESSAGE, 404);
            return;
        }
        Boolean isEnabled = StringUtils.equals((CharSequence)enabled, (CharSequence)"true");
        this.userService.setEnabledUser(username, isEnabled);
        this.writeTextResponse(response, "OK");
    }

    protected void setExternalUser(HttpServletRequest request, HttpServletResponse response) {
        String username = request.getParameter(USERNAME_PARAM);
        String external = request.getParameter("external");
        String passphrase = request.getParameter(PASSPHRASE_PARAM);
        if (!this.checkPassphrase(passphrase)) {
            this.writeJsonResponse(response, PASSPHRASE_DOESN_T_MATCH_MESSAGE, 404);
            return;
        }
        this.userService.setExternalUser(username, external);
        this.writeTextResponse(response, "OK");
    }

    protected void setSpaces(HttpServletRequest request, HttpServletResponse response) {
        String username = request.getParameter(USERNAME_PARAM);
        String spaces = request.getParameter("spaces");
        String passphrase = request.getParameter(PASSPHRASE_PARAM);
        if (!this.checkPassphrase(passphrase)) {
            this.writeJsonResponse(response, PASSPHRASE_DOESN_T_MATCH_MESSAGE, 404);
            return;
        }
        try {
            SpaceBeans spaceBeans = (SpaceBeans)ChatUtils.fromString((String)spaces);
            this.userService.setSpaces(username, spaceBeans.getSpaces());
        }
        catch (IOException | ClassNotFoundException e) {
            LOG.warning(e.getMessage());
        }
        this.writeTextResponse(response, "OK");
    }

    protected void removeUserFromSpace(HttpServletRequest request, HttpServletResponse response) {
        String username = request.getParameter(USERNAME_PARAM);
        String space = request.getParameter("space");
        String passphrase = request.getParameter(PASSPHRASE_PARAM);
        if (!this.checkPassphrase(passphrase)) {
            this.writeJsonResponse(response, PASSPHRASE_DOESN_T_MATCH_MESSAGE, 404);
            return;
        }
        try {
            SpaceBean spaceBean = (SpaceBean)ChatUtils.fromString((String)space);
            this.userService.removeUserFromSpace(username, spaceBean);
        }
        catch (IOException | ClassNotFoundException e) {
            LOG.warning(e.getMessage());
        }
        this.writeTextResponse(response, "OK");
    }

    protected void getUserFullName(HttpServletRequest request, HttpServletResponse response) {
        String username = request.getParameter(USERNAME_PARAM);
        String passphrase = request.getParameter(PASSPHRASE_PARAM);
        if (!this.checkPassphrase(passphrase)) {
            this.writeJsonResponse(response, PASSPHRASE_DOESN_T_MATCH_MESSAGE, 404);
            return;
        }
        String fullname = this.userService.getUserFullName(username);
        this.writeTextResponse(response, fullname);
    }

    protected void shouldUpdate(HttpServletRequest request, HttpServletResponse response) {
        String user = request.getParameter(USER_PARAM);
        String passphrase = request.getParameter(PASSPHRASE_PARAM);
        if (!this.checkPassphrase(passphrase)) {
            this.writeJsonResponse(response, PASSPHRASE_DOESN_T_MATCH_MESSAGE, 404);
            return;
        }
        UserBean userBean = this.userService.getUser(user);
        boolean shouldUpdate = userBean.isEnabled() == null || userBean.isDeleted() == null;
        this.writeTextResponse(response, String.valueOf(shouldUpdate));
    }

    protected void updateUnreadTestMessages(HttpServletRequest request, HttpServletResponse response) {
        String username = request.getParameter(USERNAME_PARAM);
        String room = request.getParameter(ROOM_PARAM);
        String passphrase = request.getParameter(PASSPHRASE_PARAM);
        if (!this.checkPassphrase(passphrase)) {
            this.writeJsonResponse(response, PASSPHRASE_DOESN_T_MATCH_MESSAGE, 404);
            return;
        }
        if (username == null) {
            this.writeJsonResponse(response, "{ \"message\": \"username is null\"}", 404);
            return;
        }
        if (room == null) {
            this.writeJsonResponse(response, "{ \"message\": \"room is null\"}", 404);
            return;
        }
        if (username.startsWith("space-")) {
            this.writeTextResponse(response, "OK");
            return;
        }
        if (!room.equals("ALL")) {
            this.notificationService.setNotificationsAsRead(username, "chat", ROOM_PARAM, room);
        } else {
            this.notificationService.setNotificationsAsRead(username, null, null, null);
        }
        this.writeTextResponse(response, "OK");
    }

    protected void initDB(HttpServletRequest request, HttpServletResponse response) {
        String db = request.getParameter("db");
        String passphrase = request.getParameter(PASSPHRASE_PARAM);
        if (!this.checkPassphrase(passphrase)) {
            this.writeJsonResponse(response, PASSPHRASE_DOESN_T_MATCH_MESSAGE, 404);
            return;
        }
        if (db == null) {
            this.writeJsonResponse(response, "{ \"message\": \"db is null\"}", 404);
            return;
        }
        ConnectionManager.getInstance().getDB(db);
        StringBuilder data = new StringBuilder();
        data.append("{");
        data.append(" \"message\": \"using db=" + db + "\"");
        data.append("}");
        this.writeJsonResponse(response, data.toString());
    }

    protected void ensureIndexes(HttpServletRequest request, HttpServletResponse response) {
        String db = request.getParameter("db");
        String passphrase = request.getParameter(PASSPHRASE_PARAM);
        if (!this.checkPassphrase(passphrase)) {
            this.writeJsonResponse(response, PASSPHRASE_DOESN_T_MATCH_MESSAGE, 404);
            return;
        }
        if (db == null) {
            this.writeJsonResponse(response, "{ \"message\": \"db is null\"}", 404);
            return;
        }
        if (!db.equals(ConnectionManager.getInstance().getDB().getName())) {
            this.writeJsonResponse(response, "{ \"message\": \"db name doesn't match\"}", 404);
            return;
        }
        ConnectionManager.getInstance().ensureIndexes();
        StringBuilder data = new StringBuilder();
        data.append("{");
        data.append(" \"message\": \"indexes created or updated on db=" + db + "\"");
        data.append("}");
        this.writeJsonResponse(response, data.toString());
    }

    protected void writeJsonResponse(HttpServletResponse response, String content) {
        this.writeJsonResponse(response, content, 200);
    }

    protected void writeJsonResponse(HttpServletResponse response, String content, int status) {
        this.writeResponse(response, content, MIME_TYPE_JSON, status);
    }

    protected void writeTextResponse(HttpServletResponse response, String content) {
        this.writeTextResponse(response, content, 200);
    }

    protected void writeTextResponse(HttpServletResponse response, String content, int status) {
        this.writeResponse(response, content, MIME_TYPE_TEXT, status);
    }

    protected void writeErrorResponse(HttpServletResponse response, Exception e) {
        LOG.log(Level.WARNING, "Error processing request", e);
        this.writeTextResponse(response, e.getMessage(), 500);
    }

    protected void writeErrorResponse(HttpServletResponse response, ChatException e) {
        LOG.log(Level.WARNING, "Error processing request", (Throwable)e);
        this.writeTextResponse(response, e.getMessage(), e.getStatus());
    }

    protected void writeErrorResponse(HttpServletResponse response, String message) {
        LOG.log(Level.FINE, "Error processing request: {}", message);
        this.writeTextResponse(response, message, 500);
    }

    protected void writeResponse(HttpServletResponse response, String content, String contentType, int status) {
        try {
            response.setDateHeader("Last-Modified", System.currentTimeMillis());
            response.setHeader("Cache-Control", "no-cache");
            response.setStatus(status);
            if (StringUtils.isNotBlank((CharSequence)contentType) && StringUtils.isNotBlank((CharSequence)content)) {
                response.setContentType(contentType);
                response.setCharacterEncoding(StandardCharsets.UTF_8.name());
                ServletOutputStream out = response.getOutputStream();
                out.write(content.getBytes());
                out.close();
            }
        }
        catch (IOException e) {
            throw new IllegalStateException("Error writing response", e);
        }
    }

    private boolean checkPassphrase(String passphrase) {
        boolean checkPP = false;
        if (PropertyManager.getProperty((String)"chatPassPhrase").equals(passphrase)) {
            checkPP = true;
        }
        if ("".equals(passphrase) || "chat".equals(passphrase)) {
            LOG.warning("ChatServer is not secured! Please change 'chatPassPhrase' property in " + PropertyManager.PROPERTIES_PATH);
        }
        return checkPP;
    }
}

