/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.chat.services.mongodb;

import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoCursor;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.model.Filters;
import java.util.ArrayList;
import java.util.List;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.lang3.StringUtils;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.exoplatform.chat.listener.ConnectionManager;
import org.exoplatform.chat.model.NotificationBean;
import org.exoplatform.chat.model.NotificationSettingsBean;
import org.exoplatform.chat.model.RoomBean;
import org.exoplatform.chat.services.NotificationDataStorage;
import org.exoplatform.chat.services.UserService;
import org.exoplatform.chat.utils.PropertyManager;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.json.JSONException;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

@Named(value="notificationStorage")
@ApplicationScoped
@Singleton
public class NotificationMongoDataStorage
implements NotificationDataStorage {
    private static final Log LOG = ExoLogger.getLogger(NotificationMongoDataStorage.class);
    public static final String TIMESTAMP = "timestamp";
    public static final String USER = "user";
    public static final String FROM = "from";
    public static final String TYPE = "type";
    public static final String CATEGORY = "category";
    public static final String CATEGORY_ID = "categoryId";
    public static final String CONTENT = "content";
    public static final String OPTIONS = "options";

    private MongoDatabase db() {
        return ConnectionManager.getInstance().getDB();
    }

    public static void cleanupNotifications() {
        MongoCollection coll = ConnectionManager.getInstance().getDB().getCollection("notifications");
        long daysToLive = 30L;
        String daysToLiveProp = PropertyManager.getProperty((String)"chat.notifications.days.toLive");
        if (!StringUtils.isBlank((CharSequence)daysToLiveProp)) {
            try {
                daysToLive = Long.parseLong(daysToLiveProp);
            }
            catch (NumberFormatException e) {
                LOG.warn((Object)"value set as chat notifications days to live is not a number, the default value will be used");
            }
        }
        Bson query = Filters.lt((String)TIMESTAMP, (Object)(System.currentTimeMillis() - 86400000L * daysToLive));
        coll.deleteMany(query);
    }

    @Override
    public void addNotification(String receiver, String sender, String type, String category, String categoryId, String content, String link) {
        this.addNotification(receiver, sender, type, category, categoryId, content, link, null);
    }

    @Override
    public void addNotification(String receiver, String sender, String type, String category, String categoryId, String content, String link, String options) {
        if (options != null && (options.contains("call-on") || options.contains("call-off") || options.contains("call-proceed"))) {
            return;
        }
        MongoCollection notificationsCollection = this.db().getCollection("notifications");
        Document doc = new Document();
        content = StringUtils.chomp((String)content);
        content = content.replace("&", "&#38");
        content = content.replace("<", "&lt;");
        content = content.replace(">", "&gt;");
        content = content.replace("\"", "&quot;");
        content = content.replace("\n", "<br/>");
        content = content.replace("\\\\", "&#92");
        content = content.replace("\t", "  ");
        doc.put(TIMESTAMP, (Object)System.currentTimeMillis());
        doc.put(USER, (Object)receiver);
        doc.put(FROM, (Object)sender);
        doc.put(TYPE, (Object)type);
        doc.put(CATEGORY, (Object)category);
        doc.put(CATEGORY_ID, (Object)categoryId);
        doc.put(CONTENT, (Object)content);
        if (options != null) {
            options = options.replace("<", "&lt;");
            options = options.replace(">", "&gt;");
            options = options.replace("'", "\\\\\"");
            doc.put(OPTIONS, (Object)options);
        }
        doc.put("link", (Object)link);
        doc.put("isRead", (Object)false);
        notificationsCollection.insertOne((Object)doc);
    }

    @Override
    public void setNotificationsAsRead(String user, String type, String category, String categoryId) {
        MongoCollection coll = this.db().getCollection("notifications");
        Bson query = this.buildQuery(user, type, category, categoryId);
        coll.deleteMany(query);
    }

    @Override
    public List<NotificationBean> getUnreadNotifications(String user, UserService userService) {
        return this.getUnreadNotifications(user, userService, null, null, null);
    }

    @Override
    public List<NotificationBean> getUnreadNotifications(String user, UserService userService, String type, String category, String categoryId) {
        List<NotificationBean> notifications = new ArrayList<NotificationBean>();
        try (MongoCursor<Document> cursor = this.find(user, type, category, categoryId);){
            while (cursor.hasNext()) {
                RoomBean roomBean;
                Document doc = (Document)cursor.next();
                NotificationBean notificationBean = new NotificationBean();
                notificationBean.setTimestamp((Long)doc.get((Object)TIMESTAMP));
                notificationBean.setUser(user);
                if (doc.containsKey((Object)FROM)) {
                    notificationBean.setFrom(doc.get((Object)FROM).toString());
                    notificationBean.setFromFullName(userService.getUser(notificationBean.getFrom()).getFullname());
                }
                notificationBean.setCategory(doc.get((Object)CATEGORY).toString());
                notificationBean.setCategoryId(doc.get((Object)CATEGORY_ID).toString());
                notificationBean.setType(doc.get((Object)TYPE).toString());
                notificationBean.setContent(doc.get((Object)CONTENT).toString());
                if (doc.containsKey((Object)OPTIONS)) {
                    notificationBean.setOptions(doc.get((Object)OPTIONS).toString());
                }
                if ((roomBean = userService.getRoom(user, notificationBean.getCategoryId())) != null) {
                    notificationBean.setRoomType(roomBean.getType());
                    if (roomBean.getType().equals("s") || roomBean.getType().equals("t")) {
                        notificationBean.setRoomDisplayName(roomBean.getFullName());
                    }
                }
                notificationBean.setLink(doc.get((Object)"link").toString());
                notifications.add(notificationBean);
            }
            notifications = this.filterNotifications(notifications, userService, user);
        }
        return notifications;
    }

    private List<NotificationBean> filterNotifications(List<NotificationBean> notifications, UserService userService, String receiver) {
        ArrayList<NotificationBean> notificationBeans;
        block4: {
            notificationBeans = new ArrayList<NotificationBean>();
            try {
                if (notifications == null || notifications.isEmpty()) break block4;
                NotificationSettingsBean settings = userService.getUserDesktopNotificationSettings(receiver);
                if (settings != null && settings.getEnabledRoomTriggers() != null) {
                    String bean = settings.getEnabledRoomTriggers();
                    JSONParser parser = new JSONParser();
                    JSONObject json = (JSONObject)parser.parse(bean);
                    for (NotificationBean notification : notifications) {
                        JSONObject roomSettings = (JSONObject)json.get((Object)notification.getCategoryId());
                        if (roomSettings != null && roomSettings.get((Object)"notifCond") != null && roomSettings.get((Object)"notifCond").equals("silence") && notification.getCategory().equals("room")) continue;
                        notificationBeans.add(notification);
                    }
                    break block4;
                }
                return notifications;
            }
            catch (JSONException | ParseException e) {
                LOG.error((Object)"error parsing chat notifications data", e);
            }
        }
        return notificationBeans;
    }

    @Override
    public int getUnreadNotificationsTotal(String user) {
        return this.getUnreadNotificationsTotal(user, null, null, null);
    }

    @Override
    public int getUnreadNotificationsTotal(String user, String type, String category, String categoryId) {
        try (MongoCursor<Document> cursor = this.find(user, type, category, categoryId);){
            int n = cursor.available();
            return n;
        }
    }

    @Override
    public int getNumberOfNotifications() {
        MongoCollection coll = this.db().getCollection("notifications");
        try (MongoCursor cursor = coll.find((Bson)new Document()).cursor();){
            int n = cursor.available();
            return n;
        }
    }

    @Override
    public int getNumberOfUnreadNotifications() {
        MongoCollection coll = this.db().getCollection("notifications");
        try (MongoCursor cursor = coll.find((Bson)new Document()).cursor();){
            int n = cursor.available();
            return n;
        }
    }

    private MongoCursor<Document> find(String user, String type, String category, String categoryId) {
        MongoCollection coll = this.db().getCollection("notifications");
        Bson query = this.buildQuery(user, type, category, categoryId);
        return coll.find(query).cursor();
    }

    private Bson buildQuery(String user, String type, String category, String categoryId) {
        Bson query = Filters.eq((String)USER, (Object)user);
        if (type != null) {
            query = Filters.and((Bson[])new Bson[]{query, Filters.eq((String)TYPE, (Object)type)});
        }
        if (category != null) {
            query = Filters.and((Bson[])new Bson[]{query, Filters.eq((String)CATEGORY, (Object)category)});
        }
        if (categoryId != null) {
            query = Filters.and((Bson[])new Bson[]{query, Filters.eq((String)CATEGORY_ID, (Object)categoryId)});
        }
        return query;
    }
}

