/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.addons.chat.api;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.security.RolesAllowed;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.CacheControl;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.addons.chat.listener.ServerBootstrap;
import org.exoplatform.addons.chat.utils.MessageDigester;
import org.exoplatform.chat.service.DocumentService;
import org.exoplatform.chat.utils.PropertyManager;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.rest.resource.ResourceContainer;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.user.UserStateService;
import org.exoplatform.ws.frameworks.cometd.ContinuationService;
import org.json.simple.JSONObject;

@Path(value="/chat/api/1.0/user/")
public class UserRestService
implements ResourceContainer {
    private static final String CHAT_USER_INITIALIZATION_ATTR = "exo.chat.user.initialized";
    public static final String ANONIM_USER = "__anonim_";
    protected static final String LAST_MODIFIED_PROPERTY = "Last-Modified";
    protected static final String IF_MODIFIED_SINCE_DATE_FORMAT = "EEE, dd MMM yyyy HH:mm:ss z";
    private DocumentService documentService;
    private OrganizationService organizationService;
    private ContinuationService continuationService;
    private UserStateService userStateService;

    public UserRestService(UserStateService userStateService, ContinuationService continuationService, OrganizationService organizationService, DocumentService documentService) {
        this.documentService = documentService;
        this.organizationService = organizationService;
        this.continuationService = continuationService;
        this.userStateService = userStateService;
    }

    @GET
    @Path(value="/token/")
    public Response getToken(@Context HttpServletRequest request, @QueryParam(value="tokenOnly") String tokenOnly) throws Exception {
        String token;
        boolean withTokenOnly;
        this.init(request);
        ConversationState conversationState = ConversationState.getCurrent();
        String userId = conversationState.getIdentity().getUserId();
        CacheControl cacheControl = new CacheControl();
        cacheControl.setNoCache(true);
        cacheControl.setNoStore(true);
        SimpleDateFormat dateFormat = new SimpleDateFormat(IF_MODIFIED_SINCE_DATE_FORMAT);
        boolean bl = withTokenOnly = tokenOnly != null && "true".equals(tokenOnly);
        if ("__anonim".equals(userId)) {
            userId = ANONIM_USER;
            token = "---";
        } else {
            String passphrase = PropertyManager.getProperty((String)"chatPassPhrase");
            String in = userId + passphrase;
            token = MessageDigester.getHash(in);
        }
        if (withTokenOnly) {
            return Response.ok((Object)token, (String)"text/plain").cacheControl(cacheControl).header(LAST_MODIFIED_PROPERTY, (Object)dateFormat.format(new Date())).build();
        }
        JSONObject data = new JSONObject();
        data.put((Object)"username", (Object)userId);
        data.put((Object)"token", (Object)token);
        return Response.ok((Object)data.toString(), (String)"application/json").cacheControl(cacheControl).header(LAST_MODIFIED_PROPERTY, (Object)dateFormat.format(new Date())).build();
    }

    @GET
    @Path(value="/cometdToken/")
    @RolesAllowed(value={"users"})
    public Response getCometdToken(@Context HttpServletRequest request) throws Exception {
        String token;
        this.init(request);
        ConversationState conversationState = ConversationState.getCurrent();
        String userId = conversationState.getIdentity().getUserId();
        Boolean standaloneChatServer = Boolean.valueOf(PropertyManager.getProperty((String)"standaloneChatServer"));
        if (standaloneChatServer.booleanValue()) {
            String passphrase = PropertyManager.getProperty((String)"chatPassPhrase");
            String in = userId + passphrase;
            token = MessageDigester.getHash(in);
        } else {
            token = this.continuationService.getUserToken(userId);
        }
        return Response.ok((Object)token, (String)"text/plain").build();
    }

    @GET
    @Path(value="/onlineStatus/")
    @RolesAllowed(value={"users"})
    public Response getOnlineStatus(@Context HttpServletRequest request, @QueryParam(value="users") String users) throws Exception {
        this.init(request);
        if (users != null) {
            String[] split = users.split(",");
            JSONObject data = new JSONObject();
            for (String u : split) {
                data.put((Object)u, (Object)this.userStateService.isOnline(u));
            }
            return Response.ok((Object)data.toString(), (String)"application/json").build();
        }
        return Response.serverError().status(400).build();
    }

    @GET
    @Path(value="/onlineUsers/")
    @RolesAllowed(value={"users"})
    public Response getOnlineUsers(@Context HttpServletRequest request) throws Exception {
        this.init(request);
        List list = this.userStateService.online().stream().map(u -> u.getUserId()).collect(Collectors.toList());
        String users = String.join((CharSequence)",", list);
        return Response.ok((Object)users, (String)"text/plain").build();
    }

    @GET
    @Path(value="/settings")
    @RolesAllowed(value={"users"})
    public Response getUserSettings(@Context HttpServletRequest request, @Context SecurityContext sc) throws Exception {
        this.init(request);
        String currentUsername = sc.getUserPrincipal().getName();
        String token = ServerBootstrap.getToken(currentUsername);
        String dbName = ServerBootstrap.getDBName();
        String userFullName = ServerBootstrap.getUserFullName(currentUsername, dbName);
        Boolean isUserInitialized = (Boolean)request.getSession().getAttribute(CHAT_USER_INITIALIZATION_ATTR);
        if (isUserInitialized == null || !isUserInitialized.booleanValue()) {
            User user;
            ServerBootstrap.addUser(currentUsername, token, dbName);
            if (StringUtils.isBlank((CharSequence)userFullName) && (user = this.organizationService.getUserHandler().findUserByName(currentUsername)) != null) {
                userFullName = user.getDisplayName();
                ServerBootstrap.addUserFullNameAndEmail(currentUsername, userFullName, user.getEmail(), dbName);
            }
            ServerBootstrap.saveSpaces(currentUsername, dbName);
            request.getSession().setAttribute(CHAT_USER_INITIALIZATION_ATTR, (Object)true);
        }
        boolean online = this.userStateService.isOnline(currentUsername);
        String cometdToken = this.continuationService.getUserToken(currentUsername);
        String isStandaloneString = PropertyManager.getProperty((String)"standaloneChatServer");
        boolean isStandalone = isStandaloneString != null && Boolean.valueOf(isStandaloneString) != false;
        String chatServerURI = ServerBootstrap.getServerURI();
        String chatPage = PropertyManager.getProperty((String)"chatPortalPage");
        String chatCometDServerUrl = null;
        chatCometDServerUrl = isStandalone ? chatServerURI + "/cometd" : "/cometd/cometd";
        String userStatus = ServerBootstrap.getStatus(currentUsername, token, currentUsername, dbName);
        JSONObject userSettings = new JSONObject();
        userSettings.put((Object)"username", (Object)currentUsername);
        userSettings.put((Object)"token", (Object)token);
        userSettings.put((Object)"fullName", (Object)userFullName);
        userSettings.put((Object)"status", (Object)userStatus);
        userSettings.put((Object)"isOnline", (Object)online);
        userSettings.put((Object)"cometdToken", (Object)cometdToken);
        userSettings.put((Object)"dbName", (Object)dbName);
        userSettings.put((Object)"sessionId", (Object)request.getSession().getId());
        userSettings.put((Object)"serverURL", (Object)ServerBootstrap.getServerURL());
        userSettings.put((Object)"standalone", (Object)isStandalone);
        userSettings.put((Object)"chatPage", (Object)chatPage);
        userSettings.put((Object)"offlineDelay", (Object)this.userStateService.getDelay());
        userSettings.put((Object)"wsEndpoint", (Object)chatCometDServerUrl);
        userSettings.put((Object)"maxUploadSize", (Object)this.documentService.getUploadLimitInMB());
        return Response.ok((Object)userSettings, (String)"application/json").build();
    }

    private void init(HttpServletRequest request) {
        ServerBootstrap.init(request);
    }
}

