/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.addons.chat.notification.plugin;

import org.apache.commons.lang.StringUtils;
import org.exoplatform.addons.chat.model.MentionModel;
import org.exoplatform.addons.chat.utils.NotificationUtils;
import org.exoplatform.commons.api.notification.NotificationContext;
import org.exoplatform.commons.api.notification.model.NotificationInfo;
import org.exoplatform.commons.api.notification.plugin.BaseNotificationPlugin;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.ValueParam;

public class ChatNotificationPlugin
extends BaseNotificationPlugin {
    public ChatNotificationPlugin(InitParams initParams) {
        super(initParams);
        ValueParam notificationIdParam = initParams.getValueParam("notification.id");
        if (notificationIdParam == null || StringUtils.isBlank((String)notificationIdParam.getValue())) {
            throw new IllegalStateException("'notification.id' parameter is mandatory");
        }
    }

    public String getId() {
        return "ChatMentionNotificationPlugin";
    }

    public boolean isValid(NotificationContext ctx) {
        return true;
    }

    public NotificationInfo makeNotification(NotificationContext ctx) {
        MentionModel mention = (MentionModel)ctx.value(NotificationUtils.MENTION_MODEL);
        NotificationInfo notification = NotificationInfo.instance();
        notification.key(this.getId());
        NotificationUtils.setNotificationRecipients(notification, mention.getMentionedUsers());
        if (notification.getSendToUserIds() == null || notification.getSendToUserIds().isEmpty()) {
            return null;
        }
        notification.with("roomId", String.valueOf(mention.getRoomId()));
        notification.with("sender", String.valueOf(mention.getSender()));
        notification.with("senderFullName", String.valueOf(mention.getSenderFullName()));
        notification.with("roomName", String.valueOf(mention.getRoomName()));
        notification.with("chatUrl", NotificationUtils.getRoomURL(mention.getRoomId()));
        notification.with("avatar", "/portal/rest/v1/social/users/{}/avatar".replace("{}", mention.getSender()));
        return notification;
    }
}

