/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.router.parser;

import juzu.impl.common.Location;
import juzu.impl.router.parser.RouteParserHandler;
import juzu.impl.router.regex.SyntaxException;

public class RouteParser {
    public static final int CODE_UNCLOSED_EXPR = 0;
    public static final int CODE_MISSING_EXPR_IDENT = 1;
    private static final int READ_PATH = 0;
    private static final int READ_SEGMENT = 1;
    private static final int READ_DONE = 7;
    private static final int EXPR_BEGIN = 0;
    private static final int EXPR_IDENT = 1;

    public static void parse(CharSequence s, RouteParserHandler handler) throws SyntaxException {
        RouteParser.parse(s, 0, s.length(), handler);
    }

    private static void parse(CharSequence s, int from, int to, RouteParserHandler handler) throws SyntaxException {
        int status = 0;
        int pos = 0;
        block5: while (true) {
            switch (status) {
                case 0: {
                    char c;
                    if (from < to) {
                        c = s.charAt(from);
                        if (c == '/') {
                            ++from;
                            continue block5;
                        }
                        handler.segmentOpen();
                        status = 1;
                        pos = from;
                        continue block5;
                    }
                    boolean slash = from > pos && s.charAt(from - 1) == '/';
                    handler.pathClose(slash);
                    status = 7;
                    continue block5;
                }
                case 1: {
                    char c;
                    if (from < to) {
                        c = s.charAt(from);
                        if (c == '{') {
                            if (from - pos > 0) {
                                handler.segmentChunk(s, pos, from);
                            }
                            handler.exprOpen();
                            from = pos = RouteParser.parseExpr(s, from + 1, to, handler);
                            handler.exprClose();
                            continue block5;
                        }
                        if (c == '/') {
                            status = 0;
                            if (from - pos > 0) {
                                handler.segmentChunk(s, pos, from);
                            }
                            handler.segmentClose();
                            continue block5;
                        }
                        ++from;
                        continue block5;
                    }
                    if (from - pos > 0) {
                        handler.segmentChunk(s, pos, from);
                    }
                    handler.segmentClose();
                    status = 0;
                    continue block5;
                }
                case 7: {
                    return;
                }
            }
            break;
        }
        throw new UnsupportedOperationException("Need to implement status " + status);
    }

    private static int parseExpr(CharSequence s, int from, int to, RouteParserHandler handler) throws SyntaxException {
        int status = 0;
        int pos = from;
        block4: while (true) {
            switch (status) {
                case 0: {
                    char c;
                    if (from < to) {
                        c = s.charAt(from);
                        if (c == '}') {
                            throw new SyntaxException(1, "Missing expression identifier at " + from, Location.at(1 + from));
                        }
                        status = 1;
                        continue block4;
                    }
                    throw new SyntaxException(0, "Unclosed expression at " + from, Location.at(1 + from));
                }
                case 1: {
                    char c;
                    if (from < to) {
                        c = s.charAt(from);
                        if (c == '}') {
                            handler.exprIdent(s, pos, from);
                            return ++from;
                        }
                        ++from;
                        continue block4;
                    }
                    throw new SyntaxException(0, "Unclosed expression at " + from, Location.at(1 + from));
                }
            }
            break;
        }
        throw new UnsupportedOperationException("todo");
    }
}

