/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.addons.chat.listener;

import org.exoplatform.addons.chat.listener.ServerBootstrap;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.Membership;
import org.exoplatform.services.organization.MembershipEventListener;

public class ExternalUserListener
extends MembershipEventListener {
    private static final Log LOG = ExoLogger.getLogger(ExternalUserListener.class);
    private static final String PLATFORM_EXTERNALS_GROUP = "/platform/externals";

    public void postSave(Membership m, boolean isNew) {
        if (m.getGroupId().equals(PLATFORM_EXTERNALS_GROUP)) {
            try {
                ServerBootstrap.setExternalUser(m.getUserName(), "true");
            }
            catch (Exception e) {
                LOG.error("Error while saving the external property for user  {}", new Object[]{m.getUserName(), e});
            }
        }
    }

    public void postDelete(Membership m) {
        if (m.getGroupId().equals(PLATFORM_EXTERNALS_GROUP)) {
            try {
                ServerBootstrap.setExternalUser(m.getUserName(), "false");
            }
            catch (Exception e) {
                LOG.error("Error while saving the external property for user  {}", new Object[]{m.getUserName(), e});
            }
        }
    }
}

