/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.addons.chat.api;

import jakarta.servlet.GenericServlet;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.commons.api.ui.ActionContext;
import org.exoplatform.commons.api.ui.PlugableUIService;
import org.exoplatform.commons.api.ui.Response;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.component.RequestLifeCycle;

public class ActionPluginServlet
extends GenericServlet {
    private static final long serialVersionUID = 1234812387123921L;
    public static final String CHAT_EXTENSION_POPUP = "chat_extension_popup";
    public static final String EX_ACTION_NAME = "extension_action";
    private PlugableUIService uiService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void service(ServletRequest req, ServletResponse res) throws ServletException, IOException {
        HttpServletRequest httpServletRequest = (HttpServletRequest)req;
        HttpServletResponse httpServletResponse = (HttpServletResponse)res;
        String remoteUser = httpServletRequest.getRemoteUser();
        if (StringUtils.isBlank((CharSequence)remoteUser)) {
            httpServletResponse.setStatus(404);
            return;
        }
        Map parameterMap = httpServletRequest.getParameterMap();
        HashMap parameterListMap = new HashMap();
        parameterMap.entrySet().forEach(parameterEntry -> parameterListMap.put((String)parameterEntry.getKey(), parameterEntry.getValue() == null ? Collections.emptyList() : Arrays.asList((String[])parameterEntry.getValue())));
        String actionName = httpServletRequest.getParameter(EX_ACTION_NAME);
        ActionContext actContext = new ActionContext(CHAT_EXTENSION_POPUP, actionName);
        actContext.setParams(parameterListMap);
        Response response = null;
        RequestLifeCycle.begin((ExoContainer)PortalContainer.getInstance());
        try {
            response = this.getUiService().processAction(actContext);
        }
        finally {
            RequestLifeCycle.end();
        }
        if (response != null) {
            ServletOutputStream outputStream = httpServletResponse.getOutputStream();
            outputStream.write(response.getData());
            outputStream.flush();
            outputStream.close();
        } else {
            httpServletResponse.setStatus(404);
        }
    }

    public PlugableUIService getUiService() {
        if (this.uiService == null) {
            this.uiService = (PlugableUIService)CommonsUtils.getService(PlugableUIService.class);
        }
        return this.uiService;
    }
}

