/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.janino.util;

import java.io.FilterReader;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;

public class TeeReader
extends FilterReader {
    private final Writer out;
    private final boolean closeWriterOnEOF;

    public TeeReader(Reader in, Writer out, boolean closeWriterOnEOF) {
        super(in);
        this.out = out;
        this.closeWriterOnEOF = closeWriterOnEOF;
    }

    public void close() throws IOException {
        this.in.close();
        this.out.close();
    }

    public int read() throws IOException {
        int c = this.in.read();
        if (c == -1) {
            if (this.closeWriterOnEOF) {
                this.out.close();
            } else {
                this.out.flush();
            }
        } else {
            this.out.write(c);
        }
        return c;
    }

    public int read(char[] cbuf, int off, int len) throws IOException {
        int bytesRead = this.in.read(cbuf, off, len);
        if (bytesRead == -1) {
            if (this.closeWriterOnEOF) {
                this.out.close();
            } else {
                this.out.flush();
            }
        } else {
            this.out.write(cbuf, off, bytesRead);
        }
        return bytesRead;
    }
}

