/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.janino.util.iterator;

import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Stack;
import org.codehaus.janino.util.iterator.EnumerationIterator;

public class TraversingIterator
implements Iterator {
    private final Stack nest = new Stack();
    private Object nextElement = null;
    private boolean nextElementRead = false;

    public TraversingIterator(Iterator delegate) {
        this.nest.push(delegate);
    }

    public boolean hasNext() {
        return this.nextElementRead || this.readNext();
    }

    public Object next() {
        if (!this.nextElementRead && !this.readNext()) {
            throw new NoSuchElementException();
        }
        this.nextElementRead = false;
        return this.nextElement;
    }

    private boolean readNext() {
        while (!this.nest.empty()) {
            Iterator it = (Iterator)this.nest.peek();
            if (!it.hasNext()) {
                this.nest.pop();
                continue;
            }
            Object o = it.next();
            if (o instanceof Iterator) {
                this.nest.push(o);
                continue;
            }
            if (o instanceof Object[]) {
                this.nest.push(Arrays.asList((Object[])o).iterator());
                continue;
            }
            if (o instanceof Collection) {
                this.nest.push(((Collection)o).iterator());
                continue;
            }
            if (o instanceof Enumeration) {
                this.nest.push(new EnumerationIterator((Enumeration)o));
                continue;
            }
            this.nextElement = o;
            this.nextElementRead = true;
            return true;
        }
        return false;
    }

    public void remove() {
        ((Iterator)this.nest.peek()).remove();
    }
}

