/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.janino.samples;

import java.io.FileReader;
import java.io.IOException;
import org.codehaus.commons.compiler.CompileException;
import org.codehaus.janino.Java;
import org.codehaus.janino.Parser;
import org.codehaus.janino.Scanner;
import org.codehaus.janino.util.Traverser;

public class DeclarationCounter
extends Traverser {
    private int classDeclarationCount = 0;
    private int interfaceDeclarationCount = 0;
    private int fieldCount = 0;
    private int localVariableCount = 0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws CompileException, IOException {
        DeclarationCounter dc = new DeclarationCounter();
        for (int i = 0; i < args.length; ++i) {
            Java.CompilationUnit cu;
            String fileName = args[i];
            FileReader r = new FileReader(fileName);
            try {
                cu = new Parser(new Scanner(fileName, r)).parseCompilationUnit();
            }
            finally {
                r.close();
            }
            dc.traverseCompilationUnit(cu);
        }
        System.out.println("Class declarations:     " + dc.classDeclarationCount);
        System.out.println("Interface declarations: " + dc.interfaceDeclarationCount);
        System.out.println("Fields:                 " + dc.fieldCount);
        System.out.println("Local variables:        " + dc.localVariableCount);
    }

    public void traverseClassDeclaration(Java.ClassDeclaration cd) {
        ++this.classDeclarationCount;
        super.traverseClassDeclaration(cd);
    }

    public void traverseInterfaceDeclaration(Java.InterfaceDeclaration id) {
        ++this.interfaceDeclarationCount;
        super.traverseInterfaceDeclaration(id);
    }

    public void traverseFieldDeclaration(Java.FieldDeclaration fd) {
        this.fieldCount += fd.variableDeclarators.length;
        super.traverseFieldDeclaration(fd);
    }

    public void traverseLocalVariableDeclarationStatement(Java.LocalVariableDeclarationStatement lvds) {
        this.localVariableCount += lvds.variableDeclarators.length;
        super.traverseLocalVariableDeclarationStatement(lvds);
    }
}

