/*
 * Decompiled with CFR 0.152.
 */
package org.benjp.server;

import java.util.ArrayList;
import java.util.Random;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import juzu.Resource;
import juzu.Response;
import juzu.Route;
import org.benjp.listener.ConnectionManager;
import org.benjp.model.SpaceBean;
import org.benjp.services.NotificationService;
import org.benjp.services.TokenService;
import org.benjp.services.UserService;
import org.benjp.utils.PropertyManager;

@ApplicationScoped
public class ChatTools {
    @Inject
    UserService userService;
    @Inject
    TokenService tokenService;
    @Inject
    NotificationService notificationService;

    @Resource
    @Route(value="/createDemoUser")
    public Response.Content createDemoUser(String username, String passphrase) {
        if (!PropertyManager.getProperty("chatPassPhrase").equals(passphrase)) {
            return Response.notFound((CharSequence)"{ \"message\": \"passphrase doesn't match\"}");
        }
        if (username == null) {
            return Response.notFound((CharSequence)"{ \"message\": \"username is null\"}");
        }
        String token = this.tokenService.getToken(username);
        this.tokenService.addUser(username, token);
        this.userService.addUserFullName(username, username);
        this.userService.setAsAdmin(username, false);
        StringBuffer data = new StringBuffer();
        data.append("{");
        data.append(" \"message\": \"OK\", ");
        data.append(" \"token\": \"" + token + "\", ");
        data.append(" \"user\": \"" + username + "\" ");
        data.append("}");
        return Response.ok((CharSequence)data.toString()).withMimeType("text/event-stream; charset=UTF-8").withHeader("Cache-Control", new String[]{"no-cache"});
    }

    @Resource
    @Route(value="/createDemoSpaces")
    public Response.Content createDemoSpaces(String username, String nbSpaces, String nbSpacesMax, String passphrase) {
        if (!PropertyManager.getProperty("chatPassPhrase").equals(passphrase)) {
            return Response.notFound((CharSequence)"{ \"message\": \"passphrase doesn't match\"}");
        }
        if (username == null) {
            return Response.notFound((CharSequence)"{ \"message\": \"username is null\"}");
        }
        int nbSpacesInt = new Integer(nbSpaces);
        int nbSpacesMaxInt = new Integer(nbSpacesMax);
        if (nbSpacesInt < 1) {
            return Response.notFound((CharSequence)"{ \"message\": \"you must create at least one space\"}");
        }
        if (nbSpacesMaxInt < nbSpacesInt) {
            return Response.notFound((CharSequence)"{ \"message\": \"max spaces must be greater than spaces per user\"}");
        }
        String spacePrefix = "demo-";
        Random random = new Random(System.currentTimeMillis());
        ArrayList<SpaceBean> beans = new ArrayList<SpaceBean>();
        for (int i = 0; i < nbSpacesInt; ++i) {
            int spaceNum = random.nextInt(nbSpacesMaxInt);
            SpaceBean spaceBean = new SpaceBean();
            spaceBean.setDisplayName("Demo Space " + spaceNum);
            spaceBean.setGroupId("/spaces/" + spacePrefix + spaceNum);
            spaceBean.setId(spacePrefix + spaceNum);
            spaceBean.setShortName("Demo Space " + spaceNum);
            beans.add(spaceBean);
        }
        this.userService.setSpaces(username, beans);
        StringBuffer data = new StringBuffer();
        data.append("{");
        data.append(" \"message\": \"OK\", ");
        data.append(" \"user\": \"" + username + "\" ");
        data.append("}");
        return Response.ok((CharSequence)data.toString()).withMimeType("text/event-stream; charset=UTF-8").withHeader("Cache-Control", new String[]{"no-cache"});
    }

    @Resource
    @Route(value="/getToken")
    public Response.Content getToken(String username, String passphrase) {
        if (!PropertyManager.getProperty("chatPassPhrase").equals(passphrase)) {
            return Response.notFound((CharSequence)"{ \"message\": \"passphrase doesn't match\"}");
        }
        if (username == null) {
            return Response.notFound((CharSequence)"{ \"message\": \"username is null\"}");
        }
        String token = this.tokenService.getToken(username);
        StringBuffer data = new StringBuffer();
        data.append("{");
        data.append(" \"message\": \"OK\", ");
        data.append(" \"token\": \"" + token + "\", ");
        data.append(" \"user\": \"" + username + "\" ");
        data.append("}");
        return Response.ok((CharSequence)data.toString()).withMimeType("text/event-stream; charset=UTF-8").withHeader("Cache-Control", new String[]{"no-cache"});
    }

    @Resource
    @Route(value="/updateUnreadTestMessages")
    public Response.Content updateUnreadTestMessages(String username, String room, String passphrase) {
        if (!PropertyManager.getProperty("chatPassPhrase").equals(passphrase)) {
            return Response.notFound((CharSequence)"{ \"message\": \"passphrase doesn't match\"}");
        }
        if (username == null) {
            return Response.notFound((CharSequence)"{ \"message\": \"username is null\"}");
        }
        if (room == null) {
            return Response.notFound((CharSequence)"{ \"message\": \"room is null\"}");
        }
        if (username.startsWith("space-")) {
            return Response.ok((CharSequence)"OK").withMimeType("text/event-stream; charset=UTF-8").withHeader("Cache-Control", new String[]{"no-cache"});
        }
        if (!room.equals("ALL")) {
            this.notificationService.setNotificationsAsRead(username, "chat", "room", room);
        } else {
            this.notificationService.setNotificationsAsRead(username, null, null, null);
        }
        return Response.ok((CharSequence)"OK").withMimeType("text/event-stream; charset=UTF-8").withHeader("Cache-Control", new String[]{"no-cache"});
    }

    @Resource
    @Route(value="/initDB")
    public Response.Content initDB(String db, String passphrase) {
        if (!PropertyManager.getProperty("chatPassPhrase").equals(passphrase)) {
            return Response.notFound((CharSequence)"{ \"message\": \"passphrase doesn't match\"}");
        }
        if (db == null) {
            return Response.notFound((CharSequence)"{ \"message\": \"db is null\"}");
        }
        ConnectionManager.getInstance().getDB(db);
        StringBuffer data = new StringBuffer();
        data.append("{");
        data.append(" \"message\": \"using db=" + db + "\"");
        data.append("}");
        return Response.ok((CharSequence)data.toString()).withMimeType("text/event-stream; charset=UTF-8").withHeader("Cache-Control", new String[]{"no-cache"});
    }

    @Resource
    @Route(value="/dropDB")
    public Response.Content dropDB(String db, String passphrase) {
        if (!PropertyManager.getProperty("chatPassPhrase").equals(passphrase)) {
            return Response.notFound((CharSequence)"{ \"message\": \"passphrase doesn't match\"}");
        }
        if (db == null) {
            return Response.notFound((CharSequence)"{ \"message\": \"db is null\"}");
        }
        ConnectionManager.getInstance().dropDB(db);
        StringBuffer data = new StringBuffer();
        data.append("{");
        data.append(" \"message\": \"deleting db=" + db + "\"");
        data.append("}");
        return Response.ok((CharSequence)data.toString()).withMimeType("text/event-stream; charset=UTF-8").withHeader("Cache-Control", new String[]{"no-cache"});
    }

    @Resource
    @Route(value="/ensureIndexes")
    public Response.Content ensureIndexes(String db, String passphrase) {
        if (!PropertyManager.getProperty("chatPassPhrase").equals(passphrase)) {
            return Response.notFound((CharSequence)"{ \"message\": \"passphrase doesn't match\"}");
        }
        if (db == null) {
            return Response.notFound((CharSequence)"{ \"message\": \"db is null\"}");
        }
        if (!db.equals(ConnectionManager.getInstance().getDB().getName())) {
            return Response.notFound((CharSequence)"{ \"message\": \"db name doesn't match\"}");
        }
        ConnectionManager.getInstance().ensureIndexes();
        StringBuffer data = new StringBuffer();
        data.append("{");
        data.append(" \"message\": \"indexes created or updated on db=" + db + "\"");
        data.append("}");
        return Response.ok((CharSequence)data.toString()).withMimeType("text/event-stream; charset=UTF-8").withHeader("Cache-Control", new String[]{"no-cache"});
    }
}

