/*
 * Decompiled with CFR 0.152.
 */
package org.benjp.services;

import com.mongodb.BasicDBObject;
import com.mongodb.DB;
import com.mongodb.DBCollection;
import com.mongodb.DBCursor;
import com.mongodb.DBObject;
import com.mongodb.WriteConcern;
import java.util.ArrayList;
import java.util.List;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Named;
import org.benjp.listener.ConnectionManager;
import org.benjp.model.SpaceBean;
import org.benjp.model.UserBean;

@Named(value="userService")
@ApplicationScoped
public class UserService {
    public static final String M_USERS_COLLECTION = "users";
    public static final String M_SPACES_COLLECTION = "spaces";
    public static final String STATUS_AVAILABLE = "available";
    public static final String STATUS_DONOTDISTURB = "donotdisturb";
    public static final String STATUS_AWAY = "away";
    public static final String STATUS_INVISIBLE = "invisible";
    public static final String STATUS_OFFLINE = "offline";
    public static final String STATUS_NONE = "none";
    public static final String STATUS_SPACE = "space";
    public static final String ANONIM_USER = "__anonim_";
    public static final String SUPPORT_USER = "__support_";

    private DB db() {
        return ConnectionManager.getInstance().getDB();
    }

    public void toggleFavorite(String user, String targetUser) {
        DBCollection coll = this.db().getCollection(M_USERS_COLLECTION);
        BasicDBObject query = new BasicDBObject();
        query.put("user", (Object)user);
        DBCursor cursor = coll.find((DBObject)query);
        if (cursor.hasNext()) {
            DBObject doc = cursor.next();
            List<String> favorites = new ArrayList();
            if (doc.containsField("favorites")) {
                favorites = (List)doc.get("favorites");
            }
            if (favorites.contains(targetUser)) {
                favorites.remove(targetUser);
            } else {
                favorites.add(targetUser);
            }
            doc.put("favorites", favorites);
            coll.save(doc, WriteConcern.SAFE);
        }
    }

    public boolean isFavorite(String user, String targetUser) {
        List favorites;
        DBObject doc;
        DBCollection coll = this.db().getCollection(M_USERS_COLLECTION);
        BasicDBObject query = new BasicDBObject();
        query.put("user", (Object)user);
        DBCursor cursor = coll.find((DBObject)query);
        return cursor.hasNext() && (doc = cursor.next()).containsField("favorites") && (favorites = (List)doc.get("favorites")).contains(targetUser);
    }

    public void addUserFullName(String user, String fullname) {
        DBCollection coll = this.db().getCollection(M_USERS_COLLECTION);
        BasicDBObject query = new BasicDBObject();
        query.put("user", (Object)user);
        DBCursor cursor = coll.find((DBObject)query);
        if (!cursor.hasNext()) {
            BasicDBObject doc = new BasicDBObject();
            doc.put("_id", (Object)user);
            doc.put("user", (Object)user);
            doc.put("fullname", (Object)fullname);
            coll.insert(new DBObject[]{doc});
        } else {
            DBObject doc = cursor.next();
            doc.put("fullname", (Object)fullname);
            coll.save(doc);
        }
    }

    public void addUserEmail(String user, String email) {
        DBCollection coll = this.db().getCollection(M_USERS_COLLECTION);
        BasicDBObject query = new BasicDBObject();
        query.put("user", (Object)user);
        DBCursor cursor = coll.find((DBObject)query);
        if (!cursor.hasNext()) {
            BasicDBObject doc = new BasicDBObject();
            doc.put("_id", (Object)user);
            doc.put("user", (Object)user);
            doc.put("email", (Object)email);
            coll.insert(new DBObject[]{doc});
        } else {
            DBObject doc = cursor.next();
            doc.put("email", (Object)email);
            coll.save(doc);
        }
    }

    public void setSpaces(String user, List<SpaceBean> spaces) {
        DBObject doc;
        ArrayList<String> spaceIds = new ArrayList<String>();
        DBCollection coll = this.db().getCollection(M_SPACES_COLLECTION);
        for (SpaceBean bean : spaces) {
            DBObject doc2;
            spaceIds.add(bean.getId());
            BasicDBObject query = new BasicDBObject();
            query.put("_id", (Object)bean.getId());
            DBCursor cursor = coll.find((DBObject)query);
            if (!cursor.hasNext()) {
                doc2 = new BasicDBObject();
                doc2.put("_id", (Object)bean.getId());
                doc2.put("displayName", (Object)bean.getDisplayName());
                doc2.put("groupId", (Object)bean.getGroupId());
                doc2.put("shortName", (Object)bean.getShortName());
                coll.insert(new DBObject[]{doc2});
                continue;
            }
            doc2 = cursor.next();
            String displayName = doc2.get("displayName").toString();
            if (bean.getDisplayName().equals(displayName)) continue;
            doc2.put("_id", (Object)bean.getId());
            doc2.put("displayName", (Object)bean.getDisplayName());
            doc2.put("groupId", (Object)bean.getGroupId());
            doc2.put("shortName", (Object)bean.getShortName());
            coll.save(doc2);
        }
        coll = this.db().getCollection(M_USERS_COLLECTION);
        BasicDBObject query = new BasicDBObject();
        query.put("user", (Object)user);
        DBCursor cursor = coll.find((DBObject)query);
        if (cursor.hasNext()) {
            doc = cursor.next();
            doc.put(M_SPACES_COLLECTION, spaceIds);
            coll.save(doc, WriteConcern.SAFE);
        } else {
            doc = new BasicDBObject();
            doc.put("_id", (Object)user);
            doc.put("user", (Object)user);
            doc.put(M_SPACES_COLLECTION, spaceIds);
            coll.insert(new DBObject[]{doc});
        }
    }

    private SpaceBean getSpace(String spaceId) {
        SpaceBean spaceBean = null;
        DBCollection coll = this.db().getCollection(M_SPACES_COLLECTION);
        BasicDBObject query = new BasicDBObject();
        query.put("_id", (Object)spaceId);
        DBCursor cursor = coll.find((DBObject)query);
        if (cursor.hasNext()) {
            DBObject doc = cursor.next();
            spaceBean = new SpaceBean();
            spaceBean.setId(spaceId);
            spaceBean.setDisplayName(doc.get("displayName").toString());
            spaceBean.setGroupId(doc.get("groupId").toString());
            spaceBean.setShortName(doc.get("shortName").toString());
            if (doc.containsField("timestamp")) {
                spaceBean.setTimestamp((Long)doc.get("timestamp"));
            }
        }
        return spaceBean;
    }

    public List<SpaceBean> getSpaces(String user) {
        DBObject doc;
        List listspaces;
        ArrayList<SpaceBean> spaces = new ArrayList<SpaceBean>();
        DBCollection coll = this.db().getCollection(M_USERS_COLLECTION);
        BasicDBObject query = new BasicDBObject();
        query.put("user", (Object)user);
        DBCursor cursor = coll.find((DBObject)query);
        if (cursor.hasNext() && (listspaces = (List)(doc = cursor.next()).get(M_SPACES_COLLECTION)) != null) {
            for (String space : listspaces) {
                spaces.add(this.getSpace(space));
            }
        }
        return spaces;
    }

    public List<UserBean> getUsers(String spaceId) {
        if (spaceId.indexOf("space-") > -1) {
            spaceId = spaceId.substring(6);
        }
        ArrayList<UserBean> users2 = new ArrayList<UserBean>();
        DBCollection coll = this.db().getCollection(M_USERS_COLLECTION);
        BasicDBObject query = new BasicDBObject();
        query.put(M_SPACES_COLLECTION, (Object)spaceId);
        DBCursor cursor = coll.find((DBObject)query);
        while (cursor.hasNext()) {
            DBObject doc = cursor.next();
            UserBean userBean = new UserBean();
            userBean.setName(doc.get("user").toString());
            Object prop = doc.get("fullname");
            userBean.setFullname(prop != null ? prop.toString() : "");
            prop = doc.get("email");
            userBean.setEmail(prop != null ? prop.toString() : "");
            prop = doc.get("status");
            userBean.setStatus(prop != null ? prop.toString() : "");
            users2.add(userBean);
        }
        return users2;
    }

    public String setStatus(String user, String status) {
        DBCollection coll = this.db().getCollection(M_USERS_COLLECTION);
        BasicDBObject query = new BasicDBObject();
        query.put("user", (Object)user);
        DBCursor cursor = coll.find((DBObject)query);
        if (cursor.hasNext()) {
            DBObject doc = cursor.next();
            doc.put("status", (Object)status);
            coll.save(doc, WriteConcern.SAFE);
        } else {
            BasicDBObject doc = new BasicDBObject();
            doc.put("_id", (Object)user);
            doc.put("user", (Object)user);
            doc.put("status", (Object)status);
            coll.insert(new DBObject[]{doc});
        }
        return status;
    }

    public void setAsAdmin(String user, boolean isAdmin) {
        DBCollection coll = this.db().getCollection(M_USERS_COLLECTION);
        BasicDBObject query = new BasicDBObject();
        query.put("user", (Object)user);
        DBCursor cursor = coll.find((DBObject)query);
        if (cursor.hasNext()) {
            DBObject doc = cursor.next();
            doc.put("isSupportAdmin", (Object)isAdmin);
            coll.save(doc, WriteConcern.SAFE);
        } else {
            BasicDBObject doc = new BasicDBObject();
            doc.put("_id", (Object)user);
            doc.put("user", (Object)user);
            doc.put("isSupportAdmin", (Object)isAdmin);
            coll.insert(new DBObject[]{doc});
        }
    }

    public boolean isAdmin(String user) {
        DBCollection coll = this.db().getCollection(M_USERS_COLLECTION);
        BasicDBObject query = new BasicDBObject();
        query.put("user", (Object)user);
        DBCursor cursor = coll.find((DBObject)query);
        if (cursor.hasNext()) {
            DBObject doc = cursor.next();
            Object isAdmin = doc.get("isSupportAdmin");
            return isAdmin != null && "true".equals(isAdmin.toString());
        }
        return false;
    }

    public String getStatus(String user) {
        DBObject doc;
        String status = STATUS_NONE;
        DBCollection coll = this.db().getCollection(M_USERS_COLLECTION);
        BasicDBObject query = new BasicDBObject();
        query.put("user", (Object)user);
        DBCursor cursor = coll.find((DBObject)query);
        status = cursor.hasNext() ? ((doc = cursor.next()).containsField("status") ? doc.get("status").toString() : this.setStatus(user, STATUS_AVAILABLE)) : this.setStatus(user, STATUS_AVAILABLE);
        return status;
    }

    public String getUserFullName(String user) {
        DBObject doc;
        String fullname = null;
        DBCollection coll = this.db().getCollection(M_USERS_COLLECTION);
        BasicDBObject query = new BasicDBObject();
        query.put("user", (Object)user);
        DBCursor cursor = coll.find((DBObject)query);
        if (cursor.hasNext() && (doc = cursor.next()).get("fullname") != null) {
            fullname = doc.get("fullname").toString();
        }
        return fullname;
    }

    public UserBean getUser(String user) {
        return this.getUser(user, false);
    }

    public UserBean getUser(String user, boolean withFavorites) {
        UserBean userBean = new UserBean();
        DBCollection coll = this.db().getCollection(M_USERS_COLLECTION);
        BasicDBObject query = new BasicDBObject();
        query.put("user", (Object)user);
        DBCursor cursor = coll.find((DBObject)query);
        if (cursor.hasNext()) {
            DBObject doc = cursor.next();
            userBean.setName(user);
            if (doc.get("fullname") != null) {
                userBean.setFullname(doc.get("fullname").toString());
            }
            if (doc.get("email") != null) {
                userBean.setEmail(doc.get("email").toString());
            }
            if (doc.get("status") != null) {
                userBean.setStatus(doc.get("status").toString());
            }
            if (withFavorites && doc.containsField("favorites")) {
                userBean.setFavorites((List)doc.get("favorites"));
            }
        }
        return userBean;
    }

    public List<String> getUsersFilterBy(String user, String space) {
        ArrayList<String> users2 = new ArrayList<String>();
        DBCollection coll = this.db().getCollection(M_USERS_COLLECTION);
        BasicDBObject query = new BasicDBObject();
        query.put(M_SPACES_COLLECTION, (Object)space);
        DBCursor cursor = coll.find((DBObject)query);
        while (cursor.hasNext()) {
            DBObject doc = cursor.next();
            String target = doc.get("user").toString();
            if (user.equals(target)) continue;
            users2.add(target);
        }
        return users2;
    }

    public int getNumberOfUsers() {
        DBCollection coll = this.db().getCollection(M_USERS_COLLECTION);
        BasicDBObject query = new BasicDBObject();
        DBCursor cursor = coll.find((DBObject)query);
        return cursor.count();
    }
}

