/*
 * Decompiled with CFR 0.152.
 */
package org.benjp.listener;

import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import java.util.logging.Logger;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.benjp.services.jcr.JCRModule;
import org.benjp.services.mongodb.MongoModule;
import org.benjp.utils.PropertyManager;

public class GuiceManager
implements ServletContextListener {
    private static Logger log = Logger.getLogger("GuiceManager");
    private static Injector injector_;

    public void contextInitialized(ServletContextEvent servletContextEvent) {
        log.info("INITIALIZING GUICE");
        GuiceManager.forceNew();
    }

    public void contextDestroyed(ServletContextEvent servletContextEvent) {
        log.info("CLOSING GUICE");
    }

    public static Injector getInstance() {
        return injector_;
    }

    public static void forceNew() {
        if (injector_ == null) {
            injector_ = "mongo".equals(PropertyManager.getProperty("servicesImplementation")) ? Guice.createInjector((Module[])new Module[]{new MongoModule()}) : Guice.createInjector((Module[])new Module[]{new JCRModule()});
        }
    }
}

