/*
 * Decompiled with CFR 0.152.
 */
package org.benjp.services.jcr;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Logger;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import org.apache.commons.lang3.StringUtils;
import org.benjp.model.RoomBean;
import org.benjp.model.RoomsBean;
import org.benjp.model.SpaceBean;
import org.benjp.model.UserBean;
import org.benjp.services.ChatService;
import org.benjp.services.NotificationService;
import org.benjp.services.TokenService;
import org.benjp.services.UserService;
import org.benjp.services.jcr.AbstractJCRService;
import org.benjp.services.jcr.JCRBootstrap;
import org.benjp.utils.ChatUtils;
import org.benjp.utils.PropertyManager;
import org.exoplatform.services.jcr.impl.core.query.QueryImpl;
import org.exoplatform.services.jcr.util.IdGenerator;

public class ChatServiceImpl
extends AbstractJCRService
implements ChatService {
    private static Logger log = Logger.getLogger("ChatService");
    private long readMillis;
    private int readTotalJson;
    private int readTotalTxt;

    public ChatServiceImpl() {
        long readDays = Long.parseLong(PropertyManager.getProperty("chatReadDays"));
        this.readMillis = readDays * 24L * 60L * 60L * 1000L;
        this.readTotalJson = Integer.parseInt(PropertyManager.getProperty("chatReadTotalJson"));
        this.readTotalTxt = Integer.parseInt(PropertyManager.getProperty("chatReadTotalTxt"));
    }

    @Override
    public void write(String message, String user, String room, String isSystem) {
        this.write(message, user, room, isSystem, null);
    }

    @Override
    public void write(String message, String user, String room, String isSystem, String options) {
        message = StringUtils.chomp((String)message);
        message = message.replaceAll("&", "&#38");
        message = message.replaceAll("<", "&lt;");
        message = message.replaceAll(">", "&gt;");
        message = message.replaceAll("\"", "&quot;");
        message = message.replaceAll("\n", "<br/>");
        message = message.replaceAll("\\\\", "&#92");
        message = message.replaceAll("\t", "  ");
        if (options != null) {
            options = options.replaceAll("<", "&lt;");
            options = options.replaceAll(">", "&gt;");
        }
        try {
            Session session = JCRBootstrap.getSession();
            Node roomNode = this.getRoom(room, session);
            String id = IdGenerator.generate();
            Node messageNode = roomNode.addNode(id, "chat:message");
            messageNode.setProperty("chat:user", user);
            messageNode.setProperty("chat:message", message);
            messageNode.setProperty("chat:time", Calendar.getInstance());
            messageNode.setProperty("chat:timestamp", System.currentTimeMillis());
            messageNode.setProperty("chat:issystem", isSystem);
            if (options != null) {
                messageNode.setProperty("chat:option", options);
            }
            session.save();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.updateRoomTimestamp(room);
    }

    @Override
    public void delete(String room, String user, String messageId) {
        try {
            String msgUser;
            Node messageNode;
            Session session = JCRBootstrap.getSession();
            Node roomNode = this.getRoom(room, session);
            if (roomNode.hasNode(messageId) && (messageNode = roomNode.getNode(messageId)).hasProperty("chat:user") && (msgUser = messageNode.getProperty("chat:user").getString()).equals(user)) {
                messageNode.setProperty("chat:message", "DELETED");
                messageNode.setProperty("chat:type", "DELETED");
                messageNode.save();
                session.save();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void edit(String room, String user, String messageId, String message) {
        message = StringUtils.chomp((String)message);
        message = message.replaceAll("&", "&#38");
        message = message.replaceAll("<", "&lt;");
        message = message.replaceAll(">", "&gt;");
        message = message.replaceAll("\"", "&quot;");
        message = message.replaceAll("\n", "<br/>");
        message = message.replaceAll("\\\\", "&#92");
        try {
            String msgUser;
            Node messageNode;
            Session session = JCRBootstrap.getSession();
            Node roomNode = this.getRoom(room, session);
            if (roomNode.hasNode(messageId) && (messageNode = roomNode.getNode(messageId)).hasProperty("chat:user") && (msgUser = messageNode.getProperty("chat:user").getString()).equals(user)) {
                messageNode.setProperty("chat:message", message);
                messageNode.setProperty("chat:type", "EDITED");
                messageNode.save();
                session.save();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public String read(String room, UserService userService) {
        return this.read(room, userService, false, null, null);
    }

    @Override
    public String read(String room, UserService userService, boolean isTextOnly, Long fromTimestamp) {
        return this.read(room, userService, isTextOnly, fromTimestamp, null);
    }

    @Override
    public String read(String room, UserService userService, boolean isTextOnly, Long fromTimestamp, Long toTimestamp) {
        StringBuilder sb;
        block25: {
            sb = new StringBuilder();
            SimpleDateFormat formatter = new SimpleDateFormat("hh:mm aaa");
            SimpleDateFormat formatterDate = new SimpleDateFormat("dd/MM/yyyy hh:mm aaa");
            Calendar calendar = Calendar.getInstance();
            calendar.set(10, 0);
            calendar.set(12, 0);
            calendar.set(13, 0);
            Date today = calendar.getTime();
            try {
                Session session = JCRBootstrap.getSession();
                QueryManager manager = session.getWorkspace().getQueryManager();
                long from = fromTimestamp != null ? fromTimestamp : System.currentTimeMillis() - this.readMillis;
                StringBuilder statement = new StringBuilder();
                statement.append("SELECT * FROM ").append("chat:message").append(" WHERE ");
                statement.append(" jcr:path like '/chat/rooms/").append(room).append("/%' ");
                statement.append(" AND NOT jcr:path like '/chat/rooms/").append(room).append("/%/%' ");
                statement.append(" AND ").append("chat:timestamp").append(" > ").append(from);
                if (toTimestamp != null) {
                    statement.append(" AND ").append("chat:timestamp").append(" < ").append(toTimestamp);
                }
                statement.append(" ORDER BY chat:timestamp DESC");
                Query query = manager.createQuery(statement.toString(), "sql");
                int limit = isTextOnly ? this.readTotalTxt : this.readTotalJson;
                ((QueryImpl)query).setLimit((long)limit);
                NodeIterator nodeIterator = query.execute().getNodes();
                if (nodeIterator.getSize() == 0L) {
                    if (isTextOnly) {
                        sb.append("no messages");
                    } else {
                        sb.append("{\"messages\": []}");
                    }
                    break block25;
                }
                HashMap<String, UserBean> users2 = new HashMap<String, UserBean>();
                boolean first = true;
                while (nodeIterator.hasNext()) {
                    Node msg = nodeIterator.nextNode();
                    String timestamp = msg.getProperty("chat:timestamp").getString();
                    if (first && !isTextOnly) {
                        sb.append("{\"room\": \"").append(room).append("\",");
                        sb.append("\"timestamp\": \"").append(timestamp).append("\",");
                        sb.append("\"messages\": [");
                    }
                    String user = msg.getProperty("chat:user").getString();
                    String msgId = msg.getName();
                    UserBean userBean = (UserBean)users2.get(user);
                    if (userBean == null) {
                        userBean = userService.getUser(user);
                        users2.put(user, userBean);
                    }
                    String fullname = userBean.getFullname();
                    String email = userBean.getEmail();
                    String date = "";
                    try {
                        if (msg.hasProperty("chat:time")) {
                            Date date1 = msg.getProperty("chat:time").getDate().getTime();
                            date = date1.before(today) || isTextOnly ? formatterDate.format(date1) : formatter.format(date1);
                        }
                    }
                    catch (Exception e) {
                        log.info("Message Date Format Error : " + e.getMessage());
                    }
                    if (isTextOnly) {
                        StringBuilder line = new StringBuilder();
                        line.append("[").append(date).append("] ");
                        String message = msg.getProperty("chat:message").getString();
                        if ("DELETED".equals(message)) {
                            message = "DELETED";
                        }
                        if (msg.hasProperty("chat:issystem") && msg.getProperty("chat:issystem").getBoolean()) {
                            line.append("System Message: ");
                            if (message.endsWith("<br/>")) {
                                message = message.substring(0, message.length() - 5);
                            }
                            line.append(message).append("\n");
                        } else {
                            line.append(fullname).append(": ");
                            message = message.replaceAll("<br/>", "\n");
                            line.append(message).append("\n");
                        }
                        sb.insert(0, line);
                    } else {
                        if (!first) {
                            sb.append(",");
                        }
                        sb.append("{\"id\": \"").append(msgId).append("\",");
                        sb.append("\"timestamp\": ").append(timestamp).append(",");
                        sb.append("\"user\": \"").append(user).append("\",");
                        sb.append("\"fullname\": \"").append(fullname).append("\",");
                        sb.append("\"email\": \"").append(email).append("\",");
                        sb.append("\"date\": \"").append(date).append("\",");
                        if (msg.hasProperty("chat:option")) {
                            String options = msg.getProperty("chat:option").getString();
                            if (options.startsWith("{")) {
                                sb.append("\"options\": ").append(options).append(",");
                            } else {
                                sb.append("\"options\": \"").append(options).append("\",");
                            }
                        } else {
                            sb.append("\"options\": \"\",");
                        }
                        if (msg.hasProperty("chat:type")) {
                            sb.append("\"type\": \"").append(msg.getProperty("chat:type").getString()).append("\",");
                        }
                        sb.append("\"isSystem\": \"").append(msg.getProperty("chat:issystem").getBoolean()).append("\",");
                        sb.append("\"message\": \"").append(msg.getProperty("chat:message").getString()).append("\"}");
                    }
                    first = false;
                }
                if (!isTextOnly) {
                    sb.append("]}");
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return sb.toString();
    }

    private void updateRoomTimestamp(String room) {
        try {
            Session session = JCRBootstrap.getSession();
            Node roomsNode = session.getRootNode().getNode("chat/room_rooms");
            if (roomsNode.hasNode(room)) {
                Node roomNode = roomsNode.getNode(room);
                roomNode.setProperty("chat:timestamp", System.currentTimeMillis());
                roomNode.save();
                session.save();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public String getSpaceRoom(String space) {
        String room = ChatUtils.getRoomId(space);
        try {
            Session session = JCRBootstrap.getSession();
            Node roomNode = this.getRoom(room, session, "room_rooms");
            if (!roomNode.hasProperty("chat:space")) {
                roomNode.setProperty("chat:space", space);
                roomNode.setProperty("chat:type", "s");
                session.save();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return room;
    }

    @Override
    public String getTeamRoom(String team, String user) {
        String room = ChatUtils.getRoomId(team, user);
        try {
            Session session = JCRBootstrap.getSession();
            Node roomNode = this.getRoom(room, session, "room_rooms");
            if (!roomNode.hasProperty("chat:team")) {
                roomNode.setProperty("chat:team", team);
                roomNode.setProperty("chat:user", user);
                roomNode.setProperty("chat:type", "t");
                session.save();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return room;
    }

    @Override
    public String getTeamCreator(String room) {
        if (room.indexOf("team-") == 0) {
            room = room.substring("team-".length());
        }
        String creator = "";
        try {
            Session session = JCRBootstrap.getSession();
            Node roomNode = this.getRoom(room, session, "room_rooms");
            if (roomNode.hasProperty("chat:user")) {
                creator = roomNode.getProperty("chat:user").getString();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return creator;
    }

    @Override
    public void setRoomName(String room, String name) {
        try {
            Session session = JCRBootstrap.getSession();
            Node roomNode = this.getRoom(room, session, "room_rooms");
            if (roomNode.hasProperty("chat:team")) {
                roomNode.setProperty("chat:team", name);
                session.save();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public String getRoom(List<String> users2) {
        Collections.sort(users2);
        String room = ChatUtils.getRoomId(users2);
        try {
            Session session = JCRBootstrap.getSession();
            Node roomNode = this.getRoom(room, session, "room_rooms");
            if (!roomNode.hasProperty("chat:users")) {
                String[] tabu = new String[users2.size()];
                int i = 0;
                for (String user : users2) {
                    tabu[i++] = user;
                }
                roomNode.setProperty("chat:users", tabu);
                roomNode.setProperty("chat:type", "u");
                session.save();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return room;
    }

    @Override
    public List<RoomBean> getExistingRooms(String user, boolean withPublic, boolean isAdmin, NotificationService notificationService, TokenService tokenService) {
        ArrayList<RoomBean> rooms = new ArrayList<RoomBean>();
        String roomId = null;
        try {
            Session session = JCRBootstrap.getSession();
            QueryManager manager = session.getWorkspace().getQueryManager();
            StringBuilder statement = new StringBuilder();
            statement.append("SELECT * FROM ").append("chat:room").append(" WHERE ");
            statement.append(" jcr:path like '/chat/room_rooms/%'");
            statement.append(" AND NOT jcr:path like '/chat/room_rooms/%/%'");
            statement.append(" AND ").append("chat:users").append(" = '").append(user).append("'");
            Query query = manager.createQuery(statement.toString(), "sql");
            NodeIterator nodeIterator = query.execute().getNodes();
            while (nodeIterator.hasNext()) {
                Node roomNode = nodeIterator.nextNode();
                roomId = roomNode.getName();
                long timestamp = -1L;
                if (roomNode.hasProperty("chat:timestamp")) {
                    timestamp = roomNode.getProperty("chat:timestamp").getLong();
                }
                Value[] values = roomNode.getProperty("chat:users").getValues();
                ArrayList<String> users2 = new ArrayList<String>();
                for (Value val : values) {
                    if (user.equals(val.getString())) continue;
                    users2.add(val.getString());
                }
                if (users2.size() <= 0 || user.equals(users2.get(0))) continue;
                String targetUser = (String)users2.get(0);
                boolean isDemoUser = tokenService.isDemoUser(targetUser);
                if (isAdmin && (!isAdmin || (withPublic || isDemoUser) && (!withPublic || !isDemoUser))) continue;
                RoomBean roomBean = new RoomBean();
                roomBean.setRoom(roomId);
                roomBean.setUnreadTotal(notificationService.getUnreadNotificationsTotal(user, "chat", "room", roomId));
                roomBean.setUser((String)users2.get(0));
                roomBean.setTimestamp(timestamp);
                rooms.add(roomBean);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return rooms;
    }

    @Override
    public RoomsBean getRooms(String user, String filter, boolean withUsers, boolean withSpaces, boolean withPublic, boolean withOffline, boolean isAdmin, NotificationService notificationService, UserService userService, TokenService tokenService) {
        List<Object> rooms = new ArrayList();
        ArrayList<RoomBean> roomsOffline = new ArrayList<RoomBean>();
        UserBean userBean = userService.getUser(user, true);
        int unreadOffline = 0;
        int unreadOnline = 0;
        int unreadSpaces = 0;
        int unreadTeams = 0;
        List<String> availableUsers = tokenService.getActiveUsersFilterBy(user, withUsers, withPublic, isAdmin);
        rooms = this.getExistingRooms(user, withPublic, isAdmin, notificationService, tokenService);
        if (isAdmin) {
            rooms.addAll(this.getExistingRooms("__support_", withPublic, isAdmin, notificationService, tokenService));
        }
        for (RoomBean roomBean : rooms) {
            String targetUser = roomBean.getUser();
            UserBean targetUserBean = userService.getUser(targetUser);
            roomBean.setFullname(targetUserBean.getFullname());
            roomBean.setFavorite(userBean.isFavorite(targetUser));
            if (availableUsers.contains(targetUser)) {
                roomBean.setAvailableUser(true);
                roomBean.setStatus(targetUserBean.getStatus());
                availableUsers.remove(targetUser);
                if (roomBean.getUnreadTotal() <= 0) continue;
                unreadOnline += roomBean.getUnreadTotal();
                continue;
            }
            roomBean.setAvailableUser(false);
            if (!withOffline) {
                roomsOffline.add(roomBean);
            }
            if (roomBean.getUnreadTotal() <= 0) continue;
            unreadOffline += roomBean.getUnreadTotal();
        }
        if (withUsers) {
            if (!withOffline) {
                for (RoomBean roomBean : roomsOffline) {
                    rooms.remove(roomBean);
                }
            }
            for (String string : availableUsers) {
                RoomBean roomBean = new RoomBean();
                roomBean.setUser(string);
                UserBean availableUserBean = userService.getUser(string);
                roomBean.setFullname(availableUserBean.getFullname());
                roomBean.setStatus(availableUserBean.getStatus());
                roomBean.setAvailableUser(true);
                roomBean.setFavorite(userBean.isFavorite(roomBean.getUser()));
                String string2 = roomBean.getStatus();
                if (!withOffline && (withOffline || "invisible".equals(roomBean.getStatus()) || "offline".equals(roomBean.getStatus()))) continue;
                rooms.add(roomBean);
            }
        } else {
            rooms = new ArrayList();
        }
        List<SpaceBean> spaces = userService.getSpaces(user);
        for (SpaceBean space : spaces) {
            RoomBean roomBeanS = new RoomBean();
            roomBeanS.setUser("space-" + space.getRoom());
            roomBeanS.setRoom(space.getRoom());
            roomBeanS.setFullname(space.getDisplayName());
            roomBeanS.setStatus("space");
            roomBeanS.setTimestamp(space.getTimestamp());
            roomBeanS.setAvailableUser(true);
            roomBeanS.setSpace(true);
            roomBeanS.setUnreadTotal(notificationService.getUnreadNotificationsTotal(user, "chat", "room", this.getSpaceRoom("space-" + space.getRoom())));
            if (roomBeanS.getUnreadTotal() > 0) {
                unreadSpaces += roomBeanS.getUnreadTotal();
            }
            roomBeanS.setFavorite(userBean.isFavorite(roomBeanS.getUser()));
            if (!withSpaces) continue;
            rooms.add(roomBeanS);
        }
        List<RoomBean> list = userService.getTeams(user);
        for (RoomBean team : list) {
            RoomBean roomBean = new RoomBean();
            roomBean.setUser("team-" + team.getRoom());
            roomBean.setRoom(team.getRoom());
            roomBean.setFullname(team.getFullname());
            roomBean.setStatus("team");
            roomBean.setTimestamp(team.getTimestamp());
            roomBean.setAvailableUser(true);
            roomBean.setSpace(false);
            roomBean.setTeam(true);
            roomBean.setUnreadTotal(notificationService.getUnreadNotificationsTotal(user, "chat", "room", team.getRoom()));
            if (roomBean.getUnreadTotal() > 0) {
                unreadTeams += roomBean.getUnreadTotal();
            }
            roomBean.setFavorite(userBean.isFavorite(roomBean.getUser()));
            if (!withSpaces) continue;
            rooms.add(roomBean);
        }
        ArrayList<RoomBean> finalRooms = new ArrayList();
        if (filter != null) {
            for (RoomBean roomBean : rooms) {
                String targetUser = roomBean.getFullname();
                if (!this.filter(targetUser, filter)) continue;
                finalRooms.add(roomBean);
            }
        } else {
            finalRooms = rooms;
        }
        RoomsBean roomsBean = new RoomsBean();
        roomsBean.setRooms(finalRooms);
        roomsBean.setUnreadOffline(unreadOffline);
        roomsBean.setUnreadOnline(unreadOnline);
        roomsBean.setUnreadSpaces(unreadSpaces);
        roomsBean.setUnreadTeams(unreadTeams);
        return roomsBean;
    }

    @Override
    public int getNumberOfRooms() {
        int nb = 0;
        try {
            Session session = JCRBootstrap.getSession();
            Node roomsNode = session.getRootNode().getNode("chat/rooms");
            nb = new Long(roomsNode.getNodes().getSize()).intValue();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return nb;
    }

    @Override
    public int getNumberOfMessages() {
        int nb = 0;
        try {
            Session session = JCRBootstrap.getSession();
            QueryManager manager = session.getWorkspace().getQueryManager();
            StringBuilder statement = new StringBuilder();
            statement.append("SELECT * FROM ").append("chat:message").append(" WHERE ");
            statement.append(" jcr:path like '/chat/rooms/%'");
            Query query = manager.createQuery(statement.toString(), "sql");
            NodeIterator nodeIterator = query.execute().getNodes();
            nb = new Long(nodeIterator.getSize()).intValue();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return nb;
    }

    private boolean filter(String user, String filter) {
        if (user == null || filter == null || "".equals(filter)) {
            return true;
        }
        String[] args = filter.toLowerCase().split(" ");
        String s = user.toLowerCase();
        for (String arg : args) {
            int ind = s.indexOf(arg);
            if (ind == -1) {
                return false;
            }
            s = s.substring(ind);
        }
        return true;
    }

    private Node getRoom(String room, Session session) {
        return this.getRoom(room, session, "rooms");
    }

    private Node getRoom(String room, Session session, String path) {
        Node node = null;
        try {
            Node roomsNode = session.getRootNode().getNode("chat/" + path);
            if (roomsNode.hasNode(room)) {
                node = roomsNode.getNode(room);
            } else {
                String nt = "chat:room";
                if (path.equals("rooms")) {
                    nt = "nt:unstructured";
                }
                node = roomsNode.addNode(room, nt);
                session.save();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return node;
    }
}

