/*
 * Decompiled with CFR 0.152.
 */
package org.benjp.utils;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import org.apache.commons.codec.binary.Base64;
import org.benjp.utils.MessageDigester;

public class ChatUtils {
    public static String getRoomId(String roomName, String user) {
        if (roomName.startsWith("team-") && roomName.length() > "team-".length() + 1) {
            return roomName.substring("team-".length());
        }
        StringBuilder sb = new StringBuilder();
        sb.append("1-team-room;").append(user).append(";").append(roomName).append(";");
        return MessageDigester.getHash(sb.toString());
    }

    public static String getRoomId(String roomName) {
        if (roomName.startsWith("space-") && roomName.length() > "space-".length() + 1) {
            return roomName.substring("space-".length());
        }
        StringBuilder sb = new StringBuilder();
        sb.append("1-space-room;").append(roomName).append(";");
        return MessageDigester.getHash(sb.toString());
    }

    public static String getRoomId(List<String> users2) {
        Collections.sort(users2);
        StringBuilder sb = new StringBuilder();
        for (String user : users2) {
            sb.append(user).append(";");
        }
        String roomId = MessageDigester.getHash(sb.toString());
        return roomId;
    }

    public static Object fromString(String s) throws IOException, ClassNotFoundException {
        byte[] data = Base64.decodeBase64((String)s);
        ObjectInputStream ois = new ObjectInputStream(new ByteArrayInputStream(data));
        Object o = ois.readObject();
        ois.close();
        return o;
    }

    public static String toString(Serializable o) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(baos);
        oos.writeObject(o);
        oos.close();
        return new String(Base64.encodeBase64((byte[])baos.toByteArray()));
    }
}

