/*
 * Decompiled with CFR 0.152.
 */
package org.benjp.model;

import org.apache.commons.lang3.StringEscapeUtils;

public class RoomBean
implements Comparable<RoomBean> {
    String user = "";
    String fullname = "";
    String room = "";
    int unreadTotal = -1;
    boolean isAvailableUser = false;
    String status = "invisible";
    boolean isSpace = false;
    boolean isTeam = false;
    boolean isFavorite = false;
    long timestamp = -1L;

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public String getRoom() {
        return this.room;
    }

    public void setRoom(String room) {
        this.room = room;
    }

    public int getUnreadTotal() {
        return this.unreadTotal;
    }

    public void setUnreadTotal(int unreadTotal) {
        this.unreadTotal = unreadTotal;
    }

    public boolean isAvailableUser() {
        return this.isAvailableUser;
    }

    public void setAvailableUser(boolean availableUser) {
        this.isAvailableUser = availableUser;
    }

    public boolean isActive() {
        return this.isAvailableUser || !"".equals(this.room);
    }

    public String getFullname() {
        return this.fullname;
    }

    public String getEscapedFullname() {
        return StringEscapeUtils.escapeHtml4((String)this.fullname);
    }

    public void setFullname(String fullname) {
        this.fullname = fullname;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public boolean isSpace() {
        return this.isSpace;
    }

    public void setSpace(boolean space) {
        this.isSpace = space;
    }

    public boolean isFavorite() {
        return this.isFavorite;
    }

    public void setFavorite(boolean favorite) {
        this.isFavorite = favorite;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    public boolean isTeam() {
        return this.isTeam;
    }

    public void setTeam(boolean team) {
        this.isTeam = team;
    }

    @Override
    public int compareTo(RoomBean roomBean) {
        String l = (this.isFavorite ? "0" : "1") + this.fullname;
        String r = (roomBean.isFavorite() ? "0" : "1") + roomBean.getFullname();
        return l.compareTo(r);
    }

    public String toJSON() {
        StringBuffer sb = new StringBuffer();
        sb.append("{");
        sb.append("\"escapedFullname\": \"" + this.getEscapedFullname() + "\",");
        sb.append("\"room\": \"" + this.getRoom() + "\",");
        sb.append("\"status\": \"" + this.getStatus() + "\",");
        sb.append("\"user\": \"" + this.getUser() + "\",");
        sb.append("\"timestamp\": " + this.getTimestamp() + ",");
        sb.append("\"unreadTotal\": \"" + this.getUnreadTotal() + "\",");
        sb.append("\"isActive\": \"" + this.isActive() + "\",");
        sb.append("\"isAvailableUser\": \"" + this.isAvailableUser() + "\",");
        sb.append("\"isFavorite\": \"" + this.isFavorite() + "\",");
        sb.append("\"isSpace\": \"" + this.isSpace() + "\",");
        sb.append("\"isTeam\": \"" + this.isTeam() + "\"");
        sb.append("}");
        return sb.toString();
    }
}

