/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.chat.utils;

import com.ibm.icu.text.Transliterator;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.chat.utils.MessageDigester;

public class ChatUtils {
    public static String getRoomId(String roomName, String user) {
        if (roomName.startsWith("team-") && roomName.length() > "team-".length() + 1) {
            return roomName.substring("team-".length());
        }
        StringBuilder sb = new StringBuilder();
        sb.append("1-team-room;").append(user).append(";").append(roomName).append(";");
        return MessageDigester.getHash(sb.toString());
    }

    public static String getRoomId(String roomName) {
        if (roomName.startsWith("space-") && roomName.length() > "space-".length() + 1) {
            return roomName.substring("space-".length());
        }
        StringBuilder sb = new StringBuilder();
        sb.append("1-space-room;").append(roomName).append(";");
        return MessageDigester.getHash(sb.toString());
    }

    public static String getExternalRoomId(String identifier) {
        if (identifier.startsWith("external-") && identifier.length() > "external-".length() + 1) {
            return identifier.substring("external-".length());
        }
        StringBuilder sb = new StringBuilder();
        sb.append("1-external-room;").append(identifier).append(";");
        return MessageDigester.getHash(sb.toString());
    }

    public static String getRoomId(List<String> users2) {
        Collections.sort(users2);
        StringBuilder sb = new StringBuilder();
        for (String user : users2) {
            sb.append(user).append(";");
        }
        String roomId = MessageDigester.getHash(sb.toString());
        return roomId;
    }

    public static Object fromString(String s) throws IOException, ClassNotFoundException {
        byte[] data = Base64.decodeBase64((String)s);
        ObjectInputStream ois = new ObjectInputStream(new ByteArrayInputStream(data));
        Object o = ois.readObject();
        ois.close();
        return o;
    }

    public static String toString(Serializable o) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(baos);
        oos.writeObject(o);
        oos.close();
        return new String(Base64.encodeBase64((byte[])baos.toByteArray()));
    }

    public static String cleanString(String str) {
        Transliterator accentsconverter = Transliterator.getInstance((String)"Latin; NFD; [:Nonspacing Mark:] Remove; NFC;");
        str = accentsconverter.transliterate(str);
        StringBuffer cleanedStr = new StringBuffer(str.trim());
        for (int i = 0; i < cleanedStr.length(); ++i) {
            char c = cleanedStr.charAt(i);
            if (c == ' ') {
                if (i > 0 && cleanedStr.charAt(i - 1) == '-') {
                    cleanedStr.deleteCharAt(i--);
                    continue;
                }
                c = '-';
                cleanedStr.setCharAt(i, c);
                continue;
            }
            if (i > 0 && !Character.isLetterOrDigit(c) && c != '-') {
                cleanedStr.deleteCharAt(i--);
                continue;
            }
            if (i <= 0 || c != 45 || cleanedStr.charAt(i - 1) != '-') continue;
            cleanedStr.deleteCharAt(i--);
        }
        while (StringUtils.isNotEmpty((String)cleanedStr.toString()) && !Character.isLetterOrDigit(cleanedStr.charAt(0))) {
            cleanedStr.deleteCharAt(0);
        }
        String clean = cleanedStr.toString().toLowerCase();
        if (clean.endsWith("-")) {
            clean = clean.substring(0, clean.length() - 1);
        }
        return clean;
    }
}

