/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.chat.utils;

import com.ibm.icu.text.Transliterator;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import org.apache.commons.codec.binary.Base64;
import org.exoplatform.chat.utils.MessageDigester;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.ecm.utils.text.Text;
import org.exoplatform.services.resources.ResourceBundleService;

public class ChatUtils {
    public static String getRoomId(String roomName, String user) {
        if (roomName.startsWith("team-") && roomName.length() > "team-".length() + 1) {
            return roomName.substring("team-".length());
        }
        StringBuilder sb = new StringBuilder();
        sb.append("1-team-room;").append(user).append(";").append(roomName).append(";");
        return MessageDigester.getHash(sb.toString());
    }

    public static String getRoomId(String roomName) {
        if (roomName.startsWith("space-") && roomName.length() > "space-".length() + 1) {
            return roomName.substring("space-".length());
        }
        StringBuilder sb = new StringBuilder();
        sb.append("1-space-room;").append(roomName).append(";");
        return MessageDigester.getHash(sb.toString());
    }

    public static String getExternalRoomId(String identifier) {
        if (identifier.startsWith("external-") && identifier.length() > "external-".length() + 1) {
            return identifier.substring("external-".length());
        }
        StringBuilder sb = new StringBuilder();
        sb.append("1-external-room;").append(identifier).append(";");
        return MessageDigester.getHash(sb.toString());
    }

    public static String getRoomId(List<String> users2) {
        Collections.sort(users2);
        StringBuilder sb = new StringBuilder();
        for (String user : users2) {
            sb.append(user).append(";");
        }
        String roomId = MessageDigester.getHash(sb.toString());
        return roomId;
    }

    public static Object fromString(String s) throws IOException, ClassNotFoundException {
        byte[] data = Base64.decodeBase64((String)s);
        ObjectInputStream ois = new ObjectInputStream(new ByteArrayInputStream(data));
        Object o = ois.readObject();
        ois.close();
        return o;
    }

    public static String toString(Serializable o) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(baos);
        oos.writeObject(o);
        oos.close();
        return new String(Base64.encodeBase64((byte[])baos.toByteArray()));
    }

    public static String cleanString(String str) {
        Transliterator accentsconverter = Transliterator.getInstance((String)"Latin; NFD; [:Nonspacing Mark:] Remove; NFC;");
        if (str.indexOf(46) > 0) {
            String ext = str.substring(str.lastIndexOf(46));
            str = accentsconverter.transliterate(str.substring(0, str.lastIndexOf(46))).concat(ext);
        } else {
            str = accentsconverter.transliterate(str);
        }
        return Text.escapeIllegalJcrChars((String)str);
    }

    public static String appRes(String key, Locale locale) {
        ResourceBundleService bundleService = (ResourceBundleService)CommonsUtils.getService(ResourceBundleService.class);
        ResourceBundle res = bundleService.getResourceBundle("locale.chat.server.Resource", locale);
        if (res == null || !res.containsKey(key)) {
            return key;
        }
        return res.getString(key);
    }
}

