/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.chat.server;

import com.mongodb.BasicDBList;
import com.mongodb.BasicDBObject;
import com.mongodb.util.JSON;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.mail.Address;
import javax.mail.Authenticator;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.Multipart;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import juzu.MimeType;
import juzu.Path;
import juzu.Resource;
import juzu.Response;
import juzu.Route;
import juzu.View;
import juzu.impl.common.Tools;
import juzu.template.Template;
import org.exoplatform.chat.listener.GuiceManager;
import org.exoplatform.chat.model.NotificationBean;
import org.exoplatform.chat.model.ReportBean;
import org.exoplatform.chat.model.RoomBean;
import org.exoplatform.chat.model.RoomsBean;
import org.exoplatform.chat.model.SpaceBean;
import org.exoplatform.chat.model.UserBean;
import org.exoplatform.chat.model.UsersBean;
import org.exoplatform.chat.server.ChatTools;
import org.exoplatform.chat.services.ChatService;
import org.exoplatform.chat.services.NotificationService;
import org.exoplatform.chat.services.TokenService;
import org.exoplatform.chat.services.UserService;
import org.exoplatform.chat.utils.ChatUtils;
import org.exoplatform.chat.utils.PropertyManager;
import org.json.JSONObject;

@ApplicationScoped
public class ChatServer {
    private static final Logger LOG = Logger.getLogger("ChatServer");
    @Inject
    @Path(value="index.gtmpl")
    Template index;
    @Inject
    @Path(value="users.gtmpl")
    Template users;
    ChatService chatService = (ChatService)GuiceManager.getInstance().getInstance(ChatService.class);
    UserService userService = (UserService)GuiceManager.getInstance().getInstance(UserService.class);
    TokenService tokenService = (TokenService)GuiceManager.getInstance().getInstance(TokenService.class);
    NotificationService notificationService = (NotificationService)GuiceManager.getInstance().getInstance(NotificationService.class);
    @Inject
    ChatTools chatTools;

    @View
    @Route(value="/")
    public Response.Content index() throws IOException {
        return this.index.ok();
    }

    @Resource
    @Route(value="/whoIsOnline")
    public Response.Content whoIsOnline(String user, String token, String filter, String isAdmin, String limit) {
        if (!this.tokenService.hasUserWithToken(user, token)) {
            return Response.notFound((CharSequence)"Petit malin !");
        }
        Integer ilimit = 0;
        try {
            if (limit != null && !"".equals(limit)) {
                ilimit = Integer.parseInt(limit);
            }
        }
        catch (NumberFormatException nfe) {
            LOG.info("limit is not a valid Integer number");
        }
        RoomsBean roomsBean = this.chatService.getRooms(user, filter, true, true, false, true, "true".equals(isAdmin), ilimit, this.notificationService, this.userService, this.tokenService);
        return Response.ok((CharSequence)roomsBean.roomsToJSON()).withMimeType("application/json").withHeader("Cache-Control", new String[]{"no-cache"}).withCharset(Tools.UTF_8);
    }

    @Resource
    @Route(value="/send")
    public Response.Content send(String user, String token, String targetUser, String message, String room, String isSystem, String options) throws IOException {
        block14: {
            if (!this.tokenService.hasUserWithToken(user, token)) {
                return Response.notFound((CharSequence)"Petit malin !");
            }
            try {
                List<String> roomMembers22;
                if (message == null) break block14;
                if (targetUser.startsWith("team-") && !(roomMembers22 = this.userService.getUsersFilterBy(null, room, "t")).contains(user)) {
                    return Response.content((int)403, (CharSequence)"Petit malin !");
                }
                try {
                    message = URLDecoder.decode(message, "UTF-8");
                    options = URLDecoder.decode(options, "UTF-8");
                }
                catch (UnsupportedEncodingException roomMembers22) {
                    // empty catch block
                }
                if (isSystem == null) {
                    isSystem = "false";
                }
                this.chatService.write(message, user, room, isSystem, options);
                if (!targetUser.startsWith("external-")) {
                    String content = message.length() > 30 ? message.substring(0, 29) + "..." : message;
                    String intranetPage = PropertyManager.getProperty("chatPortalPage");
                    if (targetUser.startsWith("space-")) {
                        List<String> users2 = this.userService.getUsersFilterBy(user, targetUser.substring("space-".length()), "s");
                        for (String tuser : users2) {
                            this.notificationService.addNotification(tuser, user, "chat", "room", room, content, intranetPage + "?room=" + room, options);
                        }
                    } else if (targetUser.startsWith("team-")) {
                        List<String> users3 = this.userService.getUsersFilterBy(user, targetUser.substring("team-".length()), "t");
                        for (String tuser : users3) {
                            this.notificationService.addNotification(tuser, user, "chat", "room", room, content, intranetPage + "?room=" + room, options);
                        }
                    } else {
                        this.notificationService.addNotification(targetUser, user, "chat", "room", room, content, intranetPage + "?room=" + room, options);
                    }
                    this.notificationService.setNotificationsAsRead(user, "chat", "room", room);
                }
            }
            catch (Exception e) {
                return Response.notFound((CharSequence)"Problem on Chat server. Please, try later").withMimeType("text/event-stream");
            }
        }
        return Response.ok((CharSequence)"ok").withMimeType("application/json; charset=UTF-8").withHeader("Cache-Control", new String[]{"no-cache"});
    }

    @Resource
    @Route(value="/read")
    public Response.Content read(String user, String token, String room, String fromTimestamp, String isTextOnly) throws IOException {
        List<String> roomMembers;
        if (!this.tokenService.hasUserWithToken(user, token)) {
            return Response.notFound((CharSequence)"Petit malin !");
        }
        Long from = null;
        try {
            if (fromTimestamp != null && !"".equals(fromTimestamp)) {
                from = Long.parseLong(fromTimestamp);
            }
        }
        catch (NumberFormatException nfe) {
            LOG.info("fromTimestamp is not a valid Long number");
        }
        if (this.userService.getRoom(user, room).isTeam() && !(roomMembers = this.userService.getUsersFilterBy(null, room, "t")).contains(user)) {
            return Response.content((int)403, (CharSequence)"Petit malin !");
        }
        String data = this.chatService.read(room, this.userService, "true".equals(isTextOnly), from);
        return Response.ok((CharSequence)data).withMimeType("application/json").withHeader("Cache-Control", new String[]{"no-cache"}).withCharset(Tools.UTF_8);
    }

    @Resource
    @Route(value="/sendMeetingNotes")
    public Response.Content sendMeetingNotes(String user, String token, String room, String fromTimestamp, String toTimestamp) throws IOException {
        if (!this.tokenService.hasUserWithToken(user, token)) {
            return Response.notFound((CharSequence)"Petit malin !");
        }
        Long from = null;
        Long to = null;
        String html = "";
        try {
            if (fromTimestamp != null && !"".equals(fromTimestamp)) {
                from = Long.parseLong(fromTimestamp);
            }
        }
        catch (NumberFormatException nfe) {
            LOG.info("fromTimestamp is not a valid Long number");
        }
        try {
            if (toTimestamp != null && !"".equals(toTimestamp)) {
                to = Long.parseLong(toTimestamp);
            }
        }
        catch (NumberFormatException nfe) {
            LOG.info("fromTimestamp is not a valid Long number");
        }
        String data = this.chatService.read(room, this.userService, false, from, to);
        BasicDBObject datao = (BasicDBObject)JSON.parse((String)data);
        String roomType = this.chatService.getTypeRoomChat(room);
        SimpleDateFormat formatter = new SimpleDateFormat("dd/MM/yyyy");
        String date = formatter.format(new GregorianCalendar().getTime());
        String title = "";
        String roomName = "";
        ArrayList<UserBean> users2 = new ArrayList();
        if (datao.containsField("messages")) {
            if ("u".equalsIgnoreCase(roomType)) {
                users2 = this.userService.getUsersInRoomChatOneToOne(room);
                title = "Meeting Notes [" + date + "]";
            } else {
                users2 = this.userService.getUsers(room);
                List<SpaceBean> spaces = this.userService.getSpaces(user);
                for (SpaceBean spaceBean : spaces) {
                    if (!room.equals(spaceBean.getRoom())) continue;
                    roomName = spaceBean.getDisplayName();
                }
                List<RoomBean> roomBeans = this.userService.getTeams(user);
                for (RoomBean roomBean : roomBeans) {
                    if (!room.equals(roomBean.getRoom())) continue;
                    roomName = roomBean.getFullname();
                }
                title = roomName + " : Meeting Notes [" + date + "]";
            }
            ReportBean reportBean = new ReportBean();
            reportBean.fill((BasicDBList)datao.get("messages"), users2);
            ArrayList<String> tos = new ArrayList<String>();
            String sender = user;
            for (UserBean userBean : users2) {
                if (!"".equals(userBean.getEmail())) {
                    tos.add(userBean.getEmail());
                }
                if (!user.equals(userBean.getName())) continue;
                sender = userBean.getFullname();
                sender = sender + "<" + userBean.getEmail() + ">";
            }
            html = reportBean.getAsHtml(title);
            try {
                this.sendMailWithAuth(sender, tos, html.toString(), title);
            }
            catch (Exception e) {
                LOG.info(e.getMessage());
            }
        }
        return Response.ok((CharSequence)"sent").withMimeType("text/event-stream; charset=UTF-8").withHeader("Cache-Control", new String[]{"no-cache"});
    }

    @Resource
    @Route(value="/getMeetingNotes")
    public Response.Content getMeetingNotes(String user, String token, String room, String fromTimestamp, String toTimestamp, String serverBase) throws IOException {
        if (!this.tokenService.hasUserWithToken(user, token)) {
            return Response.notFound((CharSequence)"Petit malin !");
        }
        Long from = null;
        Long to = null;
        String xwiki = "";
        String roomName = "";
        ArrayList<UserBean> users2 = new ArrayList();
        JSONObject jsonObject = new JSONObject();
        try {
            if (fromTimestamp != null && !"".equals(fromTimestamp)) {
                from = Long.parseLong(fromTimestamp);
            }
        }
        catch (NumberFormatException nfe) {
            LOG.info("fromTimestamp is not a valid Long number");
        }
        try {
            if (toTimestamp != null && !"".equals(toTimestamp)) {
                to = Long.parseLong(toTimestamp);
            }
        }
        catch (NumberFormatException nfe) {
            LOG.info("fromTimestamp is not a valid Long number");
        }
        String data = this.chatService.read(room, this.userService, false, from, to);
        String typeRoom = this.chatService.getTypeRoomChat(room);
        BasicDBObject datao = (BasicDBObject)JSON.parse((String)data);
        if (datao.containsField("messages")) {
            if ("u".equalsIgnoreCase(typeRoom)) {
                users2 = this.userService.getUsersInRoomChatOneToOne(room);
            } else {
                users2 = this.userService.getUsers(room);
                List<SpaceBean> spaces = this.userService.getSpaces(user);
                for (SpaceBean spaceBean : spaces) {
                    if (!room.equals(spaceBean.getRoom())) continue;
                    roomName = spaceBean.getDisplayName();
                }
                List<RoomBean> roomBeans = this.userService.getTeams(user);
                for (RoomBean roomBean : roomBeans) {
                    if (!room.equals(roomBean.getRoom())) continue;
                    roomName = roomBean.getFullname();
                }
            }
            ReportBean reportBean = new ReportBean();
            reportBean.fill((BasicDBList)datao.get("messages"), users2);
            ArrayList<String> usersInGroup = new ArrayList<String>();
            xwiki = reportBean.getAsXWiki(serverBase);
            try {
                for (UserBean userBean : users2) {
                    if ("".equals(userBean.getName())) continue;
                    usersInGroup.add(userBean.getName());
                }
                jsonObject.put("users", usersInGroup);
                jsonObject.put("xwiki", (Object)xwiki);
                jsonObject.put("typeRoom", (Object)typeRoom);
            }
            catch (Exception e) {
                LOG.warning(e.getMessage());
                return Response.notFound((CharSequence)"No Room yet");
            }
        }
        return Response.ok((CharSequence)jsonObject.toString()).withMimeType("application/json").withHeader("Cache-Control", new String[]{"no-cache"}).withCharset(Tools.UTF_8);
    }

    @Resource
    @MimeType(value={"text/plain"})
    @Route(value="/delete")
    public Response.Content delete(String user, String token, String room, String messageId) throws IOException {
        if (!this.tokenService.hasUserWithToken(user, token)) {
            return Response.notFound((CharSequence)"Petit malin !");
        }
        try {
            this.chatService.delete(room, user, messageId);
        }
        catch (Exception e) {
            return Response.notFound((CharSequence)"Oups");
        }
        return Response.ok((CharSequence)"Updated!");
    }

    @Resource
    @MimeType(value={"text/plain"})
    @Route(value="/edit")
    public Response.Content edit(String user, String token, String room, String messageId, String message) throws IOException {
        if (!this.tokenService.hasUserWithToken(user, token)) {
            return Response.notFound((CharSequence)"Petit malin !");
        }
        try {
            try {
                message = URLDecoder.decode(message, "UTF-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
            this.chatService.edit(room, user, messageId, message);
        }
        catch (Exception e) {
            return Response.notFound((CharSequence)"Oups");
        }
        return Response.ok((CharSequence)"Updated!");
    }

    @Resource
    @MimeType(value={"text/plain"})
    @Route(value="/toggleFavorite")
    public Response.Content toggleFavorite(String user, String token, String targetUser) {
        if (!this.tokenService.hasUserWithToken(user, token)) {
            return Response.notFound((CharSequence)"Petit malin !");
        }
        try {
            this.userService.toggleFavorite(user, targetUser);
        }
        catch (Exception e) {
            LOG.log(Level.WARNING, e.getMessage());
            return Response.notFound((CharSequence)"Oups");
        }
        return Response.ok((CharSequence)"Updated!");
    }

    @Resource
    @Route(value="/getRoom")
    public Response.Content getRoom(String user, String token, String targetUser, String isAdmin, String withDetail, String type) {
        if (!this.tokenService.hasUserWithToken(user, token)) {
            return Response.notFound((CharSequence)"Petit malin !");
        }
        String room = targetUser;
        RoomBean roomBean = null;
        try {
            if (type != null) {
                if ("room-id".equals(type)) {
                    room = targetUser;
                } else if ("space-name".equals(type)) {
                    room = this.chatService.getSpaceRoomByName(targetUser);
                } else if ("space-id".equals(type)) {
                    room = ChatUtils.getRoomId(targetUser);
                } else if ("username".equals(type)) {
                    ArrayList<String> users2 = new ArrayList<String>();
                    users2.add(user);
                    users2.add(targetUser);
                    room = this.chatService.getRoom(users2);
                } else if ("external".equals(type)) {
                    room = this.chatService.getExternalRoom(targetUser);
                }
            } else if (targetUser.startsWith("space-")) {
                room = this.chatService.getSpaceRoom(targetUser);
            } else if (targetUser.startsWith("team-")) {
                room = this.chatService.getTeamRoom(targetUser, user);
            } else if (targetUser.startsWith("external-")) {
                room = this.chatService.getExternalRoom(targetUser);
            } else {
                String finalUser = "true".equals(isAdmin) && !user.startsWith("__anonim_") && targetUser.startsWith("__anonim_") ? "__support_" : user;
                ArrayList<String> users3 = new ArrayList<String>(2);
                users3.add(finalUser);
                users3.add(targetUser);
                room = this.chatService.getRoom(users3);
            }
            if ("true".equals(withDetail)) {
                roomBean = this.userService.getRoom(user, room);
            }
            this.notificationService.setNotificationsAsRead(user, "chat", "room", room);
        }
        catch (Exception e) {
            LOG.log(Level.WARNING, e.getMessage());
            return Response.notFound((CharSequence)"No Room yet");
        }
        String out = room;
        if (roomBean != null) {
            out = roomBean.toJSON();
        }
        return Response.ok((CharSequence)out).withMimeType("application/json").withCharset(Tools.UTF_8).withHeader("Cache-Control", new String[]{"no-cache"});
    }

    @Resource
    @Route(value="/saveTeamRoom")
    public Response.Content saveTeamRoom(String user, String token, String teamName, String room, String users2) {
        if (!this.tokenService.hasUserWithToken(user, token)) {
            return Response.notFound((CharSequence)"Petit malin !");
        }
        JSONObject jsonObject = new JSONObject();
        try {
            try {
                teamName = URLDecoder.decode(teamName, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                LOG.info("Cannot decode message: " + teamName);
            }
            if (room == null || "".equals(room) || "---".equals(room)) {
                room = this.chatService.getTeamRoom(teamName, user);
                this.userService.addTeamRoom(user, room);
            } else {
                String creator = this.chatService.getTeamCreator(room);
                if (!user.equals(creator)) {
                    return Response.notFound((CharSequence)"Petit malin !");
                }
                if (room.startsWith("team-") && room.length() > "team-".length() + 1) {
                    room = room.substring("team-".length());
                }
                this.chatService.setRoomName(room, teamName);
            }
            if (users2 != null && !"".equals(users2)) {
                StringBuilder sbUsers;
                String[] ausers = users2.split(",");
                List<String> usersNew = Arrays.asList(ausers);
                ArrayList<String> usersToAdd = new ArrayList<String>(usersNew);
                ArrayList<String> usersToRemove = new ArrayList<String>();
                List<String> usersExisting = this.userService.getUsersFilterBy(null, room, "t");
                for (String userExist : usersExisting) {
                    if (!usersNew.contains(userExist)) {
                        usersToRemove.add(userExist);
                        continue;
                    }
                    if (!usersNew.contains(userExist)) continue;
                    usersToAdd.remove(userExist);
                }
                if (usersToRemove.size() > 0) {
                    this.userService.removeTeamUsers(room, usersToRemove);
                    sbUsers = new StringBuilder();
                    boolean first = true;
                    for (String usert : usersToRemove) {
                        if (!first) {
                            sbUsers.append("; ");
                        }
                        sbUsers.append(this.userService.getUserFullName(usert));
                        first = false;
                        this.notificationService.setNotificationsAsRead(usert, "chat", "room", room);
                    }
                    String removeTeamUserOptions = "{\"type\":\"type-remove-team-user\",\"users\":\"" + sbUsers + "\", " + "\"fullname\":\"" + this.userService.getUserFullName(user) + "\"}";
                    this.send(user, token, "team-" + room, "", room, "true", removeTeamUserOptions);
                }
                if (usersToAdd.size() > 0) {
                    this.userService.addTeamUsers(room, usersToAdd);
                    sbUsers = new StringBuilder();
                    boolean first = true;
                    for (String usert : usersToAdd) {
                        if (!first) {
                            sbUsers.append("; ");
                        }
                        sbUsers.append(this.userService.getUserFullName(usert));
                        first = false;
                    }
                    String addTeamUserOptions = "{\"type\":\"type-add-team-user\",\"users\":\"" + sbUsers + "\", " + "\"fullname\":\"" + this.userService.getUserFullName(user) + "\"}";
                    this.send(user, token, "team-" + room, "", room, "true", addTeamUserOptions);
                }
            }
            jsonObject.put("name", (Object)teamName);
            jsonObject.put("room", (Object)room);
        }
        catch (Exception e) {
            LOG.warning(e.getMessage());
            return Response.notFound((CharSequence)"No Room yet");
        }
        return Response.ok((CharSequence)jsonObject.toString()).withMimeType("application/json").withHeader("Cache-Control", new String[]{"no-cache"}).withCharset(Tools.UTF_8);
    }

    @Resource
    @MimeType(value={"text/plain"})
    @Route(value="/updateUnreadMessages")
    public Response.Content updateUnreadMessages(String room, String user, String token) {
        if (!this.tokenService.hasUserWithToken(user, token)) {
            return Response.notFound((CharSequence)"Petit malin !");
        }
        try {
            this.notificationService.setNotificationsAsRead(user, "chat", "room", room);
            if (this.userService.isAdmin(user)) {
                this.notificationService.setNotificationsAsRead("__support_", "chat", "room", room);
            }
        }
        catch (Exception e) {
            LOG.warning(e.getMessage());
            return Response.notFound((CharSequence)"Server Not Available yet");
        }
        return Response.ok((CharSequence)"Updated.");
    }

    @Resource
    @Route(value="/notification")
    public Response.Content notification(String user, String token, String event, String withDetails) throws IOException {
        if (!this.tokenService.hasUserWithToken(user, token)) {
            return Response.notFound((CharSequence)"Petit malin !");
        }
        boolean detailed = "true".equals(withDetails);
        int totalUnread = 0;
        List<NotificationBean> notifications = null;
        if (!detailed) {
            totalUnread = this.notificationService.getUnreadNotificationsTotal(user);
            if (this.userService.isAdmin(user)) {
                totalUnread += this.notificationService.getUnreadNotificationsTotal("__support_");
            }
        } else {
            notifications = this.notificationService.getUnreadNotifications(user, this.userService);
            totalUnread = notifications.size();
        }
        String data = "{\"total\": \"" + totalUnread + "\"";
        if (detailed && notifications != null) {
            data = data + "," + NotificationBean.notificationstoJSON(notifications);
        }
        data = data + "}";
        if (event != null && event.equals("1")) {
            data = "id: " + totalUnread + "\n";
            data = data + "data: {\"total\": " + totalUnread + "}\n\n";
        }
        return Response.ok((CharSequence)data).withMimeType("application/json").withCharset(Tools.UTF_8).withHeader("Cache-Control", new String[]{"no-cache"});
    }

    @Resource
    @MimeType(value={"text/plain"})
    @Route(value="/getStatus")
    public Response.Content getStatus(String user, String token, String targetUser) {
        if (!this.tokenService.hasUserWithToken(user, token)) {
            return Response.notFound((CharSequence)"Petit malin !");
        }
        String status = "invisible";
        try {
            if (targetUser != null) {
                boolean online = this.tokenService.isUserOnline(targetUser);
                status = online ? this.userService.getStatus(targetUser) : "offline";
            } else {
                status = this.userService.getStatus(user);
                this.tokenService.updateValidity(user, token);
            }
        }
        catch (Exception e) {
            LOG.warning(e.getMessage());
            return Response.notFound((CharSequence)status);
        }
        return Response.ok((CharSequence)status).withHeader("Cache-Control", new String[]{"no-cache"});
    }

    @Resource
    @MimeType(value={"text/plain"})
    @Route(value="/setStatus")
    public Response.Content setStatus(String user, String token, String status) {
        if (!this.tokenService.hasUserWithToken(user, token)) {
            return Response.notFound((CharSequence)"Petit malin !");
        }
        try {
            this.userService.setStatus(user, status);
        }
        catch (Exception e) {
            LOG.warning(e.getMessage());
            return Response.notFound((CharSequence)"No Status for this User");
        }
        return Response.ok((CharSequence)status);
    }

    @Resource
    @MimeType(value={"text/plain"})
    @Route(value="/getCreator")
    public Response.Content getCreator(String user, String token, String room) {
        String creator = "";
        if (!this.tokenService.hasUserWithToken(user, token)) {
            return Response.notFound((CharSequence)"Petit malin !");
        }
        try {
            creator = this.chatService.getTeamCreator(room);
        }
        catch (Exception e) {
            LOG.warning(e.getMessage());
            return Response.notFound((CharSequence)"No Status for this User");
        }
        return Response.ok((CharSequence)creator);
    }

    @Resource
    @Route(value="/users")
    public Response.Content getUsers(String user, String token, String room, String filter) {
        if (!this.tokenService.hasUserWithToken(user, token)) {
            return Response.notFound((CharSequence)"Petit malin !");
        }
        List<UserBean> users2 = room != null && !"".equals(room) ? this.userService.getUsers(room) : this.userService.getUsers(filter, true);
        for (UserBean userBean : users2) {
            boolean online = this.tokenService.isUserOnline(userBean.getName());
            if (online) continue;
            userBean.setStatus("offline");
        }
        UsersBean usersBean = new UsersBean();
        usersBean.setUsers(users2);
        return Response.ok((CharSequence)usersBean.usersToJSON()).withMimeType("application/json").withHeader("Cache-Control", new String[]{"no-cache"}).withCharset(Tools.UTF_8);
    }

    @Resource
    @Route(value="/statistics")
    public Response.Content getStatistics() {
        StringBuffer data = new StringBuffer();
        data.append("{");
        data.append(" \"users\": " + this.userService.getNumberOfUsers() + ", ");
        data.append(" \"rooms\": " + this.chatService.getNumberOfRooms() + ", ");
        data.append(" \"messages\": " + this.chatService.getNumberOfMessages() + ", ");
        data.append(" \"notifications\": " + this.notificationService.getNumberOfNotifications() + ", ");
        data.append(" \"notificationsUnread\": " + this.notificationService.getNumberOfUnreadNotifications());
        data.append("}");
        return Response.ok((CharSequence)data.toString()).withMimeType("application/json").withCharset(Tools.UTF_8).withHeader("Cache-Control", new String[]{"no-cache"});
    }

    private Session getMailSession() {
        String protocal = PropertyManager.getProperty("email.smtp.protocal");
        String host = PropertyManager.getProperty("email.smtp.host");
        final String user = PropertyManager.getProperty("email.smtp.username");
        final String password = PropertyManager.getProperty("email.smtp.password");
        String port = PropertyManager.getProperty("email.smtp.port");
        String auth = PropertyManager.getProperty("email.smtp.auth");
        String starttlsEnable = PropertyManager.getProperty("email.smtp.starttls.enable");
        String enableSSL = PropertyManager.getProperty("email.smtp.EnableSSL.enable");
        String smtpAuth = PropertyManager.getProperty("email.smtp.auth");
        String socketFactoryPort = PropertyManager.getProperty("email.smtp.socketFactory.port");
        String socketFactoryClass = PropertyManager.getProperty("email.smtp.socketFactory.class");
        String socketFactoryFallback = PropertyManager.getProperty("email.smtp.socketFactory.fallback");
        Properties props = new Properties();
        props.put("mail.transport.protocol", protocal);
        props.put("mail.smtp.host", host);
        props.put("mail.smtp.port", port);
        props.put("mail.smtp.auth", auth);
        if (Boolean.parseBoolean(smtpAuth)) {
            props.put("mail.smtp.socketFactory.port", socketFactoryPort);
            props.put("mail.smtp.socketFactory.class", socketFactoryClass);
            props.put("mail.smtp.socketFactory.fallback", socketFactoryFallback);
            props.put("mail.smtp.starttls.enable", starttlsEnable);
            props.put("mail.smtp.ssl.enable", enableSSL);
            return Session.getInstance((Properties)props, (Authenticator)new Authenticator(){

                protected PasswordAuthentication getPasswordAuthentication() {
                    return new PasswordAuthentication(user, password);
                }
            });
        }
        return Session.getInstance((Properties)props);
    }

    public void sendMailWithAuth(String senderFullname, List<String> toList, String htmlBody, String subject) throws Exception {
        Session session = this.getMailSession();
        MimeMessage message = new MimeMessage(session);
        message.setFrom((Address)new InternetAddress(senderFullname));
        for (String to : toList) {
            message.addRecipients(Message.RecipientType.TO, (Address[])InternetAddress.parse((String)to));
        }
        message.setSubject(subject, "UTF-8");
        MimeBodyPart messageBodyPart = new MimeBodyPart();
        messageBodyPart.setContent((Object)htmlBody, "text/html; charset=UTF-8");
        MimeMultipart multipart = new MimeMultipart();
        multipart.addBodyPart((BodyPart)messageBodyPart);
        message.setContent((Multipart)multipart);
        try {
            Transport.send((Message)message);
        }
        catch (Exception e) {
            LOG.info(e.getMessage());
        }
    }
}

