/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.chat.services.mongodb;

import com.mongodb.BasicDBObject;
import com.mongodb.DB;
import com.mongodb.DBCollection;
import com.mongodb.DBCursor;
import com.mongodb.DBObject;
import com.mongodb.WriteConcern;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Named;
import org.exoplatform.chat.listener.ConnectionManager;
import org.exoplatform.chat.model.RoomBean;
import org.exoplatform.chat.model.SpaceBean;
import org.exoplatform.chat.model.UserBean;
import org.exoplatform.chat.services.UserService;
import org.exoplatform.chat.utils.ChatUtils;

@Named(value="userService")
@ApplicationScoped
public class UserServiceImpl
implements UserService {
    private static final Logger LOG = Logger.getLogger("UserService");

    private DB db() {
        return ConnectionManager.getInstance().getDB();
    }

    @Override
    public void toggleFavorite(String user, String targetUser) {
        DBCollection coll = this.db().getCollection("users");
        BasicDBObject query = new BasicDBObject();
        query.put("user", (Object)user);
        DBCursor cursor = coll.find((DBObject)query);
        if (cursor.hasNext()) {
            DBObject doc = cursor.next();
            List<String> favorites = new ArrayList();
            if (doc.containsField("favorites")) {
                favorites = (List)doc.get("favorites");
            }
            if (favorites.contains(targetUser)) {
                favorites.remove(targetUser);
            } else {
                favorites.add(targetUser);
            }
            doc.put("favorites", favorites);
            coll.save(doc, WriteConcern.SAFE);
        }
    }

    @Override
    public boolean isFavorite(String user, String targetUser) {
        List favorites;
        DBObject doc;
        DBCollection coll = this.db().getCollection("users");
        BasicDBObject query = new BasicDBObject();
        query.put("user", (Object)user);
        DBCursor cursor = coll.find((DBObject)query);
        return cursor.hasNext() && (doc = cursor.next()).containsField("favorites") && (favorites = (List)doc.get("favorites")).contains(targetUser);
    }

    @Override
    public void addUserFullName(String user, String fullname) {
        DBCollection coll = this.db().getCollection("users");
        BasicDBObject query = new BasicDBObject();
        query.put("user", (Object)user);
        DBCursor cursor = coll.find((DBObject)query);
        if (!cursor.hasNext()) {
            BasicDBObject doc = new BasicDBObject();
            doc.put("_id", (Object)user);
            doc.put("user", (Object)user);
            doc.put("fullname", (Object)fullname);
            coll.insert(new DBObject[]{doc});
        } else {
            DBObject doc = cursor.next();
            doc.put("fullname", (Object)fullname);
            coll.save(doc);
        }
    }

    @Override
    public void addUserEmail(String user, String email) {
        DBCollection coll = this.db().getCollection("users");
        BasicDBObject query = new BasicDBObject();
        query.put("user", (Object)user);
        DBCursor cursor = coll.find((DBObject)query);
        if (!cursor.hasNext()) {
            BasicDBObject doc = new BasicDBObject();
            doc.put("_id", (Object)user);
            doc.put("user", (Object)user);
            doc.put("email", (Object)email);
            coll.insert(new DBObject[]{doc});
        } else {
            DBObject doc = cursor.next();
            doc.put("email", (Object)email);
            coll.save(doc);
        }
    }

    @Override
    public void setSpaces(String user, List<SpaceBean> spaces) {
        DBObject doc;
        ArrayList<String> spaceIds = new ArrayList<String>();
        DBCollection coll = this.db().getCollection("room_rooms");
        for (SpaceBean bean : spaces) {
            DBObject doc2;
            String room = ChatUtils.getRoomId(bean.getId());
            spaceIds.add(room);
            BasicDBObject query = new BasicDBObject();
            query.put("_id", (Object)room);
            DBCursor cursor = coll.find((DBObject)query);
            if (!cursor.hasNext()) {
                doc2 = new BasicDBObject();
                doc2.put("_id", (Object)room);
                doc2.put("space_id", (Object)bean.getId());
                doc2.put("displayName", (Object)bean.getDisplayName());
                doc2.put("groupId", (Object)bean.getGroupId());
                doc2.put("shortName", (Object)bean.getShortName());
                doc2.put("type", (Object)"s");
                coll.insert(new DBObject[]{doc2});
                continue;
            }
            doc2 = cursor.next();
            String displayName = doc2.get("displayName").toString();
            if (bean.getDisplayName().equals(displayName)) continue;
            doc2.put("_id", (Object)room);
            doc2.put("displayName", (Object)bean.getDisplayName());
            doc2.put("groupId", (Object)bean.getGroupId());
            doc2.put("shortName", (Object)bean.getShortName());
            coll.save(doc2);
        }
        coll = this.db().getCollection("users");
        BasicDBObject query = new BasicDBObject();
        query.put("user", (Object)user);
        DBCursor cursor = coll.find((DBObject)query);
        if (cursor.hasNext()) {
            doc = cursor.next();
            doc.put("spaces", spaceIds);
            coll.save(doc, WriteConcern.SAFE);
        } else {
            doc = new BasicDBObject();
            doc.put("_id", (Object)user);
            doc.put("user", (Object)user);
            doc.put("spaces", spaceIds);
            coll.insert(new DBObject[]{doc});
        }
    }

    @Override
    public void addTeamRoom(String user, String teamRoomId) {
        ArrayList<String> teamIds = new ArrayList<String>();
        teamIds.add(teamRoomId);
        DBCollection coll = this.db().getCollection("users");
        BasicDBObject query = new BasicDBObject();
        query.put("user", (Object)user);
        DBCursor cursor = coll.find((DBObject)query);
        if (cursor.hasNext()) {
            DBObject doc = cursor.next();
            if (doc.containsField("teams")) {
                List existingTeams = (List)doc.get("teams");
                if (!existingTeams.contains(teamRoomId)) {
                    existingTeams.add(teamRoomId);
                }
                doc.put("teams", (Object)existingTeams);
            } else {
                doc.put("teams", teamIds);
            }
            coll.save(doc, WriteConcern.SAFE);
        } else {
            BasicDBObject doc = new BasicDBObject();
            doc.put("_id", (Object)user);
            doc.put("user", (Object)user);
            doc.put("teams", teamIds);
            coll.insert(new DBObject[]{doc});
        }
    }

    @Override
    public void addTeamUsers(String teamRoomId, List<String> users2) {
        for (String user : users2) {
            LOG.info("Team Add : " + user);
            this.addTeamRoom(user, teamRoomId);
        }
    }

    @Override
    public void removeTeamUsers(String teamRoomId, List<String> users2) {
        DBCollection coll = this.db().getCollection("users");
        for (String user : users2) {
            List teams;
            DBObject doc;
            LOG.info("Team Remove : " + user);
            BasicDBObject query = new BasicDBObject();
            query.put("user", (Object)user);
            DBCursor cursor = coll.find((DBObject)query);
            if (!cursor.hasNext() || !(doc = cursor.next()).containsField("teams") || !(teams = (List)doc.get("teams")).contains(teamRoomId)) continue;
            teams.remove(teamRoomId);
            doc.put("teams", (Object)teams);
            coll.save(doc, WriteConcern.SAFE);
        }
    }

    private RoomBean getTeam(String teamId) {
        RoomBean roomBean = null;
        DBCollection coll = this.db().getCollection("room_rooms");
        BasicDBObject query = new BasicDBObject();
        query.put("_id", (Object)teamId);
        DBCursor cursor = coll.find((DBObject)query);
        if (cursor.hasNext()) {
            DBObject doc = cursor.next();
            roomBean = new RoomBean();
            roomBean.setRoom(teamId);
            roomBean.setUser(doc.get("user").toString());
            roomBean.setFullname(doc.get("team").toString());
            if (doc.containsField("timestamp")) {
                roomBean.setTimestamp((Long)doc.get("timestamp"));
            }
        }
        return roomBean;
    }

    @Override
    public List<RoomBean> getTeams(String user) {
        DBObject doc;
        List listrooms;
        ArrayList<RoomBean> rooms = new ArrayList<RoomBean>();
        DBCollection coll = this.db().getCollection("users");
        BasicDBObject query = new BasicDBObject();
        query.put("user", (Object)user);
        DBCursor cursor = coll.find((DBObject)query);
        if (cursor.hasNext() && (listrooms = (List)(doc = cursor.next()).get("teams")) != null) {
            for (String room : listrooms) {
                rooms.add(this.getTeam(room));
            }
        }
        return rooms;
    }

    @Override
    public RoomBean getRoom(String user, String roomId) {
        RoomBean roomBean = new RoomBean();
        roomBean.setRoom(roomId);
        DBCollection coll = this.db().getCollection("room_rooms");
        BasicDBObject query = new BasicDBObject();
        query.put("_id", (Object)roomId);
        DBCursor cursor = coll.find((DBObject)query);
        if (cursor.hasNext()) {
            String type;
            DBObject doc = cursor.next();
            if (doc.containsField("timestamp")) {
                roomBean.setTimestamp((Long)doc.get("timestamp"));
            }
            if ("s".equals(type = doc.get("type").toString())) {
                roomBean.setUser("space-" + roomId);
                roomBean.setFullname(doc.get("displayName").toString());
                roomBean.setSpace(true);
            } else if ("t".equals(type)) {
                roomBean.setUser("team-" + roomId);
                roomBean.setFullname(doc.get("team").toString());
                roomBean.setTeam(true);
            } else if ("u".equals(type)) {
                List users2 = (List)doc.get("users");
                users2.remove(user);
                String targetUser = (String)users2.get(0);
                roomBean.setUser(targetUser);
                roomBean.setFullname(this.getUserFullName(targetUser));
            } else if ("e".equals(type)) {
                roomBean.setUser("external-" + roomId);
                roomBean.setFullname(doc.get("identifier").toString());
            }
        }
        return roomBean;
    }

    private SpaceBean getSpace(String roomId) {
        SpaceBean spaceBean = null;
        DBCollection coll = this.db().getCollection("room_rooms");
        BasicDBObject query = new BasicDBObject();
        query.put("_id", (Object)roomId);
        DBCursor cursor = coll.find((DBObject)query);
        if (cursor.hasNext()) {
            DBObject doc = cursor.next();
            spaceBean = new SpaceBean();
            spaceBean.setRoom(roomId);
            spaceBean.setId(doc.get("space_id").toString());
            spaceBean.setDisplayName(doc.get("displayName").toString());
            spaceBean.setGroupId(doc.get("groupId").toString());
            spaceBean.setShortName(doc.get("shortName").toString());
            if (doc.containsField("timestamp")) {
                spaceBean.setTimestamp((Long)doc.get("timestamp"));
            }
        }
        return spaceBean;
    }

    @Override
    public List<SpaceBean> getSpaces(String user) {
        DBObject doc;
        List listspaces;
        ArrayList<SpaceBean> spaces = new ArrayList<SpaceBean>();
        DBCollection coll = this.db().getCollection("users");
        BasicDBObject query = new BasicDBObject();
        query.put("user", (Object)user);
        DBCursor cursor = coll.find((DBObject)query);
        if (cursor.hasNext() && (listspaces = (List)(doc = cursor.next()).get("spaces")) != null) {
            for (String space : listspaces) {
                spaces.add(this.getSpace(space));
            }
        }
        return spaces;
    }

    @Override
    public List<UserBean> getUsers(String roomId) {
        if (roomId.indexOf("space-") == 0) {
            roomId = roomId.substring("space-".length());
        }
        if (roomId.indexOf("team-") == 0) {
            roomId = roomId.substring("team-".length());
        }
        ArrayList<UserBean> users2 = new ArrayList<UserBean>();
        DBCollection coll = this.db().getCollection("users");
        BasicDBObject spaces = new BasicDBObject("spaces", (Object)roomId);
        BasicDBObject teams = new BasicDBObject("teams", (Object)roomId);
        ArrayList<BasicDBObject> orList = new ArrayList<BasicDBObject>();
        orList.add(spaces);
        orList.add(teams);
        BasicDBObject query = new BasicDBObject("$or", orList);
        DBCursor cursor = coll.find((DBObject)query);
        while (cursor.hasNext()) {
            DBObject doc = cursor.next();
            UserBean userBean = new UserBean();
            userBean.setName(doc.get("user").toString());
            Object prop = doc.get("fullname");
            userBean.setFullname(prop != null ? prop.toString() : "");
            prop = doc.get("email");
            userBean.setEmail(prop != null ? prop.toString() : "");
            prop = doc.get("status");
            userBean.setStatus(prop != null ? prop.toString() : "");
            users2.add(userBean);
        }
        return users2;
    }

    @Override
    public List<UserBean> getUsersInRoomChatOneToOne(String roomId) {
        ArrayList<UserBean> users2 = new ArrayList<UserBean>();
        DBCollection coll = this.db().getCollection("room_rooms");
        BasicDBObject query = new BasicDBObject();
        query.put("_id", (Object)roomId);
        DBCursor cursor = coll.find((DBObject)query);
        while (cursor.hasNext()) {
            DBObject doc = cursor.next();
            Object objectUsers = doc.get("users");
            ArrayList myArrayList = (ArrayList)objectUsers;
            for (int i = 0; i < myArrayList.size(); ++i) {
                users2.add(this.getUser(myArrayList.get(i).toString()));
            }
        }
        return users2;
    }

    @Override
    public List<UserBean> getUsers(String filter, boolean fullBean) {
        filter = filter.replaceAll(" ", ".*");
        ArrayList<UserBean> users2 = new ArrayList<UserBean>();
        DBCollection coll = this.db().getCollection("users");
        Pattern regex = Pattern.compile(filter, 2);
        BasicDBObject un = new BasicDBObject("user", (Object)regex);
        BasicDBObject fn = new BasicDBObject("fullname", (Object)regex);
        ArrayList<BasicDBObject> orList = new ArrayList<BasicDBObject>();
        orList.add(un);
        orList.add(fn);
        BasicDBObject query = new BasicDBObject("$or", orList);
        DBCursor cursor = coll.find((DBObject)query);
        while (cursor.hasNext()) {
            DBObject doc = cursor.next();
            UserBean userBean = new UserBean();
            userBean.setName(doc.get("user").toString());
            Object prop = doc.get("fullname");
            userBean.setFullname(prop != null ? prop.toString() : "");
            prop = doc.get("email");
            userBean.setEmail(prop != null ? prop.toString() : "");
            prop = doc.get("status");
            userBean.setStatus(prop != null ? prop.toString() : "");
            users2.add(userBean);
        }
        return users2;
    }

    @Override
    public String setStatus(String user, String status) {
        DBCollection coll = this.db().getCollection("users");
        BasicDBObject query = new BasicDBObject();
        query.put("user", (Object)user);
        DBCursor cursor = coll.find((DBObject)query);
        if (cursor.hasNext()) {
            DBObject doc = cursor.next();
            doc.put("status", (Object)status);
            coll.save(doc, WriteConcern.SAFE);
        } else {
            BasicDBObject doc = new BasicDBObject();
            doc.put("_id", (Object)user);
            doc.put("user", (Object)user);
            doc.put("status", (Object)status);
            coll.insert(new DBObject[]{doc});
        }
        return status;
    }

    @Override
    public void setAsAdmin(String user, boolean isAdmin) {
        DBCollection coll = this.db().getCollection("users");
        BasicDBObject query = new BasicDBObject();
        query.put("user", (Object)user);
        DBCursor cursor = coll.find((DBObject)query);
        if (cursor.hasNext()) {
            DBObject doc = cursor.next();
            doc.put("isSupportAdmin", (Object)isAdmin);
            coll.save(doc, WriteConcern.SAFE);
        } else {
            BasicDBObject doc = new BasicDBObject();
            doc.put("_id", (Object)user);
            doc.put("user", (Object)user);
            doc.put("isSupportAdmin", (Object)isAdmin);
            coll.insert(new DBObject[]{doc});
        }
    }

    @Override
    public boolean isAdmin(String user) {
        DBCollection coll = this.db().getCollection("users");
        BasicDBObject query = new BasicDBObject();
        query.put("user", (Object)user);
        DBCursor cursor = coll.find((DBObject)query);
        if (cursor.hasNext()) {
            DBObject doc = cursor.next();
            Object isAdmin = doc.get("isSupportAdmin");
            return isAdmin != null && "true".equals(isAdmin.toString());
        }
        return false;
    }

    @Override
    public String getStatus(String user) {
        DBObject doc;
        String status = "none";
        DBCollection coll = this.db().getCollection("users");
        BasicDBObject query = new BasicDBObject();
        query.put("user", (Object)user);
        DBCursor cursor = coll.find((DBObject)query);
        status = cursor.hasNext() ? ((doc = cursor.next()).containsField("status") ? doc.get("status").toString() : this.setStatus(user, "available")) : this.setStatus(user, "available");
        return status;
    }

    @Override
    public String getUserFullName(String user) {
        DBObject doc;
        String fullname = null;
        DBCollection coll = this.db().getCollection("users");
        BasicDBObject query = new BasicDBObject();
        query.put("user", (Object)user);
        DBCursor cursor = coll.find((DBObject)query);
        if (cursor.hasNext() && (doc = cursor.next()).get("fullname") != null) {
            fullname = doc.get("fullname").toString();
        }
        return fullname;
    }

    @Override
    public UserBean getUser(String user) {
        return this.getUser(user, false);
    }

    @Override
    public UserBean getUser(String user, boolean withFavorites) {
        UserBean userBean = new UserBean();
        DBCollection coll = this.db().getCollection("users");
        BasicDBObject query = new BasicDBObject();
        query.put("user", (Object)user);
        DBCursor cursor = coll.find((DBObject)query);
        if (cursor.hasNext()) {
            DBObject doc = cursor.next();
            userBean.setName(user);
            if (doc.get("fullname") != null) {
                userBean.setFullname(doc.get("fullname").toString());
            }
            if (doc.get("email") != null) {
                userBean.setEmail(doc.get("email").toString());
            }
            if (doc.get("status") != null) {
                userBean.setStatus(doc.get("status").toString());
            }
            if (withFavorites && doc.containsField("favorites")) {
                userBean.setFavorites((List)doc.get("favorites"));
            }
        }
        return userBean;
    }

    @Override
    public List<String> getUsersFilterBy(String user, String room, String type) {
        ArrayList<String> users2 = new ArrayList<String>();
        DBCollection coll = this.db().getCollection("users");
        BasicDBObject query = new BasicDBObject();
        if ("s".equals(type)) {
            query.put("spaces", (Object)room);
        } else {
            query.put("teams", (Object)room);
        }
        DBCursor cursor = coll.find((DBObject)query);
        while (cursor.hasNext()) {
            DBObject doc = cursor.next();
            String target = doc.get("user").toString();
            if (user != null && user.equals(target)) continue;
            users2.add(target);
        }
        return users2;
    }

    @Override
    public int getNumberOfUsers() {
        DBCollection coll = this.db().getCollection("users");
        BasicDBObject query = new BasicDBObject();
        DBCursor cursor = coll.find((DBObject)query);
        return cursor.count();
    }
}

