/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.chat.services.mongodb;

import com.mongodb.BasicDBObject;
import com.mongodb.DB;
import com.mongodb.DBCollection;
import com.mongodb.DBCursor;
import com.mongodb.DBObject;
import java.util.ArrayList;
import java.util.List;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Named;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.chat.listener.ConnectionManager;
import org.exoplatform.chat.model.NotificationBean;
import org.exoplatform.chat.model.RoomBean;
import org.exoplatform.chat.services.NotificationService;
import org.exoplatform.chat.services.UserService;

@Named(value="notificationService")
@ApplicationScoped
public class NotificationServiceImpl
implements NotificationService {
    private DB db(String dbName) {
        if (StringUtils.isEmpty((CharSequence)dbName)) {
            return ConnectionManager.getInstance().getDB();
        }
        return ConnectionManager.getInstance().getDB(dbName);
    }

    public static void cleanupNotifications() {
        DBCollection coll = ConnectionManager.getInstance().getDB().getCollection("notifications");
        BasicDBObject query = new BasicDBObject();
        query.put((Object)"timestamp", (Object)new BasicDBObject("$lt", (Object)(System.currentTimeMillis() - 86400000L)));
        DBCursor cursor = coll.find((DBObject)query);
        while (cursor.hasNext()) {
            DBObject doc = cursor.next();
            coll.remove(doc);
        }
    }

    @Override
    public void addNotification(String user, String from, String type, String category, String categoryId, String content, String link, String dbName) {
        this.addNotification(user, from, type, category, categoryId, content, link, null, dbName);
    }

    @Override
    public void addNotification(String user, String from, String type, String category, String categoryId, String content, String link, String options, String dbName) {
        if (options != null && (options.contains("call-on") || options.contains("call-off") || options.contains("call-proceed"))) {
            return;
        }
        DBCollection coll = this.db(dbName).getCollection("notifications");
        BasicDBObject doc = new BasicDBObject();
        content = StringUtils.chomp((String)content);
        content = content.replaceAll("&", "&#38");
        content = content.replaceAll("<", "&lt;");
        content = content.replaceAll(">", "&gt;");
        content = content.replaceAll("\"", "&quot;");
        content = content.replaceAll("\n", "<br/>");
        content = content.replaceAll("\\\\", "&#92");
        content = content.replaceAll("\t", "  ");
        doc.put((Object)"timestamp", (Object)System.currentTimeMillis());
        doc.put((Object)"user", (Object)user);
        doc.put((Object)"from", (Object)from);
        doc.put((Object)"type", (Object)type);
        doc.put((Object)"category", (Object)category);
        doc.put((Object)"categoryId", (Object)categoryId);
        doc.put((Object)"content", (Object)content);
        if (options != null) {
            options = options.replaceAll("<", "&lt;");
            options = options.replaceAll(">", "&gt;");
            options = options.replaceAll("'", "\\\\\"");
            doc.put((Object)"options", (Object)options);
        }
        doc.put((Object)"link", (Object)link);
        doc.put((Object)"isRead", (Object)false);
        coll.insert(new DBObject[]{doc});
    }

    @Override
    public void setNotificationsAsRead(String user, String type, String category, String categoryId, String dbName) {
        DBCollection coll = this.db(dbName).getCollection("notifications");
        BasicDBObject query = new BasicDBObject();
        query.put((Object)"user", (Object)user);
        if (categoryId != null) {
            query.put((Object)"categoryId", (Object)categoryId);
        }
        if (category != null) {
            query.put((Object)"category", (Object)category);
        }
        if (type != null) {
            query.put((Object)"type", (Object)type);
        }
        coll.remove((DBObject)query);
    }

    @Override
    public List<NotificationBean> getUnreadNotifications(String user, UserService userService, String dbName) {
        return this.getUnreadNotifications(user, userService, null, null, null, dbName);
    }

    @Override
    public List<NotificationBean> getUnreadNotifications(String user, UserService userService, String type, String category, String categoryId, String dbName) {
        ArrayList<NotificationBean> notifications = new ArrayList<NotificationBean>();
        DBCollection coll = this.db(dbName).getCollection("notifications");
        BasicDBObject query = new BasicDBObject();
        query.put((Object)"user", (Object)user);
        if (type != null) {
            query.put((Object)"type", (Object)type);
        }
        if (category != null) {
            query.put((Object)"category", (Object)category);
        }
        if (categoryId != null) {
            query.put((Object)"categoryId", (Object)categoryId);
        }
        DBCursor cursor = coll.find((DBObject)query);
        while (cursor.hasNext()) {
            RoomBean roomBean;
            DBObject doc = cursor.next();
            NotificationBean notificationBean = new NotificationBean();
            notificationBean.setTimestamp((Long)doc.get("timestamp"));
            notificationBean.setUser(user);
            if (doc.containsField("from")) {
                notificationBean.setFrom(doc.get("from").toString());
                notificationBean.setFromFullName(userService.getUser(notificationBean.getFrom(), dbName).getFullname());
            }
            notificationBean.setCategory(doc.get("category").toString());
            notificationBean.setCategoryId(doc.get("categoryId").toString());
            notificationBean.setType(doc.get("type").toString());
            notificationBean.setContent(doc.get("content").toString());
            if (doc.containsField("options")) {
                notificationBean.setOptions(doc.get("options").toString());
            }
            if ((roomBean = userService.getRoom(user, notificationBean.getCategoryId(), dbName)).isSpace() || roomBean.isTeam()) {
                notificationBean.setRoomDisplayName(roomBean.getFullname());
            }
            notificationBean.setLink(doc.get("link").toString());
            notifications.add(notificationBean);
        }
        return notifications;
    }

    @Override
    public int getUnreadNotificationsTotal(String user, String dbName) {
        return this.getUnreadNotificationsTotal(user, null, null, null, dbName);
    }

    @Override
    public int getUnreadNotificationsTotal(String user, String type, String category, String categoryId, String dbName) {
        int total = -1;
        DBCollection coll = this.db(dbName).getCollection("notifications");
        BasicDBObject query = new BasicDBObject();
        query.put((Object)"user", (Object)user);
        if (type != null) {
            query.put((Object)"type", (Object)type);
        }
        if (category != null) {
            query.put((Object)"category", (Object)category);
        }
        if (categoryId != null) {
            query.put((Object)"categoryId", (Object)categoryId);
        }
        DBCursor cursor = coll.find((DBObject)query);
        total = cursor.size();
        return total;
    }

    @Override
    public int getNumberOfNotifications(String dbName) {
        DBCollection coll = this.db(dbName).getCollection("notifications");
        BasicDBObject query = new BasicDBObject();
        DBCursor cursor = coll.find((DBObject)query);
        return cursor.count();
    }

    @Override
    public int getNumberOfUnreadNotifications(String dbName) {
        DBCollection coll = this.db(dbName).getCollection("notifications");
        BasicDBObject query = new BasicDBObject();
        DBCursor cursor = coll.find((DBObject)query);
        return cursor.count();
    }
}

