/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.chat.utils;

import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Properties;
import java.util.logging.Logger;
import org.apache.commons.lang3.StringUtils;

public class PropertyManager {
    private static final Logger LOG = Logger.getLogger(PropertyManager.class.getName());
    private static Properties properties;
    public static final String PROPERTIES_PATH;
    public static final String PROPERTY_SYSTEM_PREFIX = "chat.";
    public static final String EXO_PROPERTY_SYSTEM_PREFIX = "exo.";
    public static final String PROPERTY_SERVICES_IMPLEMENTATION = "servicesImplementation";
    public static final String PROPERTY_SERVER_TYPE = "dbServerType";
    public static final String PROPERTY_SERVER_HOST = "dbServerHost";
    public static final String PROPERTY_SERVER_PORT = "dbServerPort";
    public static final String PROPERTY_DB_NAME = "dbName";
    public static final String PROPERTY_DB_AUTHENTICATION = "dbAuthentication";
    public static final String PROPERTY_DB_USER = "dbUser";
    public static final String PROPERTY_DB_PASSWORD = "dbPassword";
    public static final String PROPERTY_CHAT_SERVER_BASE = "chatServerBase";
    public static final String PROPERTY_CHAT_SERVER_URL = "chatServerUrl";
    public static final String PROPERTY_CHAT_PORTAL_PAGE = "chatPortalPage";
    public static final String PROPERTY_INTERVAL_CHAT = "chatIntervalChat";
    public static final String PROPERTY_INTERVAL_SESSION = "chatIntervalSession";
    public static final String PROPERTY_INTERVAL_STATUS = "chatIntervalStatus";
    public static final String PROPERTY_INTERVAL_NOTIF = "chatIntervalNotif";
    public static final String PROPERTY_INTERVAL_USERS = "chatIntervalUsers";
    public static final String PROPERTY_PASSPHRASE = "chatPassPhrase";
    public static final String PROPERTY_CRON_NOTIF_CLEANUP = "chatCronNotifCleanup";
    public static final String PROPERTY_PUBLIC_MODE = "publicMode";
    public static final String PROPERTY_PUBLIC_ADMIN_GROUP = "publicAdminGroup";
    public static final String PROPERTY_TEAM_ADMIN_GROUP = "teamAdminGroup";
    public static final String PROPERTY_TOKEN_VALIDITY = "chatTokenValidity";
    public static final String PROPERTY_READ_DAYS = "chatReadDays";
    public static final String PROPERTY_READ_TOTAL_JSON = "chatReadTotalJson";
    public static final String PROPERTY_READ_TOTAL_TXT = "chatReadTotalTxt";
    public static final String PROPERTY_SERVER_TYPE_EMBED = "embed";
    public static final String PROPERTY_SERVER_TYPE_MONGO = "mongo";
    public static final String PROPERTY_SERVICE_IMPL_MONGO = "mongo";
    public static final String PROPERTY_SERVICE_IMPL_JCR = "jcr";
    public static final String PROPERTY_MAIL_PROTOCAL = "email.smtp.protocal";
    public static final String PROPERTY_MAIL_HOST = "email.smtp.host";
    public static final String PROPERTY_MAIL_PORT = "email.smtp.port";
    public static final String PROPERTY_MAIL_USER = "email.smtp.username";
    public static final String PROPERTY_MAIL_PASSWORD = "email.smtp.password";
    public static final String PROPERTY_MAIL_FROM = "email.smtp.from";
    public static final String PROPERTY_MAIL_STARTTLS_ENABLE = "email.smtp.starttls.enable";
    public static final String PROPERTY_MAIL_ENABLE_SSL_ENABLE = "email.smtp.EnableSSL.enable";
    public static final String PROPERTY_MAIL_AUTH = "email.smtp.auth";
    public static final String PROPERTY_MAIL_SOCKET_FACTORY_PORT = "email.smtp.socketFactory.port";
    public static final String PROPERTY_MAIL_SOCKET_FACTORY_CLASS = "email.smtp.socketFactory.class";
    public static final String PROPERTY_MAIL_SOCKET_FACTORY_FALLBACK = "email.smtp.socketFactory.fallback";
    public static final String PROPERTY_MAIL_SENDER = "email.smtp.from";
    public static final String PROPERTY_MAIL_SHOW_RECIPIENTS_ENABLE = "email.smtp.show.recipients.enable";
    public static final String PROPERTY_PLF_USER_STATUS_UPDATE_URL = "plfUsrStatUpdUrl";

    public static String getProperty(String key) {
        String value = (String)PropertyManager.properties().get(key);
        return value;
    }

    private static synchronized Properties properties() {
        if (properties == null) {
            properties = new Properties();
            FileInputStream stream = null;
            try {
                stream = new FileInputStream(PROPERTIES_PATH);
                properties.load(stream);
                ((InputStream)stream).close();
            }
            catch (Exception e) {
                LOG.warning(e.getMessage());
            }
            PropertyManager.overridePropertyIfNotSet(PROPERTY_SERVICES_IMPLEMENTATION, "mongo");
            PropertyManager.overridePropertyIfNotSet(PROPERTY_SERVER_TYPE, "mongo");
            PropertyManager.overridePropertyIfNotSet(PROPERTY_SERVER_HOST, "localhost");
            PropertyManager.overridePropertyIfNotSet(PROPERTY_SERVER_PORT, "27017");
            PropertyManager.overridePropertyIfNotSet(PROPERTY_DB_NAME, "chat");
            PropertyManager.overridePropertyIfNotSet(PROPERTY_DB_AUTHENTICATION, "false");
            PropertyManager.overridePropertyIfNotSet(PROPERTY_DB_USER, "");
            PropertyManager.overridePropertyIfNotSet(PROPERTY_DB_PASSWORD, "");
            PropertyManager.overridePropertyIfNotSet(PROPERTY_CHAT_SERVER_BASE, "");
            PropertyManager.overridePropertyIfNotSet(PROPERTY_CHAT_SERVER_URL, "/chatServer");
            PropertyManager.overridePropertyIfNotSet(PROPERTY_CHAT_PORTAL_PAGE, "/portal/intranet/chat");
            PropertyManager.overridePropertyIfNotSet(PROPERTY_INTERVAL_CHAT, "5000");
            PropertyManager.overridePropertyIfNotSet(PROPERTY_INTERVAL_SESSION, "60000");
            PropertyManager.overridePropertyIfNotSet(PROPERTY_INTERVAL_STATUS, "60000");
            PropertyManager.overridePropertyIfNotSet(PROPERTY_INTERVAL_NOTIF, "5000");
            PropertyManager.overridePropertyIfNotSet(PROPERTY_INTERVAL_USERS, "60000");
            PropertyManager.overridePropertyIfNotSet(PROPERTY_PASSPHRASE, "chat");
            PropertyManager.overridePropertyIfNotSet(PROPERTY_CRON_NOTIF_CLEANUP, "0 0/60 * * * ?");
            PropertyManager.overridePropertyIfNotSet(PROPERTY_PUBLIC_MODE, "false");
            PropertyManager.overridePropertyIfNotSet(PROPERTY_PUBLIC_ADMIN_GROUP, "/platform/administrators");
            PropertyManager.overridePropertyIfNotSet(PROPERTY_TEAM_ADMIN_GROUP, "/platform/users");
            PropertyManager.overridePropertyIfNotSet(PROPERTY_TOKEN_VALIDITY, "60000");
            PropertyManager.overridePropertyIfNotSet(PROPERTY_READ_DAYS, "30");
            PropertyManager.overridePropertyIfNotSet(PROPERTY_READ_TOTAL_JSON, "200");
            PropertyManager.overridePropertyIfNotSet(PROPERTY_READ_TOTAL_TXT, "2000");
            PropertyManager.overridePropertyIfNotSet(PROPERTY_MAIL_PROTOCAL, "smtp");
            PropertyManager.overridePropertyIfNotSet(PROPERTY_MAIL_HOST, "localhost");
            PropertyManager.overridePropertyIfNotSet(PROPERTY_MAIL_PORT, "25");
            PropertyManager.overridePropertyIfNotSet(PROPERTY_MAIL_USER, "");
            PropertyManager.overridePropertyIfNotSet(PROPERTY_MAIL_PASSWORD, "");
            PropertyManager.overridePropertyIfNotSet("email.smtp.from", "eXo Platform");
            PropertyManager.overridePropertyIfNotSet(PROPERTY_MAIL_STARTTLS_ENABLE, "false");
            PropertyManager.overridePropertyIfNotSet(PROPERTY_MAIL_ENABLE_SSL_ENABLE, "true");
            PropertyManager.overridePropertyIfNotSet(PROPERTY_MAIL_AUTH, "false");
            PropertyManager.overridePropertyIfNotSet(PROPERTY_MAIL_SOCKET_FACTORY_PORT, "");
            PropertyManager.overridePropertyIfNotSet(PROPERTY_MAIL_SOCKET_FACTORY_CLASS, "");
            PropertyManager.overridePropertyIfNotSet(PROPERTY_MAIL_SOCKET_FACTORY_FALLBACK, "false");
            PropertyManager.overridePropertyIfNotSet("email.smtp.from", "chat@localhost.com");
            PropertyManager.overridePropertyIfNotSet(PROPERTY_MAIL_SHOW_RECIPIENTS_ENABLE, "false");
            PropertyManager.overridePropertyIfNotSet(PROPERTY_PLF_USER_STATUS_UPDATE_URL, "/rest/state/status/");
        }
        return properties;
    }

    private static void overridePropertyIfNotSet(String key, String value) {
        if (PropertyManager.properties().getProperty(key) == null) {
            PropertyManager.properties().setProperty(key, value);
        }
        if (System.getProperty(PROPERTY_SYSTEM_PREFIX + key) != null) {
            PropertyManager.properties().setProperty(key, System.getProperty(PROPERTY_SYSTEM_PREFIX + key));
        }
        if (System.getProperty(EXO_PROPERTY_SYSTEM_PREFIX + key) != null) {
            PropertyManager.properties().setProperty(key, System.getProperty(EXO_PROPERTY_SYSTEM_PREFIX + key));
        }
    }

    public static void overrideProperty(String key, String value) {
        PropertyManager.properties().setProperty(key, value);
    }

    static {
        String chatConf = System.getProperty("exo.chat.conf");
        if (StringUtils.isNotEmpty((CharSequence)chatConf)) {
            PROPERTIES_PATH = chatConf;
        } else {
            String exoConfDir = System.getProperty("exo.conf.dir");
            String tomcatConfDir = System.getProperty("catalina.base");
            String jbossConfDir = System.getProperty("jboss.server.config.dir");
            if (StringUtils.isNotEmpty((CharSequence)exoConfDir)) {
                PROPERTIES_PATH = exoConfDir + "/chat.properties";
            } else if (StringUtils.isNotEmpty((CharSequence)tomcatConfDir)) {
                PROPERTIES_PATH = tomcatConfDir + "/conf/chat.properties";
            } else if (StringUtils.isNotEmpty((CharSequence)jbossConfDir)) {
                PROPERTIES_PATH = jbossConfDir + "/chat.properties";
            } else {
                LOG.warning("Impossible to get the path of chat.properties. Use the current folder.");
                PROPERTIES_PATH = "./chat.properties";
            }
        }
    }
}

