/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.chat.server;

import com.mongodb.BasicDBList;
import com.mongodb.BasicDBObject;
import com.mongodb.util.JSON;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLDecoder;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.mail.Address;
import javax.mail.Authenticator;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.Multipart;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.mail.util.ByteArrayDataSource;
import juzu.MimeType;
import juzu.Path;
import juzu.Resource;
import juzu.Response;
import juzu.Route;
import juzu.View;
import juzu.impl.common.Tools;
import juzu.request.ApplicationContext;
import juzu.request.UserContext;
import juzu.template.Template;
import org.exoplatform.chat.listener.GuiceManager;
import org.exoplatform.chat.model.MessageBean;
import org.exoplatform.chat.model.NotificationBean;
import org.exoplatform.chat.model.RealTimeMessageBean;
import org.exoplatform.chat.model.ReportBean;
import org.exoplatform.chat.model.RoomBean;
import org.exoplatform.chat.model.RoomsBean;
import org.exoplatform.chat.model.SpaceBean;
import org.exoplatform.chat.model.UserBean;
import org.exoplatform.chat.model.UsersBean;
import org.exoplatform.chat.server.ChatTools;
import org.exoplatform.chat.services.ChatException;
import org.exoplatform.chat.services.ChatService;
import org.exoplatform.chat.services.NotificationService;
import org.exoplatform.chat.services.RealTimeMessageService;
import org.exoplatform.chat.services.TokenService;
import org.exoplatform.chat.services.UserService;
import org.exoplatform.chat.utils.ChatUtils;
import org.exoplatform.chat.utils.PropertyManager;
import org.exoplatform.commons.utils.HTMLSanitizer;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.identity.model.Profile;
import org.exoplatform.social.notification.LinkProviderUtils;
import org.exoplatform.social.notification.Utils;
import org.json.JSONException;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

@ApplicationScoped
public class ChatServer {
    private static final Logger LOG = Logger.getLogger("ChatServer");
    @Inject
    @Path(value="index.gtmpl")
    Template index;
    @Inject
    @Path(value="users.gtmpl")
    Template users;
    ChatService chatService = (ChatService)GuiceManager.getInstance().getInstance(ChatService.class);
    UserService userService = (UserService)GuiceManager.getInstance().getInstance(UserService.class);
    TokenService tokenService = (TokenService)GuiceManager.getInstance().getInstance(TokenService.class);
    NotificationService notificationService = (NotificationService)GuiceManager.getInstance().getInstance(NotificationService.class);
    RealTimeMessageService realTimeMessageService = (RealTimeMessageService)GuiceManager.getInstance().getInstance(RealTimeMessageService.class);
    @Inject
    ChatTools chatTools;

    @View
    @Route(value="/")
    public Response.Content index() throws IOException {
        return this.index.ok();
    }

    @Resource
    @Route(value="/whoIsOnline")
    public Response.Content whoIsOnline(String user, String token, String filter, String isAdmin, String limit, String dbName) {
        if (!this.tokenService.hasUserWithToken(user, token, dbName)) {
            return Response.notFound((CharSequence)"Petit malin !");
        }
        Integer ilimit = 0;
        try {
            if (limit != null && !"".equals(limit)) {
                ilimit = Integer.parseInt(limit);
            }
        }
        catch (NumberFormatException nfe) {
            LOG.info("limit is not a valid Integer number");
        }
        RoomsBean roomsBean = this.chatService.getRooms(user, filter, true, true, false, true, "true".equals(isAdmin), ilimit, this.notificationService, this.tokenService, dbName);
        return Response.ok((CharSequence)roomsBean.roomsToJSON()).withMimeType("application/json").withHeader("Cache-Control", new String[]{"no-cache"}).withCharset(Tools.UTF_8);
    }

    @Resource
    @Route(value="/send")
    public Response.Content send(String sender, String token, String targetUser, String message, String room, String isSystem, String options, String dbName) throws IOException {
        if (!this.tokenService.hasUserWithToken(sender, token, dbName)) {
            return Response.notFound((CharSequence)"Petit malin !");
        }
        if (message != null) {
            try {
                message = URLDecoder.decode(message, "UTF-8");
                options = URLDecoder.decode(options, "UTF-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
            try {
                this.chatService.write(message, sender, room, isSystem, options, dbName, targetUser);
            }
            catch (ChatException e) {
                return Response.content((int)e.getStatus(), (CharSequence)e.getMessage());
            }
        }
        return Response.ok((CharSequence)"ok").withMimeType("application/json; charset=UTF-8").withHeader("Cache-Control", new String[]{"no-cache"});
    }

    @Resource
    @Route(value="/read")
    public Response.Content read(String user, String token, String room, String fromTimestamp, String isTextOnly, String dbName) throws IOException {
        if (!this.tokenService.hasUserWithToken(user, token, dbName)) {
            return Response.notFound((CharSequence)"Petit malin !");
        }
        Long from = null;
        try {
            if (fromTimestamp != null && !fromTimestamp.isEmpty()) {
                from = Long.parseLong(fromTimestamp);
            }
        }
        catch (NumberFormatException nfe) {
            LOG.info("fromTimestamp is not a valid Long number");
        }
        String data = null;
        try {
            data = this.chatService.read(user, room, "true".equals(isTextOnly), from, dbName);
        }
        catch (ChatException e) {
            return Response.content((int)e.getStatus(), (CharSequence)e.getMessage());
        }
        this.notificationService.setNotificationsAsRead(user, "chat", "room", room, dbName);
        return Response.ok((CharSequence)data).withMimeType("application/json").withHeader("Cache-Control", new String[]{"no-cache"}).withCharset(Tools.UTF_8);
    }

    /*
     * WARNING - void declaration
     */
    @Resource
    @Route(value="/sendMeetingNotes")
    public Response.Content sendMeetingNotes(String user, String token, String room, String fromTimestamp, String toTimestamp, String serverBase, String dbName, ApplicationContext applicationContext, UserContext userContext) throws IOException {
        if (!this.tokenService.hasUserWithToken(user, token, dbName)) {
            return Response.notFound((CharSequence)"Petit malin !");
        }
        Long from = null;
        Long to = null;
        try {
            if (fromTimestamp != null && !"".equals(fromTimestamp)) {
                from = Long.parseLong(fromTimestamp);
            }
        }
        catch (NumberFormatException nfe) {
            LOG.info("fromTimestamp is not a valid Long number");
        }
        try {
            if (toTimestamp != null && !"".equals(toTimestamp)) {
                to = Long.parseLong(toTimestamp);
            }
        }
        catch (NumberFormatException nfe) {
            LOG.info("fromTimestamp is not a valid Long number");
        }
        String data = this.chatService.read(user, room, false, from, to, dbName);
        BasicDBObject datao = (BasicDBObject)JSON.parse((String)data);
        String roomType = this.chatService.getTypeRoomChat(room, dbName);
        SimpleDateFormat formatter = new SimpleDateFormat("dd/MM/yyyy");
        String date = formatter.format(new GregorianCalendar().getTime());
        String title = "";
        String roomName = "";
        ArrayList<UserBean> users2 = new ArrayList();
        Locale locale = userContext.getLocale();
        ResourceBundle res = applicationContext.resolveBundle(locale);
        if (datao.containsField("messages")) {
            if ("u".equalsIgnoreCase(roomType)) {
                users2 = this.userService.getUsersInRoomChatOneToOne(room, dbName);
                title = res.getString("exoplatform.chat.meetingnotes") + " [" + date + "]";
            } else {
                users2 = this.userService.getUsers(room, dbName);
                List<SpaceBean> spaces = this.userService.getSpaces(user, dbName);
                for (SpaceBean spaceBean : spaces) {
                    if (!room.equals(spaceBean.getRoom())) continue;
                    roomName = spaceBean.getDisplayName();
                }
                List<RoomBean> roomBeans = this.userService.getTeams(user, dbName);
                for (RoomBean roomBean : roomBeans) {
                    if (!room.equals(roomBean.getRoom())) continue;
                    roomName = roomBean.getFullName();
                }
                title = roomName + " : " + res.getString("exoplatform.chat.meetingnotes") + " [" + date + "]";
            }
            ReportBean reportBean = new ReportBean(res);
            reportBean.fill((BasicDBList)datao.get("messages"), users2);
            ArrayList<String> tos = new ArrayList<String>();
            String string = user;
            String senderMail = "";
            for (UserBean userBean : users2) {
                if (!"".equals(userBean.getEmail())) {
                    tos.add(userBean.getEmail());
                }
                if (!user.equals(userBean.getName())) continue;
                String string2 = userBean.getFullname();
                senderMail = userBean.getEmail();
            }
            String html = reportBean.getAsHtml(title, serverBase, locale);
            String prevUser = "";
            int index2 = 0;
            HashMap<String, String> inlineImages = new HashMap<String, String>();
            for (MessageBean messageBean : reportBean.getMessages()) {
                if (!messageBean.getUser().equals(prevUser)) {
                    String keyAvatar = messageBean.getUser() + index2;
                    Identity identity = Utils.getIdentityManager().getOrCreateIdentity("organization", messageBean.getUser(), true);
                    String getAvatarUrl = LinkProviderUtils.getUserAvatarUrl((Profile)identity.getProfile());
                    inlineImages.put(keyAvatar, getAvatarUrl);
                    ++index2;
                }
                prevUser = messageBean.getUser();
            }
            try {
                void var24_29;
                this.sendMailWithAuth((String)var24_29, senderMail, tos, html.toString(), title, inlineImages);
            }
            catch (Exception e) {
                LOG.info(e.getMessage());
            }
        }
        return Response.ok((CharSequence)"sent").withMimeType("text/event-stream; charset=UTF-8").withHeader("Cache-Control", new String[]{"no-cache"});
    }

    @Resource
    @Route(value="/getMeetingNotes")
    public Response.Content getMeetingNotes(String user, String token, String room, String fromTimestamp, String toTimestamp, String serverBase, String dbName, String portalURI, ApplicationContext applicationContext, UserContext userContext) throws IOException {
        if (!this.tokenService.hasUserWithToken(user, token, dbName)) {
            return Response.notFound((CharSequence)"Petit malin !");
        }
        Long from = null;
        Long to = null;
        String xwiki = "";
        String roomName = "";
        ArrayList<UserBean> users2 = new ArrayList();
        JSONObject jsonObject = new JSONObject();
        try {
            if (fromTimestamp != null && !"".equals(fromTimestamp)) {
                from = Long.parseLong(fromTimestamp);
            }
        }
        catch (NumberFormatException nfe) {
            LOG.info("fromTimestamp is not a valid Long number");
        }
        try {
            if (toTimestamp != null && !"".equals(toTimestamp)) {
                to = Long.parseLong(toTimestamp);
            }
        }
        catch (NumberFormatException nfe) {
            LOG.info("fromTimestamp is not a valid Long number");
        }
        String data = this.chatService.read(user, room, false, from, to, dbName);
        String typeRoom = this.chatService.getTypeRoomChat(room, dbName);
        BasicDBObject datao = (BasicDBObject)JSON.parse((String)data);
        if (datao.containsField("messages")) {
            if ("u".equalsIgnoreCase(typeRoom)) {
                users2 = this.userService.getUsersInRoomChatOneToOne(room, dbName);
            } else {
                users2 = this.userService.getUsers(room, dbName);
                List<SpaceBean> spaces = this.userService.getSpaces(user, dbName);
                for (SpaceBean spaceBean : spaces) {
                    if (!room.equals(spaceBean.getRoom())) continue;
                    roomName = spaceBean.getDisplayName();
                }
                List<RoomBean> roomBeans = this.userService.getTeams(user, dbName);
                for (RoomBean roomBean : roomBeans) {
                    if (!room.equals(roomBean.getRoom())) continue;
                    roomName = roomBean.getFullName();
                }
            }
            Locale locale = userContext.getLocale();
            ResourceBundle res = applicationContext.resolveBundle(locale);
            ReportBean reportBean = new ReportBean(res);
            reportBean.fill((BasicDBList)datao.get("messages"), users2);
            ArrayList<String> usersInGroup = new ArrayList<String>();
            xwiki = reportBean.getAsXWiki(serverBase, portalURI);
            try {
                for (UserBean userBean : users2) {
                    if ("".equals(userBean.getName())) continue;
                    usersInGroup.add(userBean.getName());
                }
                jsonObject.put((Object)"users", usersInGroup);
                jsonObject.put((Object)"xwiki", (Object)xwiki);
                jsonObject.put((Object)"typeRoom", (Object)typeRoom);
            }
            catch (Exception e) {
                LOG.warning(e.getMessage());
                return Response.notFound((CharSequence)"No Room yet");
            }
        }
        return Response.ok((CharSequence)jsonObject.toString()).withMimeType("application/json").withHeader("Cache-Control", new String[]{"no-cache"}).withCharset(Tools.UTF_8);
    }

    @Resource
    @MimeType(value={"text/plain"})
    @Route(value="/delete")
    public Response.Content delete(String user, String token, String room, String messageId, String dbName) throws IOException {
        if (!this.tokenService.hasUserWithToken(user, token, dbName)) {
            return Response.notFound((CharSequence)"Petit malin !");
        }
        MessageBean message = this.chatService.getMessage(room, messageId, dbName);
        if (message == null || !message.getUser().equals(user)) {
            return Response.notFound((CharSequence)"");
        }
        try {
            this.chatService.delete(room, user, messageId, dbName);
        }
        catch (Exception e) {
            return Response.notFound((CharSequence)"Oups");
        }
        return Response.ok((CharSequence)"Updated!");
    }

    @Resource
    @MimeType(value={"text/plain"})
    @Route(value="/deleteTeamRoom")
    public Response.Content deleteTeamRoom(String user, String token, String room, String dbName) throws IOException {
        if (!this.tokenService.hasUserWithToken(user, token, dbName)) {
            return Response.notFound((CharSequence)"Petit malin !");
        }
        try {
            this.chatService.deleteTeamRoom(room, user, dbName);
        }
        catch (Exception e) {
            LOG.log(Level.SEVERE, "Impossible to delete Team Room [" + room + "] : " + e.getMessage(), e);
            return Response.content((int)500, (CharSequence)"Oups!");
        }
        return Response.ok((CharSequence)"Updated!");
    }

    @Resource
    @MimeType(value={"text/plain"})
    @Route(value="/edit")
    public Response.Content edit(String user, String token, String room, String messageId, String message, String dbName) throws IOException {
        if (!this.tokenService.hasUserWithToken(user, token, dbName)) {
            return Response.notFound((CharSequence)"Petit malin !");
        }
        MessageBean currentMessage = this.chatService.getMessage(room, messageId, dbName);
        if (currentMessage == null || !currentMessage.getUser().equals(user)) {
            return Response.notFound((CharSequence)"");
        }
        try {
            try {
                message = URLDecoder.decode(message, "UTF-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
            this.chatService.edit(room, user, messageId, message, dbName);
        }
        catch (Exception e) {
            return Response.notFound((CharSequence)"Oups");
        }
        return Response.ok((CharSequence)"Updated!");
    }

    @Resource
    @MimeType(value={"text/plain"})
    @Route(value="/toggleFavorite")
    public Response.Content toggleFavorite(String user, String token, String targetUser, String favorite, String dbName) {
        if (!this.tokenService.hasUserWithToken(user, token, dbName)) {
            return Response.notFound((CharSequence)"Petit malin !");
        }
        if (Boolean.valueOf(favorite).booleanValue()) {
            this.userService.addFavorite(user, targetUser, dbName);
        } else {
            this.userService.removeFavorite(user, targetUser, dbName);
        }
        return Response.ok((CharSequence)"Updated!");
    }

    @Resource
    @MimeType(value={"text/plain"})
    @Route(value="/isFavorite")
    public Response.Content isFavorite(String user, String token, String targetUser, String dbName) {
        if (!this.tokenService.hasUserWithToken(user, token, dbName)) {
            return Response.notFound((CharSequence)"Petit malin !");
        }
        boolean isFavorite = false;
        try {
            isFavorite = this.userService.isFavorite(user, targetUser, dbName);
        }
        catch (Exception e) {
            LOG.log(Level.WARNING, e.getMessage());
            return Response.notFound((CharSequence)"Oups");
        }
        return Response.ok((CharSequence)String.valueOf(isFavorite));
    }

    @Resource
    @MimeType(value={"application/json"})
    @Route(value="/getUserDesktopNotificationSettings")
    public Response.Content getUserDesktopNotificationSettings(String user, String token, String dbName) throws JSONException {
        if (!this.tokenService.hasUserWithToken(user, token, dbName)) {
            return Response.notFound((CharSequence)"Something is wrong.");
        }
        JSONObject response = new JSONObject();
        JSONObject res = this.userService.getUserDesktopNotificationSettings(user, dbName).toJSON();
        if (res == null || res.isEmpty()) {
            response.put((Object)"done", (Object)false);
        } else {
            response.put((Object)"done", (Object)true);
        }
        response.put((Object)"userDesktopNotificationSettings", (Object)res);
        return Response.ok((CharSequence)response.toString()).withHeader("Cache-Control", new String[]{"no-cache"}).withCharset(Tools.UTF_8);
    }

    @Resource
    @MimeType(value={"text/plain"})
    @Route(value="/setPreferredNotification")
    public Response.Content setPreferredNotification(String user, String token, String notifManner, String dbName) throws JSONException {
        if (!this.tokenService.hasUserWithToken(user, token, dbName)) {
            return Response.notFound((CharSequence)"Something is wrong.");
        }
        JSONObject response = new JSONObject();
        try {
            this.userService.setPreferredNotification(user, notifManner, dbName);
            response.put((Object)"done", (Object)true);
        }
        catch (Exception e) {
            response.put((Object)"done", (Object)false);
        }
        return Response.ok((CharSequence)response.toString()).withMimeType("application/json").withHeader("Cache-Control", new String[]{"no-cache"}).withCharset(Tools.UTF_8);
    }

    @Resource
    @MimeType(value={"text/plain"})
    @Route(value="/setRoomNotificationTrigger")
    public Response.Content setRoomNotificationTrigger(String user, String token, String room, String notifCondition, String notifConditionType, String dbName, Long time) throws JSONException {
        if (!this.tokenService.hasUserWithToken(user, token, dbName)) {
            return Response.notFound((CharSequence)"Something is wrong.");
        }
        try {
            this.userService.setRoomNotificationTrigger(user, room, notifCondition, notifConditionType, dbName, time);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return Response.ok((CharSequence)"done").withMimeType("application/json").withHeader("Cache-Control", new String[]{"no-cache"}).withCharset(Tools.UTF_8);
    }

    @Resource
    @MimeType(value={"text/plain"})
    @Route(value="/setNotificationTrigger")
    public Response.Content setNotificationTrigger(String user, String token, String notifCondition, String dbName) throws JSONException {
        if (!this.tokenService.hasUserWithToken(user, token, dbName)) {
            return Response.notFound((CharSequence)"Something is wrong.");
        }
        JSONObject response = new JSONObject();
        try {
            this.userService.setNotificationTrigger(user, notifCondition, dbName);
            response.put((Object)"done", (Object)true);
        }
        catch (Exception e) {
            response.put((Object)"done", (Object)false);
        }
        return Response.ok((CharSequence)response.toString()).withMimeType("application/json").withHeader("Cache-Control", new String[]{"no-cache"}).withCharset(Tools.UTF_8);
    }

    @Resource
    @Route(value="/getRoom")
    public Response.Content getRoom(String user, String token, String targetUser, String isAdmin, String withDetail, String type, String dbName) {
        if (!this.tokenService.hasUserWithToken(user, token, dbName)) {
            return Response.notFound((CharSequence)"Petit malin !");
        }
        String room = targetUser;
        RoomBean roomBean = null;
        try {
            if (type != null) {
                if ("room-id".equals(type)) {
                    room = targetUser;
                } else if ("space-name".equals(type)) {
                    room = this.chatService.getSpaceRoomByName(targetUser, dbName);
                } else if ("space-id".equals(type)) {
                    room = ChatUtils.getRoomId(targetUser);
                } else if ("username".equals(type)) {
                    ArrayList<String> users2 = new ArrayList<String>();
                    users2.add(user);
                    users2.add(targetUser);
                    room = this.chatService.getRoom(users2, dbName);
                } else if ("external".equals(type)) {
                    room = this.chatService.getExternalRoom(targetUser, dbName);
                }
            } else if (targetUser.startsWith("space-")) {
                room = this.chatService.getSpaceRoom(targetUser, dbName);
            } else if (targetUser.startsWith("team-")) {
                room = this.chatService.getTeamRoom(targetUser, user, dbName);
            } else if (targetUser.startsWith("external-")) {
                room = this.chatService.getExternalRoom(targetUser, dbName);
            } else {
                String finalUser = "true".equals(isAdmin) && !user.startsWith("__anonim_") && targetUser.startsWith("__anonim_") ? "__support_" : user;
                ArrayList<String> users3 = new ArrayList<String>(2);
                users3.add(finalUser);
                users3.add(targetUser);
                room = this.chatService.getRoom(users3, dbName);
            }
            if ("true".equals(withDetail)) {
                roomBean = this.userService.getRoom(user, room, dbName);
            }
            this.notificationService.setNotificationsAsRead(user, "chat", "room", room, dbName);
        }
        catch (Exception e) {
            LOG.log(Level.WARNING, e.getMessage());
            return Response.notFound((CharSequence)"No Room yet");
        }
        String out = room;
        if (roomBean != null) {
            out = roomBean.toJSON();
        }
        return Response.ok((CharSequence)out).withMimeType("application/json").withCharset(Tools.UTF_8).withHeader("Cache-Control", new String[]{"no-cache"});
    }

    @Resource
    @Route(value="/saveTeamRoom")
    public Response.Content saveTeamRoom(String user, String token, String teamName, String room, String users2, String dbName) {
        if (!this.tokenService.hasUserWithToken(user, token, dbName)) {
            return Response.notFound((CharSequence)"Petit malin !");
        }
        JSONObject jsonObject = new JSONObject();
        try {
            try {
                teamName = URLDecoder.decode(teamName, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                LOG.info("Cannot decode message: " + teamName);
            }
            teamName = HTMLSanitizer.sanitize((String)teamName);
            if ("".equals(teamName)) {
                return Response.content((int)400, (CharSequence)"Data is invalid!");
            }
            if (room == null || "".equals(room) || "---".equals(room)) {
                room = this.chatService.getTeamRoom(teamName, user, dbName);
                this.userService.addTeamUsers(room, Arrays.asList(users2.split(",")), dbName);
            } else {
                String creator = this.chatService.getTeamCreator(room, dbName);
                if (!user.equals(creator)) {
                    return Response.notFound((CharSequence)"Petit malin !");
                }
                if (users2 != null && !users2.isEmpty()) {
                    StringBuilder sbUsers;
                    List<String> existingUsers = this.userService.getUsersFilterBy(null, room, "t", dbName);
                    List<String> usersNew = Arrays.asList(users2.split(","));
                    JSONArray usersToAdd = new JSONArray();
                    usersToAdd.addAll(usersNew);
                    JSONArray usersToRemove = new JSONArray();
                    JSONObject data = new JSONObject();
                    data.put((Object)"title", (Object)teamName);
                    data.put((Object)"members", (Object)usersToAdd);
                    RealTimeMessageBean updatedRoomMessage = new RealTimeMessageBean(RealTimeMessageBean.EventType.ROOM_UPDATED, room, user, null, (Map<String, Object>)data);
                    for (String u : existingUsers) {
                        if (usersNew.contains(u)) {
                            usersToAdd.remove(u);
                            this.realTimeMessageService.sendMessage(updatedRoomMessage, u);
                            continue;
                        }
                        usersToRemove.add(u);
                    }
                    if (usersToRemove.size() > 0) {
                        this.userService.removeTeamUsers(room, (List<String>)usersToRemove, dbName);
                        sbUsers = new StringBuilder();
                        boolean first = true;
                        for (String u : usersToRemove) {
                            if (!first) {
                                sbUsers.append("; ");
                            }
                            sbUsers.append(this.userService.getUserFullName(u, dbName));
                            first = false;
                            this.notificationService.setNotificationsAsRead(u, "chat", "room", room, dbName);
                        }
                        String removeTeamUserOptions = "{\"type\":\"type-remove-team-user\",\"users\":\"" + sbUsers + "\", \"fullname\":\"" + this.userService.getUserFullName(user, dbName) + "\"}";
                        this.send(user, token, "team-" + room, "", room, "true", removeTeamUserOptions, dbName);
                    }
                    this.chatService.setRoomName(room, teamName, dbName);
                    if (usersToAdd.size() > 0) {
                        this.userService.addTeamUsers(room, (List<String>)usersToAdd, dbName);
                        sbUsers = new StringBuilder();
                        boolean first = true;
                        for (String usert : usersToAdd) {
                            if (!first) {
                                sbUsers.append("; ");
                            }
                            sbUsers.append(this.userService.getUserFullName(usert, dbName));
                            first = false;
                        }
                        String addTeamUserOptions = "{\"type\":\"type-add-team-user\",\"users\":\"" + sbUsers + "\", \"fullname\":\"" + this.userService.getUserFullName(user, dbName) + "\"}";
                        this.send(user, token, "team-" + room, "", room, "true", addTeamUserOptions, dbName);
                    }
                }
            }
            jsonObject.put((Object)"name", (Object)teamName);
            jsonObject.put((Object)"room", (Object)room);
        }
        catch (Exception e) {
            LOG.warning(e.getMessage());
            return Response.notFound((CharSequence)"No Room yet");
        }
        return Response.ok((CharSequence)jsonObject.toString()).withMimeType("application/json").withHeader("Cache-Control", new String[]{"no-cache"}).withCharset(Tools.UTF_8);
    }

    @Resource
    @MimeType(value={"text/plain"})
    @Route(value="/updateUnreadMessages")
    public Response.Content updateUnreadMessages(String room, String user, String token, String dbName) {
        if (!this.tokenService.hasUserWithToken(user, token, dbName)) {
            return Response.notFound((CharSequence)"Petit malin !");
        }
        try {
            this.notificationService.setNotificationsAsRead(user, "chat", "room", room, dbName);
            if (this.userService.isAdmin(user, dbName)) {
                this.notificationService.setNotificationsAsRead("__support_", "chat", "room", room, dbName);
            }
        }
        catch (Exception e) {
            LOG.warning(e.getMessage());
            return Response.notFound((CharSequence)"Server Not Available yet");
        }
        return Response.ok((CharSequence)"Updated.");
    }

    @Resource
    @Route(value="/notification")
    public Response.Content notification(String user, String token, String event, String withDetails, String dbName) throws IOException {
        String data;
        if (!this.tokenService.hasUserWithToken(user, token, dbName)) {
            return Response.notFound((CharSequence)"Petit malin !");
        }
        boolean detailed = Boolean.valueOf(withDetails);
        int totalUnread = 0;
        List<NotificationBean> notifications = null;
        if (!detailed) {
            totalUnread = this.notificationService.getUnreadNotificationsTotal(user, dbName);
            if (this.userService.isAdmin(user, dbName)) {
                totalUnread += this.notificationService.getUnreadNotificationsTotal("__support_", dbName);
            }
        } else {
            notifications = this.notificationService.getUnreadNotifications(user, this.userService, dbName);
            totalUnread = notifications.size();
        }
        if (event != null && event.equals("1")) {
            data = "id: " + totalUnread + "\n";
            data = data + "data: {\"total\": " + totalUnread + "}\n\n";
        } else {
            JSONObject json = new JSONObject();
            json.put((Object)"total", (Object)totalUnread);
            if (detailed && notifications != null) {
                JSONArray notifies = new JSONArray();
                for (NotificationBean o : notifications) {
                    notifies.add((Object)o.toJSONObject());
                }
                json.put((Object)"notifications", (Object)notifies);
            }
            data = json.toJSONString();
        }
        return Response.ok((CharSequence)data).withMimeType("application/json").withCharset(Tools.UTF_8).withHeader("Cache-Control", new String[]{"no-cache"});
    }

    @Resource
    @MimeType(value={"text/plain"})
    @Route(value="/getStatus")
    public Response.Content getStatus(String user, String token, String targetUser, String dbName) {
        if (!this.tokenService.hasUserWithToken(user, token, dbName)) {
            return Response.notFound((CharSequence)"Petit malin !");
        }
        String status = "invisible";
        try {
            if (targetUser != null) {
                boolean online = this.tokenService.isUserOnline(targetUser, dbName);
                status = online ? this.userService.getStatus(targetUser, dbName) : "offline";
            }
        }
        catch (Exception e) {
            LOG.warning(e.getMessage());
            return Response.notFound((CharSequence)status);
        }
        return Response.ok((CharSequence)status).withHeader("Cache-Control", new String[]{"no-cache"});
    }

    @Resource
    @MimeType(value={"text/plain"})
    @Route(value="/setStatus")
    public Response.Content setStatus(String user, String token, String status, String dbName) {
        if (!this.tokenService.hasUserWithToken(user, token, dbName)) {
            return Response.notFound((CharSequence)"Petit malin !");
        }
        try {
            this.userService.setStatus(user, status, dbName);
        }
        catch (Exception e) {
            LOG.warning(e.getMessage());
            return Response.notFound((CharSequence)"No Status for this User");
        }
        return Response.ok((CharSequence)status);
    }

    @Resource
    @MimeType(value={"text/plain"})
    @Route(value="/getCreator")
    public Response.Content getCreator(String user, String token, String room, String dbName) {
        String creator = "";
        if (!this.tokenService.hasUserWithToken(user, token, dbName)) {
            return Response.notFound((CharSequence)"Petit malin !");
        }
        try {
            creator = this.chatService.getTeamCreator(room, dbName);
        }
        catch (Exception e) {
            LOG.warning(e.getMessage());
            return Response.notFound((CharSequence)"No Status for this User");
        }
        return Response.ok((CharSequence)creator);
    }

    @Resource
    @Route(value="/users")
    public Response.Content getUsers(String user, String token, String room, String filter, String dbName) {
        if (!this.tokenService.hasUserWithToken(user, token, dbName)) {
            return Response.notFound((CharSequence)"Petit malin !");
        }
        List<UserBean> users2 = room != null && !"".equals(room) ? this.userService.getUsers(room, dbName) : this.userService.getUsers(filter, true, dbName);
        for (UserBean userBean : users2) {
            boolean online = this.tokenService.isUserOnline(userBean.getName(), dbName);
            if (online) continue;
            userBean.setStatus("offline");
        }
        UsersBean usersBean = new UsersBean();
        usersBean.setUsers(users2);
        return Response.ok((CharSequence)usersBean.usersToJSON()).withMimeType("application/json").withHeader("Cache-Control", new String[]{"no-cache"}).withCharset(Tools.UTF_8);
    }

    @Resource
    @Route(value="/statistics")
    public Response.Content getStatistics(String dbName) {
        StringBuffer data = new StringBuffer();
        data.append("{");
        data.append(" \"users\": " + this.userService.getNumberOfUsers(dbName) + ", ");
        data.append(" \"rooms\": " + this.chatService.getNumberOfRooms(dbName) + ", ");
        data.append(" \"messages\": " + this.chatService.getNumberOfMessages(dbName) + ", ");
        data.append(" \"notifications\": " + this.notificationService.getNumberOfNotifications(dbName) + ", ");
        data.append(" \"notificationsUnread\": " + this.notificationService.getNumberOfUnreadNotifications(dbName));
        data.append("}");
        return Response.ok((CharSequence)data.toString()).withMimeType("application/json").withCharset(Tools.UTF_8).withHeader("Cache-Control", new String[]{"no-cache"});
    }

    private Session getMailSession() {
        String protocal = PropertyManager.getProperty("email.smtp.protocal");
        String host = PropertyManager.getProperty("email.smtp.host");
        final String user = PropertyManager.getProperty("email.smtp.username");
        final String password = PropertyManager.getProperty("email.smtp.password");
        String port = PropertyManager.getProperty("email.smtp.port");
        String auth = PropertyManager.getProperty("email.smtp.auth");
        String starttlsEnable = PropertyManager.getProperty("email.smtp.starttls.enable");
        String enableSSL = PropertyManager.getProperty("email.smtp.EnableSSL.enable");
        String smtpAuth = PropertyManager.getProperty("email.smtp.auth");
        String socketFactoryPort = PropertyManager.getProperty("email.smtp.socketFactory.port");
        String socketFactoryClass = PropertyManager.getProperty("email.smtp.socketFactory.class");
        String socketFactoryFallback = PropertyManager.getProperty("email.smtp.socketFactory.fallback");
        Properties props = new Properties();
        props.put("mail.transport.protocol", protocal);
        props.put("mail.smtp.host", host);
        props.put("mail.smtp.port", port);
        props.put("mail.smtp.auth", auth);
        if (Boolean.parseBoolean(smtpAuth)) {
            props.put("mail.smtp.socketFactory.port", socketFactoryPort);
            props.put("mail.smtp.socketFactory.class", socketFactoryClass);
            props.put("mail.smtp.socketFactory.fallback", socketFactoryFallback);
            props.put("mail.smtp.starttls.enable", starttlsEnable);
            props.put("mail.smtp.ssl.enable", enableSSL);
            return Session.getInstance((Properties)props, (Authenticator)new Authenticator(){

                protected PasswordAuthentication getPasswordAuthentication() {
                    return new PasswordAuthentication(user, password);
                }
            });
        }
        return Session.getInstance((Properties)props);
    }

    public void sendMailWithAuth(String senderFullname, String senderMail, List<String> toList, String htmlBody, String subject, Map<String, String> inlineImages) throws Exception {
        Session session = this.getMailSession();
        MimeMessage message = new MimeMessage(session);
        message.setFrom((Address)new InternetAddress(senderMail, senderFullname, "UTF-8"));
        for (String to : toList) {
            message.addRecipients(Message.RecipientType.BCC, (Address[])InternetAddress.parse((String)to));
        }
        message.setSubject(subject, "UTF-8");
        MimeBodyPart messageBodyPart = new MimeBodyPart();
        messageBodyPart.setContent((Object)htmlBody, "text/html; charset=UTF-8");
        MimeMultipart multipart = new MimeMultipart();
        multipart.addBodyPart((BodyPart)messageBodyPart);
        if (inlineImages != null && inlineImages.size() > 0) {
            Set<String> setImageID = inlineImages.keySet();
            for (String contentId : setImageID) {
                messageBodyPart = new MimeBodyPart();
                String imageFilePath = inlineImages.get(contentId);
                URL url = new URL(imageFilePath);
                URLConnection con = url.openConnection();
                con.setDoOutput(true);
                InputStream is = con.getInputStream();
                ByteArrayDataSource byteArrayDataSource = new ByteArrayDataSource(is, con.getContentType());
                messageBodyPart.setDataHandler(new DataHandler((DataSource)byteArrayDataSource));
                messageBodyPart.setContentID("<" + contentId + ">");
                messageBodyPart.setDisposition("inline");
                multipart.addBodyPart((BodyPart)messageBodyPart);
            }
        }
        message.setContent((Multipart)multipart);
        try {
            Transport.send((Message)message);
        }
        catch (Exception e) {
            LOG.info(e.getMessage());
        }
    }
}

