/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.chat.server;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.GenericServlet;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.cometd.annotation.ServerAnnotationProcessor;
import org.cometd.bayeux.server.BayeuxServer;
import org.exoplatform.chat.server.CometdService;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.RootContainer;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.mortbay.cometd.continuation.EXoContinuationBayeux;

public class CometdConfigurationServlet
extends GenericServlet {
    private static final Log LOG = ExoLogger.getExoLogger(CometdConfigurationServlet.class);
    private final List<Object> services = new ArrayList<Object>();
    private ServerAnnotationProcessor processor;

    public void init() throws ServletException {
        ExoContainer exoContainer = ExoContainerContext.getCurrentContainerIfPresent();
        LOG.debug((Object)"CometdConfigurationServlet init");
        LOG.debug((Object)"Chat mode detected : 1 server");
        RootContainer.getInstance().addInitTask(this.getServletContext(), (RootContainer.PortalContainerInitTask)new RootContainer.PortalContainerPostInitTask(){

            public void execute(ServletContext servletContext, PortalContainer portalContainer) {
                BayeuxServer bayeux = (BayeuxServer)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(EXoContinuationBayeux.class);
                CometdConfigurationServlet.this.processor = new ServerAnnotationProcessor(bayeux);
                CometdService service = new CometdService();
                CometdConfigurationServlet.this.processor.process((Object)service);
                CometdConfigurationServlet.this.services.add(service);
            }
        }, PortalContainer.DEFAULT_PORTAL_CONTAINER_NAME);
    }

    public void destroy() {
        for (Object service : this.services) {
            this.processor.deprocess(service);
        }
    }

    public void service(ServletRequest request, ServletResponse response) throws ServletException, IOException {
        throw new ServletException();
    }
}

