/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.chat.utils;

import com.ibm.icu.text.Transliterator;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.chat.utils.MessageDigester;
import org.exoplatform.ecm.utils.text.Text;

public class ChatUtils {
    public static String getRoomId(String roomName, String user) {
        if (roomName.startsWith("team-") && roomName.length() > "team-".length() + 1) {
            return roomName.substring("team-".length());
        }
        StringBuilder sb = new StringBuilder();
        sb.append("1-team-room;").append(user).append(";").append(roomName).append(";");
        return MessageDigester.getHash(sb.toString());
    }

    public static String getRoomId(String roomName) {
        if (roomName.startsWith("space-") && roomName.length() > "space-".length() + 1) {
            return roomName.substring("space-".length());
        }
        StringBuilder sb = new StringBuilder();
        sb.append("1-space-room;").append(roomName).append(";");
        return MessageDigester.getHash(sb.toString());
    }

    public static String getExternalRoomId(String identifier) {
        if (identifier.startsWith("external-") && identifier.length() > "external-".length() + 1) {
            return identifier.substring("external-".length());
        }
        StringBuilder sb = new StringBuilder();
        sb.append("1-external-room;").append(identifier).append(";");
        return MessageDigester.getHash(sb.toString());
    }

    public static String getRoomId(List<String> users) {
        Collections.sort(users);
        StringBuilder sb = new StringBuilder();
        for (String user : users) {
            sb.append(user).append(";");
        }
        String roomId = MessageDigester.getHash(sb.toString());
        return roomId;
    }

    public static Object fromString(String s) throws IOException, ClassNotFoundException {
        byte[] data = Base64.decodeBase64((String)s);
        ObjectInputStream ois = new ObjectInputStream(new ByteArrayInputStream(data));
        Object o = ois.readObject();
        ois.close();
        return o;
    }

    public static String toString(Serializable o) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(baos);
        oos.writeObject(o);
        oos.close();
        return new String(Base64.encodeBase64((byte[])baos.toByteArray()));
    }

    public static String cleanString(String str) {
        Transliterator accentsconverter = Transliterator.getInstance((String)"Latin; NFD; [:Nonspacing Mark:] Remove; NFC;");
        if (str.indexOf(46) > 0) {
            String ext = str.substring(str.lastIndexOf(46));
            str = accentsconverter.transliterate(str.substring(0, str.lastIndexOf(46))).concat(ext);
        } else {
            str = accentsconverter.transliterate(str);
        }
        return Text.escapeIllegalJcrChars((String)str);
    }

    public static String escapeSpecialCharacters(String message) {
        message = StringUtils.chomp((String)message);
        message = message.replaceAll("&", "&#38");
        message = message.replaceAll("<", "&lt;");
        message = message.replaceAll(">", "&gt;");
        message = message.replaceAll("\"", "&quot;");
        message = message.replaceAll("\n", "<br/>");
        message = message.replaceAll("\\\\", "&#92");
        return message;
    }

    public static String unEscapeSpecialCharacters(String message) {
        message = StringUtils.chomp((String)message);
        message = message.replaceAll("&#38", "&");
        message = message.replaceAll("&lt;", "<");
        message = message.replaceAll("&gt;", ">");
        message = message.replaceAll("&quot;", "\"");
        message = message.replaceAll("<br/>", "\n");
        message = message.replaceAll("&#92", "\\\\");
        return message;
    }
}

