/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.cms.clouddrives.gdrive;

import com.google.api.client.util.DateTime;
import com.google.api.services.drive.model.File;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import org.exoplatform.services.cms.clouddrives.CloudFile;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestGoogleFile {
    protected static final Log LOG = ExoLogger.getLogger(TestGoogleFile.class);
    public List<File> listOfGoogleFiles;
    public List<CloudFile> listOfCloudFiles;
    public static final String DATE1 = "2012-07-24T15:19:34.491Z";
    public static final String DATE2 = "2007-05-01T15:43:26.3452Z";
    public static File file1;
    public static File file2;
    public static final String ID1 = "firstId";
    public static final String ID2 = "secondId";
    public static final String TITLE1 = "title1";
    public static final String TITLE2 = "title2";
    public static final String TYPE1 = "application/vnd.google-apps.folder";
    public static final String TYPE2 = "application/vnd.google-apps.file";
    public static final String LINK1 = "link1";
    public static final String LINK2 = "link2";
    public static final String LAST_USER1 = "last_user1";
    public static final String LAST_USER2 = "last_user2";
    public static final String AUTHOR1 = "author1";
    public static final String AUTHOR2 = "author2";

    @BeforeClass
    public void initClass() {
        file1 = new File();
        file2 = new File();
        ArrayList<String> owners1 = new ArrayList<String>();
        ArrayList<String> owners2 = new ArrayList<String>();
        owners1.add(AUTHOR1);
        owners2.add(AUTHOR2);
        TimeZone tz = TimeZone.getTimeZone("America/Los_Angeles");
        DateTime dt = new DateTime(new Date(), tz);
        file1.setId(ID1);
        file2.setId(ID2);
        file1.setTitle(TITLE1);
        file2.setTitle(TITLE2);
        file1.setMimeType(TYPE1);
        file2.setMimeType(TYPE2);
        file1.setAlternateLink(LINK1);
        file2.setAlternateLink(LINK2);
        file1.setLastModifyingUserName(LAST_USER1);
        file2.setLastModifyingUserName(LAST_USER2);
        file1.setOwnerNames(owners1);
        file2.setOwnerNames(owners2);
        file1.setCreatedDate(dt);
        file2.setCreatedDate(dt);
        file1.setModifiedDate(dt);
        file2.setModifiedDate(dt);
    }

    @Before
    public void initMethod() {
        this.listOfGoogleFiles = new ArrayList<File>();
        this.listOfCloudFiles = new ArrayList<CloudFile>();
    }

    @Test
    public void testParseRFC3339Date() {
        Calendar cDate1 = Calendar.getInstance();
        Calendar cDate2 = Calendar.getInstance();
        Assert.assertNotNull((Object)cDate1);
        Assert.assertNotNull((Object)cDate2);
        Assert.assertEquals((Object)"Tue Jul 24 15:19:34 FET 2012", (Object)cDate1.getTime().toString());
        Assert.assertEquals((Object)"Tue May 01 15:43:29 FEST 2007", (Object)cDate2.getTime().toString());
    }
}

