/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.cms.clouddrives.gdrive.shaded.io.opencensus.stats;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.concurrent.Immutable;
import org.exoplatform.services.cms.clouddrives.gdrive.shaded.io.opencensus.internal.Utils;
import org.exoplatform.services.cms.clouddrives.gdrive.shaded.io.opencensus.stats.AutoValue_BucketBoundaries;

@Immutable
public abstract class BucketBoundaries {
    private static final Logger logger = Logger.getLogger(BucketBoundaries.class.getName());

    public static final BucketBoundaries create(List<Double> bucketBoundaries) {
        Utils.checkNotNull(bucketBoundaries, "bucketBoundaries");
        ArrayList<Double> bucketBoundariesCopy = new ArrayList<Double>(bucketBoundaries);
        if (bucketBoundariesCopy.size() > 1) {
            double previous = (Double)bucketBoundariesCopy.get(0);
            for (int i = 1; i < bucketBoundariesCopy.size(); ++i) {
                double next = (Double)bucketBoundariesCopy.get(i);
                Utils.checkArgument(previous < next, "Bucket boundaries not sorted.");
                previous = next;
            }
        }
        return new AutoValue_BucketBoundaries(Collections.unmodifiableList(BucketBoundaries.dropNegativeBucketBounds(bucketBoundariesCopy)));
    }

    private static List<Double> dropNegativeBucketBounds(List<Double> bucketBoundaries) {
        int negativeBucketBounds = 0;
        int zeroBucketBounds = 0;
        for (Double value : bucketBoundaries) {
            if (!(value <= 0.0)) break;
            if (value == 0.0) {
                ++zeroBucketBounds;
                continue;
            }
            ++negativeBucketBounds;
        }
        if (negativeBucketBounds > 0) {
            logger.log(Level.WARNING, "Dropping " + negativeBucketBounds + " negative bucket boundaries, the values must be strictly > 0.");
        }
        return bucketBoundaries.subList(negativeBucketBounds + zeroBucketBounds, bucketBoundaries.size());
    }

    public abstract List<Double> getBoundaries();
}

