/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.cms.clouddrives.gdrive;

import com.google.api.client.auth.oauth2.Credential;
import com.google.api.client.googleapis.auth.oauth2.GoogleAuthorizationCodeFlow;
import com.google.api.client.googleapis.auth.oauth2.GoogleAuthorizationCodeTokenRequest;
import java.io.IOException;
import java.util.ArrayList;
import org.exoplatform.services.cms.clouddrives.CloudDriveException;
import org.exoplatform.services.cms.clouddrives.CloudFile;
import org.exoplatform.services.cms.clouddrives.gdrive.CredentialUtils;
import org.exoplatform.services.cms.clouddrives.gdrive.GoogleProvider;
import org.exoplatform.services.cms.clouddrives.gdrive.GoogleUser;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestGoogleDrive {
    protected static final Log LOG = ExoLogger.getLogger(TestGoogleDrive.class);
    private final String CODE1 = "4/8GJ7lnHSD5xbUPvFgHfWSjgZE01r.cjMtzpMWxWoYOl05ti8ZT3YJt8xgdAI";
    private final String CODE2 = "4/kcnLNaH7ay_cFtLq6v4PEIbon6_O.EoxkoUh1UXMZOl05ti8ZT3ZrzcnddAI";
    private final String GRANT_TYPE = "authorization_code";
    private static final String SCOPES = "https://www.googleapis.com/auth/userinfo.email https://www.googleapis.com/auth/userinfo.profile https://www.googleapis.com/auth/drive.readonly";
    private GoogleUser googleUser;
    private GoogleAuthorizationCodeFlow flow;
    private GoogleAuthorizationCodeTokenRequest tokenRequest;
    private CredentialUtils credentialHelper;
    private Credential credential;
    private GoogleProvider provider;
    private final String PROVIDER_ID = "gdrive";
    private final String PROVIDER_NAME = "Google Drive";

    @BeforeClass
    public void init() throws IOException, CloudDriveException {
        this.credentialHelper = new CredentialUtils();
        this.flow = this.credentialHelper.getFlow();
        this.tokenRequest = this.flow.newTokenRequest("4/8GJ7lnHSD5xbUPvFgHfWSjgZE01r.cjMtzpMWxWoYOl05ti8ZT3YJt8xgdAI");
        this.credential = this.credentialHelper.getCredential("4/kcnLNaH7ay_cFtLq6v4PEIbon6_O.EoxkoUh1UXMZOl05ti8ZT3ZrzcnddAI");
        this.provider = new GoogleProvider("gdrive", "Google Drive", "", "");
    }

    @Test
    public void testListOfFiles() throws CloudDriveException {
        ArrayList listOfFiles = new ArrayList();
        CloudFile first = (CloudFile)listOfFiles.get(0);
        LOG.info((Object)("Number files in list: " + listOfFiles.size()));
        Assert.assertNotNull(listOfFiles);
        Assert.assertTrue((listOfFiles.size() >= 0 ? 1 : 0) != 0);
        Assert.assertNotNull((Object)first.getAuthor());
        Assert.assertNotNull((Object)first.getCreatedDate());
        Assert.assertNotNull((Object)first.getId());
        Assert.assertNotNull((Object)first.getTitle());
        Assert.assertNotNull((Object)first.getType());
        Assert.assertNotNull((Object)first.getLink());
        for (CloudFile cf : listOfFiles) {
            LOG.info((Object)("Title----" + cf.getTitle()));
        }
    }

    @Test
    public void testListOfFilesInFolder() throws CloudDriveException {
        ArrayList listOfFiles = new ArrayList();
        CloudFile folder = null;
        CloudFile file = null;
        for (int i = 0; folder == null && listOfFiles.size() > i; ++i) {
            file = (CloudFile)listOfFiles.get(i);
            if (!file.isFolder()) continue;
            folder = file;
            LOG.info((Object)("Folder ----" + folder.getTitle()));
            ArrayList filesInFolder = new ArrayList();
            Assert.assertNotNull((Object)folder.getAuthor());
            Assert.assertNotNull((Object)folder.getCreatedDate());
            Assert.assertNotNull((Object)folder.getId());
            Assert.assertNotNull((Object)folder.getTitle());
            Assert.assertNotNull((Object)folder.getType());
            Assert.assertNotNull((Object)folder.getLink());
            Assert.assertTrue((boolean)folder.isFolder());
            for (CloudFile cf : filesInFolder) {
                LOG.info((Object)("Title----" + cf.getTitle()));
            }
        }
    }

    @Test
    public void testToken() {
        Assert.assertNotNull((Object)this.flow.getClientId());
        Assert.assertNotNull((Object)this.flow.getScopes());
        Assert.assertEquals((Object)"authorization_code", (Object)this.tokenRequest.getGrantType());
        Assert.assertEquals((Object)"4/8GJ7lnHSD5xbUPvFgHfWSjgZE01r.cjMtzpMWxWoYOl05ti8ZT3YJt8xgdAI", (Object)this.tokenRequest.getCode());
        Assert.assertEquals((Object)SCOPES, (Object)this.tokenRequest.getScopes());
    }
}

