/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.requests.extensions;

import java.util.List;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.concurrency.ICallback;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.core.ClientException;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.core.IBaseClient;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.http.BaseRequest;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.http.HttpMethod;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.models.extensions.DirectoryObject;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.options.Option;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.options.QueryOption;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.requests.extensions.IDirectoryObjectWithReferenceRequest;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.serializer.IJsonBackedObject;

public class DirectoryObjectWithReferenceRequest
extends BaseRequest
implements IDirectoryObjectWithReferenceRequest {
    public DirectoryObjectWithReferenceRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, DirectoryObject.class);
    }

    @Override
    public void post(DirectoryObject newDirectoryObject, IJsonBackedObject payload, ICallback<DirectoryObject> callback) {
        this.send(HttpMethod.POST, callback, payload);
    }

    @Override
    public DirectoryObject post(DirectoryObject newDirectoryObject, IJsonBackedObject payload) throws ClientException {
        IJsonBackedObject response = (IJsonBackedObject)this.send(HttpMethod.POST, payload);
        if (response != null) {
            return newDirectoryObject;
        }
        return null;
    }

    @Override
    public void get(ICallback<DirectoryObject> callback) {
        this.send(HttpMethod.GET, callback, null);
    }

    @Override
    public DirectoryObject get() throws ClientException {
        return (DirectoryObject)this.send(HttpMethod.GET, null);
    }

    @Override
    public void delete(ICallback<DirectoryObject> callback) {
        this.send(HttpMethod.DELETE, callback, null);
    }

    @Override
    public void delete() throws ClientException {
        this.send(HttpMethod.DELETE, null);
    }

    @Override
    public void patch(DirectoryObject sourceDirectoryObject, ICallback<DirectoryObject> callback) {
        this.send(HttpMethod.PATCH, callback, sourceDirectoryObject);
    }

    @Override
    public DirectoryObject patch(DirectoryObject sourceDirectoryObject) throws ClientException {
        return (DirectoryObject)this.send(HttpMethod.PATCH, sourceDirectoryObject);
    }

    @Override
    public IDirectoryObjectWithReferenceRequest select(String value) {
        this.getQueryOptions().add(new QueryOption("$select", value));
        return this;
    }

    @Override
    public IDirectoryObjectWithReferenceRequest expand(String value) {
        this.getQueryOptions().add(new QueryOption("$expand", value));
        return this;
    }
}

