/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.requests.extensions;

import java.util.List;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.concurrency.ICallback;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.concurrency.IExecutors;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.core.ClientException;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.core.IBaseClient;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.http.BaseCollectionRequest;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.models.extensions.SecureScoreControlProfile;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.options.Option;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.options.QueryOption;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.requests.extensions.ISecureScoreControlProfileCollectionPage;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.requests.extensions.ISecureScoreControlProfileCollectionRequest;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.requests.extensions.SecureScoreControlProfileCollectionPage;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.requests.extensions.SecureScoreControlProfileCollectionRequestBuilder;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.requests.extensions.SecureScoreControlProfileCollectionResponse;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.requests.extensions.SecureScoreControlProfileRequestBuilder;

public class SecureScoreControlProfileCollectionRequest
extends BaseCollectionRequest<SecureScoreControlProfileCollectionResponse, ISecureScoreControlProfileCollectionPage>
implements ISecureScoreControlProfileCollectionRequest {
    public SecureScoreControlProfileCollectionRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, SecureScoreControlProfileCollectionResponse.class, ISecureScoreControlProfileCollectionPage.class);
    }

    @Override
    public void get(final ICallback<ISecureScoreControlProfileCollectionPage> callback) {
        final IExecutors executors = this.getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    executors.performOnForeground(SecureScoreControlProfileCollectionRequest.this.get(), callback);
                }
                catch (ClientException e) {
                    executors.performOnForeground(e, callback);
                }
            }
        });
    }

    @Override
    public ISecureScoreControlProfileCollectionPage get() throws ClientException {
        SecureScoreControlProfileCollectionResponse response = (SecureScoreControlProfileCollectionResponse)this.send();
        return this.buildFromResponse(response);
    }

    @Override
    public void post(SecureScoreControlProfile newSecureScoreControlProfile, ICallback<SecureScoreControlProfile> callback) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        new SecureScoreControlProfileRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getOptions()).post(newSecureScoreControlProfile, callback);
    }

    @Override
    public SecureScoreControlProfile post(SecureScoreControlProfile newSecureScoreControlProfile) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new SecureScoreControlProfileRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getOptions()).post(newSecureScoreControlProfile);
    }

    @Override
    public ISecureScoreControlProfileCollectionRequest expand(String value) {
        this.addQueryOption(new QueryOption("$expand", value));
        return this;
    }

    @Override
    public ISecureScoreControlProfileCollectionRequest select(String value) {
        this.addQueryOption(new QueryOption("$select", value));
        return this;
    }

    @Override
    public ISecureScoreControlProfileCollectionRequest top(int value) {
        this.addQueryOption(new QueryOption("$top", value + ""));
        return this;
    }

    public ISecureScoreControlProfileCollectionPage buildFromResponse(SecureScoreControlProfileCollectionResponse response) {
        SecureScoreControlProfileCollectionRequestBuilder builder = response.nextLink != null ? new SecureScoreControlProfileCollectionRequestBuilder(response.nextLink, this.getBaseRequest().getClient(), null) : null;
        SecureScoreControlProfileCollectionPage page = new SecureScoreControlProfileCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}

